/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.iproduct.IWindowImages;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.EditorUtilities;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.validation.TextValidator;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.util.FileExtensionsFilter;
import org.eclipse.pde.internal.ui.util.FileValidator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class WindowImagesSection
extends PDESection {
    private TextValidator[] fWinImageEntryValidator;
    private static final int[][] F_ICON_DIMENSIONS = new int[][]{{16, 16}, {32, 32}, {48, 48}, {64, 64}, {128, 128}, {256, 256}};
    private static final String[] F_ICON_LABELS = new String[]{PDEUIMessages.WindowImagesSection_16, PDEUIMessages.WindowImagesSection_32, PDEUIMessages.WindowImagesSection_48, PDEUIMessages.WindowImagesSection_64, PDEUIMessages.WindowImagesSection_128, PDEUIMessages.WindowImagesSection_256};
    private FormEntry[] fImages = new FormEntry[F_ICON_LABELS.length];

    public WindowImagesSection(PDEFormPage page, Composite parent) {
        super(page, parent, 128);
        this.createClient(this.getSection(), page.getEditor().getToolkit());
    }

    @Override
    protected void createClient(Section section, FormToolkit toolkit) {
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(768);
        section.setLayoutData((Object)data);
        section.setText(PDEUIMessages.WindowImagesSection_title);
        section.setDescription(PDEUIMessages.WindowImagesSection_desc);
        Composite client = toolkit.createComposite((Composite)section);
        client.setLayout((Layout)FormLayoutFactory.createSectionClientGridLayout(false, 3));
        client.setLayoutData((Object)new GridData(768));
        IActionBars actionBars = this.getPage().getPDEEditor().getEditorSite().getActionBars();
        this.fWinImageEntryValidator = new TextValidator[F_ICON_LABELS.length];
        int i = 0;
        while (i < this.fImages.length) {
            final int index = i++;
            this.fImages[index] = new FormEntry(client, toolkit, F_ICON_LABELS[index], PDEUIMessages.WindowImagesSection_browse, this.isEditable());
            this.fImages[index].setEditable(this.isEditable());
            this.fWinImageEntryValidator[index] = new TextValidator(this.getManagedForm(), this.fImages[index].getText(), this.getProject(), true){

                @Override
                protected boolean validateControl() {
                    return WindowImagesSection.this.validateWinImageEntry(index);
                }
            };
            this.fImages[index].setFormEntryListener(new FormEntryAdapter(this, actionBars){

                @Override
                public void textValueChanged(FormEntry entry) {
                    WindowImagesSection.this.getWindowImages().setImagePath(entry.getValue(), index);
                }

                @Override
                public void browseButtonSelected(FormEntry entry) {
                    WindowImagesSection.this.handleBrowse(entry);
                }

                @Override
                public void linkActivated(HyperlinkEvent e) {
                    EditorUtilities.openImage(WindowImagesSection.this.fImages[index].getValue(), WindowImagesSection.this.getProduct().getDefiningPluginId());
                }
            });
        }
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        this.getModel().addModelChangedListener((IModelChangedListener)this);
    }

    public void refresh() {
        IWindowImages images = this.getWindowImages();
        this.fWinImageEntryValidator[0].setRefresh(false);
        int i = 0;
        while (i < F_ICON_LABELS.length) {
            this.fImages[i].setValue(images.getImagePath(i), true);
            ++i;
        }
        this.fWinImageEntryValidator[0].setRefresh(true);
        super.refresh();
    }

    private boolean validateWinImageEntry(int index) {
        return EditorUtilities.imageEntryHasExactSize(this.fWinImageEntryValidator[index], this.fImages[index], this.getProduct(), F_ICON_DIMENSIONS[index][0], F_ICON_DIMENSIONS[index][1]);
    }

    private IWindowImages getWindowImages() {
        IWindowImages images = this.getProduct().getWindowImages();
        if (images == null) {
            images = this.getModel().getFactory().createWindowImages();
            this.getProduct().setWindowImages(images);
        }
        return images;
    }

    private IProduct getProduct() {
        return this.getModel().getProduct();
    }

    private IProductModel getModel() {
        return (IProductModel)this.getPage().getPDEEditor().getAggregateModel();
    }

    public void commit(boolean onSave) {
        int i = 0;
        while (i < F_ICON_LABELS.length) {
            this.fImages[i].commit();
            ++i;
        }
        super.commit(onSave);
    }

    @Override
    public void cancelEdit() {
        int i = 0;
        while (i < F_ICON_LABELS.length) {
            this.fImages[i].cancelEdit();
            ++i;
        }
        super.cancelEdit();
    }

    private void handleBrowse(FormEntry entry) {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getSection().getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setValidator((ISelectionStatusValidator)new FileValidator());
        dialog.setAllowMultiple(false);
        dialog.setTitle(PDEUIMessages.WindowImagesSection_dialogTitle);
        dialog.setMessage(PDEUIMessages.WindowImagesSection_dialogMessage);
        FileExtensionsFilter filter = new FileExtensionsFilter();
        filter.addFileExtension("gif");
        filter.addFileExtension("png");
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)PDEPlugin.getWorkspace().getRoot());
        if (dialog.open() == 0) {
            IFile file = (IFile)dialog.getFirstResult();
            entry.setValue(file.getFullPath().toString());
        }
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Display d = this.getSection().getDisplay();
        Control c = d.getFocusControl();
        return c instanceof Text;
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.handleModelEventWorldChanged(e);
        }
    }

    private void handleModelEventWorldChanged(IModelChangedEvent event) {
        this.refresh();
    }

    public void dispose() {
        IProductModel model = this.getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }
}

