/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.ui.shared.target.EditBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.IUContentProvider;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.pde.ui.target.ITargetLocationEditor;
import org.eclipse.pde.ui.target.ITargetLocationUpdater;

public class IUFactory
implements IAdapterFactory,
ITargetLocationEditor,
ITargetLocationUpdater {
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;

    public Class[] getAdapterList() {
        return new Class[]{ILabelProvider.class, ITreeContentProvider.class, ITargetLocationEditor.class, ITargetLocationUpdater.class};
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IUBundleContainer) {
            if (adapterType == ILabelProvider.class) {
                return this.getLabelProvider();
            }
            if (adapterType == ITreeContentProvider.class) {
                return this.getContentProvider();
            }
            if (adapterType == ITargetLocationEditor.class) {
                return this;
            }
            if (adapterType == ITargetLocationUpdater.class) {
                return this;
            }
        } else if (adaptableObject instanceof IUContentProvider.IUWrapper) {
            if (adapterType == ILabelProvider.class) {
                return this.getLabelProvider();
            }
            if (adapterType == IContentProvider.class) {
                return this.getContentProvider();
            }
        }
        return null;
    }

    @Override
    public boolean canEdit(ITargetDefinition target, ITargetLocation targetLocation) {
        return targetLocation instanceof IUBundleContainer;
    }

    @Override
    public IWizard getEditWizard(ITargetDefinition target, ITargetLocation targetLocation) {
        return new EditBundleContainerWizard(target, targetLocation);
    }

    @Override
    public boolean canUpdate(ITargetDefinition target, ITargetLocation targetLocation) {
        return targetLocation instanceof IUBundleContainer;
    }

    @Override
    public IStatus update(ITargetDefinition target, ITargetLocation targetLocation, IProgressMonitor monitor) {
        if (targetLocation instanceof IUBundleContainer) {
            try {
                boolean result = ((IUBundleContainer)targetLocation).update(new HashSet(0), monitor);
                if (result) {
                    return Status.OK_STATUS;
                }
                return new Status(0, "org.eclipse.pde.core", 101, "", null);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        return Status.CANCEL_STATUS;
    }

    private ILabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new StyledBundleLabelProvider(true, false);
        }
        return this.fLabelProvider;
    }

    private ITreeContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new IUContentProvider();
        }
        return this.fContentProvider;
    }
}

