/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.util.ArrayList;
import junit.framework.TestCase;
import org.eclipse.compare.internal.WorkQueue;
import org.eclipse.compare.internal.Worker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class AsyncExecTests
extends TestCase {
    public AsyncExecTests() {
    }

    public AsyncExecTests(String name) {
        super(name);
    }

    public void testQueueAdd() {
        WorkQueue q = new WorkQueue();
        AsyncExecTests.assertTrue((boolean)q.isEmpty());
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
            }
        };
        IRunnableWithProgress r2 = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
            }
        };
        q.add(r);
        AsyncExecTests.assertEquals((int)1, (int)q.size());
        AsyncExecTests.assertTrue((boolean)q.contains(r));
        AsyncExecTests.assertEquals((Object)r, (Object)q.remove());
        AsyncExecTests.assertTrue((boolean)q.isEmpty());
        q.add(r);
        q.add(r);
        AsyncExecTests.assertEquals((int)1, (int)q.size());
        AsyncExecTests.assertTrue((boolean)q.contains(r));
        q.add(r2);
        AsyncExecTests.assertEquals((int)2, (int)q.size());
        AsyncExecTests.assertTrue((boolean)q.contains(r));
        AsyncExecTests.assertTrue((boolean)q.contains(r2));
        AsyncExecTests.assertEquals((Object)r, (Object)q.remove());
        AsyncExecTests.assertEquals((int)1, (int)q.size());
        AsyncExecTests.assertEquals((Object)r2, (Object)q.remove());
        AsyncExecTests.assertTrue((boolean)q.isEmpty());
        q.add(r);
        q.add(r2);
        q.add(r);
        AsyncExecTests.assertEquals((int)2, (int)q.size());
        AsyncExecTests.assertTrue((boolean)q.contains(r));
        AsyncExecTests.assertTrue((boolean)q.contains(r2));
        AsyncExecTests.assertEquals((Object)r2, (Object)q.remove());
        AsyncExecTests.assertEquals((int)1, (int)q.size());
        AsyncExecTests.assertEquals((Object)r, (Object)q.remove());
        AsyncExecTests.assertTrue((boolean)q.isEmpty());
    }

    public void testWorker() {
        final Worker w = new Worker("");
        final ArrayList worked = new ArrayList();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                AsyncExecTests.assertTrue((boolean)w.isWorking());
                AsyncExecTests.assertTrue((boolean)w.hasWork());
                worked.add(this);
            }
        };
        IRunnableWithProgress r2 = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                AsyncExecTests.assertTrue((boolean)w.isWorking());
                AsyncExecTests.assertTrue((boolean)w.hasWork());
                worked.add(this);
            }
        };
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertTrue((boolean)worked.isEmpty());
        w.run((IProgressMonitor)new NullProgressMonitor());
        AsyncExecTests.assertFalse((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertEquals((int)1, (int)worked.size());
        AsyncExecTests.assertEquals((Object)r, worked.get(0));
        worked.clear();
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.add(r2);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.run((IProgressMonitor)new NullProgressMonitor());
        AsyncExecTests.assertFalse((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertEquals((int)2, (int)worked.size());
        AsyncExecTests.assertEquals((Object)r, worked.get(0));
        AsyncExecTests.assertEquals((Object)r2, worked.get(1));
        worked.clear();
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.add(r2);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.run((IProgressMonitor)new NullProgressMonitor());
        AsyncExecTests.assertFalse((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertEquals((int)2, (int)worked.size());
        AsyncExecTests.assertEquals((Object)r, worked.get(1));
        AsyncExecTests.assertEquals((Object)r2, worked.get(0));
    }

    public void testCancelOnRequeue() {
        final Worker w = new Worker("");
        final ArrayList worked = new ArrayList();
        IRunnableWithProgress r = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                if (worked.isEmpty()) {
                    worked.add(this);
                    w.add((IRunnableWithProgress)this);
                    AsyncExecTests.assertTrue((boolean)monitor.isCanceled());
                    throw new OperationCanceledException();
                }
                AsyncExecTests.assertTrue((boolean)w.isWorking());
                AsyncExecTests.assertTrue((boolean)w.hasWork());
                worked.add(this);
            }
        };
        IRunnableWithProgress r2 = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                AsyncExecTests.assertTrue((boolean)w.isWorking());
                AsyncExecTests.assertTrue((boolean)w.hasWork());
                worked.add(this);
            }
        };
        worked.clear();
        w.add(r);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.add(r2);
        AsyncExecTests.assertTrue((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        w.run((IProgressMonitor)new NullProgressMonitor());
        AsyncExecTests.assertFalse((boolean)w.hasWork());
        AsyncExecTests.assertFalse((boolean)w.isWorking());
        AsyncExecTests.assertEquals((int)3, (int)worked.size());
        AsyncExecTests.assertEquals((Object)r, worked.get(0));
        AsyncExecTests.assertEquals((Object)r2, worked.get(1));
        AsyncExecTests.assertEquals((Object)r, worked.get(2));
    }
}

