/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import junit.framework.TestCase;
import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.internal.core.TextLineLCS;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;

public class DiffTest
extends TestCase {
    private static final String ABC = "abc";
    private static final String DEF = "def";
    private static final String XYZ = "xyz";
    private static final String _123 = "123";
    static final String SEPARATOR = System.getProperty("line.separator");

    public DiffTest() {
    }

    public DiffTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLineAddition() {
        String s1 = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String s2 = ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ;
        TextLineLCS.TextLine[] l1 = TextLineLCS.getTextLines((String)s1);
        TextLineLCS.TextLine[] l2 = TextLineLCS.getTextLines((String)s2);
        TextLineLCS lcs = new TextLineLCS(l1, l2);
        lcs.longestCommonSubsequence(SubMonitor.convert(null, (int)100));
        TextLineLCS.TextLine[][] result = lcs.getResult();
        DiffTest.assertTrue((result[0].length == result[1].length ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].length == 3 ? 1 : 0) != 0);
        int i = 0;
        while (i < result[0].length) {
            DiffTest.assertTrue((boolean)result[0][i].sameText(result[1][i]));
            ++i;
        }
        DiffTest.assertTrue((result[0][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0][1].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][1].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0][2].lineNumber() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][2].lineNumber() == 3 ? 1 : 0) != 0);
    }

    public void testLineDeletion() {
        String s1 = ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ;
        String s2 = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        TextLineLCS.TextLine[] l1 = TextLineLCS.getTextLines((String)s1);
        TextLineLCS.TextLine[] l2 = TextLineLCS.getTextLines((String)s2);
        TextLineLCS lcs = new TextLineLCS(l1, l2);
        lcs.longestCommonSubsequence(SubMonitor.convert(null, (int)100));
        TextLineLCS.TextLine[][] result = lcs.getResult();
        DiffTest.assertTrue((result[0].length == result[1].length ? 1 : 0) != 0);
        int i = 0;
        while (i < result[0].length) {
            DiffTest.assertTrue((boolean)result[0][i].sameText(result[1][i]));
            ++i;
        }
        DiffTest.assertTrue((result[0][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0][1].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0][2].lineNumber() == 3 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][1].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][2].lineNumber() == 2 ? 1 : 0) != 0);
    }

    public void testLineAppendEnd() {
        String s1 = ABC + SEPARATOR + DEF;
        String s2 = ABC + SEPARATOR + DEF + SEPARATOR + _123;
        TextLineLCS.TextLine[] l1 = TextLineLCS.getTextLines((String)s1);
        TextLineLCS.TextLine[] l2 = TextLineLCS.getTextLines((String)s2);
        TextLineLCS lcs = new TextLineLCS(l1, l2);
        lcs.longestCommonSubsequence(SubMonitor.convert(null, (int)100));
        TextLineLCS.TextLine[][] result = lcs.getResult();
        DiffTest.assertTrue((result[0].length == result[1].length ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].length == 2 ? 1 : 0) != 0);
        int i = 0;
        while (i < result[0].length) {
            DiffTest.assertTrue((boolean)result[0][i].sameText(result[1][i]));
            ++i;
        }
        DiffTest.assertTrue((result[0][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0][1].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][1].lineNumber() == 1 ? 1 : 0) != 0);
    }

    public void testLineDeleteEnd() {
        String s1 = ABC + SEPARATOR + DEF + SEPARATOR + _123;
        String s2 = ABC + SEPARATOR + DEF;
        TextLineLCS.TextLine[] l1 = TextLineLCS.getTextLines((String)s1);
        TextLineLCS.TextLine[] l2 = TextLineLCS.getTextLines((String)s2);
        TextLineLCS lcs = new TextLineLCS(l1, l2);
        lcs.longestCommonSubsequence(SubMonitor.convert(null, (int)100));
        TextLineLCS.TextLine[][] result = lcs.getResult();
        DiffTest.assertTrue((result[0].length == result[1].length ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].length == 2 ? 1 : 0) != 0);
        int i = 0;
        while (i < result[0].length) {
            DiffTest.assertTrue((boolean)result[0][i].sameText(result[1][i]));
            ++i;
        }
        DiffTest.assertTrue((result[0][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0][1].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][1].lineNumber() == 1 ? 1 : 0) != 0);
    }

    public void testLineAppendStart() {
        String s1 = ABC + SEPARATOR + DEF;
        String s2 = _123 + SEPARATOR + ABC + SEPARATOR + DEF;
        TextLineLCS.TextLine[] l1 = TextLineLCS.getTextLines((String)s1);
        TextLineLCS.TextLine[] l2 = TextLineLCS.getTextLines((String)s2);
        TextLineLCS lcs = new TextLineLCS(l1, l2);
        lcs.longestCommonSubsequence(SubMonitor.convert(null, (int)100));
        TextLineLCS.TextLine[][] result = lcs.getResult();
        DiffTest.assertTrue((result[0].length == result[1].length ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].length == 2 ? 1 : 0) != 0);
        int i = 0;
        while (i < result[0].length) {
            DiffTest.assertTrue((boolean)result[0][i].sameText(result[1][i]));
            ++i;
        }
        DiffTest.assertTrue((result[0][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][0].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0][1].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][1].lineNumber() == 2 ? 1 : 0) != 0);
    }

    public void testLineDeleteStart() {
        String s1 = _123 + SEPARATOR + ABC + SEPARATOR + DEF;
        String s2 = ABC + SEPARATOR + DEF;
        TextLineLCS.TextLine[] l1 = TextLineLCS.getTextLines((String)s1);
        TextLineLCS.TextLine[] l2 = TextLineLCS.getTextLines((String)s2);
        TextLineLCS lcs = new TextLineLCS(l1, l2);
        lcs.longestCommonSubsequence(SubMonitor.convert(null, (int)100));
        TextLineLCS.TextLine[][] result = lcs.getResult();
        DiffTest.assertTrue((result[0].length == result[1].length ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].length == 2 ? 1 : 0) != 0);
        int i = 0;
        while (i < result[0].length) {
            DiffTest.assertTrue((boolean)result[0][i].sameText(result[1][i]));
            ++i;
        }
        DiffTest.assertTrue((result[0][0].lineNumber() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0][1].lineNumber() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][0].lineNumber() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[1][1].lineNumber() == 1 ? 1 : 0) != 0);
    }

    private IRangeComparator toRangeComparator(String s) {
        Document doc1 = new Document();
        doc1.set(s);
        return new DocLineComparator((IDocument)doc1, null, true);
    }

    private RangeDifference[] getDifferences(String s1, String s2) {
        RangeDifference[] oldDifferences;
        IRangeComparator comp2;
        IRangeComparator comp1 = this.toRangeComparator(s1);
        RangeDifference[] differences = RangeDifferencer.findDifferences((IRangeComparator)comp1, (IRangeComparator)(comp2 = this.toRangeComparator(s2)));
        DiffTest.assertTrue((differences.length == (oldDifferences = RangeDifferencer.findDifferences((IRangeComparator)comp1, (IRangeComparator)comp2)).length ? 1 : 0) != 0);
        int i = 0;
        while (i < oldDifferences.length) {
            DiffTest.assertEquals((Object)oldDifferences[i], (Object)differences[i]);
            ++i;
        }
        return differences;
    }

    public void testDocAddition() {
        String s2;
        String s1 = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        RangeDifference[] result = this.getDifferences(s1, s2 = ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ);
        DiffTest.assertTrue((result.length == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftStart() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftLength() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightStart() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightLength() == 1 ? 1 : 0) != 0);
    }

    public void testDocDeletion() {
        String s2;
        String s1 = ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ;
        RangeDifference[] result = this.getDifferences(s1, s2 = ABC + SEPARATOR + DEF + SEPARATOR + XYZ);
        DiffTest.assertTrue((result.length == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftStart() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftLength() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightStart() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightLength() == 0 ? 1 : 0) != 0);
    }

    public void testDocAppendStart() {
        String s2;
        String s1 = ABC + SEPARATOR + DEF;
        RangeDifference[] result = this.getDifferences(s1, s2 = _123 + SEPARATOR + ABC + SEPARATOR + DEF);
        DiffTest.assertTrue((result.length == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftStart() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftLength() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightStart() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightLength() == 1 ? 1 : 0) != 0);
    }

    public void testDocDeleteStart() {
        String s2;
        String s1 = _123 + SEPARATOR + ABC + SEPARATOR + DEF;
        RangeDifference[] result = this.getDifferences(s1, s2 = ABC + SEPARATOR + DEF);
        DiffTest.assertTrue((result.length == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftStart() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftLength() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightStart() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightLength() == 0 ? 1 : 0) != 0);
    }

    public void testDocAppendEnd() {
        String s2;
        String s1 = ABC + SEPARATOR + DEF;
        RangeDifference[] result = this.getDifferences(s1, s2 = ABC + SEPARATOR + DEF + SEPARATOR + _123);
        DiffTest.assertTrue((result.length == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftStart() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftLength() == 0 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightStart() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightLength() == 1 ? 1 : 0) != 0);
    }

    public void testDocDeleteEnd() {
        String s2;
        String s1 = ABC + SEPARATOR + DEF + SEPARATOR + _123;
        RangeDifference[] result = this.getDifferences(s1, s2 = ABC + SEPARATOR + DEF);
        DiffTest.assertTrue((result.length == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftStart() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].leftLength() == 1 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightStart() == 2 ? 1 : 0) != 0);
        DiffTest.assertTrue((result[0].rightLength() == 0 ? 1 : 0) != 0);
    }
}

