/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.internal.core.patch.FileDiffResult;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.core.patch.Hunk;
import org.eclipse.compare.internal.patch.Patcher;
import org.eclipse.compare.patch.ApplyPatchOperation;
import org.eclipse.compare.patch.IFilePatch;
import org.eclipse.compare.patch.IFilePatchResult;
import org.eclipse.compare.patch.PatchConfiguration;
import org.eclipse.compare.patch.WorkspacePatcherUI;
import org.eclipse.compare.tests.WorkspaceTest;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;

public class FileDiffResultTest
extends WorkspaceTest {
    private static final String PATCH_FILE = "patchfile";
    private static final String NEW_FILENAME = "newfile";
    private static final String NEW_FILE_CONTENT = "Hi There";
    private IProgressMonitor nullProgressMonitor = new NullProgressMonitor();
    private PatchConfiguration patchConfiguration = new PatchConfiguration();

    public FileDiffResultTest() {
    }

    public FileDiffResultTest(String name) {
        super(name);
    }

    public void testPatchAddsNewFile() throws CoreException {
        IProject project = this.createProject("FileDiffResultTest", new String[]{"oldfile"});
        try {
            IFile file = project.getFile(PATCH_FILE);
            file.create((InputStream)new ByteArrayInputStream(this.createPatchAddingFile(project, NEW_FILENAME, false).getBytes()), true, null);
            FileDiffResultTest.assertFalse((boolean)project.getFile(NEW_FILENAME).exists());
            IFilePatch[] filePatch = ApplyPatchOperation.parsePatch((IStorage)file);
            FileDiffResultTest.assertNotNull((Object)filePatch);
            FileDiffResultTest.assertEquals((int)1, (int)filePatch.length);
            IFilePatchResult filePatchResult = filePatch[0].apply(null, this.patchConfiguration, this.nullProgressMonitor);
            FileDiffResultTest.assertTrue((boolean)filePatchResult.hasMatches());
            FileDiffResultTest.assertEquals((int)0, (int)filePatchResult.getRejects().length);
            FileDiffResultTest.assertEquals((String)"", (String)FileDiffResultTest.getStringFromStream(filePatchResult.getOriginalContents()));
            FileDiffResultTest.assertEquals((String)NEW_FILE_CONTENT, (String)FileDiffResultTest.getStringFromStream(filePatchResult.getPatchedContents()));
        }
        catch (IOException iOException) {
            FileDiffResultTest.fail();
        }
    }

    public void testPatchAddsExistingFileWithSameContents() throws CoreException {
        IProject project = this.createProject("FileDiffResultTest", new String[]{NEW_FILENAME});
        try {
            IFile file = project.getFile(PATCH_FILE);
            file.create((InputStream)new ByteArrayInputStream(this.createPatchAddingFile(project, NEW_FILENAME, true).getBytes()), true, null);
            FileDiffResultTest.assertTrue((boolean)project.getFile(NEW_FILENAME).exists());
            IFilePatch[] filePatch = ApplyPatchOperation.parsePatch((IStorage)file);
            FileDiffResultTest.assertNotNull((Object)filePatch);
            FileDiffResultTest.assertEquals((int)1, (int)filePatch.length);
            IFilePatchResult filePatchResult = filePatch[0].apply((IStorage)project.getFile(NEW_FILENAME), this.patchConfiguration, this.nullProgressMonitor);
            FileDiffResultTest.assertFalse((boolean)filePatchResult.hasMatches());
            FileDiffResultTest.assertEquals((int)1, (int)filePatchResult.getRejects().length);
            FileDiffResultTest.assertNotNull((Object)filePatchResult.getOriginalContents());
            FileDiffResultTest.assertNotNull((Object)filePatchResult.getPatchedContents());
            FileDiffResultTest.assertEquals(new FileInputStream(project.getFile(NEW_FILENAME).getLocation().toFile()), filePatchResult.getOriginalContents());
            FileDiffResultTest.assertEquals(filePatchResult.getOriginalContents(), filePatchResult.getPatchedContents());
        }
        catch (IOException iOException) {
            FileDiffResultTest.fail();
        }
    }

    public void testPatchAddsExistingFileWithDifferentContents() throws CoreException {
        IProject project = this.createProject("FileDiffResultTest", new String[]{NEW_FILENAME});
        project.getFile(NEW_FILENAME).setContents((InputStream)new ByteArrayInputStream("I'm a different content".getBytes()), 0, null);
        try {
            IFile file = project.getFile(PATCH_FILE);
            file.create((InputStream)new ByteArrayInputStream(this.createPatchAddingFile(project, NEW_FILENAME, false).getBytes()), true, null);
            FileDiffResultTest.assertTrue((boolean)project.getFile(NEW_FILENAME).exists());
            IFilePatch[] filePatch = ApplyPatchOperation.parsePatch((IStorage)file);
            FileDiffResultTest.assertNotNull((Object)filePatch);
            FileDiffResultTest.assertEquals((int)1, (int)filePatch.length);
            IFilePatchResult filePatchResult = filePatch[0].apply((IStorage)project.getFile(NEW_FILENAME), this.patchConfiguration, this.nullProgressMonitor);
            FileDiffResultTest.assertFalse((boolean)filePatchResult.hasMatches());
            FileDiffResultTest.assertEquals((int)1, (int)filePatchResult.getRejects().length);
            FileDiffResultTest.assertNotNull((Object)filePatchResult.getOriginalContents());
            FileDiffResultTest.assertNotNull((Object)filePatchResult.getPatchedContents());
            FileDiffResultTest.assertEquals(new FileInputStream(project.getFile(NEW_FILENAME).getLocation().toFile()), filePatchResult.getOriginalContents());
            FileDiffResultTest.assertEquals((String)"I'm a different content", (String)FileDiffResultTest.getStringFromStream(filePatchResult.getOriginalContents()));
            FileDiffResultTest.assertEquals(filePatchResult.getOriginalContents(), filePatchResult.getPatchedContents());
        }
        catch (IOException iOException) {
            FileDiffResultTest.fail();
        }
    }

    public void testFileDiffResultWithNullPath() {
        MyFileDiff myFileDiff = new MyFileDiff();
        FileDiffResult fileDiffResult = new FileDiffResult((FilePatch2)myFileDiff, this.patchConfiguration);
        try {
            fileDiffResult.calculateFuzz(new ArrayList(), this.nullProgressMonitor);
        }
        catch (NullPointerException nullPointerException) {
            FileDiffResultTest.fail();
        }
    }

    public void testExcludePartOfNonWorkspacePatch() {
        Patcher patcher = new Patcher();
        MyFileDiff myFileDiff = new MyFileDiff();
        try {
            patcher.setEnabled((Object)myFileDiff, false);
        }
        catch (NullPointerException nullPointerException) {
            FileDiffResultTest.fail();
        }
    }

    private String createPatchAddingFile(IProject project, String filename, boolean sameContents) throws IOException, CoreException {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(WorkspacePatcherUI.getWorkspacePatchHeader()) + "\n");
        sb.append(String.valueOf(WorkspacePatcherUI.getWorkspacePatchProjectHeader((IProject)project)) + "\n");
        sb.append("Index: " + filename + "\n");
        sb.append("===================================================================\n");
        sb.append("RCS file: " + filename + "\n");
        sb.append("diff -N " + filename + "\n");
        sb.append("--- /dev/null\t1 Jan 1970 00:00:00 -0000\n");
        sb.append("+++ " + filename + "\t1 Jan 1970 00:00:00 -0000\n");
        sb.append("@@ -0,0 +1,1 @@\n");
        if (sameContents) {
            sb.append("+" + FileDiffResultTest.getStringFromIFile(project.getFile(filename)));
        } else {
            sb.append("+Hi There");
        }
        return sb.toString();
    }

    private static String getStringFromStream(InputStream in) throws IOException {
        return Utilities.readString((InputStream)in, (String)ResourcesPlugin.getEncoding());
    }

    private static String getStringFromIFile(IFile file) throws IOException, CoreException {
        return FileDiffResultTest.getStringFromStream(new BufferedInputStream(file.getContents()));
    }

    private static void assertEquals(InputStream inputStream1, InputStream inputStream2) throws IOException {
        int byte2;
        int byte1;
        FileDiffResultTest.assertNotNull((Object)inputStream1);
        FileDiffResultTest.assertNotNull((Object)inputStream2);
        do {
            byte1 = inputStream1.read();
            byte2 = inputStream2.read();
            FileDiffResultTest.assertEquals((int)byte1, (int)byte2);
        } while (byte1 != -1 || byte2 != -1);
        FileDiffResultTest.assertEquals((int)-1, (int)byte1);
        FileDiffResultTest.assertEquals((int)-1, (int)byte2);
        inputStream1.close();
        inputStream2.close();
    }

    private class MyFileDiff
    extends FilePatch2 {
        protected MyFileDiff() {
            super(null, 0L, null, 0L);
            this.add(Hunk.createHunk((FilePatch2)this, (int[])new int[2], (int[])new int[2], new ArrayList(), (boolean)false, (boolean)false, (boolean)false));
        }
    }
}

