/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Field;
import junit.framework.TestCase;
import org.eclipse.compare.internal.core.patch.FilePatch2;
import org.eclipse.compare.internal.patch.WorkspacePatcher;
import org.eclipse.compare.patch.IHunk;
import org.eclipse.compare.tests.PatchUtils;

public class PatchLinesTest
extends TestCase {
    public PatchLinesTest(String name) {
        super(name);
    }

    public void test_196847() throws Exception {
        int[] lines = this.parsePatch("196847/stuff_patch.txt");
        PatchLinesTest.assertEquals((int)6, (int)lines[0]);
        PatchLinesTest.assertEquals((int)5, (int)lines[1]);
    }

    public void test_deletion_autofuzz() throws Exception {
        int[] lines = this.parsePatch("deletion_autofuzz/patch.txt");
        PatchLinesTest.assertEquals((int)0, (int)lines[0]);
        PatchLinesTest.assertEquals((int)1, (int)lines[1]);
    }

    public void test_patch_addition() throws Exception {
        int[] lines = this.parsePatch("patch_addition.txt");
        PatchLinesTest.assertEquals((int)9, (int)lines[0]);
        PatchLinesTest.assertEquals((int)0, (int)lines[1]);
    }

    public void test_patch_context1() throws Exception {
        int[] lines = this.parsePatch("patch_context1.txt");
        PatchLinesTest.assertEquals((int)4, (int)lines[0]);
        PatchLinesTest.assertEquals((int)2, (int)lines[1]);
    }

    public void test_patch_context3() throws Exception {
        int[] lines = this.parsePatch("patch_context3.txt");
        PatchLinesTest.assertEquals((int)4, (int)lines[0]);
        PatchLinesTest.assertEquals((int)2, (int)lines[1]);
    }

    public void test_patch_workspacePatchAddition() throws Exception {
        int[] lines = this.parsePatch("patch_workspacePatchAddition.txt");
        PatchLinesTest.assertEquals((int)31, (int)lines[0]);
        PatchLinesTest.assertEquals((int)0, (int)lines[1]);
    }

    public void test_patch_workspacePatchDelete() throws Exception {
        int[] lines = this.parsePatch("patch_workspacePatchDelete.txt");
        PatchLinesTest.assertEquals((int)29, (int)lines[0]);
        PatchLinesTest.assertEquals((int)46, (int)lines[1]);
    }

    public void test_patch_workspacePatchMod() throws Exception {
        int[] lines = this.parsePatch("patch_workspacePatchMod.txt");
        PatchLinesTest.assertEquals((int)33, (int)lines[0]);
        PatchLinesTest.assertEquals((int)8, (int)lines[1]);
    }

    public void test_patch_addition_context() throws Exception {
        int[] lines = this.parsePatch("patch_addition_context.txt");
        PatchLinesTest.assertEquals((int)9, (int)lines[0]);
        PatchLinesTest.assertEquals((int)0, (int)lines[1]);
    }

    public void test_patch_oneline_context() throws Exception {
        int[] lines = this.parsePatch("patch_oneline_context.txt");
        PatchLinesTest.assertEquals((int)1, (int)lines[0]);
        PatchLinesTest.assertEquals((int)0, (int)lines[1]);
    }

    public void test_patch_context3_context() throws Exception {
        int[] lines = this.parsePatch("patch_context3_context.txt");
        PatchLinesTest.assertEquals((int)4, (int)lines[0]);
        PatchLinesTest.assertEquals((int)2, (int)lines[1]);
    }

    private int[] parsePatch(String patch) {
        WorkspacePatcher patcher = new WorkspacePatcher();
        try {
            patcher.parse(this.getReader(patch));
            patcher.countLines();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int[] result = new int[2];
        int hunksLengthSum = 0;
        int fileDiffSum = 0;
        FilePatch2[] diffs = patcher.getDiffs();
        int i = 0;
        while (i < diffs.length) {
            FilePatch2 fileDiff = diffs[i];
            IHunk[] hunks = fileDiff.getHunks();
            int j = 0;
            while (j < hunks.length) {
                IHunk hunk = hunks[j];
                hunksLengthSum += this.getNewLength(hunk);
                hunksLengthSum -= this.getOldLength(hunk);
                ++j;
            }
            result[0] = result[0] + fileDiff.getAddedLines();
            result[1] = result[1] + fileDiff.getRemovedLines();
            fileDiffSum += fileDiff.getAddedLines();
            fileDiffSum -= fileDiff.getRemovedLines();
            ++i;
        }
        PatchLinesTest.assertEquals((int)hunksLengthSum, (int)fileDiffSum);
        return result;
    }

    private BufferedReader getReader(String name) {
        return PatchUtils.getReader(name);
    }

    private int getNewLength(IHunk hunk) {
        Class<?> cls = hunk.getClass();
        try {
            Field fld = cls.getDeclaredField("fNewLength");
            fld.setAccessible(true);
            return fld.getInt(hunk);
        }
        catch (SecurityException e) {
            PatchLinesTest.fail((String)e.getMessage());
        }
        catch (NoSuchFieldException e) {
            PatchLinesTest.fail((String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            PatchLinesTest.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            PatchLinesTest.fail((String)e.getMessage());
        }
        PatchLinesTest.fail();
        return -1;
    }

    private int getOldLength(IHunk hunk) {
        Class<?> cls = hunk.getClass();
        try {
            Field fld = cls.getDeclaredField("fOldLength");
            fld.setAccessible(true);
            return fld.getInt(hunk);
        }
        catch (SecurityException e) {
            PatchLinesTest.fail((String)e.getMessage());
        }
        catch (NoSuchFieldException e) {
            PatchLinesTest.fail((String)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            PatchLinesTest.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            PatchLinesTest.fail((String)e.getMessage());
        }
        PatchLinesTest.fail();
        return -1;
    }
}

