/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import junit.framework.TestCase;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.internal.CompareUIPlugin;
import org.eclipse.compare.internal.patch.PatchMessages;
import org.eclipse.compare.internal.patch.PatchWizard;
import org.eclipse.compare.internal.patch.PatchWizardDialog;
import org.eclipse.compare.tests.PatchUtils;
import org.eclipse.compare.tests.ReflectionUtils;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class PatchUITest
extends TestCase {
    private static final String TEST_PROJECT = "ApplyPatchTest";
    private IWorkspaceRoot workspaceRoot = null;
    private IProject testProject = null;
    private PatchWizardDialog wizardDialog = null;
    private PatchWizard wizard = null;

    public PatchUITest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.testProject = this.workspaceRoot.getProject(TEST_PROJECT);
        this.testProject.create(null);
        this.testProject.open(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.testProject.delete(true, null);
    }

    public void testApplyClipboardPatch() throws CoreException {
        if (Platform.getOS().equals("macosx")) {
            return;
        }
        this.copyIntoClipboard("patch_context0.txt");
        this.copyIntoWorkspace("context.txt");
        this.openPatchWizard();
        PatchUITest.assertTrue((this.wizard.getPageCount() == 3 ? 1 : 0) != 0);
        IWizardPage patchWizardPage = this.wizard.getPages()[0];
        PatchUITest.assertTrue((boolean)patchWizardPage.canFlipToNextPage());
        this.callMethod(this.wizardDialog, "nextPressed", new Object[0]);
        this.processQueuedEvents();
        PatchUITest.assertTrue((boolean)this.wizard.canFinish());
        this.wizard.performFinish();
        this.wizardDialog.close();
        InputStream expected = PatchUtils.asInputStream("exp_context.txt");
        InputStream actual = this.testProject.getFile("context.txt").getContents();
        this.compareStreams(expected, actual);
    }

    public void testApplyWorkspacePatch() throws CoreException {
        this.copyIntoWorkspace("patch_addition.txt");
        this.openPatchWizard();
        PatchUITest.assertTrue((this.wizard.getPageCount() == 3 ? 1 : 0) != 0);
        IWizardPage patchWizardPage = this.wizard.getPages()[0];
        this.getButton(patchWizardPage, "fUseClipboardButton").setSelection(false);
        this.getButton(patchWizardPage, "fUsePatchFileButton").setSelection(false);
        this.getButton(patchWizardPage, "fUseWorkspaceButton").setSelection(true);
        TreeViewer tree = this.getTreeViewer(patchWizardPage, "fTreeViewer");
        this.treeSelect(tree, "ApplyPatchTest/patch_addition.txt");
        this.processQueuedEvents();
        PatchUITest.assertTrue((boolean)patchWizardPage.canFlipToNextPage());
        this.callMethod(this.wizardDialog, "nextPressed", new Object[0]);
        PatchUITest.assertTrue((boolean)this.wizard.canFinish());
        this.wizard.performFinish();
        this.wizardDialog.close();
        InputStream expected = PatchUtils.asInputStream("exp_addition.txt");
        InputStream actual = this.testProject.getFile("exp_addition.txt").getContents();
        this.compareStreams(expected, actual);
    }

    public void testApplyClipboardPatch_AdditionWithWindowsLD() throws Exception {
        if (Platform.getOS().equals("macosx")) {
            return;
        }
        Preferences workspacePreferences = Platform.getPreferencesService().getRootNode().node("instance");
        String previous = this.getStoredValue(workspacePreferences);
        this.saveValue(workspacePreferences, "\r\n");
        this.copyIntoClipboard("patch_addition.txt");
        this.openPatchWizard();
        PatchUITest.assertTrue((this.wizard.getPageCount() == 3 ? 1 : 0) != 0);
        IWizardPage patchWizardPage = this.wizard.getPages()[0];
        PatchUITest.assertTrue((boolean)patchWizardPage.canFlipToNextPage());
        this.callMethod(this.wizardDialog, "nextPressed", new Object[0]);
        this.processQueuedEvents();
        PatchUITest.assertTrue((boolean)this.wizard.canFinish());
        this.wizard.performFinish();
        this.wizardDialog.close();
        InputStream expectedIS = PatchUtils.asInputStream("exp_addition.txt");
        InputStream actualIS = this.testProject.getFile("exp_addition.txt").getContents();
        String expected = PatchUtils.asString(expectedIS).replaceAll("\n", "\r\n");
        String actual = PatchUtils.asString(actualIS);
        PatchUITest.assertEquals((String)expected, (String)actual);
        this.saveValue(workspacePreferences, previous);
    }

    private String getStoredValue(Preferences node) {
        try {
            if (node.nodeExists("org.eclipse.core.runtime")) {
                return node.node("org.eclipse.core.runtime").get("line.separator", null);
            }
        }
        catch (BackingStoreException backingStoreException) {}
        return null;
    }

    private void saveValue(Preferences preferences, String val) throws BackingStoreException {
        Preferences node = preferences.node("org.eclipse.core.runtime");
        if (val == null) {
            node.remove("line.separator");
        } else {
            node.put("line.separator", val);
        }
        node.flush();
    }

    private void openPatchWizard() {
        ImageDescriptor patchWizardImage = CompareUIPlugin.getImageDescriptor((String)"wizban/applypatch_wizban.png");
        String patchWizardTitle = PatchMessages.PatchWizard_title;
        IStorage patch = null;
        IResource target = null;
        CompareConfiguration configuration = new CompareConfiguration();
        this.wizard = new PatchWizard(patch, target, configuration);
        if (patchWizardImage != null) {
            this.wizard.setDefaultPageImageDescriptor(patchWizardImage);
        }
        if (patchWizardTitle != null) {
            this.wizard.setWindowTitle(patchWizardTitle);
        }
        this.wizard.setNeedsProgressMonitor(true);
        this.wizardDialog = new PatchWizardDialog(this.getShell(), (IWizard)this.wizard);
        this.wizardDialog.setBlockOnOpen(false);
        this.wizardDialog.open();
    }

    private void copyIntoClipboard(String name) {
        Clipboard clipboard = new Clipboard(this.getShell().getDisplay());
        InputStream patchIS = PatchUtils.asInputStream(name);
        String patch = null;
        try {
            patch = PatchUtils.asString(patchIS);
        }
        catch (IOException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        TextTransfer textTransfer = TextTransfer.getInstance();
        Transfer[] transfers = new Transfer[]{textTransfer};
        Object[] data = new Object[]{patch};
        clipboard.setContents(data, transfers);
        clipboard.dispose();
    }

    private void copyIntoWorkspace(String name) {
        IFile file = this.testProject.getFile(name);
        InputStream is = PatchUtils.asInputStream(name);
        try {
            file.create(is, true, null);
        }
        catch (CoreException e) {
            PatchUITest.fail((String)e.getMessage());
        }
    }

    private void compareStreams(InputStream expectedIS, InputStream actualIS) {
        String expected = null;
        String actual = null;
        try {
            expected = PatchUtils.asString(expectedIS);
            actual = PatchUtils.asString(actualIS);
        }
        catch (IOException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        PatchUITest.assertEquals((String)expected, (String)actual);
    }

    private void treeSelect(TreeViewer tree, String path) {
        WorkspaceRoot root = (WorkspaceRoot)tree.getInput();
        IFile file = root.getFile(path);
        TreePath treePath = new TreePath(new Object[]{file});
        TreeSelection sel = new TreeSelection(treePath);
        tree.setSelection((ISelection)sel);
    }

    private Button getButton(Object object, String name) {
        return (Button)this.getField(object, name);
    }

    private TreeViewer getTreeViewer(Object object, String name) {
        return (TreeViewer)this.getField(object, name);
    }

    private Object getField(Object object, String name) {
        Object ret = null;
        try {
            ret = ReflectionUtils.getField(object, name);
        }
        catch (IllegalArgumentException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        catch (SecurityException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        catch (NoSuchFieldException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        return ret;
    }

    private Object callMethod(Object object, String name, Object[] args) {
        Object ret = null;
        try {
            ret = ReflectionUtils.callMethod(object, name, args);
        }
        catch (IllegalArgumentException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        catch (IllegalAccessException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        catch (InvocationTargetException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        catch (NoSuchMethodException e) {
            PatchUITest.fail((String)e.getMessage());
        }
        return ret;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    private void processQueuedEvents() {
        while (Display.getCurrent().readAndDispatch()) {
        }
    }
}

