/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.TestCase;
import org.eclipse.compare.internal.merge.TextStreamMerger;
import org.eclipse.core.runtime.IStatus;

public class StreamMergerTest
extends TestCase {
    private static final String ABC = "abc";
    private static final String DEF = "def";
    private static final String BAR = "bar";
    private static final String FOO = "foo";
    private static final String XYZ = "xyz";
    private static final String _123 = "123";
    private static final String _456 = "456";
    String encoding = "UTF-8";
    static final String SEPARATOR = System.getProperty("line.separator");

    public StreamMergerTest(String name) {
        super(name);
    }

    public void testIncomingAddition() throws UnsupportedEncodingException {
        String a = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String t = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String o = ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ;
        StringBuffer output = new StringBuffer();
        IStatus status = this.merge(output, a, t, o);
        StreamMergerTest.assertEquals((int)status.getSeverity(), (int)0);
        StreamMergerTest.assertEquals((int)status.getCode(), (int)0);
        StreamMergerTest.assertEquals((String)output.toString(), (String)(ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ + SEPARATOR));
    }

    public void testIncomingDeletion() throws UnsupportedEncodingException {
        String a = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String t = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String o = ABC + SEPARATOR + XYZ;
        StringBuffer output = new StringBuffer();
        IStatus status = this.merge(output, a, t, o);
        StreamMergerTest.assertEquals((int)status.getSeverity(), (int)0);
        StreamMergerTest.assertEquals((int)status.getCode(), (int)0);
        StreamMergerTest.assertEquals((String)output.toString(), (String)(ABC + SEPARATOR + XYZ + SEPARATOR));
    }

    public void testIncomingReplacement() throws UnsupportedEncodingException {
        String a = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String t = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String o = ABC + SEPARATOR + _123 + SEPARATOR + XYZ;
        StringBuffer output = new StringBuffer();
        IStatus status = this.merge(output, a, t, o);
        StreamMergerTest.assertEquals((int)status.getSeverity(), (int)0);
        StreamMergerTest.assertEquals((int)status.getCode(), (int)0);
        StreamMergerTest.assertEquals((String)output.toString(), (String)(ABC + SEPARATOR + _123 + SEPARATOR + XYZ + SEPARATOR));
    }

    public void testNonConflictingMerge() throws UnsupportedEncodingException {
        String a = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String t = ABC + SEPARATOR + DEF + SEPARATOR + XYZ + SEPARATOR + FOO;
        String o = ABC + SEPARATOR + _123 + SEPARATOR + _456 + SEPARATOR + XYZ;
        StringBuffer output = new StringBuffer();
        IStatus status = this.merge(output, a, t, o);
        StreamMergerTest.assertEquals((int)status.getSeverity(), (int)0);
        StreamMergerTest.assertEquals((int)status.getCode(), (int)0);
        StreamMergerTest.assertEquals((String)output.toString(), (String)(ABC + SEPARATOR + _123 + SEPARATOR + _456 + SEPARATOR + XYZ + SEPARATOR + FOO + SEPARATOR));
    }

    public void testConflictingReplacement() throws UnsupportedEncodingException {
        String a = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String t = ABC + SEPARATOR + FOO + SEPARATOR + XYZ;
        String o = ABC + SEPARATOR + BAR + SEPARATOR + XYZ;
        StringBuffer output = new StringBuffer();
        IStatus status = this.merge(output, a, t, o);
        StreamMergerTest.assertEquals((int)status.getSeverity(), (int)4);
        StreamMergerTest.assertEquals((int)status.getCode(), (int)1);
    }

    public void testConflictingAddition() throws UnsupportedEncodingException {
        String a = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String t = ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ;
        String o = ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ;
        StringBuffer output = new StringBuffer();
        IStatus status = this.merge(output, a, t, o);
        StreamMergerTest.assertEquals((int)status.getSeverity(), (int)0);
        StreamMergerTest.assertEquals((int)status.getCode(), (int)0);
        StreamMergerTest.assertEquals((String)output.toString(), (String)(ABC + SEPARATOR + DEF + SEPARATOR + _123 + SEPARATOR + XYZ + SEPARATOR));
    }

    public void testConflictingDeletion() throws UnsupportedEncodingException {
        String a = ABC + SEPARATOR + DEF + SEPARATOR + XYZ;
        String t = ABC + SEPARATOR + XYZ;
        String o = ABC + SEPARATOR + XYZ;
        StringBuffer output = new StringBuffer();
        IStatus status = this.merge(output, a, t, o);
        StreamMergerTest.assertEquals((int)status.getSeverity(), (int)0);
        StreamMergerTest.assertEquals((int)status.getCode(), (int)0);
        StreamMergerTest.assertEquals((String)output.toString(), (String)(ABC + SEPARATOR + XYZ + SEPARATOR));
    }

    private IStatus merge(StringBuffer output, String a, String m, String y) throws UnsupportedEncodingException {
        ByteArrayInputStream ancestor = new ByteArrayInputStream(a.getBytes(this.encoding));
        ByteArrayInputStream target = new ByteArrayInputStream(m.getBytes(this.encoding));
        ByteArrayInputStream other = new ByteArrayInputStream(y.getBytes(this.encoding));
        return this.merge(output, ancestor, target, other);
    }

    private IStatus merge(StringBuffer output, InputStream ancestor, InputStream target, InputStream other) throws UnsupportedEncodingException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        TextStreamMerger merger = new TextStreamMerger();
        IStatus status = merger.merge((OutputStream)os, this.encoding, ancestor, this.encoding, target, this.encoding, other, this.encoding, null);
        output.append(new String(os.toByteArray(), this.encoding));
        return status;
    }
}

