/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.tests.performance;

import org.eclipse.compare.internal.DocLineComparator;
import org.eclipse.compare.rangedifferencer.IRangeComparator;
import org.eclipse.compare.rangedifferencer.RangeDifference;
import org.eclipse.compare.rangedifferencer.RangeDifferencer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.PerformanceTestCase;

public class RangeDifferencerTest
extends PerformanceTestCase {
    public RangeDifferencerTest(String name) {
        super(name);
    }

    private IDocument createDocument(int code) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < 5000) {
            sb.append("line ");
            sb.append(Integer.toString(i));
            sb.append('\n');
            int mod = i % 10;
            switch (code) {
                case 1: {
                    if (mod == 1) {
                        sb.append("outgoing\n");
                    }
                    if (mod != 4) break;
                    sb.append("conflict1\n");
                    break;
                }
                case 2: {
                    if (mod == 7) {
                        sb.append("incoming\n");
                    }
                    if (mod != 4) break;
                    sb.append("conflict2\n");
                }
            }
            ++i;
        }
        return new Document(sb.toString());
    }

    public void testLargeDocument() {
        this.tagAsGlobalSummary("3-way compare, 5000 lines", Dimension.ELAPSED_PROCESS);
        DocLineComparator ancestor = new DocLineComparator(this.createDocument(0), null, false);
        DocLineComparator left = new DocLineComparator(this.createDocument(1), null, false);
        DocLineComparator right = new DocLineComparator(this.createDocument(2), null, false);
        RangeDifference[] diffs = null;
        diffs = RangeDifferencer.findRanges((IProgressMonitor)new NullProgressMonitor(), (IRangeComparator)ancestor, (IRangeComparator)left, (IRangeComparator)right);
        int i = 0;
        while (i < diffs.length - 6) {
            RangeDifferencerTest.assertEquals((int)diffs[i + 0].kind(), (int)0);
            RangeDifferencerTest.assertEquals((int)diffs[i + 1].kind(), (int)3);
            RangeDifferencerTest.assertEquals((int)diffs[i + 2].kind(), (int)0);
            RangeDifferencerTest.assertEquals((int)diffs[i + 3].kind(), (int)1);
            RangeDifferencerTest.assertEquals((int)diffs[i + 4].kind(), (int)0);
            RangeDifferencerTest.assertEquals((int)diffs[i + 5].kind(), (int)2);
            i += 6;
        }
        int count = 0;
        while (count < 3) {
            this.startMeasuring();
            RangeDifferencer.findRanges((IProgressMonitor)new NullProgressMonitor(), (IRangeComparator)ancestor, (IRangeComparator)left, (IRangeComparator)right);
            this.stopMeasuring();
            ++count;
        }
        this.commitMeasurements();
        this.assertPerformance();
    }
}

