/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.internal.expressions.CountExpression;
import org.eclipse.core.runtime.CoreException;
import org.junit.Assert;

public class CountExpressionTest
extends TestCase {
    public static Test suite() {
        return new TestSuite(CountExpressionTest.class);
    }

    private static EvaluationContext evaluationContext(int size) {
        ArrayList<Integer> variable = new ArrayList<Integer>(size + 1);
        int i = 0;
        while (i < size) {
            variable.add(i);
            ++i;
        }
        return new EvaluationContext(null, variable);
    }

    public void testNoneExpression() throws CoreException {
        CountExpression e = new CountExpression("!");
        Assert.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(0)));
        Assert.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(1)));
    }

    public void testNoneOrOneExpression() throws CoreException {
        CountExpression e = new CountExpression("?");
        Assert.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(0)));
        Assert.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(1)));
        Assert.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(2)));
    }

    public void testExactExpression() throws CoreException {
        CountExpression e = new CountExpression("5");
        Assert.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(5)));
        Assert.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(7)));
    }

    public void testAnyNumberExpression() throws CoreException {
        CountExpression e = new CountExpression("*");
        Assert.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(5)));
    }

    public void testLessThanExpression() throws CoreException {
        CountExpression e = new CountExpression("-3)");
        Assert.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(1)));
        Assert.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(3)));
        Assert.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(4)));
    }

    public void testGreaterThanExpression() throws CoreException {
        CountExpression e = new CountExpression("(3-");
        Assert.assertEquals((Object)EvaluationResult.TRUE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(5)));
        Assert.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(3)));
        Assert.assertEquals((Object)EvaluationResult.FALSE, (Object)e.evaluate((IEvaluationContext)CountExpressionTest.evaluationContext(2)));
    }
}

