/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import java.util.Arrays;
import java.util.HashSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionInfo;
import org.eclipse.core.internal.expressions.AdaptExpression;
import org.eclipse.core.internal.expressions.AndExpression;
import org.eclipse.core.internal.expressions.CountExpression;
import org.eclipse.core.internal.expressions.EqualsExpression;
import org.eclipse.core.internal.expressions.InstanceofExpression;
import org.eclipse.core.internal.expressions.IterateExpression;
import org.eclipse.core.internal.expressions.NotExpression;
import org.eclipse.core.internal.expressions.ResolveExpression;
import org.eclipse.core.internal.expressions.SystemTestExpression;
import org.eclipse.core.internal.expressions.TestExpression;
import org.eclipse.core.internal.expressions.WithExpression;

public class ExpressionInfoTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ExpressionInfoTests.class);
    }

    public void testMergeEmpty() {
        ExpressionInfo info = new ExpressionInfo();
        info.merge(new ExpressionInfo());
        this.assertNoAccess(info);
    }

    public void testMergeDefaultVariable() {
        ExpressionInfo info = new ExpressionInfo();
        info.markDefaultVariableAccessed();
        info.merge(new ExpressionInfo());
        this.assertDefaultAccessOnly(info);
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.markDefaultVariableAccessed();
        info.merge(other);
        this.assertDefaultAccessOnly(info);
        info = new ExpressionInfo();
        other = new ExpressionInfo();
        info.markDefaultVariableAccessed();
        other.markDefaultVariableAccessed();
        info.merge(other);
        this.assertDefaultAccessOnly(info);
    }

    public void testMergeSystemProperty() {
        ExpressionInfo info = new ExpressionInfo();
        info.markSystemPropertyAccessed();
        info.merge(new ExpressionInfo());
        this.assertSystemPropertyOnly(info);
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.markSystemPropertyAccessed();
        info.merge(other);
        this.assertSystemPropertyOnly(info);
        info = new ExpressionInfo();
        other = new ExpressionInfo();
        info.markSystemPropertyAccessed();
        other.markSystemPropertyAccessed();
        info.merge(other);
        this.assertSystemPropertyOnly(info);
    }

    public void testMergeVariableNames() {
        ExpressionInfo info = new ExpressionInfo();
        info.addVariableNameAccess("variable");
        info.merge(new ExpressionInfo());
        this.assertVariableAccess(info, "variable");
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.addVariableNameAccess("variable");
        info.merge(other);
        this.assertVariableAccess(info, "variable");
        info = new ExpressionInfo();
        info.addVariableNameAccess("variable");
        other = new ExpressionInfo();
        other.addVariableNameAccess("variable");
        info.merge(other);
        this.assertVariableAccess(info, "variable");
        info = new ExpressionInfo();
        info.addVariableNameAccess("variable_one");
        other = new ExpressionInfo();
        other.addVariableNameAccess("variable_two");
        info.merge(other);
        this.assertVariableAccess(info, new String[]{"variable_one", "variable_two"});
    }

    public void testMergePropertyNames() {
        ExpressionInfo info = new ExpressionInfo();
        info.addAccessedPropertyName("property");
        info.merge(new ExpressionInfo());
        this.assertPropertyAccess(info, "property", false);
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.addAccessedPropertyName("property");
        info.merge(other);
        this.assertPropertyAccess(info, "property", false);
        info = new ExpressionInfo();
        other = new ExpressionInfo();
        info.addAccessedPropertyName("property");
        other.addAccessedPropertyName("property");
        info.merge(other);
        this.assertPropertyAccess(info, "property", false);
        info = new ExpressionInfo();
        other = new ExpressionInfo();
        info.addAccessedPropertyName("prop1");
        other.addAccessedPropertyName("prop2");
        info.merge(other);
        this.assertPropertyAccess(info, new String[]{"prop1", "prop2"}, false);
    }

    public void testMergeMisbehavingExpressionTypes() {
        ExpressionInfo info = new ExpressionInfo();
        info.addMisBehavingExpressionType(WithExpression.class);
        info.merge(new ExpressionInfo());
        this.assertMisbehavedExpressionTypes(info, new Class[]{WithExpression.class});
        info = new ExpressionInfo();
        ExpressionInfo other = new ExpressionInfo();
        other.addMisBehavingExpressionType(WithExpression.class);
        info.merge(other);
        this.assertMisbehavedExpressionTypes(info, new Class[]{WithExpression.class});
        info = new ExpressionInfo();
        info.addMisBehavingExpressionType(WithExpression.class);
        other = new ExpressionInfo();
        other.addMisBehavingExpressionType(WithExpression.class);
        info.merge(other);
        this.assertMisbehavedExpressionTypes(info, new Class[]{WithExpression.class});
        info = new ExpressionInfo();
        info.addMisBehavingExpressionType(WithExpression.class);
        other = new ExpressionInfo();
        other.addMisBehavingExpressionType(ResolveExpression.class);
        info.merge(other);
        this.assertMisbehavedExpressionTypes(info, new Class[]{WithExpression.class, ResolveExpression.class});
    }

    public void testCountExpression() {
        this.assertDefaultAccessOnly(new CountExpression("10").computeExpressionInfo());
    }

    public void testEqualsExpression() {
        this.assertDefaultAccessOnly(new EqualsExpression(new Object()).computeExpressionInfo());
    }

    public void testInstanceofExpression() {
        this.assertDefaultAccessOnly(new InstanceofExpression("java.lang.Object").computeExpressionInfo());
    }

    public void testNotExpression() {
        this.assertDefaultAccessOnly(new NotExpression((Expression)new CountExpression("10")).computeExpressionInfo());
    }

    public void testSystemExpression() {
        this.assertSystemPropertyOnly(new SystemTestExpression("property", "value").computeExpressionInfo());
    }

    public void testTestExpression() {
        this.assertPropertyAccess(new TestExpression("namespace", "property", null, new Object()).computeExpressionInfo(), "namespace.property", true);
    }

    public void testAdaptExpression() throws Exception {
        this.assertDefaultAccessOnly(new AdaptExpression("java.lang.Object").computeExpressionInfo());
    }

    public void testAndExpression() throws Exception {
        AndExpression and = new AndExpression();
        this.assertNoAccess(and.computeExpressionInfo());
        and.add((Expression)new CountExpression("10"));
        this.assertDefaultAccessOnly(and.computeExpressionInfo());
    }

    public void testIterateExpression() throws Exception {
        this.assertDefaultAccessOnly(new IterateExpression("or").computeExpressionInfo());
    }

    public void testResolveExpression() {
        ResolveExpression resolve = new ResolveExpression("variable", null);
        this.assertNoAccess(resolve.computeExpressionInfo());
        resolve.add((Expression)new CountExpression("10"));
        this.assertVariableAccess(resolve.computeExpressionInfo(), "variable");
    }

    public void testWithExpression() {
        WithExpression with = new WithExpression("variable");
        this.assertNoAccess(with.computeExpressionInfo());
        with.add((Expression)new CountExpression("10"));
        this.assertVariableAccess(with.computeExpressionInfo(), "variable");
    }

    private void assertDefaultAccessOnly(ExpressionInfo info) {
        ExpressionInfoTests.assertTrue((String)"Accesses default variable", (boolean)info.hasDefaultVariableAccess());
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses system property", (boolean)info.hasSystemPropertyAccess());
        ExpressionInfoTests.assertTrue((String)"No variable accesses", (info.getAccessedVariableNames().length == 0 ? 1 : 0) != 0);
        ExpressionInfoTests.assertNull((String)"No misbehaving expression types", (Object)info.getMisbehavingExpressionTypes());
        ExpressionInfoTests.assertEquals((String)"No properties accessed", (int)0, (int)info.getAccessedPropertyNames().length);
    }

    private void assertSystemPropertyOnly(ExpressionInfo info) {
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses default variable", (boolean)info.hasDefaultVariableAccess());
        ExpressionInfoTests.assertTrue((String)"Accesses system property", (boolean)info.hasSystemPropertyAccess());
        ExpressionInfoTests.assertTrue((String)"No variable accesses", (info.getAccessedVariableNames().length == 0 ? 1 : 0) != 0);
        ExpressionInfoTests.assertNull((String)"No misbehaving expression types", (Object)info.getMisbehavingExpressionTypes());
        ExpressionInfoTests.assertEquals((String)"No properties accessed", (int)0, (int)info.getAccessedPropertyNames().length);
    }

    private void assertNoAccess(ExpressionInfo info) {
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses default variable", (boolean)info.hasDefaultVariableAccess());
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses system property", (boolean)info.hasSystemPropertyAccess());
        ExpressionInfoTests.assertTrue((String)"No variable accesses", (info.getAccessedVariableNames().length == 0 ? 1 : 0) != 0);
        ExpressionInfoTests.assertNull((String)"No misbehaving expression types", (Object)info.getMisbehavingExpressionTypes());
        ExpressionInfoTests.assertEquals((String)"No properties accessed", (int)0, (int)info.getAccessedPropertyNames().length);
    }

    private void assertVariableAccess(ExpressionInfo info, String variable) {
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses default variable", (boolean)info.hasDefaultVariableAccess());
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses system property", (boolean)info.hasSystemPropertyAccess());
        String[] accessedVariableNames = info.getAccessedVariableNames();
        ExpressionInfoTests.assertEquals((String)"One variable accessed", (int)1, (int)accessedVariableNames.length);
        ExpressionInfoTests.assertEquals((String)"Variable accessed", (String)variable, (String)accessedVariableNames[0]);
        ExpressionInfoTests.assertNull((String)"No misbehaving expression types", (Object)info.getMisbehavingExpressionTypes());
        ExpressionInfoTests.assertEquals((String)"No properties accessed", (int)0, (int)info.getAccessedPropertyNames().length);
    }

    private void assertVariableAccess(ExpressionInfo info, String[] variables) {
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses default variable", (boolean)info.hasDefaultVariableAccess());
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses system property", (boolean)info.hasSystemPropertyAccess());
        HashSet<String> accessedVariableNames = new HashSet<String>(Arrays.asList(info.getAccessedVariableNames()));
        ExpressionInfoTests.assertEquals((String)"All variable accessed", (int)variables.length, (int)accessedVariableNames.size());
        String[] stringArray = variables;
        int n = variables.length;
        int n2 = 0;
        while (n2 < n) {
            String variable = stringArray[n2];
            ExpressionInfoTests.assertTrue((String)"Variable accessed", (boolean)accessedVariableNames.contains(variable));
            ++n2;
        }
        ExpressionInfoTests.assertNull((String)"No misbehaving expression types", (Object)info.getMisbehavingExpressionTypes());
        ExpressionInfoTests.assertEquals((String)"No properties accessed", (int)0, (int)info.getAccessedPropertyNames().length);
    }

    private void assertPropertyAccess(ExpressionInfo info, String property, boolean defaultVariable) {
        ExpressionInfoTests.assertEquals((String)"Accesses default variable", (boolean)defaultVariable, (boolean)info.hasDefaultVariableAccess());
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses system property", (boolean)info.hasSystemPropertyAccess());
        String[] accessedPropertyNames = info.getAccessedPropertyNames();
        ExpressionInfoTests.assertEquals((String)"One property accessed", (int)1, (int)accessedPropertyNames.length);
        ExpressionInfoTests.assertEquals((String)"Property accessed", (String)property, (String)accessedPropertyNames[0]);
        ExpressionInfoTests.assertNull((String)"No misbehaving expression types", (Object)info.getMisbehavingExpressionTypes());
        ExpressionInfoTests.assertEquals((String)"No variable accesses", (int)0, (int)info.getAccessedVariableNames().length);
    }

    private void assertPropertyAccess(ExpressionInfo info, String[] properties, boolean defaultVariable) {
        ExpressionInfoTests.assertEquals((String)"Accesses default variable", (boolean)defaultVariable, (boolean)info.hasDefaultVariableAccess());
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses system property", (boolean)info.hasSystemPropertyAccess());
        HashSet<String> accessedPropertyNames = new HashSet<String>(Arrays.asList(info.getAccessedPropertyNames()));
        ExpressionInfoTests.assertEquals((String)"All properties accessed", (int)properties.length, (int)accessedPropertyNames.size());
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            ExpressionInfoTests.assertTrue((String)"Property accessed", (boolean)accessedPropertyNames.contains(property));
            ++n2;
        }
        ExpressionInfoTests.assertNull((String)"No misbehaving expression types", (Object)info.getMisbehavingExpressionTypes());
        ExpressionInfoTests.assertEquals((String)"No variable accesses", (int)0, (int)info.getAccessedVariableNames().length);
    }

    private void assertMisbehavedExpressionTypes(ExpressionInfo info, Class<?>[] types) {
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses default variable", (boolean)info.hasDefaultVariableAccess());
        ExpressionInfoTests.assertFalse((String)"Doesn't accesses system property", (boolean)info.hasSystemPropertyAccess());
        ExpressionInfoTests.assertTrue((String)"No variable accesses", (info.getAccessedVariableNames().length == 0 ? 1 : 0) != 0);
        ExpressionInfoTests.assertEquals((String)"No properties accessed", (int)0, (int)info.getAccessedPropertyNames().length);
        HashSet<Class> misbehavedTypes = new HashSet<Class>(Arrays.asList(info.getMisbehavingExpressionTypes()));
        ExpressionInfoTests.assertEquals((String)"All types accessed", (int)types.length, (int)misbehavedTypes.size());
        Class<?>[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> type = classArray[n2];
            ExpressionInfoTests.assertTrue((String)"Type collected", (boolean)misbehavedTypes.contains(type));
            ++n2;
        }
    }
}

