/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import java.net.URL;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.expressions.IVariableResolver;
import org.eclipse.core.internal.expressions.AdaptExpression;
import org.eclipse.core.internal.expressions.AndExpression;
import org.eclipse.core.internal.expressions.CountExpression;
import org.eclipse.core.internal.expressions.EnablementExpression;
import org.eclipse.core.internal.expressions.EqualsExpression;
import org.eclipse.core.internal.expressions.Expressions;
import org.eclipse.core.internal.expressions.InstanceofExpression;
import org.eclipse.core.internal.expressions.IterateExpression;
import org.eclipse.core.internal.expressions.NotExpression;
import org.eclipse.core.internal.expressions.OrExpression;
import org.eclipse.core.internal.expressions.ResolveExpression;
import org.eclipse.core.internal.expressions.SystemTestExpression;
import org.eclipse.core.internal.expressions.TestExpression;
import org.eclipse.core.internal.expressions.WithExpression;
import org.eclipse.core.internal.expressions.tests.A;
import org.eclipse.core.internal.expressions.tests.AdaptableAdaptee;
import org.eclipse.core.internal.expressions.tests.Adaptee;
import org.eclipse.core.internal.expressions.tests.B;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ExpressionTests
extends TestCase {
    private static final int TYPE_ITERATIONS = 100000;

    public static Test suite() {
        return new TestSuite(ExpressionTests.class);
    }

    public void testEscape() throws Exception {
        ExpressionTests.assertEquals((String)"Str'ing", (String)Expressions.unEscapeString((String)"Str''ing"));
        ExpressionTests.assertEquals((String)"'", (String)Expressions.unEscapeString((String)"''"));
        boolean caught = false;
        try {
            Expressions.unEscapeString((String)"'");
        }
        catch (CoreException coreException) {
            caught = true;
        }
        ExpressionTests.assertTrue((boolean)caught);
    }

    public void testArgumentConversion() throws Exception {
        ExpressionTests.assertNull((Object)Expressions.convertArgument(null));
        ExpressionTests.assertEquals((Object)"", (Object)Expressions.convertArgument((String)""));
        ExpressionTests.assertEquals((Object)"", (Object)Expressions.convertArgument((String)"''"));
        ExpressionTests.assertEquals((Object)"eclipse", (Object)Expressions.convertArgument((String)"eclipse"));
        ExpressionTests.assertEquals((Object)"e'clips'e", (Object)Expressions.convertArgument((String)"e'clips'e"));
        ExpressionTests.assertEquals((Object)"eclipse", (Object)Expressions.convertArgument((String)"'eclipse'"));
        ExpressionTests.assertEquals((Object)"'ecl'ipse'", (Object)Expressions.convertArgument((String)"'''ecl''ipse'''"));
        ExpressionTests.assertEquals((Object)"true", (Object)Expressions.convertArgument((String)"'true'"));
        ExpressionTests.assertEquals((Object)"1.7", (Object)Expressions.convertArgument((String)"'1.7'"));
        ExpressionTests.assertEquals((Object)"007", (Object)Expressions.convertArgument((String)"'007'"));
        ExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)Expressions.convertArgument((String)"true"));
        ExpressionTests.assertEquals((Object)Boolean.FALSE, (Object)Expressions.convertArgument((String)"false"));
        ExpressionTests.assertEquals((Object)100, (Object)Expressions.convertArgument((String)"100"));
        ExpressionTests.assertEquals((Object)new Float(1.7f), (Object)Expressions.convertArgument((String)"1.7"));
    }

    public void testArgumentParsing() throws Exception {
        Object[] result = null;
        result = Expressions.parseArguments((String)"");
        ExpressionTests.assertEquals((Object)"", (Object)result[0]);
        result = Expressions.parseArguments((String)"s1");
        ExpressionTests.assertEquals((Object)"s1", (Object)result[0]);
        result = Expressions.parseArguments((String)" s1 ");
        ExpressionTests.assertEquals((Object)"s1", (Object)result[0]);
        result = Expressions.parseArguments((String)"s1,s2");
        ExpressionTests.assertEquals((Object)"s1", (Object)result[0]);
        ExpressionTests.assertEquals((Object)"s2", (Object)result[1]);
        result = Expressions.parseArguments((String)" s1 , s2 ");
        ExpressionTests.assertEquals((Object)"s1", (Object)result[0]);
        ExpressionTests.assertEquals((Object)"s2", (Object)result[1]);
        result = Expressions.parseArguments((String)"' s1 ',' s2 '");
        ExpressionTests.assertEquals((Object)" s1 ", (Object)result[0]);
        ExpressionTests.assertEquals((Object)" s2 ", (Object)result[1]);
        result = Expressions.parseArguments((String)" s1 , ' s2 '");
        ExpressionTests.assertEquals((Object)"s1", (Object)result[0]);
        ExpressionTests.assertEquals((Object)" s2 ", (Object)result[1]);
        result = Expressions.parseArguments((String)"' s1 ', s2 ");
        ExpressionTests.assertEquals((Object)" s1 ", (Object)result[0]);
        ExpressionTests.assertEquals((Object)"s2", (Object)result[1]);
        result = Expressions.parseArguments((String)"''''");
        ExpressionTests.assertEquals((Object)"'", (Object)result[0]);
        result = Expressions.parseArguments((String)"''',''',','");
        ExpressionTests.assertEquals((Object)"','", (Object)result[0]);
        ExpressionTests.assertEquals((Object)",", (Object)result[1]);
        result = Expressions.parseArguments((String)"' s1 ', true ");
        ExpressionTests.assertEquals((Object)" s1 ", (Object)result[0]);
        ExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)result[1]);
        boolean caught = false;
        try {
            Expressions.parseArguments((String)"' s1");
        }
        catch (CoreException coreException) {
            caught = true;
        }
        ExpressionTests.assertTrue((boolean)caught);
        caught = false;
        try {
            Expressions.parseArguments((String)"'''s1");
        }
        catch (CoreException coreException) {
            caught = true;
        }
        ExpressionTests.assertTrue((boolean)caught);
    }

    public void testSystemProperty() throws Exception {
        SystemTestExpression expression = new SystemTestExpression("os.name", System.getProperty("os.name"));
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, new Object()));
        ExpressionTests.assertTrue((result == EvaluationResult.TRUE ? 1 : 0) != 0);
    }

    public void testAdaptExpression() throws Exception {
        AdaptExpression expression = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)new Adaptee()));
        ExpressionTests.assertTrue((result == EvaluationResult.TRUE ? 1 : 0) != 0);
    }

    public void testAdaptExpressionAdaptable() throws Exception {
        AdaptExpression expression = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)new AdaptableAdaptee()));
        ExpressionTests.assertTrue((result == EvaluationResult.TRUE ? 1 : 0) != 0);
    }

    public void testAdaptExpressionNotEqual() throws Exception {
        AdaptExpression expression1 = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        AdaptExpression expression2 = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        ExpressionTests.assertTrue((String)"These adapt expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testAdaptExpressionHashCode() throws Exception {
        AdaptExpression expression1 = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        AdaptExpression expression2 = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testAdaptExpressionFail() throws Exception {
        AdaptExpression expression = new AdaptExpression("org.eclipse.core.internal.expressions.tests.NotExisting");
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)new Adaptee()));
        ExpressionTests.assertTrue((result == EvaluationResult.FALSE ? 1 : 0) != 0);
    }

    public void testAdaptExpressionFail2() throws Exception {
        AdaptExpression expression = new AdaptExpression("org.eclipse.core.internal.expressions.tests.Adapter");
        expression.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.NotExisting"));
        EvaluationResult result = expression.evaluate((IEvaluationContext)new EvaluationContext(null, (Object)new Adaptee()));
        ExpressionTests.assertTrue((result == EvaluationResult.FALSE ? 1 : 0) != 0);
    }

    public void testAdaptExpressionWithNull() throws Exception {
        EvaluationContext testContext = new EvaluationContext(null, (Object)new Adaptee());
        testContext.addVariable("nullCarrier", Arrays.asList(null, null, null));
        WithExpression withExpression = new WithExpression("nullCarrier");
        IterateExpression iterateExpression = new IterateExpression("and");
        iterateExpression.add((Expression)new AdaptExpression("org.eclipse.core.internal.expressions.tests.NotExisting"));
        withExpression.add((Expression)iterateExpression);
        EvaluationResult result = withExpression.evaluate((IEvaluationContext)testContext);
        ExpressionTests.assertTrue((result == EvaluationResult.FALSE ? 1 : 0) != 0);
    }

    public void testAndExpressionNotEqual() throws Exception {
        AndExpression expression1 = new AndExpression();
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        AndExpression expression2 = new AndExpression();
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        ExpressionTests.assertTrue((String)"These and expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testAndExpressionHashCode() throws Exception {
        AndExpression expression1 = new AndExpression();
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        AndExpression expression2 = new AndExpression();
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testCountExpressionNotEqual() throws Exception {
        CountExpression expression1 = new CountExpression("+");
        CountExpression expression2 = new CountExpression("!");
        ExpressionTests.assertTrue((String)"These count expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testCountExpressionHashCode() throws Exception {
        CountExpression expression1 = new CountExpression("*");
        CountExpression expression2 = new CountExpression("*");
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testEnablementExpressionNotEqual() throws Exception {
        EnablementExpression expression1 = new EnablementExpression(null);
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        EnablementExpression expression2 = new EnablementExpression(null);
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        ExpressionTests.assertTrue((String)"These enablement expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testEnablementExpressionHashCode() throws Exception {
        EnablementExpression expression1 = new EnablementExpression(null);
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        EnablementExpression expression2 = new EnablementExpression(null);
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testEqualsExpressionNotEqual() throws Exception {
        EqualsExpression expression1 = new EqualsExpression((Object)"+");
        EqualsExpression expression2 = new EqualsExpression((Object)"!");
        ExpressionTests.assertTrue((String)"These equals expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testEqualsExpressionHashCode() throws Exception {
        EqualsExpression expression1 = new EqualsExpression((Object)"*");
        EqualsExpression expression2 = new EqualsExpression((Object)"*");
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testInstanceOfExpressionNotEqual() throws Exception {
        InstanceofExpression expression1 = new InstanceofExpression("+");
        InstanceofExpression expression2 = new InstanceofExpression("!");
        ExpressionTests.assertTrue((String)"These instance of expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testInstanceOfExpressionHashCode() throws Exception {
        InstanceofExpression expression1 = new InstanceofExpression("*");
        InstanceofExpression expression2 = new InstanceofExpression("*");
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testIterateExpressionNotEqual() throws Exception {
        IterateExpression expression1 = new IterateExpression("or");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        IterateExpression expression2 = new IterateExpression("and");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertTrue((String)"These iterate expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testIterateExpressionHashCode() throws Exception {
        IterateExpression expression1 = new IterateExpression("and");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        IterateExpression expression2 = new IterateExpression("and");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testNotExpressionNotEqual() throws Exception {
        NotExpression expression1 = new NotExpression((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        NotExpression expression2 = new NotExpression((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        ExpressionTests.assertTrue((String)"These not expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testNotExpressionHashCode() throws Exception {
        NotExpression expression1 = new NotExpression((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        NotExpression expression2 = new NotExpression((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testOrExpressionNotEqual() throws Exception {
        OrExpression expression1 = new OrExpression();
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        OrExpression expression2 = new OrExpression();
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        ExpressionTests.assertTrue((String)"These or expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testOrExpressionHashCode() throws Exception {
        OrExpression expression1 = new OrExpression();
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        OrExpression expression2 = new OrExpression();
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testResolveExpressionNotEqual() throws Exception {
        ResolveExpression expression1 = new ResolveExpression("variable1", new Object[0]);
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        ResolveExpression expression2 = new ResolveExpression("variable2", new Object[0]);
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        ExpressionTests.assertTrue((String)"These resolve expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testResolveExpressionHashCode() throws Exception {
        ResolveExpression expression1 = new ResolveExpression("variable", new Object[0]);
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ResolveExpression expression2 = new ResolveExpression("variable", new Object[0]);
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testSystemTestExpressionNotEqual() throws Exception {
        SystemTestExpression expression1 = new SystemTestExpression("prop", "value1");
        SystemTestExpression expression2 = new SystemTestExpression("prop", "value2");
        ExpressionTests.assertTrue((String)"These system test expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testSystemTestExpressionHashCode() throws Exception {
        SystemTestExpression expression1 = new SystemTestExpression("prop", "value");
        SystemTestExpression expression2 = new SystemTestExpression("prop", "value");
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testTestExpressionNotEqual() throws Exception {
        TestExpression expression1 = new TestExpression("namespace", "prop", new Object[0], (Object)"value1");
        TestExpression expression2 = new TestExpression("namespace", "prop", new Object[0], (Object)"value2");
        ExpressionTests.assertTrue((String)"These system test expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testTestExpressionHashCode() throws Exception {
        TestExpression expression1 = new TestExpression("namespace", "prop", new Object[0], (Object)"value");
        TestExpression expression2 = new TestExpression("namespace", "prop", new Object[0], (Object)"value");
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testWithExpressionNotEqual() throws Exception {
        WithExpression expression1 = new WithExpression("variable1");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter1"));
        WithExpression expression2 = new WithExpression("variable2");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter2"));
        ExpressionTests.assertTrue((String)"These with expressions should not be equal", (!expression1.equals((Object)expression2) ? 1 : 0) != 0);
    }

    public void testWithExpressionHashCode() throws Exception {
        WithExpression expression1 = new WithExpression("variable");
        expression1.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        WithExpression expression2 = new WithExpression("variable");
        expression2.add((Expression)new InstanceofExpression("org.eclipse.core.internal.expressions.tests.Adapter"));
        ExpressionTests.assertEquals((String)"Equal expressions should have the same hash code", (int)expression1.hashCode(), (int)expression2.hashCode());
    }

    public void testWithExpressionNoVariable() throws Exception {
        WithExpression expr = new WithExpression("variable");
        expr.add((Expression)new EqualsExpression(new Object()));
        EvaluationContext context = new EvaluationContext(null, new Object());
        try {
            expr.evaluate((IEvaluationContext)context);
            ExpressionTests.fail((String)"Should throw exceptoin");
        }
        catch (CoreException coreException) {}
    }

    public void testWithExpressionUndefinedVariable() throws Exception {
        WithExpression expr = new WithExpression("variable");
        expr.add((Expression)new EqualsExpression(new Object()));
        EvaluationContext context = new EvaluationContext(null, new Object());
        context.addVariable("variable", IEvaluationContext.UNDEFINED_VARIABLE);
        ExpressionTests.assertEquals((Object)EvaluationResult.FALSE, (Object)expr.evaluate((IEvaluationContext)context));
    }

    public void testVariableResolver() throws Exception {
        final Object result = new Object();
        IVariableResolver resolver = new IVariableResolver(){

            public Object resolve(String name, Object[] args) throws CoreException {
                ExpressionTests.assertEquals((String)"variable", (String)name);
                ExpressionTests.assertEquals((Object)"arg1", (Object)args[0]);
                ExpressionTests.assertEquals((Object)Boolean.TRUE, (Object)args[1]);
                return result;
            }
        };
        EvaluationContext context = new EvaluationContext(null, new Object(), new IVariableResolver[]{resolver});
        ExpressionTests.assertTrue((result == context.resolveVariable("variable", new Object[]{"arg1", Boolean.TRUE}) ? 1 : 0) != 0);
    }

    public void testEqualsExpression() throws Exception {
        EqualsExpression exp = new EqualsExpression((Object)"name");
        EvaluationContext context = new EvaluationContext(null, (Object)"name");
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        exp = new EqualsExpression((Object)Boolean.TRUE);
        context = new EvaluationContext(null, (Object)Boolean.TRUE);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        exp = new EqualsExpression((Object)"name");
        context = new EvaluationContext(null, (Object)Boolean.TRUE);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testCountExpressionAnyNumber() throws Exception {
        CountExpression exp = new CountExpression("*");
        ArrayList<String> list = new ArrayList<String>();
        EvaluationContext context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        list.add("two");
        list.add("three");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testCountExpressionExact() throws Exception {
        CountExpression exp = new CountExpression("2");
        ArrayList<String> list = new ArrayList<String>();
        list.add("one");
        EvaluationContext context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        list.add("two");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        list.add("two");
        list.add("three");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testCountExpressionNoneOrOne() throws Exception {
        CountExpression exp = new CountExpression("?");
        ArrayList<String> list = new ArrayList<String>();
        EvaluationContext context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        list.add("two");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testCountExpressionOneOrMore() throws Exception {
        CountExpression exp = new CountExpression("+");
        ArrayList<String> list = new ArrayList<String>();
        EvaluationContext context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        list.add("two");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testCountExpressionNone() throws Exception {
        CountExpression exp = new CountExpression("!");
        ArrayList<String> list = new ArrayList<String>();
        EvaluationContext context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        list.add("two");
        context = new EvaluationContext(null, list);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testCountExpressionNoneWithAdapterManager() throws Exception {
        CountExpression exp = new CountExpression("!");
        ArrayList<String> list = new ArrayList<String>();
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = list;
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        context = new EvaluationContext(null, (Object)wrapper);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        list.clear();
        list.add("one");
        list.add("two");
        context = new EvaluationContext(null, (Object)wrapper);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testCountExpressionFailure() throws Exception {
        CountExpression exp = new CountExpression("!");
        EvaluationContext context = new EvaluationContext(null, new Object());
        try {
            EvaluationResult result = exp.evaluate((IEvaluationContext)context);
            ExpressionTests.fail((String)("Count should've failed for non-Collection variable.  Result = " + result.toString()));
        }
        catch (CoreException e) {
            ExpressionTests.assertEquals((int)3, (int)e.getStatus().getCode());
        }
    }

    public void testInstanceofTrue() throws Exception {
        InstanceofExpression exp = new InstanceofExpression("org.eclipse.core.internal.expressions.tests.B");
        B b = new B();
        EvaluationContext context = new EvaluationContext(null, (Object)b);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        exp = new InstanceofExpression("org.eclipse.core.internal.expressions.tests.A");
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        exp = new InstanceofExpression("org.eclipse.core.internal.expressions.tests.I");
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testInstanceofFalse() throws Exception {
        InstanceofExpression exp = new InstanceofExpression("org.eclipse.core.internal.expressions.tests.B");
        A a = new A();
        EvaluationContext context = new EvaluationContext(null, (Object)a);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionAndTrue() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.TRUE;
            }
        };
        IterateExpression exp = new IterateExpression("and");
        exp.add(myExpression);
        ArrayList<String> input = new ArrayList<String>();
        input.add("one");
        input.add("two");
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        ExpressionTests.assertTrue((boolean)result.equals(input));
    }

    public void testIterateExpressionAndFalse() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.FALSE;
            }
        };
        IterateExpression exp = new IterateExpression("and");
        exp.add(myExpression);
        ArrayList<String> input = new ArrayList<String>();
        input.add("one");
        input.add("two");
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        ExpressionTests.assertTrue((result.size() == 1 && result.get(0).equals("one") ? 1 : 0) != 0);
    }

    public void testIterateExpressionOrTrue() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.TRUE;
            }
        };
        IterateExpression exp = new IterateExpression("or");
        exp.add(myExpression);
        ArrayList<String> input = new ArrayList<String>();
        input.add("one");
        input.add("two");
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        ExpressionTests.assertTrue((result.size() == 1 && result.get(0).equals("one") ? 1 : 0) != 0);
    }

    public void testIterateExpressionOrFalse() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.FALSE;
            }
        };
        IterateExpression exp = new IterateExpression("or");
        exp.add(myExpression);
        ArrayList<String> input = new ArrayList<String>();
        input.add("one");
        input.add("two");
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        ExpressionTests.assertTrue((boolean)result.equals(input));
    }

    public void testIterateExpressionOrMultiChildren() throws Exception {
        IterateExpression exp = new IterateExpression("or");
        exp.add(Expression.FALSE);
        exp.add(Expression.TRUE);
        ArrayList<String> input = new ArrayList<String>();
        input.add("one");
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionAndMultiChildren() throws Exception {
        IterateExpression exp = new IterateExpression("and");
        exp.add(Expression.FALSE);
        exp.add(Expression.TRUE);
        ArrayList<String> input = new ArrayList<String>();
        input.add("one");
        input.add("two");
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionEmptyOr() throws Exception {
        IterateExpression exp = new IterateExpression("or");
        ArrayList input = new ArrayList();
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionEmptyAnd() throws Exception {
        IterateExpression exp = new IterateExpression("and");
        ArrayList input = new ArrayList();
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionAnd_IfEmptyTrue() throws Exception {
        IterateExpression exp = new IterateExpression("and", "true");
        ArrayList input = new ArrayList();
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionAnd_IfEmptyFalse() throws Exception {
        IterateExpression exp = new IterateExpression("and", "false");
        ArrayList input = new ArrayList();
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionOr_IfEmptyTrue() throws Exception {
        IterateExpression exp = new IterateExpression("or", "true");
        ArrayList input = new ArrayList();
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionOr_IfEmptyFalse() throws Exception {
        IterateExpression exp = new IterateExpression("or", "false");
        ArrayList input = new ArrayList();
        EvaluationContext context = new EvaluationContext(null, input);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionWithAdapterManager() throws Exception {
        final ArrayList result = new ArrayList();
        Expression myExpression = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                result.add(context.getDefaultVariable());
                return EvaluationResult.FALSE;
            }
        };
        IterateExpression exp = new IterateExpression("or");
        exp.add(myExpression);
        ArrayList<String> input = new ArrayList<String>();
        input.add("one");
        input.add("two");
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = input;
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
        ExpressionTests.assertTrue((boolean)result.equals(input));
    }

    public void testIterateExpressionWithAdapterManagerEmptyAnd() throws Exception {
        IterateExpression exp = new IterateExpression("and");
        ArrayList<String> input = new ArrayList<String>();
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = input;
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionWithAdapterManagerEmptyOr() throws Exception {
        IterateExpression exp = new IterateExpression("or");
        ArrayList<String> input = new ArrayList<String>();
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = input;
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionWithAdapterManagerIfEmptyFalse() throws Exception {
        IterateExpression exp = new IterateExpression("or", "false");
        ArrayList<String> input = new ArrayList<String>();
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = input;
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        ExpressionTests.assertTrue((EvaluationResult.FALSE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionWithAdapterManagerIfEmptyTrue() throws Exception {
        IterateExpression exp = new IterateExpression("or", "true");
        ArrayList<String> input = new ArrayList<String>();
        CollectionWrapper wrapper = new CollectionWrapper();
        wrapper.collection = input;
        EvaluationContext context = new EvaluationContext(null, (Object)wrapper);
        ExpressionTests.assertTrue((EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context) ? 1 : 0) != 0);
    }

    public void testIterateExpressionFailure() throws Exception {
        IterateExpression exp = new IterateExpression(null);
        EvaluationContext context = new EvaluationContext(null, new Object());
        try {
            EvaluationResult result = exp.evaluate((IEvaluationContext)context);
            ExpressionTests.fail((String)("Count should've failed for non-Collection variable.  Result = " + result.toString()));
        }
        catch (CoreException e) {
            ExpressionTests.assertEquals((int)3, (int)e.getStatus().getCode());
        }
    }

    public void testReadXMLExpression() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "test1").getChildren("enablement")[0];
        ExpressionConverter.getDefault().perform(enable);
    }

    public void testReadDOMExpression() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        URL url = FrameworkUtil.getBundle(ExpressionTests.class).getEntry("plugin.xml");
        Document document = builder.parse(url.openStream());
        NodeList testParticipants = document.getElementsByTagName("testParticipant");
        int i = 0;
        while (i < testParticipants.getLength()) {
            Element elem = (Element)testParticipants.item(i);
            String id = elem.getAttribute("id");
            Element enable1 = (Element)elem.getElementsByTagName("enablement").item(0);
            IConfigurationElement enable2 = this.findExtension(ces, id).getChildren("enablement")[0];
            Expression exp1 = ExpressionConverter.getDefault().perform(enable1);
            Expression exp2 = ExpressionConverter.getDefault().perform(enable2);
            ExpressionTests.assertEquals((Object)exp1, (Object)exp2);
            ++i;
        }
    }

    public void testForcePluginActivation() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "test2").getChildren("enablement")[0];
        EnablementExpression exp = (EnablementExpression)ExpressionConverter.getDefault().perform(enable);
        Expression[] children = exp.getChildren();
        ExpressionTests.assertTrue((children.length == 3 ? 1 : 0) != 0);
        TestExpression test = (TestExpression)children[0];
        ExpressionTests.assertTrue((boolean)test.testGetForcePluginActivation());
        test = (TestExpression)children[1];
        ExpressionTests.assertTrue((!test.testGetForcePluginActivation() ? 1 : 0) != 0);
        test = (TestExpression)children[2];
        ExpressionTests.assertTrue((!test.testGetForcePluginActivation() ? 1 : 0) != 0);
    }

    public void testPlatformPropertyTester() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "test3").getChildren("enablement")[0];
        Expression exp = ExpressionConverter.getDefault().perform(enable);
        EvaluationContext context = new EvaluationContext(null, Platform.class);
        ExpressionTests.assertEquals((Object)EvaluationResult.TRUE, (Object)exp.evaluate((IEvaluationContext)context));
    }

    private IConfigurationElement findExtension(IConfigurationElement[] ces, String id) {
        IConfigurationElement[] iConfigurationElementArray = ces;
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (id.equals(ce.getAttribute("id"))) {
                return ce;
            }
            ++n2;
        }
        return null;
    }

    public void testDefinitionExpression() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions", "definitions");
        IConfigurationElement expr = this.findExtension(ces, "org.eclipse.core.expressions.tests.activeProblemsView");
        ExpressionTests.assertNotNull((Object)expr);
        Expression probExpr = ExpressionConverter.getDefault().perform(expr.getChildren()[0]);
        EvaluationContext context = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        try {
            probExpr.evaluate((IEvaluationContext)context);
            ExpressionTests.fail((String)"Should report error with no variable");
        }
        catch (CoreException coreException) {}
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.TasksView");
        ExpressionTests.assertEquals((Object)EvaluationResult.FALSE, (Object)probExpr.evaluate((IEvaluationContext)context));
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.ProblemsView");
        ExpressionTests.assertEquals((Object)EvaluationResult.TRUE, (Object)probExpr.evaluate((IEvaluationContext)context));
    }

    public void testReferenceExpression() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "refTest1").getChildren("enablement")[0];
        EnablementExpression probExpr = (EnablementExpression)ExpressionConverter.getDefault().perform(enable);
        EvaluationContext context = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        try {
            probExpr.evaluate((IEvaluationContext)context);
            ExpressionTests.fail((String)"Should report error with no variable");
        }
        catch (CoreException coreException) {}
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.TasksView");
        ExpressionTests.assertEquals((Object)EvaluationResult.FALSE, (Object)probExpr.evaluate((IEvaluationContext)context));
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.ProblemsView");
        ExpressionTests.assertEquals((Object)EvaluationResult.TRUE, (Object)probExpr.evaluate((IEvaluationContext)context));
    }

    public void testTwoReferences() throws Exception {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] ces = registry.getConfigurationElementsFor("org.eclipse.core.expressions.tests", "testParticipants");
        IConfigurationElement enable = this.findExtension(ces, "refTest2").getChildren("enablement")[0];
        EnablementExpression probExpr = (EnablementExpression)ExpressionConverter.getDefault().perform(enable);
        EvaluationContext context = new EvaluationContext(null, (Object)Collections.EMPTY_LIST);
        try {
            probExpr.evaluate((IEvaluationContext)context);
            ExpressionTests.fail((String)"Should report error with no variable");
        }
        catch (CoreException coreException) {}
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.TasksView");
        ExpressionTests.assertEquals((Object)EvaluationResult.FALSE, (Object)probExpr.evaluate((IEvaluationContext)context));
        context.addVariable("activePartId", (Object)"org.eclipse.ui.views.ProblemsView");
        ExpressionTests.assertEquals((Object)EvaluationResult.FALSE, (Object)probExpr.evaluate((IEvaluationContext)context));
        context = new EvaluationContext((IEvaluationContext)context, Collections.singletonList(probExpr));
        ExpressionTests.assertEquals((Object)EvaluationResult.TRUE, (Object)probExpr.evaluate((IEvaluationContext)context));
    }

    public void testSubType() throws Exception {
        EvaluationContext context = new EvaluationContext(null, IEvaluationContext.UNDEFINED_VARIABLE);
        ArrayList<AbstractCollection> list = new ArrayList<AbstractCollection>();
        HashSet o1 = new HashSet();
        EvaluationContext c1 = new EvaluationContext(null, o1);
        list.add(o1);
        ArrayList o2 = new ArrayList();
        EvaluationContext c2 = new EvaluationContext(null, o2);
        list.add(o2);
        LinkedList o3 = new LinkedList();
        EvaluationContext c3 = new EvaluationContext(null, o3);
        list.add(o3);
        context.addVariable("selection", list);
        WithExpression with = new WithExpression("selection");
        IterateExpression iterate = new IterateExpression("and", "false");
        with.add((Expression)iterate);
        InstanceofExpression iCollection = new InstanceofExpression("java.util.Collection");
        iterate.add((Expression)iCollection);
        InstanceofExpression iSet = new InstanceofExpression("java.util.Set");
        InstanceofExpression iList = new InstanceofExpression("java.util.List");
        ExpressionTests.assertEquals((Object)EvaluationResult.TRUE, (Object)iSet.evaluate((IEvaluationContext)c1));
        ExpressionTests.assertEquals((Object)EvaluationResult.FALSE, (Object)iList.evaluate((IEvaluationContext)c1));
        ExpressionTests.assertEquals((Object)EvaluationResult.FALSE, (Object)iSet.evaluate((IEvaluationContext)c2));
        ExpressionTests.assertEquals((Object)EvaluationResult.TRUE, (Object)iList.evaluate((IEvaluationContext)c2));
        ExpressionTests.assertEquals((Object)EvaluationResult.FALSE, (Object)iSet.evaluate((IEvaluationContext)c3));
        ExpressionTests.assertEquals((Object)EvaluationResult.TRUE, (Object)iList.evaluate((IEvaluationContext)c3));
        ExpressionTests.assertEquals((Object)EvaluationResult.TRUE, (Object)with.evaluate((IEvaluationContext)context));
    }

    public void testSubTypeTiming() throws Exception {
        HashSet o1 = new HashSet();
        System.gc();
        long cachedStart = System.currentTimeMillis();
        int i = 0;
        while (i < 100000) {
            ExpressionTests.assertTrue((boolean)Expressions.isInstanceOf(o1, (String)"java.util.Set"));
            ExpressionTests.assertFalse((boolean)Expressions.isInstanceOf(o1, (String)"java.util.List"));
            ++i;
        }
        long cachedDelta = System.currentTimeMillis() - cachedStart;
        System.gc();
        long instanceStart = System.currentTimeMillis();
        int i2 = 0;
        while (i2 < 100000) {
            ExpressionTests.assertTrue((boolean)Expressions.uncachedIsSubtype(o1.getClass(), (String)"java.util.Set"));
            ExpressionTests.assertFalse((boolean)Expressions.uncachedIsSubtype(o1.getClass(), (String)"java.util.List"));
            ++i2;
        }
        long instanceDelta = System.currentTimeMillis() - instanceStart;
        ExpressionTests.assertTrue((String)("cachedDelta: " + cachedDelta + ", instanceDelta: " + instanceDelta), ((double)cachedDelta * 1.5 < (double)instanceDelta ? 1 : 0) != 0);
    }

    public static class CollectionWrapper {
        public Collection<String> collection;
    }
}

