/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.expressions.tests;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.internal.expressions.Expressions;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class ExpressionTestsPluginUnloading
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite(ExpressionTestsPluginUnloading.class);
        ArrayList<Test> tests = Collections.list(suite.tests());
        Collections.sort(tests, new Comparator<Test>(){

            @Override
            public int compare(Test o1, Test o2) {
                return ((TestCase)o1).getName().compareTo(((TestCase)o2).getName());
            }
        });
        TestSuite result = new TestSuite();
        for (Test test : tests) {
            result.addTest(test);
        }
        return result;
    }

    public ExpressionTestsPluginUnloading(String name) {
        super(name);
    }

    public void test01PluginStopping() throws Exception {
        Bundle bundle = ExpressionTestsPluginUnloading.getBundle("com.ibm.icu");
        ExpressionTestsPluginUnloading.assertEquals((int)8, (int)bundle.getState());
        this.doTestInstanceofICUDecimalFormat(bundle);
        ExpressionTestsPluginUnloading.assertEquals((int)32, (int)bundle.getState());
        bundle.stop();
        ExpressionTestsPluginUnloading.assertEquals((int)4, (int)bundle.getState());
        bundle.start();
        ExpressionTestsPluginUnloading.assertEquals((int)32, (int)bundle.getState());
        this.doTestInstanceofICUDecimalFormat(bundle);
    }

    public void test02MultipleClassloaders() throws Exception {
        Bundle expr = ExpressionTestsPluginUnloading.getBundle("org.eclipse.core.expressions.tests");
        Bundle icu = ExpressionTestsPluginUnloading.getBundle("com.ibm.icu");
        Class exprClass = expr.loadClass("com.ibm.icu.text.DecimalFormat");
        Class icuClass = icu.loadClass("com.ibm.icu.text.DecimalFormat");
        ExpressionTestsPluginUnloading.assertNotSame((Object)exprClass, (Object)icuClass);
        Object exprObj = exprClass.newInstance();
        Object icuObj = icuClass.newInstance();
        this.assertInstanceOf(exprObj, "java.lang.Runnable", "java.lang.String");
        this.assertInstanceOf(exprObj, "java.lang.Object", "java.io.Serializable");
        this.assertInstanceOf(icuObj, "java.io.Serializable", "java.lang.String");
        this.assertInstanceOf(icuObj, "java.text.Format", "java.lang.Runnable");
    }

    private void assertInstanceOf(Object obj, String isInstance, String isNotInstance) throws Exception {
        Class<?> clazz = obj.getClass();
        System.out.println("ExpressionTestsPluginUnloading#" + this.getName() + "() - " + clazz.getName() + ": " + clazz.hashCode());
        System.out.println("ExpressionTestsPluginUnloading#" + this.getName() + "() - ClassLoader: " + clazz.getClassLoader().hashCode());
        int i = 0;
        while (i < 2) {
            ExpressionTestsPluginUnloading.assertTrue((boolean)Expressions.isInstanceOf((Object)obj, (String)isInstance));
            ExpressionTestsPluginUnloading.assertFalse((boolean)Expressions.isInstanceOf((Object)obj, (String)isNotInstance));
            ++i;
        }
    }

    private void doTestInstanceofICUDecimalFormat(Bundle bundle) throws Exception {
        Class clazz = bundle.loadClass("com.ibm.icu.text.DecimalFormat");
        Object decimalFormat = clazz.newInstance();
        this.assertInstanceOf(decimalFormat, "com.ibm.icu.text.DecimalFormat", "java.text.NumberFormat");
    }

    private static Bundle getBundle(String bundleName) {
        Bundle[] bundles;
        BundleContext bundleContext = ExpressionPlugin.getDefault().getBundleContext();
        Bundle[] bundleArray = bundles = bundleContext.getBundles();
        int n = bundles.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = bundleArray[n2];
            if (bundleName.equals(bundle.getSymbolicName())) {
                return bundle;
            }
            ++n2;
        }
        ExpressionTestsPluginUnloading.fail((String)("Could not find bundle: " + bundleName));
        return null;
    }
}

