/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FileBuffersForNonAccessibleWorkspaceFiles
extends FileBufferFunctions {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.getProject().close(null);
    }

    @Override
    protected IPath createPath(IProject project) throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IFile file = ResourceHelper.createFile(folder, "WorkspaceFile", "content");
        return file.getFullPath();
    }

    @Override
    @After
    public void tearDown() {
        FileTool.delete(this.getPath());
        super.tearDown();
    }

    @Override
    protected void setReadOnly(boolean state) throws Exception {
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.getPath());
        Assert.assertNotNull((Object)fileStore);
        fileStore.fetchInfo().setAttribute(2, state);
    }

    @Override
    protected boolean isStateValidationSupported() {
        return false;
    }

    @Override
    protected boolean deleteUnderlyingFile() throws Exception {
        return false;
    }

    @Override
    protected IPath moveUnderlyingFile() throws Exception {
        return null;
    }

    @Override
    protected boolean modifyUnderlyingFile() throws Exception {
        return false;
    }

    @Override
    protected Class<IAnnotationModel> getAnnotationModelClass() throws Exception {
        return null;
    }

    @Override
    @Test
    public void test7() throws Exception {
    }

    @Override
    @Test
    public void test11_1() throws Exception {
    }

    @Override
    @Test
    public void test17_3() throws Exception {
    }
}

