/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filebuffers.tests.FileBufferFunctions;
import org.eclipse.core.filebuffers.tests.FileTool;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class FileBuffersForNonExistingWorkspaceFiles
extends FileBufferFunctions {
    @Override
    @After
    public void tearDown() {
        FileTool.delete(this.getPath());
        super.tearDown();
    }

    @Override
    protected IPath createPath(IProject project) throws Exception {
        IFolder folder = ResourceHelper.createFolder("project/folderA/folderB/");
        IPath filePath = folder.getLocation().append("NonExistingWorkspaceFile");
        return filePath.makeAbsolute();
    }

    @Test
    public void testBug118199() throws Exception {
        IFile file = this.getProject().getWorkspace().getRoot().getFile(this.getPath());
        Assert.assertFalse((boolean)file.exists());
        this.fManager.connect(this.getPath(), LocationKind.NORMALIZE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(this.getPath(), LocationKind.NORMALIZE);
            buffer.getDocument().set("test");
            buffer.commit(null, false);
        }
        finally {
            this.fManager.disconnect(this.getPath(), LocationKind.NORMALIZE, null);
        }
        Assert.assertFalse((boolean)file.exists());
    }

    @Test
    public void testBug118199_fixed() throws Exception {
        IFile file = this.getProject().getWorkspace().getRoot().getFileForLocation(this.getPath());
        IPath path = file.getFullPath();
        Assert.assertFalse((boolean)file.exists());
        this.fManager.connect(path, LocationKind.IFILE, null);
        try {
            ITextFileBuffer buffer = this.fManager.getTextFileBuffer(path, LocationKind.IFILE);
            buffer.getDocument().set("test");
            buffer.commit(null, false);
        }
        finally {
            this.fManager.disconnect(path, LocationKind.IFILE, null);
        }
        Assert.assertTrue((boolean)file.exists());
    }

    @Override
    protected void setReadOnly(boolean state) throws Exception {
        IFileStore fileStore = FileBuffers.getFileStoreAtLocation((IPath)this.getPath());
        Assert.assertNotNull((Object)fileStore);
        fileStore.fetchInfo().setAttribute(2, state);
    }

    @Override
    protected boolean isStateValidationSupported() {
        return false;
    }

    @Override
    protected boolean deleteUnderlyingFile() throws Exception {
        return false;
    }

    @Override
    protected IPath moveUnderlyingFile() throws Exception {
        return null;
    }

    @Override
    protected boolean modifyUnderlyingFile() throws Exception {
        return false;
    }

    @Override
    protected Class<IAnnotationModel> getAnnotationModelClass() throws Exception {
        return null;
    }
}

