/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.filebuffers.tests;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.URI;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.tests.FileBufferListener;
import org.eclipse.core.filebuffers.tests.ResourceHelper;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class FileStoreFileBufferFunctions {
    private IProject fProject;
    protected ITextFileBufferManager fManager;
    private IFileStore fFileStore;

    protected abstract IPath createPath(IProject var1) throws Exception;

    protected abstract void setReadOnly(boolean var1) throws Exception;

    protected abstract boolean modifyUnderlyingFile() throws Exception;

    protected abstract boolean deleteUnderlyingFile() throws Exception;

    protected abstract IPath moveUnderlyingFile() throws Exception;

    protected abstract boolean isStateValidationSupported();

    protected abstract Class<IAnnotationModel> getAnnotationModelClass() throws Exception;

    @Before
    public void setUp() throws Exception {
        this.fManager = FileBuffers.getTextFileBufferManager();
        this.fProject = ResourceHelper.createProject("project");
        this.fFileStore = EFS.getLocalFileSystem().getStore(this.createPath(this.fProject));
        ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
        Assert.assertTrue((buffer == null ? 1 : 0) != 0);
    }

    protected IProject getProject() {
        return this.fProject;
    }

    @After
    public void tearDown() {
        ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
        Assert.assertTrue((buffer == null ? 1 : 0) != 0);
        ResourceHelper.deleteProject("project");
    }

    protected IPath getPath() {
        return URIUtil.toPath((URI)this.fFileStore.toURI());
    }

    @Test
    public void test1() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertEquals((Object)this.fFileStore, (Object)buffer.getFileStore());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test2() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            long lastModified;
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((boolean)fileBuffer.isSynchronized());
            IFileStore fileStore = this.fFileStore;
            IFileInfo fileInfo = fileStore.fetchInfo();
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                fileStore.putInfo(fileInfo, 2048, null);
            }
            Assert.assertTrue(((lastModified = fileStore.fetchInfo().getLastModified()) == 0L || !fileBuffer.isSynchronized() ? 1 : 0) != 0);
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test3() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertFalse((boolean)fileBuffer.isDirty());
            IDocument document = fileBuffer.getDocument();
            document.replace(document.getLength(), 0, "appendix");
            Assert.assertTrue((boolean)fileBuffer.isDirty());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test4() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer1 = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertFalse((boolean)fileBuffer1.isShared());
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                ITextFileBuffer fileBuffer2 = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                Assert.assertTrue((boolean)fileBuffer1.isShared());
                Assert.assertTrue((boolean)fileBuffer2.isShared());
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
            Assert.assertFalse((boolean)fileBuffer1.isShared());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test5() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            long lastModified;
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            long modificationStamp = fileBuffer.getModificationStamp();
            IFileInfo fileInfo = this.fFileStore.fetchInfo();
            Assert.assertEquals((Object)(modificationStamp != -1L ? 1 : 0), (Object)fileInfo.exists());
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                this.fFileStore.putInfo(fileInfo, 2048, null);
            }
            Assert.assertTrue(((lastModified = this.fFileStore.fetchInfo().getLastModified()) == 0L || modificationStamp != fileBuffer.getModificationStamp() ? 1 : 0) != 0);
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test6() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            IDocument document = fileBuffer.getDocument();
            String originalContent = document.get();
            document.replace(document.getLength(), 0, "appendix");
            IFileInfo fileInfo = this.fFileStore.fetchInfo();
            fileInfo.setLastModified(1000L);
            if (fileInfo.exists()) {
                this.fFileStore.putInfo(fileInfo, 2048, null);
            }
            fileBuffer.revert(null);
            Assert.assertEquals((Object)originalContent, (Object)document.get());
            Assert.assertFalse((boolean)fileBuffer.isDirty());
            Assert.assertTrue((boolean)fileBuffer.isSynchronized());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test7() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            IDocument document = fileBuffer.getDocument();
            document.replace(document.getLength(), 0, "appendix");
            String originalContent = document.get();
            fileBuffer.commit(null, true);
            Assert.assertEquals((Object)originalContent, (Object)document.get());
            Assert.assertFalse((boolean)fileBuffer.isDirty());
            Assert.assertTrue((boolean)fileBuffer.isSynchronized());
            fileBuffer.revert(null);
            Assert.assertEquals((Object)originalContent, (Object)document.get());
            Assert.assertFalse((boolean)fileBuffer.isDirty());
            Assert.assertTrue((boolean)fileBuffer.isSynchronized());
            this.fManager.disconnectFileStore(this.fFileStore, null);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                document = fileBuffer.getDocument();
                Assert.assertEquals((Object)originalContent, (Object)document.get());
                Assert.assertFalse((boolean)fileBuffer.isDirty());
                Assert.assertTrue((boolean)fileBuffer.isSynchronized());
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test8_1() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            fileBuffer.validateState(null, null);
            Assert.assertTrue((boolean)fileBuffer.isStateValidated());
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test8_2() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            this.setReadOnly(true);
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            fileBuffer.validateState(null, null);
            Assert.assertTrue((boolean)fileBuffer.isStateValidated());
        }
        finally {
            this.setReadOnly(false);
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test9_1() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            fileBuffer.validateState(null, null);
            fileBuffer.resetStateValidation();
            if (this.isStateValidationSupported()) {
                Assert.assertFalse((boolean)fileBuffer.isStateValidated());
            }
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test9_2() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            this.setReadOnly(true);
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            fileBuffer.validateState(null, null);
            fileBuffer.resetStateValidation();
            if (this.isStateValidationSupported()) {
                Assert.assertFalse((boolean)fileBuffer.isStateValidated());
            }
        }
        finally {
            this.setReadOnly(false);
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test10() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void bufferCreated(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }

            @Override
            public void bufferDisposed(IFileBuffer buf) {
                --this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            this.fManager.connectFileStore(this.fFileStore, null);
            Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
            Assert.assertNotNull((Object)listener.buffer);
            IFileBuffer fileBuffer = this.fManager.getFileStoreFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            this.fManager.disconnectFileStore(this.fFileStore, null);
            Assert.assertTrue((listener.count == 0 ? 1 : 0) != 0);
            Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
        }
        finally {
            try {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
            finally {
                this.fManager.removeFileBufferListener((IFileBufferListener)listener);
            }
        }
    }

    @Test
    public void test11_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isDirty;

            Listener() {
            }

            @Override
            public void dirtyStateChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isDirty = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                Assert.assertTrue((boolean)listener.isDirty);
                fileBuffer.commit(null, true);
                Assert.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                Assert.assertFalse((boolean)listener.isDirty);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test11_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isDirty;

            Listener() {
            }

            @Override
            public void dirtyStateChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isDirty = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                Assert.assertTrue((boolean)listener.isDirty);
                fileBuffer.revert(null);
                Assert.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                Assert.assertFalse((boolean)listener.isDirty);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test12_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer preBuffer;
            public IFileBuffer postBuffer;
            public int preCount;
            public int postCount;

            Listener() {
            }

            @Override
            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                ++this.preCount;
                this.preBuffer = buffer;
            }

            @Override
            public void bufferContentReplaced(IFileBuffer buffer) {
                ++this.postCount;
                this.postBuffer = buffer;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.preCount == 0 && listener.postCount == 0 && listener.preBuffer == null && listener.postBuffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.revert(null);
                Assert.assertTrue((listener.preCount == 1 ? 1 : 0) != 0);
                Assert.assertTrue((listener.preBuffer == fileBuffer ? 1 : 0) != 0);
                Assert.assertTrue((listener.postCount == 1 ? 1 : 0) != 0);
                Assert.assertTrue((listener.postBuffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test12_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer preBuffer;
            public IFileBuffer postBuffer;
            public int preCount;
            public int postCount;

            Listener() {
            }

            @Override
            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
                ++this.preCount;
                this.preBuffer = buffer;
            }

            @Override
            public void bufferContentReplaced(IFileBuffer buffer) {
                ++this.postCount;
                this.postBuffer = buffer;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.preCount == 0 && listener.postCount == 0 && listener.preBuffer == null && listener.postBuffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.modifyUnderlyingFile()) {
                    Assert.assertTrue((listener.preCount == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.preBuffer == fileBuffer ? 1 : 0) != 0);
                    Assert.assertTrue((listener.postCount == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.postBuffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test13_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;

            Listener() {
            }

            @Override
            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test13_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;

            Listener() {
            }

            @Override
            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                this.setReadOnly(true);
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    Assert.assertTrue((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.setReadOnly(false);
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test13_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;

            Listener() {
            }

            @Override
            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                fileBuffer.resetStateValidation();
                if (this.isStateValidationSupported()) {
                    Assert.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    Assert.assertFalse((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test13_4() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public boolean isStateValidated;

            Listener() {
            }

            @Override
            public void stateValidationChanged(IFileBuffer buf, boolean state) {
                ++this.count;
                this.buffer = buf;
                this.isStateValidated = state;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                this.setReadOnly(true);
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                fileBuffer.resetStateValidation();
                if (this.isStateValidationSupported()) {
                    Assert.assertTrue((listener.count == 2 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    Assert.assertFalse((boolean)listener.isStateValidated);
                }
            }
            finally {
                this.setReadOnly(false);
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test14() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void underlyingFileDeleted(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.deleteUnderlyingFile()) {
                    Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test15() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;
            public IPath newLocation;

            Listener() {
            }

            @Override
            public void underlyingFileMoved(IFileBuffer buf, IPath location) {
                ++this.count;
                this.buffer = buf;
                this.newLocation = location;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IPath newLocation = this.moveUnderlyingFile();
                if (newLocation != null) {
                    Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                    Assert.assertEquals((Object)listener.newLocation, (Object)newLocation);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test16_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.modifyUnderlyingFile()) {
                    Assert.assertSame((Object)listener.buffer, (Object)fileBuffer);
                    Assert.assertEquals((long)1L, (long)listener.count);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test16_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.deleteUnderlyingFile()) {
                    Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test16_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                if (this.moveUnderlyingFile() != null) {
                    Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test17_1() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                fileBuffer.validateState(null, null);
                if (this.isStateValidationSupported()) {
                    Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                    Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
                }
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test17_2() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.revert(null);
                Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test17_3() throws Exception {
        class Listener
        extends FileBufferListener {
            public IFileBuffer buffer;
            public int count;

            Listener() {
            }

            @Override
            public void stateChanging(IFileBuffer buf) {
                ++this.count;
                this.buffer = buf;
            }
        }
        Listener listener = new Listener();
        this.fManager.addFileBufferListener((IFileBufferListener)listener);
        try {
            ITextFileBuffer fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertTrue((listener.count == 0 && listener.buffer == null ? 1 : 0) != 0);
            this.fManager.connectFileStore(this.fFileStore, null);
            try {
                fileBuffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
                IDocument document = fileBuffer.getDocument();
                document.replace(0, 0, "prefix");
                fileBuffer.commit(null, true);
                Assert.assertTrue((listener.count == 1 ? 1 : 0) != 0);
                Assert.assertTrue((listener.buffer == fileBuffer ? 1 : 0) != 0);
            }
            finally {
                this.fManager.disconnectFileStore(this.fFileStore, null);
            }
        }
        finally {
            this.fManager.removeFileBufferListener((IFileBufferListener)listener);
        }
    }

    @Test
    public void test18() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertNotNull((Object)buffer);
            Class<IAnnotationModel> clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                IAnnotationModel model = buffer.getAnnotationModel();
                Assert.assertTrue((boolean)clazz.isInstance(model));
            }
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void test19() throws Exception {
        class NotifiedListener
        extends FileBufferListener {
            int notifyCount = 0;

            NotifiedListener() {
            }

            @Override
            public void bufferCreated(IFileBuffer buffer) {
                ++this.notifyCount;
            }

            @Override
            public void bufferDisposed(IFileBuffer buffer) {
                ++this.notifyCount;
            }
        }
        NotifiedListener notifyCounter1 = new NotifiedListener();
        NotifiedListener notifyCounter2 = new NotifiedListener();
        FileBufferListener failingListener = new FileBufferListener(){

            @Override
            public void bufferCreated(IFileBuffer buffer) {
                class ForcedException
                extends RuntimeException {
                    private static final long serialVersionUID = 1L;

                    ForcedException() {
                    }

                    @Override
                    public void printStackTrace(PrintStream s) {
                        s.println("!FORCED BY TEST: this entry is intentional");
                    }

                    @Override
                    public void printStackTrace(PrintWriter s) {
                        s.println("!FORCED BY TEST: this entry is intentional");
                    }
                }
                throw new ForcedException();
            }

            @Override
            public void bufferDisposed(IFileBuffer buffer) {
                throw new ForcedException();
            }
        };
        this.fManager.addFileBufferListener((IFileBufferListener)notifyCounter1);
        this.fManager.addFileBufferListener((IFileBufferListener)failingListener);
        this.fManager.addFileBufferListener((IFileBufferListener)notifyCounter2);
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertNotNull((Object)buffer);
            Class<IAnnotationModel> clazz = this.getAnnotationModelClass();
            if (clazz != null) {
                IAnnotationModel model = buffer.getAnnotationModel();
                Assert.assertTrue((boolean)clazz.isInstance(model));
            }
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
            this.fManager.removeFileBufferListener((IFileBufferListener)notifyCounter1);
            this.fManager.removeFileBufferListener((IFileBufferListener)failingListener);
            this.fManager.removeFileBufferListener((IFileBufferListener)notifyCounter2);
        }
        Assert.assertEquals((long)2L, (long)notifyCounter1.notifyCount);
        Assert.assertEquals((long)2L, (long)notifyCounter2.notifyCount);
    }

    @Test
    public void testGetBufferForDocument() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertNotNull((Object)buffer);
            IDocument document = buffer.getDocument();
            Assert.assertNotNull((Object)document);
            Assert.assertSame((Object)buffer, (Object)this.fManager.getTextFileBuffer(document));
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }

    @Test
    public void testGetFileStoreFileBuffers() throws Exception {
        this.fManager.connectFileStore(this.fFileStore, null);
        try {
            ITextFileBuffer buffer = this.fManager.getFileStoreTextFileBuffer(this.fFileStore);
            Assert.assertNotNull((Object)buffer);
            IFileBuffer[] fileBuffers = this.fManager.getFileStoreFileBuffers();
            Assert.assertNotNull((Object)fileBuffers);
            Assert.assertEquals((long)1L, (long)fileBuffers.length);
            Assert.assertSame((Object)buffer, (Object)fileBuffers[0]);
            fileBuffers = this.fManager.getFileBuffers();
            Assert.assertNotNull((Object)fileBuffers);
            Assert.assertEquals((long)0L, (long)fileBuffers.length);
        }
        finally {
            this.fManager.disconnectFileStore(this.fFileStore, null);
        }
    }
}

