/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;

public class FileSystemComparator {
    private static final String SNAPSHOT_FILE_NAME = "snapshot";

    public void compareSnapshots(String tag, Object oldOne, Object newOne) {
        Map oldSnapshot = (Map)oldOne;
        Map newSnapshot = (Map)newOne;
        boolean sameSize = oldSnapshot.size() == newSnapshot.size();
        for (Object element : newSnapshot.values()) {
            FileSummary newElement = (FileSummary)element;
            FileSummary oldElement = (FileSummary)oldSnapshot.get(newElement.getPath());
            Assert.assertNotNull((String)(String.valueOf(tag) + " - " + newElement.getPath() + " was added"), (Object)oldElement);
            Assert.assertEquals((String)(String.valueOf(tag) + " - " + newElement.getPath() + " changed timestamp "), (long)oldElement.getTimestamp(), (long)newElement.getTimestamp());
            Assert.assertEquals((String)(String.valueOf(tag) + " - " + newElement.getPath() + " changed size "), (long)oldElement.getSize(), (long)newElement.getSize());
        }
        if (!sameSize) {
            for (Object element : oldSnapshot.values()) {
                FileSummary oldElement = (FileSummary)element;
                FileSummary newElement = (FileSummary)newSnapshot.get(oldElement.getPath());
                Assert.assertNotNull((String)(String.valueOf(tag) + " - " + oldElement.getPath() + " was removed"), (Object)newElement);
            }
        }
    }

    public Object loadSnapshot(File rootLocation) throws IOException {
        File summaryFile = new File(rootLocation, SNAPSHOT_FILE_NAME);
        HashMap<String, FileSummary> snapshot = new HashMap<String, FileSummary>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(summaryFile)));){
            String line;
            while ((line = in.readLine()) != null) {
                String path = line;
                long timestamp = Long.parseLong(in.readLine());
                long size = Long.parseLong(in.readLine());
                snapshot.put(path, new FileSummary(path, timestamp, size));
            }
        }
        return snapshot;
    }

    public void saveSnapshot(Object toSave, File rootLocation) throws IOException {
        File summaryFile = new File(rootLocation, SNAPSHOT_FILE_NAME);
        Map snapshot = (Map)toSave;
        try (PrintWriter out = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(summaryFile))));){
            for (Object element : snapshot.values()) {
                FileSummary fileSummary = (FileSummary)element;
                out.println(fileSummary.getPath());
                out.println(fileSummary.getTimestamp());
                out.println(fileSummary.getSize());
            }
        }
    }

    public Object takeSnapshot(File rootLocation, boolean skip) {
        HashMap<String, FileSummary> snapshot = new HashMap<String, FileSummary>();
        this.takeSnapshot(snapshot, rootLocation, skip);
        return snapshot;
    }

    private void takeSnapshot(Map<String, FileSummary> snapshot, File rootLocation, boolean skip) {
        FileSummary summary = new FileSummary(rootLocation);
        if (!skip && !rootLocation.getName().equals(SNAPSHOT_FILE_NAME)) {
            snapshot.put(rootLocation.getAbsolutePath(), summary);
        }
        if (!rootLocation.isDirectory()) {
            return;
        }
        File[] entries = rootLocation.listFiles();
        if (entries == null) {
            return;
        }
        File[] fileArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            this.takeSnapshot(snapshot, fileEntry, false);
            ++n2;
        }
    }

    private class FileSummary {
        boolean directory;
        private String path;
        private long size;
        private long timestamp;

        FileSummary(File file) {
            if (!file.exists()) {
                throw new IllegalArgumentException(file + " does not exist");
            }
            this.path = file.getAbsolutePath();
            this.timestamp = file.lastModified();
            this.size = file.isDirectory() ? -1L : file.length();
        }

        FileSummary(String file, long timestamp, long size) {
            this.path = file;
            this.timestamp = timestamp;
            this.size = this.directory ? -1L : size;
        }

        public boolean equals(Object obj) {
            return obj instanceof FileSummary && ((FileSummary)obj).path.equals(this.path);
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public String toString() {
            return String.valueOf(this.path) + " timestamp: " + this.timestamp + " size: " + this.size;
        }
    }
}

