/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import junit.framework.TestFailure;
import org.eclipse.core.tests.harness.PerformanceTestResult;
import org.eclipse.core.tests.harness.PerformanceTimer;

public class LoggingPerformanceTestResult
extends PerformanceTestResult {
    private static PrintWriter createWriter(File logFile) {
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(logFile), true);
            return writer;
        }
        catch (IOException iOException) {
            System.out.println("Unable to open log output file: " + logFile);
            return new PrintWriter(System.out, true);
        }
    }

    public LoggingPerformanceTestResult(File logFile) {
        super(LoggingPerformanceTestResult.createWriter(logFile));
        this.printHTMLHeader(this.output);
    }

    public synchronized void log(String s) {
        this.output.println(s);
    }

    @Override
    public synchronized void print() {
        try {
            super.print();
            this.printHTMLTrailer(this.output);
        }
        finally {
            this.output.flush();
            this.output.close();
        }
    }

    @Override
    protected void printErrors(PrintWriter out) {
        out.println("<h3>Error summary</h3>");
        int count = this.errorCount();
        if (count != 0) {
            if (count == 1) {
                out.println("There was " + count + " error:<p>");
            } else {
                out.println("There were " + count + " errors:<p>");
            }
            int i = 1;
            Enumeration e = this.errors();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                out.println(String.valueOf(i) + ") " + failure.failedTest() + "<p>");
                failure.thrownException().printStackTrace(out);
                out.println("<p>");
                ++i;
            }
        } else {
            out.println("No errors reported.");
        }
    }

    @Override
    protected void printFailures(PrintWriter out) {
        out.println("<h3>Failure summary</h3>");
        int count = this.failureCount();
        if (count != 0) {
            if (count == 1) {
                out.println("There was " + count + " failure:<p>");
            } else {
                out.println("There were " + count + " failures:<p>");
            }
            int i = 1;
            Enumeration e = this.failures();
            while (e.hasMoreElements()) {
                TestFailure failure = (TestFailure)e.nextElement();
                out.println(String.valueOf(i) + ") " + failure.failedTest() + "<p>");
                failure.thrownException().printStackTrace(out);
                out.println("<p>");
                ++i;
            }
        } else {
            out.println("No failures reported.");
        }
    }

    @Override
    protected void printHeader(PrintWriter out) {
    }

    protected void printHTMLHeader(PrintWriter out) {
        StringBuffer buf = new StringBuffer();
        buf.append("<html>\n<head>\n<title>Eclipse Performance Test Output Page</title>");
        buf.append("</head>\n<body>\n");
        out.println(buf.toString());
    }

    protected void printHTMLTrailer(PrintWriter out) {
        out.println("</body>");
        out.println("</html>");
    }

    @Override
    protected void printTimings(PrintWriter out) {
        out.println("<h3>Timing summary</h3>");
        out.println("<ul>");
        for (PerformanceTimer timer : this.timerList) {
            out.println("<li>" + timer.getName() + " : " + timer.getElapsedTime() + " ms</li>");
        }
        out.println("</ul>");
    }

    @Override
    public synchronized void startTimer(String timerName) {
        super.startTimer(timerName);
    }

    @Override
    public synchronized void stopTimer(String timerName) {
        super.stopTimer(timerName);
    }
}

