/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.session;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.tests.session.SessionTestRunner;
import org.eclipse.core.tests.session.Setup;
import org.eclipse.core.tests.session.SetupManager;
import org.eclipse.core.tests.session.TestDescriptor;

public class SessionTestSuite
extends TestSuite {
    public static final String CORE_TEST_APPLICATION = "org.eclipse.pde.junit.runtime.coretestapplication";
    public static final String UI_TEST_APPLICATION = "org.eclipse.pde.junit.runtime.uitestapplication";
    protected String applicationId = "org.eclipse.pde.junit.runtime.coretestapplication";
    private Set<TestCase> crashTests = new HashSet<TestCase>();
    private Set<TestCase> localTests = new HashSet<TestCase>();
    protected String pluginId;
    private Setup setup;
    private boolean sharedSession;
    protected SessionTestRunner testRunner;

    public SessionTestSuite(String pluginId) {
        this.pluginId = pluginId;
    }

    public SessionTestSuite(String pluginId, Class<?> theClass) {
        super(theClass);
        this.pluginId = pluginId;
    }

    public SessionTestSuite(String pluginId, Class<? extends TestCase> theClass, String name) {
        super(theClass, name);
        this.pluginId = pluginId;
    }

    public SessionTestSuite(String pluginId, String name) {
        super(name);
        this.pluginId = pluginId;
    }

    public void addCrashTest(TestCase test) {
        this.crashTests.add(test);
        super.addTest((Test)test);
    }

    public void addLocalTest(TestCase test) {
        this.localTests.add(test);
        super.addTest((Test)test);
    }

    protected void fillTestDescriptor(TestDescriptor test) throws SetupManager.SetupException {
        if (test.getApplicationId() == null) {
            test.setApplicationId(this.applicationId);
        }
        if (test.getPluginId() == null) {
            test.setPluginId(this.pluginId);
        }
        if (test.getSetup() == null) {
            test.setSetup(this.getSetup());
        }
        if (!test.isCrashTest() && this.crashTests.contains(test.getTest())) {
            test.setCrashTest(true);
        }
        test.setTestRunner(this.getTestRunner());
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Setup getSetup() throws SetupManager.SetupException {
        if (this.setup == null) {
            this.setup = this.newSetup();
        }
        return this.setup;
    }

    protected SessionTestRunner getTestRunner() {
        if (this.testRunner == null) {
            this.testRunner = new SessionTestRunner();
        }
        return this.testRunner;
    }

    protected Test[] getTests(boolean sort) {
        Test[] allTests = new Test[this.testCount()];
        Enumeration e = this.tests();
        int i = 0;
        while (i < allTests.length) {
            allTests[i] = (Test)e.nextElement();
            ++i;
        }
        if (sort) {
            Arrays.sort(allTests, new Comparator<Test>(){

                @Override
                public int compare(Test o1, Test o2) {
                    return ((TestCase)o1).getName().compareTo(((TestCase)o2).getName());
                }
            });
        }
        return allTests;
    }

    private boolean isLocalTest(Test test) {
        return this.localTests.contains(test);
    }

    public boolean isSharedSession() {
        return this.sharedSession;
    }

    protected Setup newSetup() throws SetupManager.SetupException {
        Setup base = SetupManager.getInstance().getDefaultSetup();
        base.setSystemProperty("org.eclipse.update.reconcile", "false");
        return base;
    }

    public void run(TestResult result) {
        if (!this.sharedSession) {
            super.run(result);
            return;
        }
        Enumeration tests = this.tests();
        Assert.isTrue((boolean)tests.hasMoreElements(), (String)"A single test suite must be provided");
        Test onlyTest = (Test)tests.nextElement();
        Assert.isTrue((!tests.hasMoreElements() ? 1 : 0) != 0, (String)"Only a single test suite can be run");
        Assert.isTrue((boolean)(onlyTest instanceof TestSuite), (String)"Only test suites can be run in shared session mode");
        TestSuite nested = (TestSuite)onlyTest;
        try {
            Setup localSetup = (Setup)this.getSetup().clone();
            localSetup.setEclipseArgument("application", this.applicationId);
            localSetup.setEclipseArgument("testpluginname", this.pluginId);
            localSetup.setEclipseArgument("classname", nested.getName() != null ? nested.getName() : nested.getClass().getName());
            new SessionTestRunner().run((Test)this, result, localSetup, false);
        }
        catch (SetupManager.SetupException e) {
            result.addError((Test)this, e.getCause());
            return;
        }
    }

    protected void runSessionTest(TestDescriptor test, TestResult result) {
        try {
            this.fillTestDescriptor(test);
            test.run(result);
        }
        catch (SetupManager.SetupException e) {
            result.addError(test.getTest(), e.getCause());
        }
    }

    public final void runTest(Test test, TestResult result) {
        if (this.sharedSession) {
            throw new UnsupportedOperationException();
        }
        if (test instanceof TestDescriptor) {
            this.runSessionTest((TestDescriptor)test, result);
        } else if (test instanceof TestCase) {
            if (this.isLocalTest(test)) {
                test.run(result);
            } else {
                this.runSessionTest(new TestDescriptor((TestCase)test), result);
            }
        } else if (test instanceof TestSuite) {
            this.runTestSuite((TestSuite)test, result);
        } else {
            test.run(result);
        }
    }

    protected void runTestSuite(TestSuite suite, TestResult result) {
        Enumeration e = suite.tests();
        while (e.hasMoreElements()) {
            if (result.shouldStop()) break;
            Test test = (Test)e.nextElement();
            this.runTest(test, result);
        }
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    void setSetup(Setup setup) {
        this.setup = setup;
    }

    public void setSharedSession(boolean sharedSession) {
        this.sharedSession = sharedSession;
    }
}

