/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.net;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.internal.preferences.EclipsePreferences;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.junit.Assert;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class PreferenceModifyListenerTest {
    private static final String NODE_NAME = "bug419228";
    private static final String KEY = "someKey";
    private static final String VALUE = "someValue";

    @Test
    public void testPreApply() throws BackingStoreException, CoreException {
        IEclipsePreferences toExport = InstanceScope.INSTANCE.getNode(NODE_NAME);
        toExport.put(KEY, VALUE);
        IPreferencesService service = Platform.getPreferencesService();
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        Assert.assertTrue((boolean)service.exportPreferences(toExport, (OutputStream)stream, null).isOK());
        IExportedPreferences exported = service.readPreferences((InputStream)new ByteArrayInputStream(stream.toByteArray()));
        exported = (IExportedPreferences)exported.node("instance").node(NODE_NAME);
        Assert.assertTrue((boolean)service.applyPreferences(exported).isOK());
        String debugString = ((EclipsePreferences)exported.node("/")).toDeepDebugString();
        Assert.assertFalse((String)debugString, (boolean)exported.nodeExists("instance/org.eclipse.core.net"));
        Assert.assertFalse((String)debugString, (boolean)exported.nodeExists("/instance/org.eclipse.core.net"));
        Assert.assertFalse((String)debugString, (boolean)exported.nodeExists("configuration/org.eclipse.core.net"));
        Assert.assertFalse((String)debugString, (boolean)exported.nodeExists("/configuration/org.eclipse.core.net"));
    }
}

