/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.alias;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.AliasManager;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.filesystem.wrapper.WrapperFileSystem;
import org.eclipse.core.tests.resources.ResourceTest;

public class BasicAliasTest
extends ResourceTest {
    private IProject pNoOverlap;
    private IProject pOverlap;
    private IProject pLinked;
    private IFolder fOverlap;
    private IFile lChildOverlap;
    private IFile lOverlap;
    private IFolder fLinked;
    private IFolder fLinkOverlap1;
    private IFolder fLinkOverlap2;
    private IFile lLinked;
    private IFile lChildLinked;
    private IPath linkOverlapLocation;

    public static Test suite() {
        return new TestSuite(BasicAliasTest.class);
    }

    public BasicAliasTest() {
    }

    public BasicAliasTest(String name) {
        super(name);
    }

    public void assertOverlap(String message, IResource resource1, IResource resource2) {
        String errMsg = String.valueOf(message) + resource1.getFullPath().toString();
        BasicAliasTest.assertEquals((String)(String.valueOf(errMsg) + "(location)"), (Object)resource1.getLocation(), (Object)resource2.getLocation());
        BasicAliasTest.assertTrue((String)(String.valueOf(errMsg) + "(sync)"), (boolean)resource1.isSynchronized(0));
        BasicAliasTest.assertTrue((String)(String.valueOf(errMsg) + "(sync)"), (boolean)resource2.isSynchronized(0));
        IResource[] children1 = null;
        IResource[] children2 = null;
        try {
            children1 = this.getSortedChildren(resource1);
            children2 = this.getSortedChildren(resource2);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)errMsg, (Throwable)e);
        }
        BasicAliasTest.assertEquals((String)(String.valueOf(errMsg) + "(child count)"), (int)children1.length, (int)children2.length);
        int i = 0;
        while (i < children2.length) {
            this.assertOverlap(message, children1[i], children2[i]);
            ++i;
        }
    }

    private IResource[] getSortedChildren(IResource resource) throws CoreException {
        if (!(resource instanceof IContainer)) {
            return new IResource[0];
        }
        IResource[] children = ((IContainer)resource).members();
        Arrays.sort(children, (arg0, arg1) -> arg0.getFullPath().toString().compareTo(arg1.getFullPath().toString()));
        return children;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot root = BasicAliasTest.getWorkspace().getRoot();
        this.pNoOverlap = root.getProject("NoOverlap");
        this.ensureExistsInWorkspace((IResource)this.pNoOverlap, true);
        this.ensureExistsInWorkspace(this.buildResources((IContainer)this.pNoOverlap, new String[]{"/1/", "/1/1", "/1/2", "/2/", "/2/1"}), true);
        this.pOverlap = root.getProject("Overlap");
        this.ensureExistsInWorkspace((IResource)this.pOverlap, true);
        this.fOverlap = this.pOverlap.getFolder("fOverlap");
        IFolder f2 = this.pOverlap.getFolder("F2");
        this.lOverlap = f2.getFile("lOverlap");
        this.lChildOverlap = this.fOverlap.getFile("lChildOverlap");
        this.ensureExistsInWorkspace(new IResource[]{this.fOverlap, f2, this.lOverlap, this.lChildOverlap}, true);
        this.ensureExistsInWorkspace(this.buildResources((IContainer)this.pOverlap, new String[]{"/1/", "/1/1", "/1/2"}), true);
        this.ensureExistsInWorkspace(this.buildResources((IContainer)f2, new String[]{"/1/", "/1/1", "/1/2"}), true);
        this.ensureExistsInWorkspace(this.buildResources((IContainer)this.fOverlap, new String[]{"/1/", "/1/1", "/1/2"}), true);
        this.pLinked = root.getProject("LinkProject");
        this.ensureExistsInWorkspace((IResource)this.pLinked, true);
        this.fLinked = this.pLinked.getFolder("LinkedFolder");
        this.fLinkOverlap1 = this.pLinked.getFolder("LinkOverlap1");
        this.fLinkOverlap2 = this.pLinked.getFolder("LinkOverlap2");
        this.lLinked = this.pLinked.getFile("LinkedFile");
        this.lChildLinked = this.fLinked.getFile(this.lChildOverlap.getName());
        this.fLinked.createLink(this.fOverlap.getLocation(), 0, null);
        this.lLinked.createLink(this.lOverlap.getLocation(), 0, null);
        this.ensureExistsInWorkspace((IResource)this.lChildLinked, true);
        this.ensureExistsInWorkspace(this.buildResources((IContainer)this.pLinked, new String[]{"/a/", "/a/a", "/a/b"}), true);
        this.ensureExistsInWorkspace(this.buildResources((IContainer)this.fLinked, new String[]{"/a/", "/a/a", "/a/b"}), true);
        this.linkOverlapLocation = this.getRandomLocation();
        this.linkOverlapLocation.toFile().mkdirs();
        this.fLinkOverlap1.createLink(this.linkOverlapLocation, 0, null);
        this.fLinkOverlap2.createLink(this.linkOverlapLocation, 0, null);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        Workspace.clear((File)this.linkOverlapLocation.toFile());
    }

    public void testBug32785() {
        IProject project = this.pNoOverlap;
        IFolder link = project.getFolder("Source");
        IFile child = link.getFile("Child.txt");
        IPath location = this.getRandomLocation();
        location.toFile().mkdirs();
        try {
            try {
                link.createLink(location, 0, this.getMonitor());
                this.ensureExistsInWorkspace(child, this.getRandomContents());
            }
            catch (CoreException e) {
                BasicAliasTest.fail((String)"1.99", (Throwable)e);
            }
            IFolder movedLink = project.getFolder("MovedLink");
            try {
                link.move(movedLink.getFullPath(), 32, this.getMonitor());
            }
            catch (CoreException e) {
                BasicAliasTest.fail((String)"2.99", (Throwable)e);
            }
            BasicAliasTest.assertTrue((String)"3.0", (!link.exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"3.1", (boolean)movedLink.exists());
            BasicAliasTest.assertEquals((String)"3.2", (Object)location, (Object)movedLink.getLocation());
            BasicAliasTest.assertTrue((String)"3.3", (boolean)movedLink.isSynchronized(2));
            IFolder copiedLink = project.getFolder("CopiedLink");
            try {
                movedLink.copy(copiedLink.getFullPath(), 32, this.getMonitor());
            }
            catch (CoreException e) {
                BasicAliasTest.fail((String)"3.99", (Throwable)e);
            }
            BasicAliasTest.assertTrue((String)"4.0", (!link.exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"4.1", (boolean)movedLink.exists());
            BasicAliasTest.assertTrue((String)"4.2", (boolean)copiedLink.exists());
            BasicAliasTest.assertEquals((String)"4.3", (Object)location, (Object)movedLink.getLocation());
            BasicAliasTest.assertEquals((String)"4.4", (Object)location, (Object)copiedLink.getLocation());
            BasicAliasTest.assertTrue((String)"4.5", (boolean)movedLink.isSynchronized(2));
            BasicAliasTest.assertTrue((String)"4.6", (boolean)copiedLink.isSynchronized(2));
        }
        finally {
            Workspace.clear((File)location.toFile());
        }
    }

    public void testBug156082() {
        IProject top = BasicAliasTest.getWorkspace().getRoot().getProject("Bug156082_Top");
        IProject sub1 = BasicAliasTest.getWorkspace().getRoot().getProject("Bug156082_Sub1");
        IProject sub2 = BasicAliasTest.getWorkspace().getRoot().getProject("Bug156082_Sub2");
        this.ensureExistsInWorkspace((IResource)top, true);
        IProjectDescription desc1 = BasicAliasTest.getWorkspace().newProjectDescription(sub1.getName());
        desc1.setLocation(top.getLocation().append(sub1.getName()));
        IProjectDescription desc2 = BasicAliasTest.getWorkspace().newProjectDescription(sub2.getName());
        desc2.setLocation(top.getLocation().append(sub2.getName()));
        try {
            sub1.create(desc1, this.getMonitor());
            sub1.open(this.getMonitor());
            sub2.create(desc2, this.getMonitor());
            sub2.open(this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"0.99", (Throwable)e);
        }
        IFile sub2File = sub2.getFile("file.txt");
        IFile topFile = top.getFolder(sub2.getName()).getFile(sub2File.getName());
        this.ensureExistsInWorkspace(sub2File, this.getRandomContents());
        BasicAliasTest.assertTrue((String)"1.0", (boolean)topFile.exists());
    }

    public void testBug198571() {
        if (!BasicAliasTest.isWindows()) {
            return;
        }
        String[] devices = this.findAvailableDevices();
        if (devices[0] == null || devices[1] == null) {
            return;
        }
        String location = this.getUniqueString();
        IProject testProject1 = BasicAliasTest.getWorkspace().getRoot().getProject(String.valueOf(location) + "1");
        IProject testProject2 = BasicAliasTest.getWorkspace().getRoot().getProject(String.valueOf(location) + "2");
        IProjectDescription desc1 = BasicAliasTest.getWorkspace().newProjectDescription(testProject1.getName());
        Path location1 = new Path(String.valueOf(devices[0]) + location);
        BasicAliasTest.assertTrue((String)"0.1", (!location1.toFile().exists() ? 1 : 0) != 0);
        desc1.setLocation((IPath)location1);
        IProjectDescription desc2 = BasicAliasTest.getWorkspace().newProjectDescription(testProject2.getName());
        Path location2 = new Path(String.valueOf(devices[1]) + location);
        BasicAliasTest.assertTrue((String)"0.2", (!location2.toFile().exists() ? 1 : 0) != 0);
        desc2.setLocation((IPath)location2);
        try {
            try {
                testProject1.create(desc1, this.getMonitor());
                testProject1.open(this.getMonitor());
                testProject2.create(desc2, this.getMonitor());
                testProject2.open(this.getMonitor());
            }
            catch (CoreException e) {
                BasicAliasTest.fail((String)"1.0", (Throwable)e);
            }
            AliasManager aliasManager = ((Workspace)BasicAliasTest.getWorkspace()).getAliasManager();
            aliasManager.startup(null);
            IFolder folder = testProject2.getFolder("NewFolder");
            this.ensureExistsInFileSystem((IResource)folder);
            try {
                testProject2.refreshLocal(2, null);
                IResource[] resources = aliasManager.computeAliases((IResource)folder, ((Folder)folder).getStore());
                BasicAliasTest.assertNull((Object)resources);
            }
            catch (CoreException e) {
                BasicAliasTest.fail((String)"2.0", (Throwable)e);
            }
        }
        finally {
            this.clear(EFS.getLocalFileSystem().getStore((IPath)location1));
            this.clear(EFS.getLocalFileSystem().getStore((IPath)location2));
        }
    }

    private void replaceProject(IProject project, URI newLocation) throws CoreException {
        IProjectDescription projectDesc = project.getDescription();
        projectDesc.setLocationURI(newLocation);
        project.move(projectDesc, 256, null);
    }

    public void testBug256837() {
        AliasManager aliasManager = ((Workspace)BasicAliasTest.getWorkspace()).getAliasManager();
        aliasManager.startup(null);
        IWorkspaceRoot root = BasicAliasTest.getWorkspace().getRoot();
        IProject p1 = root.getProject(this.getUniqueString());
        IProject p2 = root.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace(new IResource[]{p1, p2}, true);
        IFileStore tempStore = null;
        try {
            tempStore = this.getTempStore();
            tempStore.mkdir(0, this.getMonitor());
        }
        catch (CoreException e1) {
            BasicAliasTest.fail((String)"1.0", (Throwable)e1);
        }
        try {
            this.replaceProject(p2, WrapperFileSystem.getWrappedURI(p2.getLocationURI()));
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.0", (Throwable)e);
        }
        IFolder link2TempFolder = p1.getFolder("link2TempFolder");
        try {
            link2TempFolder.createLink(tempStore.toURI(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            this.replaceProject(p2, tempStore.toURI());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"4.0", (Throwable)e);
        }
        IResource[] resources = aliasManager.computeAliases((IResource)link2TempFolder, ((Folder)link2TempFolder).getStore());
        BasicAliasTest.assertEquals((String)"5.0", (int)1, (int)resources.length);
        BasicAliasTest.assertEquals((String)"6.0", (Object)p2, (Object)resources[0]);
        resources = aliasManager.computeAliases((IResource)p2, ((Project)p2).getStore());
        BasicAliasTest.assertEquals((String)"7.0", (int)1, (int)resources.length);
        BasicAliasTest.assertEquals((String)"8.0", (Object)link2TempFolder, (Object)resources[0]);
    }

    public void testBug258987() {
        IFileStore dirStore = this.getTempStore();
        try {
            dirStore.mkdir(0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.0", (Throwable)e);
        }
        BasicAliasTest.assertTrue((String)"2.0", (boolean)dirStore.fetchInfo().exists());
        BasicAliasTest.assertTrue((String)"3.0", (boolean)dirStore.fetchInfo().isDirectory());
        IFileStore childStore = dirStore.getChild("child");
        this.createFileInFileSystem(childStore);
        BasicAliasTest.assertTrue((String)"4.0", (boolean)childStore.fetchInfo().exists());
        IProject project1 = ResourcesPlugin.getWorkspace().getRoot().getProject("project1");
        IFolder folder1 = null;
        try {
            project1.create(this.getMonitor());
            project1.open(this.getMonitor());
            folder1 = project1.getFolder("subdir");
            folder1.createLink(dirStore.toURI(), 256, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"5.0", (Throwable)e);
        }
        IProject project2 = ResourcesPlugin.getWorkspace().getRoot().getProject("project2");
        IFolder folder2 = null;
        try {
            project2.create(this.getMonitor());
            project2.open(this.getMonitor());
            folder2 = project2.getFolder("subdir");
            folder2.createLink(dirStore.toURI(), 256, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"6.0", (Throwable)e);
        }
        try {
            project2.close(this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"7.0", (Throwable)e);
        }
        IResource[] resources = ((Workspace)BasicAliasTest.getWorkspace()).getAliasManager().computeAliases((IResource)folder1, ((Folder)folder1).getStore());
        BasicAliasTest.assertNull((String)"8.0", (Object)resources);
    }

    public void testCloseOpenProject() {
        try {
            this.pOverlap.close(this.getMonitor());
            IFile linkFile = this.fLinked.getFile("ChildFile.txt");
            linkFile.create(this.getRandomContents(), 0, this.getMonitor());
            IFile closedFile = this.fOverlap.getFile(linkFile.getName());
            BasicAliasTest.assertTrue((String)"1.0", (!closedFile.exists() ? 1 : 0) != 0);
            this.pOverlap.open(0, this.getMonitor());
            this.pOverlap.refreshLocal(2, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.1", (boolean)closedFile.exists());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"4.99", (Throwable)e);
        }
    }

    public void testCopyFile() {
        IFile overlapDest;
        IFile linkDest;
        IFile sourceFile = this.pNoOverlap.getFile("CopySource");
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        try {
            linkDest = this.fLinked.getFile("CopyDestination");
            overlapDest = this.fOverlap.getFile(linkDest.getName());
            sourceFile.copy(linkDest.getFullPath(), 0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.1", (boolean)linkDest.exists());
            BasicAliasTest.assertTrue((String)"1.2", (boolean)overlapDest.exists());
            this.assertOverlap("1.3", (IResource)linkDest, (IResource)overlapDest);
            linkDest.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.4", (!linkDest.exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"1.5", (!overlapDest.exists() ? 1 : 0) != 0);
            this.assertOverlap("1.6", (IResource)linkDest, (IResource)overlapDest);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            linkDest = this.lLinked;
            overlapDest = this.lOverlap;
            overlapDest.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"2.1", (boolean)linkDest.exists());
            BasicAliasTest.assertTrue((String)"2.2", (!overlapDest.exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"2.3", (!linkDest.getLocation().toFile().exists() ? 1 : 0) != 0);
            BasicAliasTest.assertEquals((String)"2.4", (Object)linkDest.getLocation(), (Object)overlapDest.getLocation());
            sourceFile.copy(overlapDest.getFullPath(), 0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"2.4", (boolean)linkDest.exists());
            BasicAliasTest.assertTrue((String)"2.5", (boolean)overlapDest.exists());
            this.assertOverlap("2.6", (IResource)linkDest, (IResource)overlapDest);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            linkDest = this.fLinked.getFile("CopyDestination");
            overlapDest = this.fOverlap.getFile(linkDest.getName());
            sourceFile.copy(overlapDest.getFullPath(), 0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"3.1", (boolean)linkDest.exists());
            BasicAliasTest.assertTrue((String)"3.2", (boolean)overlapDest.exists());
            this.assertOverlap("3.3", (IResource)linkDest, (IResource)overlapDest);
            overlapDest.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"3.4", (!linkDest.exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"3.5", (!overlapDest.exists() ? 1 : 0) != 0);
            this.assertOverlap("3.6", (IResource)linkDest, (IResource)overlapDest);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.99", (Throwable)e);
        }
    }

    public void testCopyFolder() {
        IFolder source = this.pNoOverlap.getFolder("CopyFolder");
        this.ensureExistsInWorkspace((IResource)source, true);
        IFolder destFolder1 = this.fLinkOverlap1.getFolder(source.getName());
        IFolder destFolder2 = this.fLinkOverlap2.getFolder(source.getName());
        IResource[] allDest = new IResource[]{destFolder1, destFolder2};
        this.assertDoesNotExistInWorkspace("1.0", allDest);
        try {
            source.copy(destFolder1.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            BasicAliasTest.fail((String)"1.1");
        }
        this.assertExistsInWorkspace("1.2", allDest);
        try {
            destFolder2.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.3", (Throwable)e);
        }
        try {
            source.copy(destFolder2.getFullPath(), 0, this.getMonitor());
        }
        catch (CoreException coreException) {
            BasicAliasTest.fail((String)"1.4");
        }
        this.assertExistsInWorkspace("1.5", allDest);
        try {
            destFolder1.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.6", (Throwable)e);
        }
    }

    public void testCopyToChild() {
        IFolder copyDest = this.fLinkOverlap1.getFolder("CopyDest");
        try {
            this.fLinkOverlap2.copy(copyDest.getFullPath(), 0, this.getMonitor());
            BasicAliasTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            this.fLinkOverlap2.move(copyDest.getFullPath(), 0, this.getMonitor());
            BasicAliasTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        IFolder copyDest2 = this.fLinkOverlap2.getFolder(copyDest.getName());
        try {
            copyDest.create(0, true, this.getMonitor());
        }
        catch (CoreException coreException) {
            BasicAliasTest.fail((String)"1.3");
        }
        try {
            copyDest.copy(copyDest2.getFullPath(), 0, this.getMonitor());
            BasicAliasTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
        try {
            copyDest.move(copyDest2.getFullPath(), 0, this.getMonitor());
            BasicAliasTest.fail((String)"1.0");
        }
        catch (CoreException coreException) {}
    }

    public void testCreateDeleteFile() {
        try {
            this.lChildLinked.delete(0, this.getMonitor());
            this.assertOverlap("1.1", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
            this.lChildLinked.create(this.getRandomContents(), 0, this.getMonitor());
            this.assertOverlap("1.2", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            this.lOverlap.delete(0, this.getMonitor());
            BasicAliasTest.assertEquals((String)"2.0", (Object)this.lLinked.getLocation(), (Object)this.lOverlap.getLocation());
            BasicAliasTest.assertTrue((String)"2.1", (!this.lOverlap.exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"2.2", (!this.lOverlap.getLocation().toFile().exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"2.3", (boolean)this.lOverlap.isSynchronized(2));
            BasicAliasTest.assertTrue((String)"2.4", (boolean)this.lLinked.exists());
            BasicAliasTest.assertTrue((String)"2.5", (!this.lLinked.getLocation().toFile().exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"2.6", (boolean)this.lLinked.isSynchronized(2));
            try {
                this.lLinked.setContents(this.getRandomContents(), 0, this.getMonitor());
                BasicAliasTest.fail((String)"2.7");
            }
            catch (CoreException coreException) {}
            this.lOverlap.create(this.getRandomContents(), 0, this.getMonitor());
            this.assertOverlap("2.8", (IResource)this.lLinked, (IResource)this.lOverlap);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            this.lChildOverlap.delete(0, this.getMonitor());
            this.assertOverlap("1.1", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
            this.lChildOverlap.create(this.getRandomContents(), 0, this.getMonitor());
            this.assertOverlap("1.2", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testCreateDeleteFolder() {
        try {
            this.fOverlap.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.0", (boolean)this.fLinked.exists());
            BasicAliasTest.assertTrue((String)"1.1", (!this.fLinked.getLocation().toFile().exists() ? 1 : 0) != 0);
            this.fOverlap.create(0, true, this.getMonitor());
            this.assertOverlap("1.2", (IResource)this.fOverlap, (IResource)this.fLinked);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            this.fLinked.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"2.0", (boolean)this.fOverlap.exists());
            BasicAliasTest.assertTrue((String)"2.1", (boolean)this.fOverlap.getLocation().toFile().exists());
            this.fLinked.createLink(this.fOverlap.getLocation(), 0, this.getMonitor());
            this.assertOverlap("1.4", (IResource)this.fOverlap, (IResource)this.fLinked);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.99", (Throwable)e);
        }
        IFolder child1 = this.fLinkOverlap1.getFolder("LinkChild");
        IFolder child2 = this.fLinkOverlap2.getFolder(child1.getName());
        try {
            child1.create(0, true, this.getMonitor());
            this.assertOverlap("3.0", (IResource)child1, (IResource)child2);
            child1.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"3.1", (!child1.exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"3.2", (!child2.exists() ? 1 : 0) != 0);
            child2.create(0, true, this.getMonitor());
            this.assertOverlap("3.3", (IResource)child1, (IResource)child2);
            child2.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"3.4", (!child1.exists() ? 1 : 0) != 0);
            BasicAliasTest.assertTrue((String)"3.5", (!child2.exists() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.99", (Throwable)e);
        }
    }

    public void testCreateDeleteLink() {
        IFolder folder = this.pNoOverlap.getFolder("folder");
        IFile folderChild = folder.getFile("Child.txt");
        IFolder link = this.pLinked.getFolder("FolderLink");
        IFile linkChild = link.getFile(folderChild.getName());
        this.ensureExistsInWorkspace((IResource)folder, true);
        this.ensureExistsInWorkspace((IResource)folderChild, true);
        try {
            link.createLink(folder.getLocationURI(), 0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.0", (boolean)linkChild.exists());
            folderChild.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.1", (!linkChild.exists() ? 1 : 0) != 0);
            this.ensureExistsInWorkspace((IResource)folderChild, true);
            BasicAliasTest.assertTrue((String)"1.2", (boolean)linkChild.exists());
            link.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.3", (!linkChild.exists() ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testDeepLink() {
        IFolder folder = this.pNoOverlap.getFolder("folder");
        IFile folderChild = folder.getFile("Child.txt");
        IFolder linkParent = this.pLinked.getFolder("LinkParent");
        IFolder link = linkParent.getFolder("FolderLink");
        IFile linkChild = link.getFile(folderChild.getName());
        this.ensureExistsInWorkspace(new IResource[]{folder, folderChild, linkParent}, true);
        try {
            link.createLink(folder.getLocationURI(), 0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.0", (boolean)linkChild.exists());
            folderChild.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.1", (!linkChild.exists() ? 1 : 0) != 0);
            this.ensureExistsInWorkspace((IResource)folderChild, true);
            BasicAliasTest.assertTrue((String)"1.2", (boolean)linkChild.exists());
            link.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"1.3", (!linkChild.exists() ? 1 : 0) != 0);
            link.createLink(folder.getLocationURI(), 0, this.getMonitor());
            link.getProject().close(this.getMonitor());
            link.getProject().open(this.getMonitor());
            folderChild.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"2.1", (!linkChild.exists() ? 1 : 0) != 0);
            this.ensureExistsInWorkspace((IResource)folderChild, true);
            BasicAliasTest.assertTrue((String)"2.2", (boolean)linkChild.exists());
            AliasManager aliasManager = ((Workspace)BasicAliasTest.getWorkspace()).getAliasManager();
            aliasManager.startup(null);
            folderChild.delete(0, this.getMonitor());
            BasicAliasTest.assertTrue((String)"3.1", (!linkChild.exists() ? 1 : 0) != 0);
            this.ensureExistsInWorkspace((IResource)folderChild, true);
            BasicAliasTest.assertTrue((String)"3.2", (boolean)linkChild.exists());
            IFile fileInLinkedProject = this.pLinked.getFile("fileInLinkedProject.txt");
            this.createFileInFileSystem(((Resource)fileInLinkedProject).getStore(), this.getRandomContents());
            try {
                BasicAliasTest.getWorkspace().getRoot().delete(0, this.getMonitor());
            }
            catch (CoreException coreException) {}
            Object[] aliases = aliasManager.computeAliases((IResource)folder, ((Folder)folder).getStore());
            if (aliases != null) {
                BasicAliasTest.fail((String)("Unexpected aliases: " + Arrays.toString(aliases)));
            }
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.99", (Throwable)e);
        }
    }

    public void testCreateOpenProject() {
        IProject newProject = BasicAliasTest.getWorkspace().getRoot().getProject("createOpenProject");
        IProjectDescription desc = BasicAliasTest.getWorkspace().newProjectDescription(newProject.getName());
        desc.setLocationURI(this.fLinkOverlap1.getLocationURI());
        try {
            newProject.create(desc, this.getMonitor());
            newProject.open(this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.99", (Throwable)e);
        }
        IFile linkChild = this.fLinkOverlap1.getFile(".project");
        BasicAliasTest.assertTrue((String)"1.0", (boolean)linkChild.exists());
    }

    public void testDeepCopyLink() {
    }

    public void testDeepMoveLink() {
    }

    public void testDeleteLink() {
        IFolder linkOnProject = this.pLinked.getFolder("LinkOnProject");
        try {
            linkOnProject.createLink(this.pOverlap.getLocation(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            linkOnProject.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.0", (Throwable)e);
        }
        BasicAliasTest.assertTrue((String)"2.1", (!linkOnProject.exists() ? 1 : 0) != 0);
        BasicAliasTest.assertTrue((String)"2.2", (boolean)this.pOverlap.exists());
        BasicAliasTest.assertTrue((String)"2.3", (boolean)this.fOverlap.exists());
    }

    public void testDeleteProject() {
    }

    public void testDeleteProjectUnderProject() {
        IProject parent = BasicAliasTest.getWorkspace().getRoot().getProject("parent");
        IProject child = BasicAliasTest.getWorkspace().getRoot().getProject("child");
        this.ensureExistsInWorkspace((IResource)parent, true);
        IProjectDescription childDesc = BasicAliasTest.getWorkspace().newProjectDescription(child.getName());
        childDesc.setLocation(parent.getLocation().append(child.getName()));
        try {
            child.create(childDesc, this.getMonitor());
            child.open(this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.99", (Throwable)e);
        }
        IFolder childDirInParent = parent.getFolder(child.getName());
        IFile childProjectFileInParent = childDirInParent.getFile(".project");
        BasicAliasTest.assertTrue((String)"1.0", (boolean)childDirInParent.exists());
        BasicAliasTest.assertTrue((String)"1.1", (boolean)childProjectFileInParent.exists());
        try {
            child.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.99", (Throwable)e);
        }
        BasicAliasTest.assertTrue((String)"2.0", (!childDirInParent.exists() ? 1 : 0) != 0);
        BasicAliasTest.assertTrue((String)"2.1", (!childProjectFileInParent.exists() ? 1 : 0) != 0);
        try {
            child.create(childDesc, this.getMonitor());
            child.open(this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.99", (Throwable)e);
        }
        BasicAliasTest.assertTrue((String)"3.0", (boolean)childDirInParent.exists());
        BasicAliasTest.assertTrue((String)"3.1", (boolean)childProjectFileInParent.exists());
        try {
            parent.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"4.99", (Throwable)e);
        }
        BasicAliasTest.assertTrue((String)"4.0", (!parent.exists() ? 1 : 0) != 0);
        BasicAliasTest.assertTrue((String)"4.1", (!child.exists() ? 1 : 0) != 0);
        BasicAliasTest.assertTrue((String)"4.2", (!childDirInParent.exists() ? 1 : 0) != 0);
        BasicAliasTest.assertTrue((String)"4.3", (!childProjectFileInParent.exists() ? 1 : 0) != 0);
    }

    public void testDeleteProjectContents() {
        try {
            this.pOverlap.delete(4, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.0", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("1.1", new IResource[]{this.pOverlap, this.fOverlap, this.lOverlap, this.lChildOverlap, this.lChildLinked});
        this.assertDoesNotExistInFileSystem("1.2", new IResource[]{this.pOverlap, this.fOverlap, this.lOverlap, this.lChildOverlap, this.lChildLinked, this.lLinked, this.fLinked});
        this.assertExistsInWorkspace("1.3", new IResource[]{this.pLinked, this.fLinked, this.lLinked});
    }

    public void testFileAppendContents() {
        try {
            this.lLinked.appendContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.0", (Throwable)e);
        }
        this.assertOverlap("1.1", (IResource)this.lLinked, (IResource)this.lOverlap);
        try {
            this.lChildLinked.appendContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.0", (Throwable)e);
        }
        this.assertOverlap("2.1", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        try {
            this.lOverlap.appendContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertOverlap("3.1", (IResource)this.lLinked, (IResource)this.lOverlap);
        try {
            this.lChildOverlap.appendContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertOverlap("3.1", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
    }

    public void testFileSetContents() {
        try {
            this.lLinked.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.0", (Throwable)e);
        }
        this.assertOverlap("1.1", (IResource)this.lLinked, (IResource)this.lOverlap);
        try {
            this.lChildLinked.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.0", (Throwable)e);
        }
        this.assertOverlap("2.1", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        try {
            this.lOverlap.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertOverlap("3.1", (IResource)this.lLinked, (IResource)this.lOverlap);
        try {
            this.lChildOverlap.setContents(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.0", (Throwable)e);
        }
        this.assertOverlap("3.1", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
    }

    public void testMoveFile() {
        IFile destination = this.pNoOverlap.getFile("MoveDestination");
        try {
            this.lChildLinked.move(destination.getFullPath(), 0, this.getMonitor());
            this.assertDoesNotExistInWorkspace("1.1", (IResource)this.lChildLinked);
            this.assertDoesNotExistInWorkspace("1.2", (IResource)this.lChildOverlap);
            this.assertExistsInWorkspace("1.3", (IResource)destination);
            this.assertOverlap("1.4", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
            BasicAliasTest.assertTrue((String)"1.5", (boolean)this.lChildLinked.isSynchronized(2));
            BasicAliasTest.assertTrue((String)"1.6", (boolean)destination.isSynchronized(2));
            destination.move(this.lChildLinked.getFullPath(), 0, this.getMonitor());
            this.assertExistsInWorkspace("2.1", (IResource)this.lChildLinked);
            this.assertExistsInWorkspace("2.2", (IResource)this.lChildOverlap);
            this.assertDoesNotExistInWorkspace("2.3", (IResource)destination);
            this.assertOverlap("2.4", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"1.99", (Throwable)e);
        }
        try {
            this.lOverlap.move(destination.getFullPath(), 0, this.getMonitor());
            this.assertDoesNotExistInWorkspace("3.1", (IResource)this.lOverlap);
            this.assertExistsInWorkspace("3.2", (IResource)this.lLinked);
            this.assertDoesNotExistInFileSystem("3.25", (IResource)this.lLinked);
            this.assertExistsInWorkspace("3.3", (IResource)destination);
            BasicAliasTest.assertEquals((String)"3.4", (Object)this.lLinked.getLocation(), (Object)this.lOverlap.getLocation());
            BasicAliasTest.assertTrue((String)"3.4.1", (boolean)this.lLinked.isSynchronized(2));
            destination.move(this.lOverlap.getFullPath(), 0, this.getMonitor());
            this.assertExistsInWorkspace("3.5", (IResource)this.lLinked);
            this.assertExistsInWorkspace("3.6", (IResource)this.lOverlap);
            this.assertDoesNotExistInWorkspace("3.7", (IResource)destination);
            this.assertOverlap("3.8", (IResource)this.lLinked, (IResource)this.lOverlap);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            this.lChildOverlap.move(destination.getFullPath(), 0, this.getMonitor());
            this.assertDoesNotExistInWorkspace("3.1", (IResource)this.lChildLinked);
            this.assertDoesNotExistInWorkspace("3.2", (IResource)this.lChildOverlap);
            this.assertExistsInWorkspace("3.3", (IResource)destination);
            this.assertOverlap("3.4", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
            destination.move(this.lChildOverlap.getFullPath(), 0, this.getMonitor());
            this.assertExistsInWorkspace("3.5", (IResource)this.lChildLinked);
            this.assertExistsInWorkspace("3.6", (IResource)this.lChildOverlap);
            this.assertDoesNotExistInWorkspace("3.7", (IResource)destination);
            this.assertOverlap("3.8", (IResource)this.lChildLinked, (IResource)this.lChildOverlap);
        }
        catch (CoreException e) {
            BasicAliasTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testMoveFolder() {
    }

    public void testShallowCopyLink() {
    }

    public void testShallowMoveLink() {
    }

    public void testShallowDeleteProject() {
    }
}

