/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.ConfigurationBuilder;
import org.eclipse.core.tests.resources.ResourceDeltaVerifier;

public class BuildConfigurationsTest
extends AbstractBuilderTest {
    private IProject project0;
    private IProject project1;
    private IFile file0;
    private IFile file1;
    private final String variant0 = "Variant0";
    private final String variant1 = "Variant1";
    private final String variant2 = "Variant2";

    public static Test suite() {
        return new TestSuite(BuildConfigurationsTest.class);
    }

    public BuildConfigurationsTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IWorkspaceRoot root = BuildConfigurationsTest.getWorkspace().getRoot();
        this.project0 = root.getProject("BuildVariantTest_p0");
        this.project1 = root.getProject("BuildVariantTest_p1");
        this.file0 = this.project0.getFile("File0");
        this.file1 = this.project1.getFile("File1");
        IResource[] resources = new IResource[]{this.project0, this.project1, this.file0, this.file1};
        this.ensureExistsInWorkspace(resources, true);
        this.setAutoBuilding(false);
        this.setupProject(this.project0);
        this.setupProject(this.project1);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.project0.delete(true, null);
        this.project1.delete(true, null);
    }

    private void setupProject(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand command = this.createCommand(desc, "org.eclipse.core.tests.resources.configbuilder", "Build0");
        command.setBuilding(9, true);
        command.setBuilding(6, true);
        command.setBuilding(10, true);
        command.setBuilding(15, true);
        desc.setBuildSpec(new ICommand[]{command});
        desc.setBuildConfigs(new String[]{"Variant0", "Variant1", "Variant2"});
        project.setDescription(desc, this.getMonitor());
    }

    public void testDeltas() throws CoreException {
        ConfigurationBuilder.clearStats();
        this.file0.setContents(this.getRandomContents(), true, true, this.getMonitor());
        this.incrementalBuild(1, this.project0, "Variant1", true, 1, 6);
        this.incrementalBuild(2, this.project0, "Variant1", false, 1, 0);
        this.incrementalBuild(3, this.project0, "Variant2", true, 1, 6);
        this.incrementalBuild(4, this.project0, "Variant1", false, 1, 0);
        this.file0.setContents(this.getRandomContents(), true, true, this.getMonitor());
        this.incrementalBuild(5, this.project0, "Variant1", true, 2, 10);
        this.incrementalBuild(6, this.project0, "Variant2", true, 2, 10);
        this.incrementalBuild(7, this.project0, "Variant0", true, 1, 6);
    }

    public void testCloseAndOpenProject() throws CoreException {
        ConfigurationBuilder.clearStats();
        this.file0.setContents(this.getRandomContents(), true, true, this.getMonitor());
        this.incrementalBuild(1, this.project0, "Variant0", true, 1, 6);
        this.incrementalBuild(2, this.project0, "Variant1", true, 1, 6);
        this.incrementalBuild(3, this.project0, "Variant2", true, 1, 6);
        this.project0.close(this.getMonitor());
        ConfigurationBuilder.clearStats();
        this.project0.open(this.getMonitor());
        this.incrementalBuild(4, this.project0, "Variant0", false, 0, 0);
        this.incrementalBuild(5, this.project0, "Variant1", false, 0, 0);
        this.incrementalBuild(6, this.project0, "Variant2", false, 0, 0);
    }

    public void testCloseAndOpenProject_Bug361675() throws CoreException {
        IWorkspaceRoot root = BuildConfigurationsTest.getWorkspace().getRoot();
        IProject tempProject = root.getProject("BuildVariantTest_pTemp");
        IFile tempFile0 = tempProject.getFile("File0");
        IFile tempFile1 = tempProject.getFile("File1");
        IResource[] resources = new IResource[]{tempProject, tempFile0, tempFile1};
        this.ensureExistsInWorkspace(resources, true);
        this.setupProject(tempProject);
        try {
            ConfigurationBuilder.clearStats();
            tempFile0.setContents(this.getRandomContents(), true, true, this.getMonitor());
            tempFile1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            this.incrementalBuild(1, tempProject, "Variant0", true, 1, 6);
            this.incrementalBuild(2, tempProject, "Variant1", true, 1, 6);
            this.incrementalBuild(3, tempProject, "Variant2", true, 1, 6);
            tempFile0.setContents(this.getRandomContents(), true, true, this.getMonitor());
            this.incrementalBuild(4, tempProject, "Variant1", true, 2, 10);
            tempFile1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            this.incrementalBuild(5, tempProject, "Variant2", true, 2, 10);
            tempProject.close(this.getMonitor());
            ConfigurationBuilder.clearStats();
            tempProject.open(this.getMonitor());
            this.incrementalBuild(6, tempProject, "Variant0", true, 1, 10);
            ConfigurationBuilder builder0 = ConfigurationBuilder.getBuilder(tempProject.getBuildConfig("Variant0"));
            BuildConfigurationsTest.assertNotNull((String)"6.10", (Object)((Object)builder0));
            ResourceDeltaVerifier verifier0 = new ResourceDeltaVerifier();
            verifier0.addExpectedChange((IResource)tempFile0, (IResource)tempProject, 4, 256);
            verifier0.addExpectedChange((IResource)tempFile1, (IResource)tempProject, 4, 256);
            verifier0.verifyDelta(builder0.deltaForLastBuild);
            BuildConfigurationsTest.assertTrue((String)("6.11: " + verifier0.getMessage()), (boolean)verifier0.isDeltaValid());
            this.incrementalBuild(7, tempProject, "Variant1", true, 1, 10);
            ConfigurationBuilder builder1 = ConfigurationBuilder.getBuilder(tempProject.getBuildConfig("Variant1"));
            BuildConfigurationsTest.assertNotNull((String)"7.10", (Object)((Object)builder1));
            ResourceDeltaVerifier verifier1 = new ResourceDeltaVerifier();
            verifier1.addExpectedChange((IResource)tempFile1, (IResource)tempProject, 4, 256);
            verifier1.verifyDelta(builder1.deltaForLastBuild);
            BuildConfigurationsTest.assertTrue((String)("7.11: " + verifier1.getMessage()), (boolean)verifier1.isDeltaValid());
            this.incrementalBuild(8, tempProject, "Variant2", false, 0, 0);
        }
        finally {
            tempProject.delete(true, this.getMonitor());
        }
    }

    public void testBuildReferences() throws CoreException {
        ConfigurationBuilder.clearStats();
        ConfigurationBuilder.clearBuildOrder();
        IProjectDescription desc = this.project0.getDescription();
        desc.setActiveBuildConfig("Variant0");
        this.project0.setDescription(desc, this.getMonitor());
        desc = this.project1.getDescription();
        desc.setActiveBuildConfig("Variant0");
        this.project1.setDescription(desc, this.getMonitor());
        this.setReferences(this.project0, "Variant0", new IBuildConfiguration[]{this.project0.getBuildConfig("Variant1"), this.project1.getBuildConfig("Variant2"), this.project1.getBuildConfig("Variant0")});
        BuildConfigurationsTest.getWorkspace().build(10, this.getMonitor());
        BuildConfigurationsTest.assertEquals((String)"1.0", (int)4, (int)ConfigurationBuilder.buildOrder.size());
        BuildConfigurationsTest.assertEquals((String)"1.1", (Object)this.project0.getBuildConfig("Variant1"), (Object)ConfigurationBuilder.buildOrder.get(0));
        BuildConfigurationsTest.assertEquals((String)"1.2", (Object)this.project1.getBuildConfig("Variant0"), (Object)ConfigurationBuilder.buildOrder.get(1));
        BuildConfigurationsTest.assertEquals((String)"1.3", (Object)this.project1.getBuildConfig("Variant2"), (Object)ConfigurationBuilder.buildOrder.get(2));
        BuildConfigurationsTest.assertEquals((String)"1.4", (Object)this.project0.getBuildConfig("Variant0"), (Object)ConfigurationBuilder.buildOrder.get(3));
        this.checkBuild(2, this.project0, "Variant0", true, 1, 6);
        this.checkBuild(3, this.project0, "Variant1", true, 1, 6);
        this.checkBuild(4, this.project0, "Variant2", false, 0, 0);
        this.checkBuild(5, this.project1, "Variant0", true, 1, 6);
        this.checkBuild(6, this.project1, "Variant1", false, 0, 0);
        this.checkBuild(7, this.project1, "Variant2", true, 1, 6);
        this.file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
        ConfigurationBuilder.clearBuildOrder();
        BuildConfigurationsTest.getWorkspace().build(10, this.getMonitor());
        BuildConfigurationsTest.assertEquals((String)"8.0", (int)2, (int)ConfigurationBuilder.buildOrder.size());
        BuildConfigurationsTest.assertEquals((String)"8.1", (Object)this.project1.getBuildConfig("Variant0"), (Object)ConfigurationBuilder.buildOrder.get(0));
        BuildConfigurationsTest.assertEquals((String)"8.2", (Object)this.project1.getBuildConfig("Variant2"), (Object)ConfigurationBuilder.buildOrder.get(1));
        this.checkBuild(9, this.project0, "Variant0", false, 1, 0);
        this.checkBuild(10, this.project0, "Variant1", false, 1, 0);
        this.checkBuild(11, this.project0, "Variant2", false, 0, 0);
        this.checkBuild(12, this.project1, "Variant0", true, 2, 10);
        this.checkBuild(13, this.project1, "Variant1", false, 0, 0);
        this.checkBuild(14, this.project1, "Variant2", true, 2, 10);
    }

    public void testBuildReferencesOfClosedProject() throws CoreException {
        ConfigurationBuilder.clearStats();
        ConfigurationBuilder.clearBuildOrder();
        IProjectDescription desc = this.project0.getDescription();
        desc.setActiveBuildConfig("Variant0");
        desc.setBuildConfigReferences("Variant0", new IBuildConfiguration[]{this.project1.getBuildConfig("Variant0")});
        this.project0.setDescription(desc, this.getMonitor());
        this.project1.close(this.getMonitor());
        BuildConfigurationsTest.getWorkspace().build(new IBuildConfiguration[]{this.project0.getBuildConfig("Variant0")}, 6, true, this.getMonitor());
        BuildConfigurationsTest.assertEquals((String)"1.0", (int)1, (int)ConfigurationBuilder.buildOrder.size());
        BuildConfigurationsTest.assertEquals((String)"1.1", (Object)this.project0.getBuildConfig("Variant0"), (Object)ConfigurationBuilder.buildOrder.get(0));
        this.checkBuild(2, this.project0, "Variant0", true, 1, 6);
        ConfigurationBuilder.clearStats();
        ConfigurationBuilder.clearBuildOrder();
        BuildConfigurationsTest.getWorkspace().build(6, this.getMonitor());
        BuildConfigurationsTest.assertEquals((String)"1.0", (int)1, (int)ConfigurationBuilder.buildOrder.size());
        BuildConfigurationsTest.assertEquals((String)"1.1", (Object)this.project0.getBuildConfig("Variant0"), (Object)ConfigurationBuilder.buildOrder.get(0));
        this.checkBuild(2, this.project0, "Variant0", true, 1, 6);
        this.project1.open(this.getMonitor());
        ConfigurationBuilder.clearStats();
        ConfigurationBuilder.clearBuildOrder();
        BuildConfigurationsTest.getWorkspace().build(6, this.getMonitor());
        BuildConfigurationsTest.assertEquals((String)"8.0", (int)2, (int)ConfigurationBuilder.buildOrder.size());
        BuildConfigurationsTest.assertEquals((String)"8.1", (Object)this.project1.getBuildConfig("Variant0"), (Object)ConfigurationBuilder.buildOrder.get(0));
        BuildConfigurationsTest.assertEquals((String)"8.2", (Object)this.project0.getBuildConfig("Variant0"), (Object)ConfigurationBuilder.buildOrder.get(1));
    }

    public void testClean() throws CoreException {
        ConfigurationBuilder.clearStats();
        this.incrementalBuild(1, this.project0, "Variant0", true, 1, 6);
        this.incrementalBuild(2, this.project0, "Variant1", true, 1, 6);
        this.clean(3, this.project0, "Variant0", 2);
        this.incrementalBuild(4, this.project0, "Variant1", false, 1, 0);
    }

    private void setReferences(IProject project, String configId, IBuildConfiguration[] configs) throws CoreException {
        IProjectDescription desc = project.getDescription();
        desc.setBuildConfigReferences(configId, configs);
        project.setDescription(desc, this.getMonitor());
    }

    private void incrementalBuild(int testId, IProject project, String variant, boolean shouldBuild, int expectedCount, int expectedTrigger) throws CoreException {
        project.build(project.getBuildConfig(variant), 10, this.getMonitor());
        this.checkBuild(testId, project, variant, shouldBuild, expectedCount, expectedTrigger);
    }

    private void clean(int testId, IProject project, String variant, int expectedCount) throws CoreException {
        project.build(project.getBuildConfig(variant), 15, this.getMonitor());
        ConfigurationBuilder builder = ConfigurationBuilder.getBuilder(project.getBuildConfig(variant));
        BuildConfigurationsTest.assertNotNull((String)(String.valueOf(testId) + ".0"), (Object)((Object)builder));
        BuildConfigurationsTest.assertEquals((String)(String.valueOf(testId) + ".1"), (int)expectedCount, (int)builder.buildCount);
        BuildConfigurationsTest.assertEquals((String)(String.valueOf(testId) + ".2"), (int)15, (int)builder.triggerForLastBuild);
    }

    private void checkBuild(int testId, IProject project, String variant, boolean shouldBuild, int expectedCount, int expectedTrigger) throws CoreException {
        try {
            project.getBuildConfig(variant);
        }
        catch (CoreException coreException) {
            BuildConfigurationsTest.fail((String)(String.valueOf(testId) + ".0"));
        }
        ConfigurationBuilder builder = ConfigurationBuilder.getBuilder(project.getBuildConfig(variant));
        if (builder == null) {
            BuildConfigurationsTest.assertFalse((String)(String.valueOf(testId) + ".1"), (boolean)shouldBuild);
            BuildConfigurationsTest.assertEquals((String)(String.valueOf(testId) + ".2"), (int)0, (int)expectedCount);
        } else {
            BuildConfigurationsTest.assertEquals((String)(String.valueOf(testId) + ".3"), (int)expectedCount, (int)builder.buildCount);
            if (shouldBuild) {
                BuildConfigurationsTest.assertEquals((String)(String.valueOf(testId) + ".4"), (int)expectedTrigger, (int)builder.triggerForLastBuild);
            }
        }
    }
}

