/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.DeltaVerifierBuilder;

public class BuildDeltaVerificationTest
extends AbstractBuilderTest {
    DeltaVerifierBuilder verifier;
    protected static final String PROJECT1 = "Project1";
    protected static final String PROJECT2 = "Project2";
    protected static final String FOLDER1 = "Folder1";
    protected static final String FOLDER2 = "Folder2";
    protected static final String FILE1 = "File1";
    protected static final String FILE2 = "File2";
    protected static final String FILE3 = "File3";
    IProject project1;
    IProject project2;
    IFolder folder1;
    IFolder folder2;
    IFolder folder3;
    IFile file1;
    IFile file2;
    IFile file3;

    public BuildDeltaVerificationTest() {
        super(null);
    }

    public BuildDeltaVerificationTest(String name) {
        super(name);
    }

    public void assertDelta() {
        this.verifier.isDeltaValid();
        BuildDeltaVerificationTest.assertTrue((String)"Should be an incremental build", (boolean)this.verifier.wasIncrementalBuild());
        BuildDeltaVerificationTest.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
    }

    protected void handleCoreException(CoreException e) {
        BuildDeltaVerificationTest.assertTrue((String)("CoreException: " + e.getMessage()), (boolean)false);
    }

    protected void rebuild() throws CoreException {
        this.project1.build(10, this.getMonitor());
        this.project2.build(10, this.getMonitor());
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IWorkspace workspace = BuildDeltaVerificationTest.getWorkspace();
        this.setAutoBuilding(false);
        this.project1 = workspace.getRoot().getProject(PROJECT1);
        this.project2 = workspace.getRoot().getProject(PROJECT2);
        this.folder1 = this.project1.getFolder(FOLDER1);
        this.folder2 = this.folder1.getFolder(FOLDER2);
        this.folder3 = this.folder1.getFolder(FILE1);
        this.file1 = this.folder1.getFile(FILE1);
        this.file2 = this.folder1.getFile(FILE2);
        this.file3 = this.folder2.getFile(FILE1);
        try {
            this.project1.create(this.getMonitor());
            this.project1.open(this.getMonitor());
            this.folder1.create(true, true, this.getMonitor());
            this.file1.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            BuildDeltaVerificationTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            IProjectDescription desc = this.project1.getDescription();
            ICommand command = desc.newCommand();
            command.setBuilderName("org.eclipse.core.tests.resources.deltaverifierbuilder");
            desc.setBuildSpec(new ICommand[]{command});
            this.project1.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e) {
            BuildDeltaVerificationTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            this.project1.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            BuildDeltaVerificationTest.fail((String)"3.3", (Throwable)e);
        }
        this.verifier = DeltaVerifierBuilder.getInstance();
        BuildDeltaVerificationTest.assertNotNull((String)"Builder was not instantiated", (Object)((Object)this.verifier));
        BuildDeltaVerificationTest.assertTrue((String)"First build should be a batch build", (boolean)this.verifier.wasFullBuild());
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BuildDeltaVerificationTest.class);
        return suite;
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        BuildDeltaVerificationTest.getWorkspace().getRoot().delete(true, this.getMonitor());
    }

    public void testAddAndRemoveFile() {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
            this.file2.create((InputStream)in, true, this.getMonitor());
            this.file2.delete(true, this.getMonitor());
            this.rebuild();
            if (this.verifier.wasFullBuild()) {
                this.verifier.emptyBuild();
            }
            BuildDeltaVerificationTest.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddAndRemoveFolder() {
        try {
            this.folder2.create(true, true, this.getMonitor());
            this.folder2.delete(true, this.getMonitor());
            this.rebuild();
            if (this.verifier.wasFullBuild()) {
                this.verifier.emptyBuild();
            }
            BuildDeltaVerificationTest.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.file2, (IResource)this.project1, 1, 0);
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
            this.file2.create((InputStream)in, true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddFileAndFolder() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, (IResource)this.project1, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file3, (IResource)this.project1, 1, 0);
            this.folder2.create(true, true, this.getMonitor());
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
            this.file3.create((InputStream)in, true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddFolder() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, (IResource)this.project1, 1, 0);
            this.folder2.create(true, true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testAddProject() {
        try {
            this.project2.create(this.getMonitor());
            this.rebuild();
            BuildDeltaVerificationTest.assertTrue((String)this.verifier.getMessage(), (boolean)this.verifier.isDeltaValid());
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testChangeFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 256);
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
            this.file1.setContents((InputStream)in, true, false, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testChangeFileToFolder() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 295168);
            this.file1.delete(true, this.getMonitor());
            this.folder3.create(true, true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testChangeFolderToFile() {
        try {
            this.file1.delete(true, this.getMonitor());
            this.folder3.create(true, true, this.getMonitor());
            this.rebuild();
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 295168);
            this.folder3.delete(true, this.getMonitor());
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{1, 2});
            this.file1.create((InputStream)in, true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testCloseOpenReplaceFile() {
        try {
            this.rebuild();
            this.project1.close(null);
            this.project1.open(null);
            this.verifier = DeltaVerifierBuilder.getInstance();
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 262400);
            this.file1.delete(true, null);
            this.file1.create(this.getRandomContents(), true, null);
            this.rebuild();
            this.verifier = DeltaVerifierBuilder.getInstance();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testMoveFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder2, (IResource)this.project1, 1, 0);
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 2, 8192, null, this.file3.getFullPath());
            this.verifier.addExpectedChange((IResource)this.file3, (IResource)this.project1, 1, 4096, this.file1.getFullPath(), null);
            this.folder2.create(true, true, this.getMonitor());
            this.file1.move(this.file3.getFullPath(), true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testRemoveFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 2, 0);
            this.file1.delete(true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testRemoveFileAndFolder() {
        try {
            this.verifier.addExpectedChange((IResource)this.folder1, (IResource)this.project1, 2, 0);
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 2, 0);
            this.folder1.delete(true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testReplaceFile() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 262400);
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
            this.file1.delete(true, this.getMonitor());
            this.file1.create((InputStream)in, true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }

    public void testTwoFileChanges() {
        try {
            this.verifier.addExpectedChange((IResource)this.file1, (IResource)this.project1, 4, 256);
            this.verifier.addExpectedChange((IResource)this.file2, (IResource)this.project1, 1, 0);
            ByteArrayInputStream in = new ByteArrayInputStream(new byte[]{4, 5, 6});
            this.file1.setContents((InputStream)in, true, false, this.getMonitor());
            ByteArrayInputStream in2 = new ByteArrayInputStream(new byte[]{4, 5, 6});
            this.file2.create((InputStream)in2, true, this.getMonitor());
            this.rebuild();
            this.assertDelta();
        }
        catch (CoreException e) {
            this.handleCoreException(e);
        }
    }
}

