/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.SnowBuilder;

public class BuilderNatureTest
extends AbstractBuilderTest {
    public BuilderNatureTest() {
        super(null);
    }

    public BuilderNatureTest(String testName) {
        super(testName);
    }

    protected InputStream projectFileWithoutSnow() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>P1</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.core.tests.resources.snowbuilder</name>\n\t\t\t<arguments>\n\t\t\t\t<dictionary>\n\t\t\t\t\t<key>BuildID</key>\n\t\t\t\t\t<value>SnowBuild</value>\n\t\t\t\t</dictionary>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.core.tests.resources.waterNature</nature>\n\t</natures>\n</projectDescription>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    protected InputStream projectFileWithoutWater() {
        String contents = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<projectDescription>\n\t<name>P1</name>\n\t<comment></comment>\n\t<projects>\n\t</projects>\n\t<buildSpec>\n\t\t<buildCommand>\n\t\t\t<name>org.eclipse.core.tests.resources.snowbuilder</name>\n\t\t\t<arguments>\n\t\t\t\t<dictionary>\n\t\t\t\t\t<key>BuildID</key>\n\t\t\t\t\t<value>SnowBuild</value>\n\t\t\t\t</dictionary>\n\t\t\t</arguments>\n\t\t</buildCommand>\n\t</buildSpec>\n\t<natures>\n\t\t<nature>org.eclipse.core.tests.resources.snowNature</nature>\n\t</natures>\n</projectDescription>";
        return new ByteArrayInputStream(contents.getBytes());
    }

    public static Test suite() {
        return new TestSuite(BuilderNatureTest.class);
    }

    public void testBasic() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        this.ensureExistsInWorkspace((IResource)project, true);
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.reset();
        try {
            this.setAutoBuilding(true);
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
            project.setDescription(desc, 1, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"0.99", (Throwable)e);
        }
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.addExpectedLifecycleEvent("SnowBuild");
        builder.assertLifecycleEvents("1.0");
    }

    public void testDisabledNature() {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            this.setAutoBuilding(true);
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
            project.setDescription(desc, 1, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"0.99", (Throwable)e);
        }
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.reset();
        IFile descFile = project.getFile(".project");
        try {
            descFile.setContents(this.projectFileWithoutWater(), 1, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"1.99", (Throwable)e);
        }
        builder.assertLifecycleEvents("1.0");
        builder.reset();
        builder.addExpectedLifecycleEvent("SnowBuild");
        try {
            IProjectDescription desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
            project.setDescription(desc, 1, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"2.99", (Throwable)e);
        }
        builder.assertLifecycleEvents("2.0");
        BuilderNatureTest.assertTrue((String)"2.1", (boolean)builder.wasDeltaNull());
    }

    public void testMissingNature() {
        int n;
        IProjectDescription desc;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject("P1");
        this.ensureExistsInWorkspace((IResource)project, true);
        try {
            this.setAutoBuilding(true);
            IProjectDescription desc2 = project.getDescription();
            desc2.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
            project.setDescription(desc2, 1, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"0.99", (Throwable)e);
        }
        SnowBuilder builder = SnowBuilder.getInstance();
        builder.reset();
        try {
            desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature"});
            project.setDescription(desc, 0, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"1.99", (Throwable)e);
        }
        builder.assertLifecycleEvents("2.0");
        try {
            ICommand[] commands;
            ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
            n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                ICommand command = iCommandArray[n2];
                if (command.getBuilderName().equals("org.eclipse.core.tests.resources.snowbuilder")) {
                    BuilderNatureTest.assertTrue((String)"2.1", (boolean)false);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"2.99", (Throwable)e);
        }
        builder.reset();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.addExpectedLifecycleEvent("SnowBuild");
        try {
            desc = project.getDescription();
            desc.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
            project.setDescription(desc, 2, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"3.99", (Throwable)e);
        }
        builder.assertLifecycleEvents("3.0");
        builder.reset();
        IFile descFile = project.getFile(".project");
        try {
            descFile.setContents(this.projectFileWithoutSnow(), 1, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"4.99", (Throwable)e);
        }
        builder.assertLifecycleEvents("4.0");
        try {
            ICommand[] commands;
            ICommand[] iCommandArray = commands = project.getDescription().getBuildSpec();
            int n3 = commands.length;
            n = 0;
            while (n < n3) {
                ICommand command = iCommandArray[n];
                if (command.getBuilderName().equals("org.eclipse.core.tests.resources.snowbuilder")) {
                    BuilderNatureTest.assertTrue((String)"4.1", (boolean)false);
                }
                ++n;
            }
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"5.99", (Throwable)e);
        }
        builder.reset();
        builder.addExpectedLifecycleEvent("SetInitializationData");
        builder.addExpectedLifecycleEvent("StartupOnInitialize");
        builder.addExpectedLifecycleEvent("SnowBuild");
        try {
            IProjectDescription desc3 = project.getDescription();
            desc3.setNatureIds(new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"});
            project.setDescription(desc3, 1, this.getMonitor());
            this.waitForBuild();
        }
        catch (CoreException e) {
            BuilderNatureTest.fail((String)"6.99", (Throwable)e);
        }
        builder.assertLifecycleEvents("5.0");
        BuilderNatureTest.assertTrue((String)"5.1", (boolean)builder.wasDeltaNull());
    }
}

