/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.internal.builders.AbstractBuilderTest;
import org.eclipse.core.tests.internal.builders.CustomTriggerBuilder;
import org.eclipse.core.tests.internal.builders.SortBuilder;

public class CustomBuildTriggerTest
extends AbstractBuilderTest {
    public static Test suite() {
        return new TestSuite(CustomBuildTriggerTest.class);
    }

    public CustomBuildTriggerTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        SortBuilder.resetSingleton();
        CustomTriggerBuilder.resetSingleton();
    }

    public void testBuildAfterClean_builderRespondingToFull() throws CoreException {
        IWorkspace workspace = CustomBuildTriggerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ICommand command = null;
        this.setAutoBuilding(false);
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        IProjectDescription desc = project.getDescription();
        command = this.createCommand(desc, "org.eclipse.core.tests.resources.flexbuilder", "Build0");
        command.setBuilding(9, false);
        command.setBuilding(6, true);
        command.setBuilding(10, false);
        command.setBuilding(15, false);
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, this.getMonitor());
        command = project.getDescription().getBuildSpec()[0];
        this.setAutoBuilding(true);
        workspace.build(15, this.getMonitor());
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertNotNull((String)"1.0", (Object)((Object)builder));
        CustomBuildTriggerTest.assertTrue((String)"1.1", (builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        this.waitForBuild();
        builder.reset();
        workspace.build(15, this.getMonitor());
        CustomBuildTriggerTest.assertEquals((String)"2.0", (int)0, (int)builder.triggerForLastBuild);
        this.waitForBuild();
        CustomBuildTriggerTest.assertEquals((String)"2.1", (int)0, (int)builder.triggerForLastBuild);
        builder.reset();
        workspace.build(10, this.getMonitor());
        CustomBuildTriggerTest.assertTrue((String)"3.0", (boolean)builder.wasFullBuild());
        builder.reset();
        builder.clearBuildTrigger();
        workspace.build(10, this.getMonitor());
        CustomBuildTriggerTest.assertTrue((String)"3.1", (builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
    }

    public void testBuildAfterClean_builderRespondingToIncremental() throws CoreException {
        IWorkspace workspace = CustomBuildTriggerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ICommand command = null;
        this.setAutoBuilding(false);
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        IProjectDescription desc = project.getDescription();
        command = this.createCommand(desc, "org.eclipse.core.tests.resources.flexbuilder", "Build0");
        command.setBuilding(9, false);
        command.setBuilding(6, false);
        command.setBuilding(10, true);
        command.setBuilding(15, false);
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, this.getMonitor());
        command = project.getDescription().getBuildSpec()[0];
        this.setAutoBuilding(true);
        workspace.build(15, this.getMonitor());
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertNotNull((String)"1.0", (Object)((Object)builder));
        CustomBuildTriggerTest.assertEquals((String)"1.1", (int)0, (int)builder.triggerForLastBuild);
        this.waitForBuild();
        builder.reset();
        workspace.build(15, this.getMonitor());
        CustomBuildTriggerTest.assertEquals((String)"2.0", (int)0, (int)builder.triggerForLastBuild);
        this.waitForBuild();
        CustomBuildTriggerTest.assertEquals((String)"2.1", (int)0, (int)builder.triggerForLastBuild);
        builder.reset();
        workspace.build(10, this.getMonitor());
        CustomBuildTriggerTest.assertTrue((String)"3.0", (boolean)builder.wasFullBuild());
        IFile file = project.getFile("a.txt");
        try {
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"4.0", (Throwable)e);
        }
        builder.reset();
        builder.clearBuildTrigger();
        workspace.build(10, this.getMonitor());
        CustomBuildTriggerTest.assertEquals((String)"5.0", (int)10, (int)builder.triggerForLastBuild);
    }

    public void testBuildAfterClean_builderRespondingToAuto() throws CoreException {
        IWorkspace workspace = CustomBuildTriggerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ICommand command = null;
        this.setAutoBuilding(false);
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        IProjectDescription desc = project.getDescription();
        command = this.createCommand(desc, "org.eclipse.core.tests.resources.flexbuilder", "Build0");
        command.setBuilding(9, true);
        command.setBuilding(6, false);
        command.setBuilding(10, false);
        command.setBuilding(15, false);
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, this.getMonitor());
        command = project.getDescription().getBuildSpec()[0];
        this.setAutoBuilding(true);
        workspace.build(15, this.getMonitor());
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertNotNull((String)"1.0", (Object)((Object)builder));
        CustomBuildTriggerTest.assertTrue((String)"1.1", (builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        this.waitForBuild();
        builder.reset();
        workspace.build(15, this.getMonitor());
        this.waitForBuild();
        CustomBuildTriggerTest.assertTrue((String)"2.1", (boolean)builder.wasFullBuild());
        builder.clearBuildTrigger();
        builder.reset();
        IFile file = project.getFile("b.txt");
        try {
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"3.00", (Throwable)e);
        }
        this.waitForBuild();
        CustomBuildTriggerTest.assertTrue((String)"6.0", (!builder.wasCleanBuild() ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"6.1", (boolean)builder.wasAutobuild());
    }

    public void testConfigurable() {
        IProjectDescription desc;
        IWorkspace workspace = CustomBuildTriggerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ICommand command = null;
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            desc = project.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "org.eclipse.core.tests.resources.flexbuilder", "Build0")});
            project.setDescription(desc, this.getMonitor());
            command = project.getDescription().getBuildSpec()[0];
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"0.99", (Throwable)e);
        }
        CustomBuildTriggerTest.assertTrue((String)"1.0", (boolean)command.isConfigurable());
        CustomBuildTriggerTest.assertTrue((String)"1.1", (boolean)command.isBuilding(9));
        command.setBuilding(9, false);
        CustomBuildTriggerTest.assertTrue((String)"1.2", (!command.isBuilding(9) ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"1.3", (boolean)command.isBuilding(15));
        command.setBuilding(15, false);
        CustomBuildTriggerTest.assertTrue((String)"1.4", (!command.isBuilding(15) ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"1.5", (boolean)command.isBuilding(6));
        command.setBuilding(6, false);
        CustomBuildTriggerTest.assertTrue((String)"1.6", (!command.isBuilding(6) ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"1.7", (boolean)command.isBuilding(10));
        command.setBuilding(10, false);
        CustomBuildTriggerTest.assertTrue((String)"1.8", (!command.isBuilding(10) ? 1 : 0) != 0);
        try {
            desc = project.getDescription();
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e1) {
            CustomBuildTriggerTest.fail((String)"1.99", (Throwable)e1);
        }
        try {
            project.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"2.99", (Throwable)e);
        }
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertTrue((String)"2.0", (builder == null || builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        try {
            project.build(15, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"2.91", (Throwable)e);
        }
        builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertTrue((String)"2.1", (builder == null || builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        try {
            project.touch(this.getMonitor());
            project.build(10, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"3.99", (Throwable)e);
        }
        builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertTrue((String)"3.0", (builder == null || builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        try {
            this.setAutoBuilding(true);
            project.touch(this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"4.99", (Throwable)e);
        }
        builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertTrue((String)"4.0", (builder == null || builder.triggerForLastBuild == 0 ? 1 : 0) != 0);
        command.setBuilding(9, true);
        command.setBuilding(15, true);
        command.setBuilding(6, true);
        command.setBuilding(10, true);
        try {
            this.setAutoBuilding(false);
            IProjectDescription desc2 = project.getDescription();
            desc2.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc2, this.getMonitor());
        }
        catch (CoreException e1) {
            CustomBuildTriggerTest.fail((String)"5.99", (Throwable)e1);
        }
        try {
            project.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"6.99", (Throwable)e);
        }
        builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertTrue((String)"6.1", (boolean)builder.wasFullBuild());
        try {
            project.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"7.99", (Throwable)e);
        }
        builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertTrue((String)"7.1", (boolean)builder.wasFullBuild());
        try {
            project.build(15, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"8.99", (Throwable)e);
        }
        CustomBuildTriggerTest.assertTrue((String)"8.1", (boolean)builder.wasCleanBuild());
    }

    public void testNonConfigurable() {
        IProjectDescription desc;
        IWorkspace workspace = CustomBuildTriggerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ICommand command = null;
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            desc = project.getDescription();
            desc.setBuildSpec(new ICommand[]{this.createCommand(desc, "Build0")});
            project.setDescription(desc, this.getMonitor());
            command = project.getDescription().getBuildSpec()[0];
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"0.99", (Throwable)e);
        }
        CustomBuildTriggerTest.assertTrue((String)"1.0", (!command.isConfigurable() ? 1 : 0) != 0);
        command.setBuilding(9, false);
        CustomBuildTriggerTest.assertTrue((String)"1.1", (boolean)command.isBuilding(9));
        command.setBuilding(15, false);
        CustomBuildTriggerTest.assertTrue((String)"1.2", (boolean)command.isBuilding(15));
        command.setBuilding(6, false);
        CustomBuildTriggerTest.assertTrue((String)"1.3", (boolean)command.isBuilding(6));
        command.setBuilding(10, false);
        CustomBuildTriggerTest.assertTrue((String)"1.4", (boolean)command.isBuilding(10));
        try {
            desc = project.getDescription();
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
        }
        catch (CoreException e1) {
            CustomBuildTriggerTest.fail((String)"1.99", (Throwable)e1);
        }
        try {
            project.build(6, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"2.99", (Throwable)e);
        }
        SortBuilder builder = SortBuilder.getInstance();
        CustomBuildTriggerTest.assertTrue((String)"2.0", (boolean)builder.wasBuilt());
        CustomBuildTriggerTest.assertTrue((String)"2.1", (boolean)builder.wasFullBuild());
        CustomBuildTriggerTest.assertEquals((String)"2.2", (Object)command, (Object)builder.getCommand());
        try {
            project.touch(this.getMonitor());
            project.build(10, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"3.99", (Throwable)e);
        }
        CustomBuildTriggerTest.assertTrue((String)"3.0", (boolean)builder.wasBuilt());
        CustomBuildTriggerTest.assertTrue((String)"3.1", (boolean)builder.wasIncrementalBuild());
    }

    public void testSkipAutobuildDelta() {
        IWorkspace workspace = CustomBuildTriggerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ICommand command = null;
        CustomTriggerBuilder.resetSingleton();
        try {
            this.setAutoBuilding(false);
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            IProjectDescription desc = project.getDescription();
            command = this.createCommand(desc, "org.eclipse.core.tests.resources.flexbuilder", "Build0");
            command.setBuilding(9, false);
            desc.setBuildSpec(new ICommand[]{command});
            project.setDescription(desc, this.getMonitor());
            command = project.getDescription().getBuildSpec()[0];
            this.setAutoBuilding(true);
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"0.99", (Throwable)e);
        }
        CustomBuildTriggerTest.assertTrue((String)"1.0", (boolean)command.isConfigurable());
        CustomBuildTriggerTest.assertTrue((String)"1.1", (!command.isBuilding(9) ? 1 : 0) != 0);
        try {
            project.build(10, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"1.2", (Throwable)e);
        }
        this.waitForBuild();
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertNotNull((String)"1.3", (Object)((Object)builder));
        builder.clearBuildTrigger();
        IFile file = project.getFile("a.txt");
        try {
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"1.99", (Throwable)e);
        }
        this.waitForBuild();
        CustomBuildTriggerTest.assertTrue((String)"2.0", (!builder.wasIncrementalBuild() ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"2.1", (!builder.wasAutobuild() ? 1 : 0) != 0);
        try {
            project.build(10, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"2.99", (Throwable)e);
        }
        CustomBuildTriggerTest.assertTrue((String)"2.1", (!builder.wasAutobuild() ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"3.0", (boolean)builder.wasIncrementalBuild());
    }

    public void testCleanBuild_AfterCleanBuilder() throws CoreException {
        IWorkspace workspace = CustomBuildTriggerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ICommand command = null;
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        IProjectDescription desc = project.getDescription();
        command = this.createCommand(desc, "org.eclipse.core.tests.resources.flexbuilder", "Build0");
        command.setBuilding(9, false);
        command.setBuilding(6, true);
        command.setBuilding(10, false);
        command.setBuilding(15, false);
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, this.getMonitor());
        command = project.getDescription().getBuildSpec()[0];
        this.setAutoBuilding(false);
        try {
            project.build(10, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"1.0", (Throwable)e);
        }
        this.waitForBuild();
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertNotNull((String)"2.0", (Object)((Object)builder));
        CustomBuildTriggerTest.assertTrue((String)"2.1", (boolean)builder.wasFullBuild());
        builder.clearBuildTrigger();
        builder.reset();
        workspace.build(15, this.getMonitor());
        CustomBuildTriggerTest.assertTrue((String)"3.0", (!builder.wasCleanBuild() ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"3.1", (!builder.wasFullBuild() ? 1 : 0) != 0);
        builder.clearBuildTrigger();
        builder.reset();
        workspace.build(10, this.getMonitor());
        this.waitForBuild();
        CustomBuildTriggerTest.assertTrue((String)"4.0", (!builder.wasCleanBuild() ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"4.1", (boolean)builder.wasFullBuild());
        IFile file = project.getFile("a.txt");
        try {
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"5.00", (Throwable)e);
        }
        builder.clearBuildTrigger();
        builder.reset();
        workspace.build(10, this.getMonitor());
        this.waitForBuild();
        CustomBuildTriggerTest.assertTrue((String)"6.0", (!builder.wasCleanBuild() ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"6.1", (!builder.wasFullBuild() ? 1 : 0) != 0);
    }

    public void testCleanAutoBuild_AfterCleanBuilder() throws CoreException {
        IWorkspace workspace = CustomBuildTriggerTest.getWorkspace();
        IProject project = workspace.getRoot().getProject("PROJECT1");
        ICommand command = null;
        project.create(this.getMonitor());
        project.open(this.getMonitor());
        IProjectDescription desc = project.getDescription();
        command = this.createCommand(desc, "org.eclipse.core.tests.resources.flexbuilder", "Build0");
        command.setBuilding(9, false);
        command.setBuilding(6, true);
        command.setBuilding(10, false);
        command.setBuilding(15, false);
        desc.setBuildSpec(new ICommand[]{command});
        project.setDescription(desc, this.getMonitor());
        command = project.getDescription().getBuildSpec()[0];
        this.setAutoBuilding(true);
        this.waitForBuild();
        CustomTriggerBuilder builder = CustomTriggerBuilder.getInstance();
        CustomBuildTriggerTest.assertNotNull((String)"1.0", (Object)((Object)builder));
        CustomBuildTriggerTest.assertEquals((String)"1.1", (int)0, (int)builder.triggerForLastBuild);
        builder.clearBuildTrigger();
        builder.reset();
        workspace.build(15, this.getMonitor());
        CustomBuildTriggerTest.assertTrue((String)"2.0", (!builder.wasCleanBuild() ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"2.1", (!builder.wasFullBuild() ? 1 : 0) != 0);
        builder.clearBuildTrigger();
        builder.reset();
        IFile file = project.getFile("a.txt");
        try {
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"3.00", (Throwable)e);
        }
        this.waitForBuild();
        CustomBuildTriggerTest.assertEquals((String)"4.0", (int)0, (int)builder.triggerForLastBuild);
        project.build(10, this.getMonitor());
        this.waitForBuild();
        CustomBuildTriggerTest.assertTrue((String)"4.1", (boolean)builder.wasFullBuild());
        builder.clearBuildTrigger();
        builder.reset();
        file = project.getFile("b.txt");
        try {
            file.create(this.getRandomContents(), 0, this.getMonitor());
        }
        catch (CoreException e) {
            CustomBuildTriggerTest.fail((String)"5.00", (Throwable)e);
        }
        this.waitForBuild();
        CustomBuildTriggerTest.assertTrue((String)"6.0", (!builder.wasCleanBuild() ? 1 : 0) != 0);
        CustomBuildTriggerTest.assertTrue((String)"6.1", (!builder.wasFullBuild() ? 1 : 0) != 0);
    }
}

