/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.builders;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.tests.internal.builders.TestBuilder;
import org.junit.Assert;

public class CustomTriggerBuilder
extends TestBuilder {
    public static final String BUILDER_NAME = "org.eclipse.core.tests.resources.flexbuilder";
    private static CustomTriggerBuilder singleton;
    int triggerForLastBuild;

    public static CustomTriggerBuilder getInstance() {
        return singleton;
    }

    public static void resetSingleton() {
        singleton = null;
    }

    public CustomTriggerBuilder() {
        singleton = this;
    }

    @Override
    protected IProject[] build(int kind, Map<String, String> args, IProgressMonitor monitor) throws CoreException {
        this.triggerForLastBuild = kind;
        return super.build(kind, args, monitor);
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        this.triggerForLastBuild = 15;
        IResourceDelta delta = this.getDelta(this.getProject());
        Assert.assertNull((Object)delta);
    }

    public void clearBuildTrigger() {
        this.triggerForLastBuild = 0;
    }

    public boolean wasAutobuild() {
        return this.triggerForLastBuild == 9;
    }

    public boolean wasCleanBuild() {
        return this.triggerForLastBuild == 15;
    }

    public boolean wasFullBuild() {
        return this.triggerForLastBuild == 6;
    }

    public boolean wasIncrementalBuild() {
        return this.triggerForLastBuild == 10;
    }
}

