/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.dtree;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.dtree.AbstractDataTree;
import org.eclipse.core.internal.dtree.DataTree;
import org.eclipse.core.internal.dtree.ObjectNotFoundException;
import org.eclipse.core.internal.dtree.TestHelper;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.dtree.DeltaDataTreeTest;

public class DataTreeTest
extends TestCase {
    DataTree tree;
    DataTree emptyTree;
    IPath rootKey;
    IPath leftKey;
    IPath rightKey;

    public DataTreeTest() {
        super(null);
    }

    public DataTreeTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.emptyTree = new DataTree();
        this.tree = new DataTree();
        this.rootKey = Path.ROOT;
        try {
            this.tree.createChild(this.rootKey, "leftOfRoot");
            this.tree.createChild(this.rootKey, "rightOfRoot");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error("Error in setUp");
        }
        this.leftKey = this.rootKey.append("leftOfRoot");
        this.rightKey = this.rootKey.append("rightOfRoot");
        try {
            this.tree.createChild(this.leftKey, "one");
            this.tree.createChild(this.leftKey, "two");
            this.tree.createChild(this.leftKey, "three");
            this.tree.createChild(this.rightKey, "rightOfRight");
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error("Error in setUp");
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(DataTreeTest.class);
        suite.addTest(DeltaDataTreeTest.suite());
        return suite;
    }

    protected void tearDown() throws Exception {
    }

    public void testCreateChild() {
        block19: {
            boolean caught;
            block17: {
                caught = false;
                try {
                    try {
                        this.tree.createChild(this.rootKey.append("bogus"), "foobar");
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        caught = true;
                        DataTreeTest.assertTrue((String)"1", (boolean)caught);
                        break block17;
                    }
                }
                catch (Throwable throwable) {
                    DataTreeTest.assertTrue((String)"1", (boolean)caught);
                    throw throwable;
                }
                DataTreeTest.assertTrue((String)"1", (boolean)caught);
            }
            caught = false;
            try {
                try {
                    this.emptyTree.createChild(this.rootKey.append("bogus"), "foobar");
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DataTreeTest.assertTrue((String)"2", (boolean)caught);
                    break block19;
                }
            }
            catch (Throwable throwable) {
                DataTreeTest.assertTrue((String)"2", (boolean)caught);
                throw throwable;
            }
            DataTreeTest.assertTrue((String)"2", (boolean)caught);
        }
        try {
            this.emptyTree.createChild(this.rootKey, "first");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DataTreeTest.assertTrue((String)"3", (boolean)this.emptyTree.includes(this.rootKey.append("first")));
        try {
            this.tree.createChild(this.rootKey, "NewTopLevel");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DataTreeTest.assertTrue((String)"4", (boolean)this.tree.includes(this.rootKey.append("NewTopLevel")));
        DataTreeTest.assertTrue((String)"5", (boolean)this.tree.includes(this.leftKey));
        DataTreeTest.assertTrue((String)"6", (boolean)this.tree.includes(this.rightKey));
        DataTreeTest.assertTrue((String)"7", (boolean)this.tree.includes(this.leftKey.append("one")));
        try {
            this.tree.createChild(this.leftKey.append("one"), "NewBottom");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DataTreeTest.assertTrue((String)"8", (boolean)this.tree.includes(this.leftKey));
        DataTreeTest.assertTrue((String)"9", (boolean)this.tree.includes(this.rightKey));
        DataTreeTest.assertTrue((String)"10", (boolean)this.tree.includes(this.leftKey.append("one")));
        DataTreeTest.assertTrue((String)"11", (boolean)this.tree.includes(this.leftKey.append("one").append("NewBottom")));
        try {
            this.tree.createChild(this.rightKey, "NewRight");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DataTreeTest.assertTrue((String)"12", (boolean)this.tree.includes(this.leftKey));
        DataTreeTest.assertTrue((String)"13", (boolean)this.tree.includes(this.rightKey));
        DataTreeTest.assertTrue((String)"14", (boolean)this.tree.includes(this.rightKey.append("rightOfRight")));
        DataTreeTest.assertTrue((String)"15", (boolean)this.tree.includes(this.rightKey.append("NewRight")));
        int size = this.tree.getNamesOfChildren(this.leftKey).length;
        this.tree.createChild(this.leftKey, "double");
        this.tree.createChild(this.leftKey, "double");
        DataTreeTest.assertTrue((this.tree.getNamesOfChildren(this.leftKey).length == size + 1 ? 1 : 0) != 0);
    }

    public void testDeleteChild() {
        block27: {
            boolean caught;
            block25: {
                block23: {
                    block21: {
                        caught = false;
                        try {
                            try {
                                this.emptyTree.deleteChild(this.rootKey, "non-existant");
                            }
                            catch (ObjectNotFoundException objectNotFoundException) {
                                caught = true;
                                DataTreeTest.assertTrue((String)"1", (boolean)caught);
                                break block21;
                            }
                        }
                        catch (Throwable throwable) {
                            DataTreeTest.assertTrue((String)"1", (boolean)caught);
                            throw throwable;
                        }
                        DataTreeTest.assertTrue((String)"1", (boolean)caught);
                    }
                    caught = false;
                    try {
                        try {
                            this.tree.deleteChild(this.rootKey, "rightOfRight");
                        }
                        catch (ObjectNotFoundException objectNotFoundException) {
                            caught = true;
                            DataTreeTest.assertTrue((String)"2", (boolean)caught);
                            break block23;
                        }
                    }
                    catch (Throwable throwable) {
                        DataTreeTest.assertTrue((String)"2", (boolean)caught);
                        throw throwable;
                    }
                    DataTreeTest.assertTrue((String)"2", (boolean)caught);
                }
                DataTreeTest.assertTrue((String)"3", (boolean)this.tree.includes(this.rightKey.append("rightOfRight")));
                caught = false;
                try {
                    try {
                        this.tree.deleteChild(this.rootKey.append("bogus"), "rightOfRight");
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        caught = true;
                        DataTreeTest.assertTrue((String)"4", (boolean)caught);
                        break block25;
                    }
                }
                catch (Throwable throwable) {
                    DataTreeTest.assertTrue((String)"4", (boolean)caught);
                    throw throwable;
                }
                DataTreeTest.assertTrue((String)"4", (boolean)caught);
            }
            DataTreeTest.assertTrue((String)"5", (boolean)this.tree.includes(this.rightKey.append("rightOfRight")));
            caught = false;
            try {
                try {
                    this.tree.deleteChild(this.leftKey, "four");
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DataTreeTest.assertTrue((String)"6", (boolean)caught);
                    break block27;
                }
            }
            catch (Throwable throwable) {
                DataTreeTest.assertTrue((String)"6", (boolean)caught);
                throw throwable;
            }
            DataTreeTest.assertTrue((String)"6", (boolean)caught);
        }
        DataTreeTest.assertTrue((String)"7", (boolean)this.tree.includes(this.leftKey));
        try {
            this.tree.deleteChild(this.rootKey, "leftOfRoot");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DataTreeTest.assertTrue((String)"8", (!this.tree.includes(this.leftKey) ? 1 : 0) != 0);
        DataTreeTest.assertTrue((String)"9", (!this.tree.includes(this.leftKey.append("one")) ? 1 : 0) != 0);
        DataTreeTest.assertTrue((String)"10", (boolean)this.tree.includes(this.rootKey));
        try {
            this.tree.deleteChild(this.rightKey, "rightOfRight");
        }
        catch (ObjectNotFoundException objectNotFoundException) {}
        DataTreeTest.assertTrue((String)"11", (!this.tree.includes(this.rightKey.append("rightOfRight")) ? 1 : 0) != 0);
        DataTreeTest.assertTrue((String)"12", (boolean)this.tree.includes(this.rightKey));
    }

    public void testEmpty() {
        DataTreeTest.assertTrue((String)"1", (boolean)this.emptyTree.includes(this.rootKey));
        DataTreeTest.assertTrue((String)"2", (TestHelper.getRootNode((AbstractDataTree)this.emptyTree) != null ? 1 : 0) != 0);
        DataTreeTest.assertTrue((String)"3", (TestHelper.getRootNode((AbstractDataTree)this.emptyTree).getChildren().length == 0 ? 1 : 0) != 0);
    }

    public void testGetChild() {
        boolean caught = false;
        try {
            DataTreeTest.assertTrue((boolean)this.tree.getChild(this.rootKey, 0).equals((Object)this.leftKey));
            DataTreeTest.assertTrue((boolean)this.tree.getChild(this.leftKey, 2).equals((Object)this.leftKey.append("two")));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DataTreeTest.assertTrue((!caught ? 1 : 0) != 0);
        caught = false;
        try {
            this.tree.getChild(this.rootKey, 99);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            caught = true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error();
        }
        DataTreeTest.assertTrue((boolean)caught);
        caught = false;
        try {
            this.tree.getChild(this.leftKey, 99);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            caught = true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error();
        }
        DataTreeTest.assertTrue((boolean)caught);
        caught = false;
        try {
            this.tree.getChild(this.leftKey.append("one"), 99);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            caught = true;
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new Error();
        }
        DataTreeTest.assertTrue((boolean)caught);
        caught = false;
        try {
            this.tree.getChild(this.rootKey.append("bogus"), 0);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DataTreeTest.assertTrue((boolean)caught);
    }

    public void testGetChildCount() {
        boolean caught;
        block9: {
            caught = false;
            try {
                try {
                    DataTreeTest.assertTrue((String)"1", (this.emptyTree.getChildCount(this.rootKey) == 0 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"2", (this.tree.getChildCount(this.rootKey) == 2 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"3", (this.tree.getChildCount(this.leftKey) == 3 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"4", (this.tree.getChildCount(this.rightKey) == 1 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"5", (this.tree.getChildCount(this.leftKey.append("one")) == 0 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"6", (this.tree.getChildCount(this.leftKey.append("three")) == 0 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"7", (this.tree.getChildCount(this.rightKey.append("rightOfRight")) == 0 ? 1 : 0) != 0);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DataTreeTest.assertTrue((!caught ? 1 : 0) != 0);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DataTreeTest.assertTrue((!caught ? 1 : 0) != 0);
                throw throwable;
            }
            DataTreeTest.assertTrue((!caught ? 1 : 0) != 0);
        }
        caught = false;
        try {
            this.tree.getChildCount(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DataTreeTest.assertTrue((boolean)caught);
        caught = false;
        try {
            this.emptyTree.getChildCount(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DataTreeTest.assertTrue((boolean)caught);
    }

    public void testGetChildren() {
        boolean caught;
        block9: {
            IPath[] rootChildren = new IPath[]{this.leftKey, this.rightKey};
            IPath[] leftChildren = new IPath[]{this.leftKey.append("one"), this.leftKey.append("two"), this.leftKey.append("three")};
            IPath[] rightChildren = new IPath[]{this.rightKey.append("rightOfRight")};
            caught = false;
            try {
                try {
                    IPath[] testChildren = this.emptyTree.getChildren(this.rootKey);
                    DataTreeTest.assertTrue((String)"1", (testChildren.length == 0 ? 1 : 0) != 0);
                    testChildren = this.tree.getChildren(this.rootKey);
                    DataTreeTest.assertTrue((String)"2", (testChildren.length == 2 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"3", (boolean)testChildren[0].equals((Object)rootChildren[0]));
                    DataTreeTest.assertTrue((String)"4", (boolean)testChildren[1].equals((Object)rootChildren[1]));
                    testChildren = this.tree.getChildren(this.leftKey);
                    DataTreeTest.assertTrue((String)"5", (testChildren.length == 3 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"6", (boolean)testChildren[0].equals((Object)leftChildren[0]));
                    DataTreeTest.assertTrue((String)"7", (boolean)testChildren[2].equals((Object)leftChildren[1]));
                    DataTreeTest.assertTrue((String)"8", (boolean)testChildren[1].equals((Object)leftChildren[2]));
                    testChildren = this.tree.getChildren(leftChildren[0]);
                    DataTreeTest.assertTrue((String)"9", (testChildren.length == 0 ? 1 : 0) != 0);
                    testChildren = this.tree.getChildren(rightChildren[0]);
                    DataTreeTest.assertTrue((String)"10", (testChildren.length == 0 ? 1 : 0) != 0);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
                throw throwable;
            }
            DataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
        }
        caught = false;
        try {
            this.tree.getChildren(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DataTreeTest.assertTrue((String)"12", (boolean)caught);
        caught = false;
        try {
            this.emptyTree.getChildren(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DataTreeTest.assertTrue((String)"13", (boolean)caught);
    }

    public void testGetNameOfChild() {
    }

    public void testGetNamesOfChildren() {
        boolean caught;
        block9: {
            String[] rootChildren = new String[]{"leftOfRoot", "rightOfRoot"};
            String[] leftChildren = new String[]{"one", "two", "three"};
            caught = false;
            try {
                try {
                    String[] testChildren = this.emptyTree.getNamesOfChildren(this.rootKey);
                    DataTreeTest.assertTrue((String)"1", (testChildren.length == 0 ? 1 : 0) != 0);
                    testChildren = this.tree.getNamesOfChildren(this.rootKey);
                    DataTreeTest.assertTrue((String)"2", (testChildren.length == 2 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"3", (boolean)testChildren[0].equals(rootChildren[0]));
                    DataTreeTest.assertTrue((String)"4", (boolean)testChildren[1].equals(rootChildren[1]));
                    testChildren = this.tree.getNamesOfChildren(this.leftKey);
                    DataTreeTest.assertTrue((String)"5", (testChildren.length == 3 ? 1 : 0) != 0);
                    DataTreeTest.assertTrue((String)"6", (boolean)testChildren[0].equals(leftChildren[0]));
                    DataTreeTest.assertTrue((String)"7", (boolean)testChildren[2].equals(leftChildren[1]));
                    DataTreeTest.assertTrue((String)"8", (boolean)testChildren[1].equals(leftChildren[2]));
                    testChildren = this.tree.getNamesOfChildren(this.leftKey.append("one"));
                    DataTreeTest.assertTrue((String)"9", (testChildren.length == 0 ? 1 : 0) != 0);
                    testChildren = this.tree.getNamesOfChildren(this.rightKey.append("rightOfRight"));
                    DataTreeTest.assertTrue((String)"10", (testChildren.length == 0 ? 1 : 0) != 0);
                }
                catch (ObjectNotFoundException objectNotFoundException) {
                    caught = true;
                    DataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                DataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
                throw throwable;
            }
            DataTreeTest.assertTrue((String)"11", (!caught ? 1 : 0) != 0);
        }
        caught = false;
        try {
            this.tree.getNamesOfChildren(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DataTreeTest.assertTrue((String)"12", (boolean)caught);
        caught = false;
        try {
            this.emptyTree.getNamesOfChildren(this.rootKey.append("bogus"));
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            caught = true;
        }
        DataTreeTest.assertTrue((String)"13", (boolean)caught);
    }

    public void testIncludes() {
        DataTreeTest.assertTrue((boolean)this.emptyTree.includes(this.rootKey));
        DataTreeTest.assertTrue((boolean)this.tree.includes(this.rootKey));
        DataTreeTest.assertTrue((boolean)this.tree.includes(this.leftKey));
        DataTreeTest.assertTrue((boolean)this.tree.includes(this.rightKey));
        DataTreeTest.assertTrue((boolean)this.tree.includes(this.leftKey.append("one")));
        DataTreeTest.assertTrue((boolean)this.tree.includes(this.rightKey.append("rightOfRight")));
        DataTreeTest.assertTrue((!this.emptyTree.includes(this.rootKey.append("bogus")) ? 1 : 0) != 0);
        DataTreeTest.assertTrue((!this.tree.includes(this.rootKey.append("bogus")) ? 1 : 0) != 0);
        DataTreeTest.assertTrue((!this.tree.includes(this.leftKey.append("bogus")) ? 1 : 0) != 0);
        DataTreeTest.assertTrue((!this.tree.includes(this.leftKey.append("one").append("bogus")) ? 1 : 0) != 0);
        DataTreeTest.assertTrue((!this.tree.includes(this.rightKey.append("bogus")) ? 1 : 0) != 0);
    }
}

