/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.localstore.BlobStore;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class BlobStoreTest
extends LocalStoreTest {
    public BlobStoreTest() {
    }

    public BlobStoreTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(BlobStoreTest.class);
    }

    public void testConstructor() {
        IFileStore root = this.createStore();
        boolean ok = false;
        try {
            new BlobStore(null, 0);
        }
        catch (RuntimeException runtimeException) {
            ok = true;
        }
        BlobStoreTest.assertTrue((String)"1.1", (boolean)ok);
        ok = false;
        try {
            new BlobStore(EFS.getLocalFileSystem().getStore((IPath)new Path("../this/path/should/not/be/a/folder")), 128);
        }
        catch (RuntimeException runtimeException) {
            ok = true;
        }
        BlobStoreTest.assertTrue((String)"3.1", (boolean)ok);
        ok = false;
        try {
            new BlobStore(root, 0);
        }
        catch (RuntimeException runtimeException) {
            ok = true;
        }
        BlobStoreTest.assertTrue((String)"4.1", (boolean)ok);
        ok = false;
        try {
            new BlobStore(root, -1);
        }
        catch (RuntimeException runtimeException) {
            ok = true;
        }
        BlobStoreTest.assertTrue((String)"4.2", (boolean)ok);
        ok = false;
        try {
            new BlobStore(root, 35);
        }
        catch (RuntimeException runtimeException) {
            ok = true;
        }
        BlobStoreTest.assertTrue((String)"4.3", (boolean)ok);
        ok = false;
        try {
            new BlobStore(root, 512);
        }
        catch (RuntimeException runtimeException) {
            ok = true;
        }
        BlobStoreTest.assertTrue((String)"4.4", (boolean)ok);
    }

    private IFileStore createStore() {
        IFileStore root = this.getTempStore();
        try {
            root.mkdir(0, null);
        }
        catch (CoreException e1) {
            BlobStoreTest.fail((String)"createStore.99", (Throwable)e1);
        }
        IFileInfo info = root.fetchInfo();
        BlobStoreTest.assertTrue((String)"createStore.1", (boolean)info.exists());
        BlobStoreTest.assertTrue((String)"createStore.2", (boolean)info.isDirectory());
        return root;
    }

    public void testDeleteBlob() {
        UniversalUniqueIdentifier uuid;
        IFileStore root = this.createStore();
        BlobStore store = new BlobStore(root, 64);
        BlobStoreTest.assertTrue((String)"2.1", (!store.fileFor(uuid = new UniversalUniqueIdentifier()).fetchInfo().exists() ? 1 : 0) != 0);
        store.deleteBlob(uuid);
        BlobStoreTest.assertTrue((String)"2.2", (!store.fileFor(uuid).fetchInfo().exists() ? 1 : 0) != 0);
        IFileStore target = root.getChild("target");
        try {
            this.createFile(target, "bla bla bla");
            uuid = store.addBlob(target, true);
        }
        catch (CoreException e) {
            BlobStoreTest.fail((String)"4.1", (Throwable)e);
        }
        BlobStoreTest.assertTrue((String)"4.2", (boolean)store.fileFor(uuid).fetchInfo().exists());
        store.deleteBlob(uuid);
        BlobStoreTest.assertTrue((String)"4.3", (!store.fileFor(uuid).fetchInfo().exists() ? 1 : 0) != 0);
    }

    public void testGetBlob() {
        IFileStore root = this.createStore();
        BlobStore store = new BlobStore(root, 64);
        boolean ok = false;
        try {
            store.getBlob(null);
        }
        catch (RuntimeException runtimeException) {
            ok = true;
        }
        catch (CoreException e) {
            BlobStoreTest.fail((String)"2.0", (Throwable)e);
        }
        BlobStoreTest.assertTrue((String)"2.1", (boolean)ok);
        IFileStore target = root.getChild("target");
        UniversalUniqueIdentifier uuid = null;
        String content = "nothing important........tnatropmi gnihton";
        try {
            this.createFile(target, content);
            uuid = store.addBlob(target, true);
        }
        catch (CoreException e) {
            BlobStoreTest.fail((String)"3.1", (Throwable)e);
        }
        InputStream input = null;
        try {
            input = store.getBlob(uuid);
        }
        catch (CoreException e) {
            BlobStoreTest.fail((String)"3.4", (Throwable)e);
        }
        BlobStoreTest.assertTrue((String)"4.1", (boolean)this.compareContent(this.getContents(content), input));
    }

    public void testSetBlob() {
        IFileStore root = this.createStore();
        BlobStore store = new BlobStore(root, 64);
        IFileStore target = root.getChild("target");
        UniversalUniqueIdentifier uuid = null;
        String content = "nothing important........tnatropmi gnihton";
        try {
            this.createFile(target, content);
            uuid = store.addBlob(target, true);
        }
        catch (CoreException e) {
            BlobStoreTest.fail((String)"2.1", (Throwable)e);
        }
        InputStream input = null;
        try {
            input = store.getBlob(uuid);
        }
        catch (CoreException e) {
            BlobStoreTest.fail((String)"2.4", (Throwable)e);
        }
        BlobStoreTest.assertTrue((String)"2.5", (boolean)this.compareContent(this.getContents(content), input));
    }
}

