/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.internal.localstore.IHistoryStore;
import org.eclipse.core.internal.resources.FileState;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.UniversalUniqueIdentifier;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceTest;

public class HistoryStoreTest
extends ResourceTest {
    private IWorkspaceDescription original;

    public static void assertEquals(String tag, IFileState expected, IFileState actual) {
        HistoryStoreTest.assertEquals((String)(String.valueOf(tag) + " path differs"), (Object)expected.getFullPath(), (Object)actual.getFullPath());
        HistoryStoreTest.assertEquals((String)(String.valueOf(tag) + " timestamp differs"), (long)expected.getModificationTime(), (long)actual.getModificationTime());
        HistoryStoreTest.assertEquals((String)(String.valueOf(tag) + " uuid differs"), (Object)((FileState)expected).getUUID(), (Object)((FileState)actual).getUUID());
    }

    public static Test suite() {
        return new TestSuite(HistoryStoreTest.class);
    }

    public static void wipeHistoryStore(IProgressMonitor monitor) {
        IHistoryStore store = ((Workspace)HistoryStoreTest.getWorkspace()).getFileSystemManager().getHistoryStore();
        store.remove((IPath)Path.ROOT, monitor);
        store.removeGarbage();
    }

    public HistoryStoreTest() {
    }

    public HistoryStoreTest(String name) {
        super(name);
    }

    private int numBytes(InputStream input) {
        int i = 0;
        int c = -1;
        try {
            c = input.read();
            while (c != -1) {
                ++i;
                c = input.read();
            }
        }
        catch (IOException iOException) {
            i = 0;
        }
        if (c != -1) {
            i = 0;
        }
        return i;
    }

    public IWorkspaceDescription setMaxFileStates(int maxFileStates) throws CoreException {
        IWorkspaceDescription currentDescription = HistoryStoreTest.getWorkspace().getDescription();
        IWorkspaceDescription newDescription = HistoryStoreTest.getWorkspace().getDescription();
        newDescription.setMaxFileStates(maxFileStates);
        HistoryStoreTest.getWorkspace().setDescription(newDescription);
        return currentDescription;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.original = HistoryStoreTest.getWorkspace().getDescription();
    }

    @Override
    protected void tearDown() throws Exception {
        HistoryStoreTest.getWorkspace().setDescription(this.original);
        super.tearDown();
        HistoryStoreTest.wipeHistoryStore(this.getMonitor());
    }

    public void testAddStateAndPolicies() {
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("file.txt");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IWorkspaceDescription description = HistoryStoreTest.getWorkspace().getDescription();
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(5);
        description.setMaxFileStateSize(0x100000L);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.1", (Throwable)e);
        }
        int i = 0;
        while (i < 8) {
            try {
                this.ensureOutOfSync(file);
                file.refreshLocal(0, this.getMonitor());
                file.setContents(this.getRandomContents(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)"1.0", (Throwable)e);
            }
            ++i;
        }
        IFileState[] states = null;
        try {
            states = file.getHistory(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.01", (Throwable)e);
        }
        HistoryStoreTest.assertEquals((String)"1.02", (int)8, (int)states.length);
        IFileState[] oldStates = states;
        try {
            HistoryStoreTest.getWorkspace().save(true, null);
            states = file.getHistory(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.1", (Throwable)e);
        }
        HistoryStoreTest.assertEquals((String)"1.2", (int)description.getMaxFileStates(), (int)states.length);
        long lastModified = states[0].getModificationTime();
        int i2 = 1;
        while (i2 < states.length) {
            HistoryStoreTest.assertTrue((String)("1.3." + i2), (lastModified >= states[i2].getModificationTime() ? 1 : 0) != 0);
            lastModified = states[i2].getModificationTime();
            ++i2;
        }
        i2 = 0;
        while (i2 < states.length) {
            HistoryStoreTest.assertEquals("1.4." + i2, oldStates[i2], states[i2]);
            ++i2;
        }
        description.setMaxFileStates(15);
        description.setMaxFileStateSize(7L);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.0.0", (Throwable)e);
        }
        file = project.getFile("file1.txt");
        try {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.0", (Throwable)e);
        }
        i = 0;
        while (i < 10) {
            try {
                file.appendContents(this.getContents("a"), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)"2.1", (Throwable)e);
            }
            ++i;
        }
        try {
            HistoryStoreTest.getWorkspace().save(true, null);
            states = file.getHistory(this.getMonitor());
            i = 0;
            while (i < states.length) {
                int bytesRead = this.numBytes(states[i].getContents());
                HistoryStoreTest.assertTrue((String)("2.2." + i), ((long)bytesRead <= description.getMaxFileStateSize() ? 1 : 0) != 0);
                ++i;
            }
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.3", (Throwable)e);
        }
        file = project.getFile("file.txt");
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(5);
        description.setMaxFileStateSize(0x100000L);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.1", (int)description.getMaxFileStates(), (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.2", (Throwable)e);
        }
        description.setFileStateLongevity(10000L);
        description.setMaxFileStateSize(0x100000L);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.3", (Throwable)e);
        }
        try {
            Thread.sleep(12000L);
        }
        catch (InterruptedException e) {
            HistoryStoreTest.fail((String)"3.4", (Throwable)e);
        }
        try {
            HistoryStoreTest.getWorkspace().save(true, null);
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.5", (int)0, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.6", (Throwable)e);
        }
    }

    public void testBug28238() {
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("myproject");
        IFolder folder = project.getFolder("myfolder");
        IFolder destinationFolder = project.getFolder("myfolder2");
        IFile file = folder.getFile("myfile.txt");
        IFile destinationFile = destinationFolder.getFile(file.getName());
        IHistoryStore store = ((Resource)HistoryStoreTest.getWorkspace().getRoot()).getLocalManager().getHistoryStore();
        IFileStore fileStore = this.getTempStore();
        this.createFileInFileSystem(fileStore);
        FileInfo fileInfo = new FileInfo(file.getName());
        fileInfo.setLastModified(System.currentTimeMillis());
        store.addState(file.getFullPath(), fileStore, (IFileInfo)fileInfo, true);
        IFileState[] states = store.getStates(file.getFullPath(), this.getMonitor());
        HistoryStoreTest.assertEquals((String)"2.0", (int)1, (int)states.length);
        store.copyHistory((IResource)folder, (IResource)destinationFolder, true);
        states = store.getStates(destinationFile.getFullPath(), this.getMonitor());
        HistoryStoreTest.assertEquals((String)"3.0", (int)1, (int)states.length);
    }

    public void testBug28603() {
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("myproject");
        IFolder folder1 = project.getFolder("myfolder1");
        IFolder folder2 = project.getFolder("myfolder2");
        IFile file1 = folder1.getFile("myfile.txt");
        IFile file2 = folder2.getFile(file1.getName());
        this.ensureExistsInWorkspace(new IResource[]{project, folder1, folder2}, true);
        try {
            file1.create(this.getRandomContents(), 1, this.getMonitor());
            file1.setContents(this.getRandomContents(), 3, this.getMonitor());
            file1.setContents(this.getRandomContents(), 3, this.getMonitor());
            file1.setContents(this.getRandomContents(), 3, this.getMonitor());
            this.setMaxFileStates(50);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        int maxStates = ResourcesPlugin.getWorkspace().getDescription().getMaxFileStates();
        IFileState[] states = null;
        try {
            states = file1.getHistory(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.0", (Throwable)e);
        }
        HistoryStoreTest.assertEquals((String)"1.1", (int)3, (int)states.length);
        int currentStates = 3;
        int i = 0;
        while (i < maxStates + 10) {
            try {
                states = file1.getHistory(this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("2.0." + i), (Throwable)e);
            }
            HistoryStoreTest.assertEquals((String)("2.1." + i + " file1 states"), (int)currentStates, (int)states.length);
            try {
                file1.move(file2.getFullPath(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("2.2." + i), (Throwable)e);
            }
            try {
                states = file2.getHistory(this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("2.3." + i), (Throwable)e);
            }
            currentStates = currentStates < maxStates ? currentStates + 1 : maxStates;
            HistoryStoreTest.assertEquals((String)("2.4." + i + " file2 states"), (int)currentStates, (int)states.length);
            try {
                file2.move(file1.getFullPath(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("2.5." + i), (Throwable)e);
            }
            try {
                states = file1.getHistory(this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("2.6." + i), (Throwable)e);
            }
            currentStates = currentStates < maxStates ? currentStates + 1 : maxStates;
            HistoryStoreTest.assertEquals((String)("2.7." + i + " file1 states"), (int)currentStates, (int)states.length);
            ++i;
        }
    }

    public void testClean() {
        IFileState[] states;
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("file.txt");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IHistoryStore store = ((Workspace)HistoryStoreTest.getWorkspace()).getFileSystemManager().getHistoryStore();
        IWorkspaceDescription description = HistoryStoreTest.getWorkspace().getDescription();
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(500);
        description.setMaxFileStateSize(0x100000L);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.1", (Throwable)e);
        }
        int i = 0;
        while (i < 8) {
            try {
                this.ensureOutOfSync(file);
                file.refreshLocal(0, this.getMonitor());
                file.setContents(this.getRandomContents(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)"1.0", (Throwable)e);
            }
            ++i;
        }
        long[] oldLastModTimes = new long[8];
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.1", (int)8, (int)states.length);
            int i2 = 0;
            while (i2 < 8) {
                oldLastModTimes[i2] = states[i2].getModificationTime();
                ++i2;
            }
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.2", (Throwable)e);
        }
        description.setMaxFileStates(3);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.0", (Throwable)e);
        }
        store.clean(this.getMonitor());
        description.setMaxFileStates(500);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.2", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.3", (int)3, (int)states.length);
            long lastModified = states[0].getModificationTime();
            int i3 = 1;
            while (i3 < states.length) {
                HistoryStoreTest.assertTrue((String)("2.4." + i3), (lastModified >= states[i3].getModificationTime() ? 1 : 0) != 0);
                lastModified = states[i3].getModificationTime();
                ++i3;
            }
            i3 = 0;
            while (i3 < states.length) {
                HistoryStoreTest.assertTrue((String)("2.5." + i3), (oldLastModTimes[i3] == states[i3].getModificationTime() ? 1 : 0) != 0);
                ++i3;
            }
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.6", (Throwable)e);
        }
        file = project.getFile("file.txt");
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStates(500);
        description.setMaxFileStateSize(0x100000L);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.1", (int)3, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.2", (Throwable)e);
        }
        description.setFileStateLongevity(10000L);
        description.setMaxFileStateSize(0x100000L);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"4.0", (Throwable)e);
        }
        try {
            Thread.sleep(12000L);
        }
        catch (InterruptedException e) {
            HistoryStoreTest.fail((String)"4.1", (Throwable)e);
        }
        store.clean(this.getMonitor());
        description.setFileStateLongevity(86400000L);
        description.setMaxFileStateSize(0x100000L);
        try {
            HistoryStoreTest.getWorkspace().setDescription(description);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"5.1", (int)0, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"5.2", (Throwable)e);
        }
    }

    public void testCopyFolder() {
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("CopyFolderProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IFile file = project.getFile("file1.txt");
        IFolder folder = project.getFolder("folder1");
        IFolder folder2 = project.getFolder("folder2");
        file = folder.getFile("file1.txt");
        try {
            folder.create(true, true, this.getMonitor());
            file.create(this.getContents(contents[0]), true, this.getMonitor());
            file.setContents(this.getContents(contents[1]), true, true, this.getMonitor());
            file.setContents(this.getContents(contents[2]), true, true, this.getMonitor());
            IFileState[] states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"1.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"1.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            folder.copy(folder2.getFullPath(), true, this.getMonitor());
            IFile file2 = folder2.getFile("file1.txt");
            HistoryStoreTest.assertTrue((String)"1.3", (boolean)file2.getFullPath().toString().endsWith("folder2/file1.txt"));
            file2.setContents(this.getContents(contents[3]), true, true, this.getMonitor());
            file2.setContents(this.getContents(contents[4]), true, true, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"2.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"2.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            states = file2.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.3", (int)4, (int)states.length);
            HistoryStoreTest.assertTrue((String)"2.4", (boolean)this.compareContent(this.getContents(contents[3]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"2.5", (boolean)this.compareContent(this.getContents(contents[2]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"2.6", (boolean)this.compareContent(this.getContents(contents[1]), states[2].getContents()));
            HistoryStoreTest.assertTrue((String)"2.7", (boolean)this.compareContent(this.getContents(contents[0]), states[3].getContents()));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.8", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testCopyHistoryFile() {
        String[] contents = new String[]{"content0", "content1", "content2", "content3", "content4"};
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("TestCopyHistoryProject");
        this.ensureExistsInWorkspace((IResource)project, true);
        IFolder folder = project.getFolder("folder1");
        IFile file = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        try {
            folder.create(true, true, this.getMonitor());
            file.create(this.getContents(contents[0]), true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.0", (Throwable)e);
            }
            file.setContents(this.getContents(contents[1]), true, true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.1", (Throwable)e);
            }
            file.setContents(this.getContents(contents[2]), true, true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.2", (Throwable)e);
            }
            IFileState[] states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"1.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"1.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            file2.create(this.getContents(contents[3]), true, this.getMonitor());
            file2.setContents(this.getContents(contents[4]), true, true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.3", (Throwable)e);
        }
        LogListenerVerifier verifier = new LogListenerVerifier();
        ILog log = ResourcesPlugin.getPlugin().getLog();
        log.addLogListener((ILogListener)verifier);
        IHistoryStore store = ((Resource)file).getLocalManager().getHistoryStore();
        verifier.addExpected(566);
        store.copyHistory(null, null, false);
        try {
            verifier.verify();
        }
        catch (VerificationFailedException e) {
            HistoryStoreTest.fail((String)"1.4 ", (Throwable)e);
        }
        verifier.reset();
        verifier.addExpected(566);
        store.copyHistory(null, (IResource)file2, false);
        try {
            verifier.verify();
        }
        catch (VerificationFailedException e) {
            HistoryStoreTest.fail((String)"1.5 ", (Throwable)e);
        }
        verifier.reset();
        verifier.addExpected(566);
        store.copyHistory((IResource)file, null, false);
        try {
            verifier.verify();
        }
        catch (VerificationFailedException e) {
            HistoryStoreTest.fail((String)"1.6 ", (Throwable)e);
        }
        verifier.reset();
        verifier.addExpected(566);
        store.copyHistory((IResource)file, (IResource)file, false);
        try {
            verifier.verify();
        }
        catch (VerificationFailedException e) {
            HistoryStoreTest.fail((String)"1.7 ", (Throwable)e);
        }
        verifier.reset();
        log.removeLogListener((ILogListener)verifier);
        store.copyHistory((IResource)file, (IResource)file2, false);
        IFileState[] states = null;
        try {
            states = file2.getHistory(this.getMonitor());
        }
        catch (CoreException coreException) {
            HistoryStoreTest.fail((String)"2.3");
        }
        HistoryStoreTest.assertEquals((String)"2.4", (int)3, (int)states.length);
        try {
            HistoryStoreTest.assertTrue((String)"2.5", (boolean)this.compareContent(this.getContents(contents[3]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"2.6", (boolean)this.compareContent(this.getContents(contents[1]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"2.7", (boolean)this.compareContent(this.getContents(contents[0]), states[2].getContents()));
        }
        catch (CoreException coreException) {
            HistoryStoreTest.fail((String)"2.8");
        }
    }

    public void testCopyHistoryFolder() {
        String[] contents = new String[]{"content0", "content1", "content2", "content3", "content4"};
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("TestCopyHistoryProject");
        this.ensureExistsInWorkspace((IResource)project, true);
        IFolder folder = project.getFolder("folder1");
        IFolder folder2 = project.getFolder("folder2");
        IFile file = folder.getFile("file1.txt");
        IFile file2 = folder2.getFile("file1.txt");
        try {
            folder.create(true, true, this.getMonitor());
            file.create(this.getContents(contents[0]), true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.0", (Throwable)e);
            }
            file.setContents(this.getContents(contents[1]), true, true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.1", (Throwable)e);
            }
            file.setContents(this.getContents(contents[2]), true, true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.2", (Throwable)e);
            }
            IFileState[] states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"1.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"1.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            folder2.create(true, true, this.getMonitor());
            file2.create(this.getContents(contents[3]), true, this.getMonitor());
            file2.setContents(this.getContents(contents[4]), true, true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.9", (Throwable)e);
        }
        IHistoryStore store = ((Resource)file).getLocalManager().getHistoryStore();
        store.copyHistory((IResource)folder, (IResource)folder2, false);
        IFileState[] states = null;
        try {
            states = file2.getHistory(this.getMonitor());
        }
        catch (CoreException coreException) {
            HistoryStoreTest.fail((String)"2.3");
        }
        HistoryStoreTest.assertEquals((String)"2.4", (int)3, (int)states.length);
        try {
            HistoryStoreTest.assertTrue((String)"2.5", (boolean)this.compareContent(this.getContents(contents[3]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"2.6", (boolean)this.compareContent(this.getContents(contents[1]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"2.7", (boolean)this.compareContent(this.getContents(contents[0]), states[2].getContents()));
        }
        catch (CoreException coreException) {
            HistoryStoreTest.fail((String)"2.8");
        }
    }

    public void testCopyHistoryProject() {
        String[] contents = new String[]{"content0", "content1", "content2", "content3", "content4"};
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("TestCopyHistoryProject");
        IProject project2 = HistoryStoreTest.getWorkspace().getRoot().getProject("TestCopyHistoryProject2");
        this.ensureExistsInWorkspace(new IResource[]{project, project2}, true);
        IFolder folder = project.getFolder("folder1");
        IFolder folder2 = project2.getFolder("folder1");
        IFile file = folder.getFile("file1.txt");
        IFile file2 = folder2.getFile("file1.txt");
        try {
            folder.create(true, true, this.getMonitor());
            file.create(this.getContents(contents[0]), true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.0", (Throwable)e);
            }
            file.setContents(this.getContents(contents[1]), true, true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.1", (Throwable)e);
            }
            file.setContents(this.getContents(contents[2]), true, true, this.getMonitor());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                HistoryStoreTest.fail((String)"0.2", (Throwable)e);
            }
            IFileState[] states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"1.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"1.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            folder2.create(true, true, this.getMonitor());
            file2.create(this.getContents(contents[3]), true, this.getMonitor());
            file2.setContents(this.getContents(contents[4]), true, true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.9", (Throwable)e);
        }
        IHistoryStore store = ((Resource)file).getLocalManager().getHistoryStore();
        store.copyHistory((IResource)project, (IResource)project2, false);
        IFileState[] states = null;
        try {
            states = file2.getHistory(this.getMonitor());
        }
        catch (CoreException coreException) {
            HistoryStoreTest.fail((String)"2.3");
        }
        HistoryStoreTest.assertEquals((String)"2.4", (int)3, (int)states.length);
        try {
            HistoryStoreTest.assertTrue((String)"2.5", (boolean)this.compareContent(this.getContents(contents[3]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"2.6", (boolean)this.compareContent(this.getContents(contents[1]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"2.7", (boolean)this.compareContent(this.getContents(contents[0]), states[2].getContents()));
        }
        catch (CoreException coreException) {
            HistoryStoreTest.fail((String)"2.8");
        }
    }

    public void testDelete() {
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IFile file = project.getFile("file.txt");
        try {
            file.create(this.getRandomContents(), true, this.getMonitor());
            file.setContents(this.getRandomContents(), true, true, this.getMonitor());
            file.setContents(this.getRandomContents(), true, true, this.getMonitor());
            IFileState[] states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.0", (int)2, (int)states.length);
            file.delete(true, true, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.1", (int)3, (int)states.length);
            file.create(this.getRandomContents(), true, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.2", (int)3, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.20", (Throwable)e);
        }
        IFolder folder = project.getFolder("folder");
        file = folder.getFile("file2.txt");
        try {
            folder.create(true, true, this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
            file.setContents(this.getRandomContents(), true, true, this.getMonitor());
            file.setContents(this.getRandomContents(), true, true, this.getMonitor());
            IFileState[] states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.0", (int)2, (int)states.length);
            folder.delete(true, true, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.1", (int)3, (int)states.length);
            folder.create(true, true, this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.2", (int)3, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.99", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public void testExists() throws Throwable {
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("removeAllStatesFile.txt");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        int i = 0;
        while (i < 20) {
            try {
                file.setContents(this.getRandomContents(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("3.0." + i), (Throwable)e);
            }
            ++i;
        }
        IFileState[] states = null;
        try {
            states = file.getHistory(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"5.0", (Throwable)e);
        }
        HistoryStoreTest.assertEquals((String)"5.1", (int)20, (int)states.length);
        int i2 = 0;
        while (i2 < states.length) {
            HistoryStoreTest.assertTrue((String)("5.2." + i2), (boolean)states[i2].exists());
            ++i2;
        }
    }

    public void testFindDeleted() {
        IFile[] df;
        IFile[] df2;
        IFile[] df3;
        IWorkspaceRoot root = HistoryStoreTest.getWorkspace().getRoot();
        IProject project = root.getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            IFile[] df4 = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.1", (int)0, (int)df4.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IFile pfile = project.getFile("findDeletedFile.txt");
        try {
            pfile.create(this.getRandomContents(), true, this.getMonitor());
            pfile.delete(true, true, this.getMonitor());
            df3 = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.1", (int)1, (int)df3.length);
            HistoryStoreTest.assertEquals((String)"0.2", (Object)pfile, (Object)df3[0]);
            df3 = project.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.3", (int)1, (int)df3.length);
            HistoryStoreTest.assertEquals((String)"0.4", (Object)pfile, (Object)df3[0]);
            df3 = project.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.5", (int)0, (int)df3.length);
            df3 = root.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.5.1", (int)0, (int)df3.length);
            df3 = root.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.5.2", (int)1, (int)df3.length);
            HistoryStoreTest.assertEquals((String)"0.5.3", (Object)pfile, (Object)df3[0]);
            df3 = root.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.5.4", (int)0, (int)df3.length);
            pfile.create(this.getRandomContents(), true, this.getMonitor());
            df3 = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.6", (int)0, (int)df3.length);
            df3 = project.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.7", (int)0, (int)df3.length);
            df3 = project.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.8", (int)0, (int)df3.length);
            df3 = root.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.8.1", (int)0, (int)df3.length);
            df3 = root.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.8.2", (int)0, (int)df3.length);
            df3 = root.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.8.3", (int)0, (int)df3.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.00", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            df3 = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"0.9", (int)0, (int)df3.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.10", (Throwable)e);
        }
        IFolder folder = project.getFolder("folder");
        IFile file = folder.getFile("filex.txt");
        IFile folderAsFile = project.getFile(folder.getProjectRelativePath());
        try {
            folder.create(true, true, this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
            file.delete(true, true, this.getMonitor());
            df2 = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.1", (int)0, (int)df2.length);
            df2 = project.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.2", (int)1, (int)df2.length);
            HistoryStoreTest.assertEquals((String)"1.3", (Object)file, (Object)df2[0]);
            df2 = project.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.4", (int)0, (int)df2.length);
            file.create(this.getRandomContents(), true, this.getMonitor());
            df2 = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.5", (int)0, (int)df2.length);
            df2 = project.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.6", (int)0, (int)df2.length);
            df2 = project.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.7", (int)0, (int)df2.length);
            folder.delete(true, true, this.getMonitor());
            df2 = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.8", (int)0, (int)df2.length);
            df2 = project.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.9", (int)1, (int)df2.length);
            HistoryStoreTest.assertEquals((String)"1.10", (Object)file, (Object)df2[0]);
            df2 = project.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.11", (int)0, (int)df2.length);
            folderAsFile.create(this.getRandomContents(), true, this.getMonitor());
            folderAsFile.delete(true, true, this.getMonitor());
            folder.create(true, true, this.getMonitor());
            df2 = folder.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.12", (int)1, (int)df2.length);
            HistoryStoreTest.assertEquals((String)"1.13", (Object)folderAsFile, (Object)df2[0]);
            df2 = folder.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.14", (int)2, (int)df2.length);
            List<IFile> dfList = Arrays.asList(df2);
            HistoryStoreTest.assertTrue((String)"1.15", (boolean)dfList.contains(file));
            HistoryStoreTest.assertTrue((String)"1.16", (boolean)dfList.contains(folderAsFile));
            df2 = folder.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.17", (int)2, (int)df2.length);
            dfList = Arrays.asList(df2);
            HistoryStoreTest.assertTrue((String)"1.18", (boolean)dfList.contains(file));
            HistoryStoreTest.assertTrue((String)"1.19", (boolean)dfList.contains(folderAsFile));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.00", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            df2 = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.50", (int)0, (int)df2.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.51", (Throwable)e);
        }
        folder = project.getFolder("folder");
        IFile file1 = folder.getFile("file1.txt");
        IFile file2 = folder.getFile("file2.txt");
        IFolder folder2 = folder.getFolder("folder2");
        IFile file3 = folder2.getFile("file3.txt");
        try {
            folder.create(true, true, this.getMonitor());
            folder2.create(true, true, this.getMonitor());
            file1.create(this.getRandomContents(), true, this.getMonitor());
            file2.create(this.getRandomContents(), true, this.getMonitor());
            file3.create(this.getRandomContents(), true, this.getMonitor());
            folder.delete(true, true, this.getMonitor());
            df = root.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.1", (int)0, (int)df.length);
            df = root.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.2", (int)0, (int)df.length);
            df = root.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.3", (int)3, (int)df.length);
            List<IFile> dfList = Arrays.asList(df);
            HistoryStoreTest.assertTrue((String)"3.3.1", (boolean)dfList.contains(file1));
            HistoryStoreTest.assertTrue((String)"3.3.2", (boolean)dfList.contains(file2));
            HistoryStoreTest.assertTrue((String)"3.3.3", (boolean)dfList.contains(file3));
            df = project.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.4", (int)0, (int)df.length);
            df = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.5", (int)0, (int)df.length);
            df = project.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.6", (int)3, (int)df.length);
            dfList = Arrays.asList(df);
            HistoryStoreTest.assertTrue((String)"3.6.1", (boolean)dfList.contains(file1));
            HistoryStoreTest.assertTrue((String)"3.6.2", (boolean)dfList.contains(file2));
            HistoryStoreTest.assertTrue((String)"3.6.3", (boolean)dfList.contains(file3));
            df = folder.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.7", (int)0, (int)df.length);
            df = folder.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.8", (int)2, (int)df.length);
            df = folder.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.9", (int)3, (int)df.length);
            df = folder2.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.10", (int)0, (int)df.length);
            df = folder2.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.11", (int)1, (int)df.length);
            df = folder2.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.12", (int)1, (int)df.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.00", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.5", (Throwable)e);
        }
        try {
            df = root.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.1", (int)0, (int)df.length);
            df = root.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.2", (int)0, (int)df.length);
            df = root.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.3", (int)0, (int)df.length);
            df = project.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.4", (int)0, (int)df.length);
            df = project.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.5", (int)0, (int)df.length);
            df = project.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.6", (int)0, (int)df.length);
            df = folder.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.7", (int)0, (int)df.length);
            df = folder.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.8", (int)0, (int)df.length);
            df = folder.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.9", (int)0, (int)df.length);
            df = folder2.findDeletedMembersWithHistory(0, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.10", (int)0, (int)df.length);
            df = folder2.findDeletedMembersWithHistory(1, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.11", (int)0, (int)df.length);
            df = folder2.findDeletedMembersWithHistory(2, this.getMonitor());
            HistoryStoreTest.assertEquals((String)"4.12", (int)0, (int)df.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"4.00", (Throwable)e);
        }
    }

    public void testGetContents() throws Throwable {
        ByteArrayInputStream is;
        FileInfo fileInfo;
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("Project");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IFile file = project.getFile("getContentsFile.txt");
        String contents = "This file has some contents in testGetContents.";
        this.ensureExistsInWorkspace(file, contents);
        IFile secondValidFile = project.getFile("secondGetContentsFile.txt");
        contents = "A file with some other contents in testGetContents.";
        this.ensureExistsInWorkspace(secondValidFile, contents);
        IHistoryStore historyStore = ((Workspace)HistoryStoreTest.getWorkspace()).getFileSystemManager().getHistoryStore();
        long myLong = 0L;
        int i = 0;
        while (i < 20) {
            fileInfo = new FileInfo(file.getName());
            fileInfo.setLastModified(myLong);
            historyStore.addState(file.getFullPath(), ((Resource)file).getStore(), (IFileInfo)fileInfo, true);
            try {
                contents = "This file has some contents in testGetContents.";
                is = new ByteArrayInputStream(contents.getBytes());
                this.createFileInFileSystem(file.getLocation(), (InputStream)is);
                file.refreshLocal(2, null);
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("1.1." + i), (Throwable)e);
            }
            ++i;
            ++myLong;
        }
        i = 0;
        while (i < 20) {
            fileInfo = new FileInfo(file.getName());
            fileInfo.setLastModified(myLong);
            historyStore.addState(secondValidFile.getFullPath(), ((Resource)secondValidFile).getStore(), (IFileInfo)fileInfo, true);
            try {
                contents = "A file with some other contents in testGetContents.";
                is = new ByteArrayInputStream(contents.getBytes());
                this.createFileInFileSystem(secondValidFile.getLocation(), (InputStream)is);
                secondValidFile.refreshLocal(2, null);
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("2.1." + i), (Throwable)e);
            }
            ++i;
            ++myLong;
        }
        DataInputStream inFile = null;
        DataInputStream inContents = null;
        IFileState[] stateArray = null;
        stateArray = historyStore.getStates(file.getFullPath(), this.getMonitor());
        int i2 = 0;
        while (i2 < stateArray.length) {
            inFile = new DataInputStream(file.getContents(false));
            try {
                inContents = new DataInputStream(historyStore.getContents(stateArray[i2]));
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("3.1." + i2), (Throwable)e);
            }
            if (!this.compareContent(inFile, inContents)) {
                HistoryStoreTest.fail((String)("3.2." + i2 + " No match, files are not identical."));
            }
            ++i2;
            ++myLong;
        }
        stateArray = historyStore.getStates(secondValidFile.getFullPath(), this.getMonitor());
        i2 = 0;
        while (i2 < stateArray.length) {
            inFile = new DataInputStream(secondValidFile.getContents(false));
            try {
                inContents = new DataInputStream(historyStore.getContents(stateArray[i2]));
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("4.1." + i2), (Throwable)e);
            }
            if (!this.compareContent(inFile, inContents)) {
                HistoryStoreTest.fail((String)("4.2." + i2 + " No match, files are not identical."));
            }
            ++i2;
            ++myLong;
        }
        i2 = 0;
        while (i2 < 20) {
            try {
                InputStream in = historyStore.getContents((IFileState)new FileState(historyStore, (IPath)Path.ROOT, myLong, new UniversalUniqueIdentifier()));
                in.close();
                HistoryStoreTest.fail((String)("6." + i2 + " Edition should be invalid."));
            }
            catch (CoreException coreException) {}
            ++i2;
        }
        i2 = 0;
        while (i2 < 20) {
            try {
                historyStore.getContents(null);
                HistoryStoreTest.fail((String)("7." + i2 + " Null edition should be invalid."));
            }
            catch (RuntimeException runtimeException) {}
            ++i2;
        }
    }

    public void testModifiedStamp() {
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("Project");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IFile file = project.getFile("file");
        try {
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.0", (Throwable)e);
        }
        IFileState[] history = null;
        try {
            history = file.getHistory(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.1", (Throwable)e);
        }
        HistoryStoreTest.assertEquals((String)"1.2", (int)0, (int)history.length);
        long fileTimeStamp = file.getLocalTimeStamp();
        try {
            file.setContents(this.getRandomContents(), true, true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            history = file.getHistory(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.1", (Throwable)e);
        }
        HistoryStoreTest.assertEquals((String)"2.2", (int)1, (int)history.length);
        HistoryStoreTest.assertEquals((String)"3.0", (long)fileTimeStamp, (long)history[0].getModificationTime());
    }

    public void testMoveFolder() {
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IFile file = project.getFile("file1.txt");
        IFolder folder = project.getFolder("folder1");
        IFolder folder2 = project.getFolder("folder2");
        file = folder.getFile("file1.txt");
        try {
            folder.create(true, true, this.getMonitor());
            file.create(this.getContents(contents[0]), true, this.getMonitor());
            file.setContents(this.getContents(contents[1]), true, true, this.getMonitor());
            file.setContents(this.getContents(contents[2]), true, true, this.getMonitor());
            IFileState[] states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"1.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"1.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            folder.move(folder2.getFullPath(), true, this.getMonitor());
            IFile file2 = folder2.getFile("file1.txt");
            HistoryStoreTest.assertTrue((String)"1.3", (boolean)file2.getFullPath().toString().endsWith("folder2/file1.txt"));
            file2.setContents(this.getContents(contents[3]), true, true, this.getMonitor());
            file2.setContents(this.getContents(contents[4]), true, true, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"2.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"2.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            states = file2.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.3", (int)4, (int)states.length);
            HistoryStoreTest.assertTrue((String)"2.4", (boolean)this.compareContent(this.getContents(contents[3]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"2.5", (boolean)this.compareContent(this.getContents(contents[2]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"2.6", (boolean)this.compareContent(this.getContents(contents[1]), states[2].getContents()));
            HistoryStoreTest.assertTrue((String)"2.7", (boolean)this.compareContent(this.getContents(contents[0]), states[3].getContents()));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.8", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testMoveProject() {
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("MoveProjectProject");
        IProject project2 = HistoryStoreTest.getWorkspace().getRoot().getProject("SecondMoveProjectProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        IFile file = project.getFile("file1.txt");
        IFolder folder = project.getFolder("folder1");
        file = folder.getFile("file1.txt");
        try {
            folder.create(true, true, this.getMonitor());
            file.create(this.getContents(contents[0]), true, this.getMonitor());
            file.setContents(this.getContents(contents[1]), true, true, this.getMonitor());
            file.setContents(this.getContents(contents[2]), true, true, this.getMonitor());
            IFileState[] states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"1.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"1.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"1.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            project.move((IPath)new Path("SecondMoveProjectProject"), true, this.getMonitor());
            IFile file2 = project2.getFile("folder1/file1.txt");
            HistoryStoreTest.assertTrue((String)"1.3", (boolean)file2.getFullPath().toString().endsWith("SecondMoveProjectProject/folder1/file1.txt"));
            file2.setContents(this.getContents(contents[3]), true, true, this.getMonitor());
            file2.setContents(this.getContents(contents[4]), true, true, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.0", (int)0, (int)states.length);
            states = file2.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"2.3", (int)4, (int)states.length);
            HistoryStoreTest.assertTrue((String)"2.4", (boolean)this.compareContent(this.getContents(contents[3]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"2.5", (boolean)this.compareContent(this.getContents(contents[2]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"2.6", (boolean)this.compareContent(this.getContents(contents[1]), states[2].getContents()));
            HistoryStoreTest.assertTrue((String)"2.7", (boolean)this.compareContent(this.getContents(contents[0]), states[3].getContents()));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.9", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.0", (Throwable)e);
        }
    }

    public void testRemoveAll() {
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("Project");
        IFile file = project.getFile("removeAllStatesFile.txt");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        int i = 0;
        while (i < 20) {
            try {
                file.setContents(this.getRandomContents(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("3.0." + i), (Throwable)e);
            }
            ++i;
        }
        IFileState[] states = null;
        try {
            states = file.getHistory(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"4.0", (Throwable)e);
        }
        HistoryStoreTest.assertEquals((String)"4.1", (int)20, (int)states.length);
        try {
            file.clearHistory(this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"5.0", (int)0, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"5.1", (Throwable)e);
        }
        IFolder folder = project.getFolder("folder");
        IFile anotherOne = folder.getFile("anotherOne");
        try {
            folder.create(true, true, this.getMonitor());
            anotherOne.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"6.0", (Throwable)e);
        }
        int i2 = 0;
        while (i2 < 20) {
            try {
                file.setContents(this.getRandomContents(), true, true, this.getMonitor());
                anotherOne.setContents(this.getRandomContents(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("6.1." + i2), (Throwable)e);
            }
            ++i2;
        }
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"6.2", (int)20, (int)states.length);
            states = anotherOne.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"6.3", (int)20, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"6.4", (Throwable)e);
        }
        try {
            project.clearHistory(this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"7.0", (int)0, (int)states.length);
            states = anotherOne.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"7.1", (int)0, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"7.2", (Throwable)e);
        }
        IFile aaa = project.getFile("aaa");
        IFolder bbb = project.getFolder("bbb");
        anotherOne = bbb.getFile("anotherOne");
        IFile ccc = project.getFile("ccc");
        try {
            bbb.create(true, true, this.getMonitor());
            anotherOne.create(this.getRandomContents(), true, this.getMonitor());
            aaa.create(this.getRandomContents(), true, this.getMonitor());
            ccc.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"8.0", (Throwable)e);
        }
        int i3 = 0;
        while (i3 < 20) {
            try {
                anotherOne.setContents(this.getRandomContents(), true, true, this.getMonitor());
                aaa.setContents(this.getRandomContents(), true, true, this.getMonitor());
                ccc.setContents(this.getRandomContents(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                HistoryStoreTest.fail((String)("8.1." + i3), (Throwable)e);
            }
            ++i3;
        }
        try {
            states = anotherOne.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"8.3", (int)20, (int)states.length);
            states = aaa.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"8.4", (int)20, (int)states.length);
            states = ccc.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"8.5", (int)20, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"8.6", (Throwable)e);
        }
        try {
            bbb.clearHistory(this.getMonitor());
            states = anotherOne.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"9.1", (int)0, (int)states.length);
            states = aaa.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"9.2", (int)20, (int)states.length);
            states = ccc.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"9.3", (int)20, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"9.4", (Throwable)e);
        }
    }

    public void testSimpleCopy() {
        IFileState[] states;
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("SimpleCopyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IFile file = project.getFile("simpleCopyFileWithHistoryCopy");
        IFile copyFile = project.getFile("copyOfSimpleCopyFileWithHistoryCopy");
        try {
            file.create(this.getContents(contents[0]), true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.2", (Throwable)e);
        }
        try {
            file.setContents(this.getContents(contents[1]), true, true, null);
            file.setContents(this.getContents(contents[2]), true, true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            file.copy(copyFile.getFullPath(), true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            states = file.getHistory(null);
            HistoryStoreTest.assertEquals((String)"4.0", (int)2, (int)states.length);
            states = copyFile.getHistory(null);
            HistoryStoreTest.assertEquals((String)"4.1", (int)2, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"4.2", (Throwable)e);
        }
        try {
            copyFile.setContents(this.getContents(contents[3]), true, true, null);
            copyFile.setContents(this.getContents(contents[4]), true, true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            states = file.getHistory(null);
            HistoryStoreTest.assertEquals((String)"6.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"6.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"6.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            states = copyFile.getHistory(null);
            HistoryStoreTest.assertEquals((String)"6.3", (int)4, (int)states.length);
            HistoryStoreTest.assertTrue((String)"6.4", (boolean)this.compareContent(this.getContents(contents[3]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"6.5", (boolean)this.compareContent(this.getContents(contents[2]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"6.6", (boolean)this.compareContent(this.getContents(contents[1]), states[2].getContents()));
            HistoryStoreTest.assertTrue((String)"6.7", (boolean)this.compareContent(this.getContents(contents[0]), states[3].getContents()));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"6.8", (Throwable)e);
        }
    }

    public void testSimpleMove() {
        IFileState[] states;
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("SimpleMoveProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        String[] contents = new String[]{"content1", "content2", "content3", "content4", "content5"};
        IFile file = project.getFile("simpleMoveFileWithCopy");
        IFile moveFile = project.getFile("copyOfSimpleMoveFileWithCopy");
        try {
            file.create(this.getContents(contents[0]), true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.2", (Throwable)e);
        }
        try {
            file.setContents(this.getContents(contents[1]), true, true, null);
            file.setContents(this.getContents(contents[2]), true, true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            file.move(moveFile.getFullPath(), true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            states = file.getHistory(null);
            HistoryStoreTest.assertEquals((String)"4.0", (int)2, (int)states.length);
            states = moveFile.getHistory(null);
            HistoryStoreTest.assertEquals((String)"4.1", (int)2, (int)states.length);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"4.2", (Throwable)e);
        }
        try {
            moveFile.setContents(this.getContents(contents[3]), true, true, null);
            moveFile.setContents(this.getContents(contents[4]), true, true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            states = file.getHistory(null);
            HistoryStoreTest.assertEquals((String)"6.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"6.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"6.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
            states = moveFile.getHistory(null);
            HistoryStoreTest.assertEquals((String)"6.3", (int)4, (int)states.length);
            HistoryStoreTest.assertTrue((String)"6.4", (boolean)this.compareContent(this.getContents(contents[3]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"6.5", (boolean)this.compareContent(this.getContents(contents[2]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"6.6", (boolean)this.compareContent(this.getContents(contents[1]), states[2].getContents()));
            HistoryStoreTest.assertTrue((String)"6.7", (boolean)this.compareContent(this.getContents(contents[0]), states[3].getContents()));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"6.8", (Throwable)e);
        }
    }

    public void testSimpleUse() {
        IFileState[] states;
        IProject project = HistoryStoreTest.getWorkspace().getRoot().getProject("Project");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"0.0", (Throwable)e);
        }
        String[] contents = new String[]{"content1", "content2", "content3"};
        IFile file = project.getFile("file");
        try {
            file.create(this.getContents(contents[0]), true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            int i = 0;
            while (i < 2) {
                file.setContents(this.getContents(contents[i + 1]), true, true, this.getMonitor());
                ++i;
            }
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"3.0", (int)2, (int)states.length);
            HistoryStoreTest.assertTrue((String)"3.1.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"3.1.2", (boolean)this.compareContent(this.getContents(contents[0]), states[1].getContents()));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"3.2", (Throwable)e);
        }
        try {
            file.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"4.0", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"5.0", (int)3, (int)states.length);
            HistoryStoreTest.assertTrue((String)"5.1.1", (boolean)this.compareContent(this.getContents(contents[2]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"5.1.2", (boolean)this.compareContent(this.getContents(contents[1]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"5.1.3", (boolean)this.compareContent(this.getContents(contents[0]), states[2].getContents()));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"5.2", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            file.create(states[0].getContents(), false, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"6.0", (int)3, (int)states.length);
            HistoryStoreTest.assertTrue((String)"6.1.1", (boolean)this.compareContent(this.getContents(contents[2]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"6.1.2", (boolean)this.compareContent(this.getContents(contents[1]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"6.1.3", (boolean)this.compareContent(this.getContents(contents[0]), states[2].getContents()));
            HistoryStoreTest.assertTrue((String)"6.2", (boolean)this.compareContent(this.getContents(contents[2]), file.getContents(false)));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"6.3", (Throwable)e);
        }
        try {
            file.setContents(this.getContents(contents[1]), true, true, null);
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"7.0", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"8.0", (int)4, (int)states.length);
            HistoryStoreTest.assertTrue((String)"8.1.1", (boolean)this.compareContent(this.getContents(contents[2]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"8.1.2", (boolean)this.compareContent(this.getContents(contents[2]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"8.1.3", (boolean)this.compareContent(this.getContents(contents[1]), states[2].getContents()));
            HistoryStoreTest.assertTrue((String)"8.1.4", (boolean)this.compareContent(this.getContents(contents[0]), states[3].getContents()));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"8.2", (Throwable)e);
        }
        try {
            states = file.getHistory(this.getMonitor());
            file.setContents(states[2], true, true, this.getMonitor());
            states = file.getHistory(this.getMonitor());
            HistoryStoreTest.assertEquals((String)"9.0", (int)5, (int)states.length);
            HistoryStoreTest.assertTrue((String)"9.1.1", (boolean)this.compareContent(this.getContents(contents[1]), states[0].getContents()));
            HistoryStoreTest.assertTrue((String)"9.1.2", (boolean)this.compareContent(this.getContents(contents[2]), states[1].getContents()));
            HistoryStoreTest.assertTrue((String)"9.1.3", (boolean)this.compareContent(this.getContents(contents[2]), states[2].getContents()));
            HistoryStoreTest.assertTrue((String)"9.1.4", (boolean)this.compareContent(this.getContents(contents[1]), states[3].getContents()));
            HistoryStoreTest.assertTrue((String)"9.1.5", (boolean)this.compareContent(this.getContents(contents[0]), states[4].getContents()));
            HistoryStoreTest.assertTrue((String)"9.2", (boolean)this.compareContent(this.getContents(contents[1]), file.getContents(false)));
        }
        catch (CoreException e) {
            HistoryStoreTest.fail((String)"9.3", (Throwable)e);
        }
    }

    class LogListenerVerifier
    implements ILogListener {
        List<Integer> actual = new ArrayList<Integer>();
        List<Integer> expected = new ArrayList<Integer>();

        LogListenerVerifier() {
        }

        void addExpected(int statusCode) {
            this.expected.add(statusCode);
        }

        String dump() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("Expected:\n");
            for (Integer integer : this.expected) {
                buffer.append("\t" + integer + "\n");
            }
            buffer.append("Actual:\n");
            for (Integer integer : this.actual) {
                buffer.append("\t" + integer + "\n");
            }
            return buffer.toString();
        }

        public void logging(IStatus status, String plugin) {
            this.actual.add(status.getCode());
        }

        void reset() {
            this.expected = new ArrayList<Integer>();
            this.actual = new ArrayList<Integer>();
        }

        void verify() throws VerificationFailedException {
            if (this.expected.size() != this.actual.size()) {
                String message = "Expected size: " + this.expected.size() + " does not equal actual size: " + this.actual.size() + "\n";
                message = String.valueOf(message) + this.dump();
                throw new VerificationFailedException(message);
            }
            for (Integer status : this.expected) {
                if (this.actual.contains(status)) continue;
                String message = "Expected and actual results differ.\n";
                message = String.valueOf(message) + this.dump();
                throw new VerificationFailedException(message);
            }
        }
    }

    class VerificationFailedException
    extends Exception {
        private static final long serialVersionUID = 1L;

        VerificationFailedException(String message) {
            super(message);
        }
    }
}

