/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class MoveTest
extends LocalStoreTest {
    public MoveTest() {
    }

    public MoveTest(String name) {
        super(name);
    }

    @Override
    public String[] defineHierarchy() {
        return new String[]{"/", "/file1", "/file2", "/folder1/", "/folder1/file3", "/folder1/file4", "/folder2/", "/folder2/file5", "/folder2/file6", "/folder1/folder3/", "/folder1/folder3/file7", "/folder1/folder3/file8"};
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(MoveTest.class.getName());
        suite.addTest((Test)new MoveTest("testRenameProjects"));
        suite.addTest((Test)new MoveTest("testRenameFolder"));
        suite.addTest((Test)new MoveTest("testRenameFile"));
        suite.addTest((Test)new MoveTest("testMoveFolderBetweenProjects"));
        suite.addTest((Test)new MoveTest("testMoveFileBetweenProjects"));
        suite.addTest((Test)new MoveTest("testMoveFolderAcrossVolumes"));
        suite.addTest((Test)new MoveTest("testMoveFileAcrossVolumes"));
        suite.addTest((Test)new MoveTest("testMoveHierarchy"));
        suite.addTest((Test)new MoveTest("testMoveHierarchyBetweenProjects"));
        suite.addTest((Test)new MoveTest("testMoveResource"));
        return suite;
    }

    public void testMoveFileAcrossVolumes() {
        if (!MoveTest.isWindows()) {
            return;
        }
        String[] devices = this.findAvailableDevices();
        if (devices[0] == null || devices[1] == null) {
            return;
        }
        String location = this.getUniqueString();
        IProject source = MoveTest.getWorkspace().getRoot().getProject(String.valueOf(location) + "1");
        IProject destination = MoveTest.getWorkspace().getRoot().getProject(String.valueOf(location) + "2");
        try {
            source.create(this.getMonitor());
            source.open(this.getMonitor());
            IProjectDescription description = MoveTest.getWorkspace().newProjectDescription(destination.getName());
            description.setLocation((IPath)new Path(String.valueOf(devices[1]) + location));
            destination.create(description, this.getMonitor());
            destination.open(this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"0.0", (Throwable)e);
        }
        String fileName = "fileToBeMoved.txt";
        IFile file = source.getFile(fileName);
        try {
            file.create(this.getRandomContents(), true, this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"1.0", (Throwable)e);
        }
        QualifiedName[] propNames = new QualifiedName[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        try {
            int j = 0;
            while (j < numberOfProperties) {
                propNames[j] = new QualifiedName("test", "prop" + j);
                propValues[j] = "value" + j;
                file.setPersistentProperty(propNames[j], propValues[j]);
                file.setSessionProperty(propNames[j], (Object)propValues[j]);
                ++j;
            }
        }
        catch (CoreException e) {
            MoveTest.fail((String)"2.0", (Throwable)e);
        }
        IPath dest = destination.getFile(fileName).getFullPath();
        try {
            file.move(dest, true, this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"3.0", (Throwable)e);
        }
        IFile newFile = destination.getFile(fileName);
        this.assertDoesNotExistInWorkspace("4.1", (IResource)file);
        this.assertDoesNotExistInFileSystem("4.2", (IResource)file);
        this.assertExistsInWorkspace("4.3", (IResource)newFile);
        this.assertExistsInFileSystem("4.4", (IResource)newFile);
        try {
            int j = 0;
            while (j < numberOfProperties) {
                String persistentValue = newFile.getPersistentProperty(propNames[j]);
                Object sessionValue = newFile.getSessionProperty(propNames[j]);
                MoveTest.assertEquals((String)"5.1", (String)persistentValue, (String)propValues[j]);
                MoveTest.assertEquals((String)"5.2", (Object)sessionValue, (Object)propValues[j]);
                ++j;
            }
        }
        catch (CoreException e) {
            MoveTest.fail((String)"5.3", (Throwable)e);
        }
        try {
            source.delete(true, true, this.getMonitor());
            destination.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public void testMoveFileBetweenProjects() throws Exception {
        IProject[] projects = MoveTest.getWorkspace().getRoot().getProjects();
        String fileName = "newFile.txt";
        IFile file = projects[0].getFile(fileName);
        this.ensureExistsInWorkspace((IResource)file, true);
        QualifiedName[] propNames = new QualifiedName[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        int j = 0;
        while (j < numberOfProperties) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            file.setPersistentProperty(propNames[j], propValues[j]);
            file.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        IPath destination = projects[1].getFile(fileName).getFullPath();
        file.move(destination, true, null);
        IFile newFile = projects[1].getFile(fileName);
        this.assertDoesNotExistInWorkspace((IResource)file);
        this.assertDoesNotExistInFileSystem((IResource)file);
        this.assertExistsInWorkspace((IResource)newFile);
        this.assertExistsInFileSystem((IResource)newFile);
        int j2 = 0;
        while (j2 < numberOfProperties) {
            String persistentValue = newFile.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFile.getSessionProperty(propNames[j2]);
            MoveTest.assertTrue((String)"persistent property value is not the same", (boolean)propValues[j2].equals(persistentValue));
            MoveTest.assertTrue((String)"session property value is not the same", (boolean)propValues[j2].equals(sessionValue));
            ++j2;
        }
    }

    public void testMoveFolderAcrossVolumes() {
        if (!MoveTest.isWindows()) {
            return;
        }
        String[] devices = this.findAvailableDevices();
        if (devices[0] == null || devices[1] == null) {
            return;
        }
        String location = this.getUniqueString();
        IProject source = MoveTest.getWorkspace().getRoot().getProject(String.valueOf(location) + "1");
        IProject destination = MoveTest.getWorkspace().getRoot().getProject(String.valueOf(location) + "2");
        try {
            source.create(this.getMonitor());
            source.open(this.getMonitor());
            IProjectDescription description = MoveTest.getWorkspace().newProjectDescription(destination.getName());
            description.setLocation((IPath)new Path(String.valueOf(devices[1]) + location));
            destination.create(description, this.getMonitor());
            destination.open(this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"0.0", (Throwable)e);
        }
        String folderName = "folderToBeMoved";
        IFolder folder = source.getFolder(folderName);
        try {
            folder.create(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"1.0", (Throwable)e);
        }
        QualifiedName[] propNames = new QualifiedName[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        try {
            int j = 0;
            while (j < numberOfProperties) {
                propNames[j] = new QualifiedName("test", "prop" + j);
                propValues[j] = "value" + j;
                folder.setPersistentProperty(propNames[j], propValues[j]);
                folder.setSessionProperty(propNames[j], (Object)propValues[j]);
                ++j;
            }
        }
        catch (CoreException e) {
            MoveTest.fail((String)"2.0", (Throwable)e);
        }
        IPath dest = destination.getFile(folderName).getFullPath();
        try {
            folder.move(dest, true, this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"3.0", (Throwable)e);
        }
        IFolder newFolder = destination.getFolder(folderName);
        this.assertDoesNotExistInWorkspace("4.1", (IResource)folder);
        this.assertDoesNotExistInFileSystem("4.2", (IResource)folder);
        this.assertExistsInWorkspace("4.3", (IResource)newFolder);
        this.assertExistsInFileSystem("4.4", (IResource)newFolder);
        try {
            int j = 0;
            while (j < numberOfProperties) {
                String persistentValue = newFolder.getPersistentProperty(propNames[j]);
                Object sessionValue = newFolder.getSessionProperty(propNames[j]);
                MoveTest.assertEquals((String)"5.1", (String)persistentValue, (String)propValues[j]);
                MoveTest.assertEquals((String)"5.2", (Object)sessionValue, (Object)propValues[j]);
                ++j;
            }
        }
        catch (CoreException e) {
            MoveTest.fail((String)"5.3", (Throwable)e);
        }
        try {
            source.delete(true, true, this.getMonitor());
            destination.delete(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"6.0", (Throwable)e);
        }
    }

    public void testMoveFolderBetweenProjects() throws Exception {
        IProject[] projects = MoveTest.getWorkspace().getRoot().getProjects();
        String folderName = "newFolder";
        IFolder folder = projects[0].getFolder(folderName);
        this.ensureExistsInWorkspace((IResource)folder, true);
        QualifiedName[] propNames = new QualifiedName[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        int j = 0;
        while (j < numberOfProperties) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            folder.setPersistentProperty(propNames[j], propValues[j]);
            folder.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        IPath destination = projects[1].getFolder(folderName).getFullPath();
        folder.move(destination, true, null);
        IFolder newFolder = projects[1].getFolder(folderName);
        this.assertDoesNotExistInWorkspace((IResource)folder);
        this.assertDoesNotExistInFileSystem((IResource)folder);
        this.assertExistsInWorkspace((IResource)newFolder);
        this.assertExistsInFileSystem((IResource)newFolder);
        int j2 = 0;
        while (j2 < numberOfProperties) {
            String persistentValue = newFolder.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFolder.getSessionProperty(propNames[j2]);
            MoveTest.assertTrue((String)"persistent property value is not the same", (boolean)propValues[j2].equals(persistentValue));
            MoveTest.assertTrue((String)"session property value is not the same", (boolean)propValues[j2].equals(sessionValue));
            ++j2;
        }
    }

    public void testMoveHierarchy() throws Exception {
        IProject[] projects = MoveTest.getWorkspace().getRoot().getProjects();
        String folderSourceName = "folder source";
        IFolder folderSource = projects[0].getFolder(folderSourceName);
        this.ensureExistsInWorkspace((IResource)folderSource, true);
        String[] hierarchy = this.defineHierarchy();
        IResource[] resources = this.buildResources((IContainer)folderSource, hierarchy);
        this.ensureExistsInWorkspace(resources, true);
        String[] propNames = new String[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        int j = 0;
        while (j < numberOfProperties) {
            propNames[j] = "prop" + j;
            propValues[j] = "value" + j;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                QualifiedName propName = new QualifiedName("test", String.valueOf(resource.getName()) + propNames[j]);
                String propValue = String.valueOf(resource.getName()) + propValues[j];
                resource.setPersistentProperty(propName, propValue);
                resource.setSessionProperty(propName, (Object)propValue);
                ++n2;
            }
            ++j;
        }
        String folderDestinationName = "folder destination";
        IFolder folderDestination = projects[0].getFolder(folderDestinationName);
        IProgressMonitor monitor = this.getMonitor();
        folderSource.move(folderDestination.getFullPath(), true, monitor);
        IResource[] newResources = this.buildResources((IContainer)folderDestination, hierarchy);
        this.assertDoesNotExistInWorkspace(resources);
        this.assertDoesNotExistInFileSystem(resources);
        this.assertExistsInWorkspace(newResources);
        this.assertExistsInFileSystem(newResources);
        int j2 = 0;
        while (j2 < numberOfProperties) {
            int i = 0;
            while (i < newResources.length) {
                IResource destResource = newResources[i];
                IResource sourceResource = resources[i];
                QualifiedName propName = new QualifiedName("test", String.valueOf(sourceResource.getName()) + propNames[j2]);
                String propValue = String.valueOf(sourceResource.getName()) + propValues[j2];
                String persistentValue = destResource.getPersistentProperty(propName);
                Object sessionValue = destResource.getSessionProperty(propName);
                MoveTest.assertTrue((String)"persistent property value is not the same", (boolean)propValue.equals(persistentValue));
                MoveTest.assertTrue((String)"session property value is not the same", (boolean)propValue.equals(sessionValue));
                ++i;
            }
            ++j2;
        }
    }

    public void testMoveHierarchyBetweenProjects() throws Exception {
        IProject[] projects = MoveTest.getWorkspace().getRoot().getProjects();
        String folderSourceName = "source";
        IFolder folderSource = projects[0].getFolder(folderSourceName);
        this.ensureExistsInWorkspace((IResource)folderSource, true);
        String[] hierarchy = this.defineHierarchy();
        IResource[] resources = this.buildResources((IContainer)folderSource, hierarchy);
        this.ensureExistsInWorkspace(resources, true);
        String[] propNames = new String[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        int j = 0;
        while (j < numberOfProperties) {
            propNames[j] = "prop" + j;
            propValues[j] = "value" + j;
            IResource[] iResourceArray = resources;
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                QualifiedName propName = new QualifiedName("test", String.valueOf(resource.getName()) + propNames[j]);
                String propValue = String.valueOf(resource.getName()) + propValues[j];
                resource.setPersistentProperty(propName, propValue);
                resource.setSessionProperty(propName, (Object)propValue);
                ++n2;
            }
            ++j;
        }
        String folderDestinationName = "destination";
        IFolder folderDestination = projects[1].getFolder(folderDestinationName);
        folderSource.move(folderDestination.getFullPath(), true, null);
        IResource[] newResources = this.buildResources((IContainer)folderDestination, hierarchy);
        this.assertDoesNotExistInWorkspace(resources);
        this.assertDoesNotExistInFileSystem(resources);
        this.assertExistsInWorkspace(newResources);
        this.assertExistsInFileSystem(newResources);
        int j2 = 0;
        while (j2 < numberOfProperties) {
            int i = 0;
            while (i < newResources.length) {
                IResource destResource = newResources[i];
                IResource sourceResource = resources[i];
                QualifiedName propName = new QualifiedName("test", String.valueOf(sourceResource.getName()) + propNames[j2]);
                String propValue = String.valueOf(sourceResource.getName()) + propValues[j2];
                String persistentValue = destResource.getPersistentProperty(propName);
                Object sessionValue = destResource.getSessionProperty(propName);
                MoveTest.assertTrue((String)"persistent property value is not the same", (boolean)propValue.equals(persistentValue));
                MoveTest.assertTrue((String)"session property value is not the same", (boolean)propValue.equals(sessionValue));
                ++i;
            }
            ++j2;
        }
    }

    public void testMoveResource() throws Exception {
        IProject[] projects = MoveTest.getWorkspace().getRoot().getProjects();
        IFolder folder = projects[0].getFolder("folder");
        IFile file = folder.getFile("file.txt");
        this.ensureExistsInWorkspace((IResource)folder, true);
        this.ensureExistsInWorkspace((IResource)file, true);
        IFile destination = projects[0].getFile("file.txt");
        file.move(destination.getFullPath(), true, null);
        MoveTest.assertTrue((String)"1.1", (!file.exists() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"1.2", (boolean)destination.exists());
        destination.move(file.getFullPath(), true, null);
        MoveTest.assertTrue((String)"1.3", (boolean)file.exists());
        MoveTest.assertTrue((String)"1.4", (!destination.exists() ? 1 : 0) != 0);
        Path path = new Path("destination");
        destination = folder.getFile((IPath)path);
        file.move((IPath)path, true, null);
        MoveTest.assertTrue((String)"2.1", (!file.exists() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"2.2", (boolean)destination.exists());
        destination.move(file.getFullPath(), true, null);
        MoveTest.assertTrue((String)"2.3", (boolean)file.exists());
        MoveTest.assertTrue((String)"2.4", (!destination.exists() ? 1 : 0) != 0);
        destination = folder.getFolder("subfolder");
        boolean ok = false;
        try {
            folder.move(destination.getFullPath(), true, null);
        }
        catch (RuntimeException runtimeException) {
            ok = true;
        }
        MoveTest.assertTrue((String)"3.1", (boolean)ok);
        projects[0].refreshLocal(2, null);
        IFolder subfolder = folder.getFolder("aaa");
        this.ensureExistsInFileSystem((IResource)subfolder);
        IFile anotherFile = folder.getFile("bbb");
        this.ensureExistsInFileSystem(anotherFile);
        destination = projects[0].getFolder("destination");
        ok = false;
        try {
            folder.move(destination.getFullPath(), false, null);
        }
        catch (CoreException coreException) {
            ok = true;
        }
        MoveTest.assertTrue((String)"4.2", (boolean)ok);
        try {
            folder.move(destination.getFullPath(), false, null);
            MoveTest.fail((String)"4.2.1");
        }
        catch (CoreException coreException) {}
        MoveTest.assertTrue((String)"4.3", (boolean)folder.exists());
        IFile destChild = ((IContainer)destination).getFile((IPath)new Path(anotherFile.getName()));
        MoveTest.assertTrue((String)"4.4", (!destination.exists() ? 1 : 0) != 0);
        MoveTest.assertTrue((String)"4.5", (!destChild.exists() ? 1 : 0) != 0);
        try {
            destination.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"4.6", (Throwable)e);
        }
        try {
            destination.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            MoveTest.fail((String)"4.7", (Throwable)e);
        }
        folder.refreshLocal(2, this.getMonitor());
        try {
            folder.move(destination.getFullPath(), false, this.getMonitor());
        }
        catch (CoreException coreException) {
            MoveTest.fail((String)"4.8");
        }
        destination.move(folder.getFullPath(), true, null);
        MoveTest.assertTrue((String)"4.9", (boolean)folder.exists());
        MoveTest.assertTrue((String)"4.10", (!destination.exists() ? 1 : 0) != 0);
        IFile hackFile = file = projects[0].getFile("ghost");
        Workspace workspace = (Workspace)MoveTest.getWorkspace();
        IWorkspaceRunnable operation = monitor -> {
            ResourceInfo resourceInfo = workspace.createResource((IResource)hackFile, false);
        };
        workspace.run(operation, null);
        destination = projects[0].getFile("destination");
        ok = false;
        try {
            file.move(destination.getFullPath(), true, null);
        }
        catch (CoreException coreException) {
            ok = true;
        }
        MoveTest.assertTrue((String)"5.1", (boolean)ok);
        MoveTest.assertTrue((String)"6.1", (boolean)file.exists());
        operation = monitor -> ((Resource)hackFile).convertToPhantom();
        workspace.run(operation, null);
        MoveTest.assertTrue((String)"6.2", (!file.exists() ? 1 : 0) != 0);
        ResourceInfo info = ((File)file).getResourceInfo(true, false);
        int flags = ((File)file).getFlags(info);
        MoveTest.assertTrue((String)"6.3", (boolean)((Resource)file).exists(flags, true));
        anotherFile = folder.getFile("anotherFile");
        this.ensureExistsInWorkspace((IResource)anotherFile, true);
        anotherFile.move(file.getFullPath(), true, null);
        MoveTest.assertTrue((String)"6.4", (boolean)file.exists());
    }

    public void testRenameFile() throws Exception {
        IProject[] projects = MoveTest.getWorkspace().getRoot().getProjects();
        String fileName = "file.txt";
        IFile file = projects[0].getFile(fileName);
        this.ensureExistsInWorkspace((IResource)file, true);
        QualifiedName[] propNames = new QualifiedName[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        int j = 0;
        while (j < numberOfProperties) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            file.setPersistentProperty(propNames[j], propValues[j]);
            file.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        String newFileName = "newFile.txt";
        IPath destination = projects[0].getFile(newFileName).getFullPath();
        file.move(destination, true, null);
        IFile newFile = projects[0].getFile(newFileName);
        this.assertDoesNotExistInWorkspace((IResource)file);
        this.assertDoesNotExistInFileSystem((IResource)file);
        this.assertExistsInWorkspace((IResource)newFile);
        this.assertExistsInFileSystem((IResource)newFile);
        int j2 = 0;
        while (j2 < numberOfProperties) {
            String persistentValue = newFile.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFile.getSessionProperty(propNames[j2]);
            MoveTest.assertTrue((String)"persistent property value is not the same", (boolean)propValues[j2].equals(persistentValue));
            MoveTest.assertTrue((String)"session property value is not the same", (boolean)propValues[j2].equals(sessionValue));
            ++j2;
        }
    }

    public void testRenameFolder() throws Exception {
        IProject[] projects = MoveTest.getWorkspace().getRoot().getProjects();
        String folderName = "folder";
        IFolder folder = projects[0].getFolder(folderName);
        this.ensureExistsInWorkspace((IResource)folder, true);
        QualifiedName[] propNames = new QualifiedName[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        int j = 0;
        while (j < numberOfProperties) {
            propNames[j] = new QualifiedName("test", "prop" + j);
            propValues[j] = "value" + j;
            folder.setPersistentProperty(propNames[j], propValues[j]);
            folder.setSessionProperty(propNames[j], (Object)propValues[j]);
            ++j;
        }
        String newFolderName = "newFolder";
        IPath destination = projects[0].getFolder(newFolderName).getFullPath();
        folder.move(destination, true, null);
        IFolder newFolder = projects[0].getFolder(newFolderName);
        this.assertDoesNotExistInWorkspace((IResource)folder);
        this.assertDoesNotExistInFileSystem((IResource)folder);
        this.assertExistsInWorkspace((IResource)newFolder);
        this.assertExistsInFileSystem((IResource)newFolder);
        int j2 = 0;
        while (j2 < numberOfProperties) {
            String persistentValue = newFolder.getPersistentProperty(propNames[j2]);
            Object sessionValue = newFolder.getSessionProperty(propNames[j2]);
            MoveTest.assertTrue((String)"persistent property value is not the same", (boolean)propValues[j2].equals(persistentValue));
            MoveTest.assertTrue((String)"session property value is not the same", (boolean)propValues[j2].equals(sessionValue));
            ++j2;
        }
    }

    public void testRenameProjects() throws Exception {
        IProject[] projects = MoveTest.getWorkspace().getRoot().getProjects();
        numberOfProperties = numberOfProjects;
        QualifiedName[] propNames = new QualifiedName[numberOfProperties];
        String[] propValues = new String[numberOfProperties];
        int i = 0;
        while (i < numberOfProjects) {
            propNames[i] = new QualifiedName("test", "prop" + i);
            propValues[i] = "value" + i;
            projects[i].setPersistentProperty(propNames[i], propValues[i]);
            projects[i].setSessionProperty(propNames[i], (Object)propValues[i]);
            ++i;
        }
        i = 0;
        while (i < numberOfProjects) {
            String persistentValue = projects[i].getPersistentProperty(propNames[i]);
            Object sessionValue = projects[i].getSessionProperty(propNames[i]);
            MoveTest.assertTrue((String)("1.0." + i), (boolean)propValues[i].equals(persistentValue));
            MoveTest.assertTrue((String)("1.1." + i), (boolean)propValues[i].equals(sessionValue));
            ++i;
        }
        String prefix = "Renamed_PrOjEcT";
        int i2 = 0;
        while (i2 < numberOfProjects) {
            String projectName = String.valueOf(prefix) + i2;
            IPath destination = MoveTest.getWorkspace().getRoot().getProject(projectName).getFullPath();
            projects[i2].move(destination, true, null);
            this.projectNames[i2] = projectName;
            ++i2;
        }
        i2 = 0;
        while (i2 < numberOfProjects) {
            projects[i2] = MoveTest.getWorkspace().getRoot().getProject(this.projectNames[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < numberOfProjects) {
            String persistentValue = projects[i2].getPersistentProperty(propNames[i2]);
            Object sessionValue = projects[i2].getSessionProperty(propNames[i2]);
            MoveTest.assertTrue((String)("2.0." + i2), (boolean)propValues[i2].equals(persistentValue));
            MoveTest.assertTrue((String)("2.1." + i2), (boolean)propValues[i2].equals(sessionValue));
            ++i2;
        }
    }
}

