/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.localstore;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.localstore.ILocalStoreConstants;
import org.eclipse.core.internal.localstore.SafeChunkyInputStream;
import org.eclipse.core.internal.localstore.SafeChunkyOutputStream;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.internal.localstore.LocalStoreTest;

public class SafeChunkyInputOutputStreamTest
extends LocalStoreTest {
    protected File temp;

    public SafeChunkyInputOutputStreamTest() {
    }

    public SafeChunkyInputOutputStreamTest(String name) {
        super(name);
    }

    protected boolean compare(byte[] source, byte[] target) {
        if (source.length != target.length) {
            return false;
        }
        int i = 0;
        while (i < target.length) {
            if (source[i] != target[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected byte[] merge(byte[] b1, byte[] b2) {
        byte[] result = new byte[b1.length + b2.length];
        int i = 0;
        while (i < b1.length) {
            result[i] = b1[i];
            ++i;
        }
        i = 0;
        while (i < b2.length) {
            result[b1.length + i] = b2[i];
            ++i;
        }
        return result;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        IPath location = this.getRandomLocation();
        this.temp = location.append("temp").toFile();
        this.temp.mkdirs();
        SafeChunkyInputOutputStreamTest.assertTrue((String)"could not create temp directory", (boolean)this.temp.isDirectory());
    }

    public static Test suite() {
        return new TestSuite(SafeChunkyInputOutputStreamTest.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.ensureDoesNotExistInFileSystem(this.temp.getParentFile());
        super.tearDown();
    }

    public void testBufferLimit() {
        File target = new File(this.temp, "target");
        Workspace.clear((File)target);
        SafeChunkyInputOutputStreamTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        int bufferSize = 10024;
        byte[] chunk = this.getBigContents(bufferSize);
        SafeChunkyOutputStream output = null;
        try {
            output = new SafeChunkyOutputStream(target);
            try {
                output.write(chunk);
                output.succeed();
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            SafeChunkyInputOutputStreamTest.fail((String)"2.0", (Throwable)e);
        }
        SafeChunkyInputStream input = null;
        try {
            input = new SafeChunkyInputStream(target);
            try {
                byte[] read = new byte[chunk.length];
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.0", (input.read(read) == chunk.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.6", (boolean)this.compare(chunk, read));
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            SafeChunkyInputOutputStreamTest.fail((String)"3.20", (Throwable)e);
        }
        Workspace.clear((File)target);
    }

    public void testFailure() {
        File target = new File(this.temp, "target");
        Workspace.clear((File)target);
        SafeChunkyInputOutputStreamTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        byte[] fakeEnd = new byte[ILocalStoreConstants.END_CHUNK.length];
        System.arraycopy(ILocalStoreConstants.END_CHUNK, 0, fakeEnd, 0, ILocalStoreConstants.END_CHUNK.length);
        fakeEnd[fakeEnd.length - 1] = 86;
        byte[] chunk1 = this.getRandomString().getBytes();
        byte[] chunk2 = this.getRandomString().getBytes();
        byte[] chunk3 = this.getRandomString().getBytes();
        byte[] chunk4 = this.getRandomString().getBytes();
        byte[] chunk5 = this.getRandomString().getBytes();
        byte[] chunk6 = this.getRandomString().getBytes();
        SafeChunkyOutputStream output = null;
        try {
            output = new SafeChunkyOutputStream(target);
            try {
                output.write(chunk1);
                output.succeed();
                this.doNothing(output);
                output = new SafeChunkyOutputStream(target);
                output.write(chunk2);
                output.write(ILocalStoreConstants.BEGIN_CHUNK);
                output.succeed();
                this.doNothing(output);
                output = new SafeChunkyOutputStream(target);
                output.write(chunk3);
                output.succeed();
                this.doNothing(output);
                output = new SafeChunkyOutputStream(target);
                output.write(chunk4);
                output.write(ILocalStoreConstants.END_CHUNK);
                output.succeed();
                this.doNothing(output);
                output = new SafeChunkyOutputStream(target);
                output.write(chunk5);
                output.succeed();
                output.write(fakeEnd);
                output.write(chunk6);
                output.succeed();
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            SafeChunkyInputOutputStreamTest.fail((String)"2.0", (Throwable)e);
        }
        SafeChunkyInputStream input = null;
        try {
            input = new SafeChunkyInputStream(target);
            try {
                byte[] read1 = new byte[chunk1.length];
                byte[] read3 = new byte[chunk3.length];
                byte[] read4 = new byte[chunk4.length];
                byte[] read5 = new byte[chunk5.length];
                byte[] read6 = new byte[fakeEnd.length + chunk6.length];
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.0", (input.read(read1) == chunk1.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.2", (input.read(read3) == chunk3.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.3", (input.read(read4) == chunk4.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.4", (input.read(read5) == chunk5.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.5", (input.read(read6) == fakeEnd.length + chunk6.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.6", (boolean)this.compare(chunk1, read1));
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.8", (boolean)this.compare(chunk3, read3));
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.9", (boolean)this.compare(chunk4, read4));
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.10", (boolean)this.compare(chunk5, read5));
                byte[] expected = this.merge(fakeEnd, chunk6);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.11", (boolean)this.compare(expected, read6));
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            SafeChunkyInputOutputStreamTest.fail((String)"3.20", (Throwable)e);
        }
        Workspace.clear((File)target);
    }

    private void doNothing(SafeChunkyOutputStream output) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void testAlmostEmpty() {
        File target;
        block31: {
            target = new File(this.temp, "target");
            Workspace.clear((File)target);
            SafeChunkyInputOutputStreamTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
            SafeChunkyOutputStream output = null;
            try {
                try {
                    output = new SafeChunkyOutputStream(target);
                }
                catch (IOException e) {
                    SafeChunkyInputOutputStreamTest.fail((String)"1.0", (Throwable)e);
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException e2) {
                            SafeChunkyInputOutputStreamTest.fail((String)"1.1", (Throwable)e2);
                        }
                    }
                    break block31;
                }
            }
            catch (Throwable throwable) {
                if (output == null) throw throwable;
                try {
                    output.close();
                    throw throwable;
                }
                catch (IOException e) {
                    SafeChunkyInputOutputStreamTest.fail((String)"1.1", (Throwable)e);
                }
                throw throwable;
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    SafeChunkyInputOutputStreamTest.fail((String)"1.1", (Throwable)e);
                }
            }
        }
        FilterInputStream input = null;
        try {
            try {
                input = new DataInputStream((InputStream)new SafeChunkyInputStream(target));
                ((DataInputStream)input).readUTF();
                SafeChunkyInputOutputStreamTest.fail((String)"2.0");
                return;
            }
            catch (EOFException eOFException) {
                if (input == null) return;
                try {
                    input.close();
                    return;
                }
                catch (IOException e) {
                    SafeChunkyInputOutputStreamTest.fail((String)"2.2", (Throwable)e);
                }
                return;
            }
            catch (IOException e) {
                SafeChunkyInputOutputStreamTest.fail((String)"2.1", (Throwable)e);
                if (input == null) return;
                try {
                    input.close();
                    return;
                }
                catch (IOException e3) {
                    SafeChunkyInputOutputStreamTest.fail((String)"2.2", (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    SafeChunkyInputOutputStreamTest.fail((String)"2.2", (Throwable)e);
                }
            }
        }
    }

    public void testSimple() {
        File target = new File(this.temp, "target");
        Workspace.clear((File)target);
        SafeChunkyInputOutputStreamTest.assertTrue((String)"1.0", (!target.exists() ? 1 : 0) != 0);
        byte[] chunk1 = this.getRandomString().getBytes();
        byte[] chunk2 = this.getRandomString().getBytes();
        byte[] chunk3 = this.getRandomString().getBytes();
        byte[] chunk4 = this.getRandomString().getBytes();
        byte[] chunk5 = this.getRandomString().getBytes();
        SafeChunkyOutputStream output = null;
        try {
            output = new SafeChunkyOutputStream(target);
            try {
                output.write(chunk1);
                output.succeed();
                output.write(chunk2);
                output.succeed();
                output.write(chunk3);
                output.succeed();
                output.write(chunk4);
                output.succeed();
                output.write(chunk5);
                output.succeed();
            }
            finally {
                output.close();
            }
        }
        catch (IOException e) {
            SafeChunkyInputOutputStreamTest.fail((String)"2.0", (Throwable)e);
        }
        SafeChunkyInputStream input = null;
        try {
            input = new SafeChunkyInputStream(target);
            try {
                byte[] read1 = new byte[chunk1.length];
                byte[] read2 = new byte[chunk2.length];
                byte[] read3 = new byte[chunk3.length];
                byte[] read4 = new byte[chunk4.length];
                byte[] read5 = new byte[chunk5.length];
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.0", (input.read(read1) == chunk1.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.1", (input.read(read2) == chunk2.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.2", (input.read(read3) == chunk3.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.3", (input.read(read4) == chunk4.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.4", (input.read(read5) == chunk5.length ? 1 : 0) != 0);
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.5", (boolean)this.compare(chunk1, read1));
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.6", (boolean)this.compare(chunk2, read2));
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.7", (boolean)this.compare(chunk3, read3));
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.8", (boolean)this.compare(chunk4, read4));
                SafeChunkyInputOutputStreamTest.assertTrue((String)"3.9", (boolean)this.compare(chunk5, read5));
            }
            finally {
                input.close();
            }
        }
        catch (IOException e) {
            SafeChunkyInputOutputStreamTest.fail((String)"3.10", (Throwable)e);
        }
        Workspace.clear((File)target);
    }
}

