/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.mapping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ModelStatus;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class ChangeDescription {
    public static final String ADDED = "Added {0}";
    public static final String CHANGED = "Changed {0}";
    public static final String CLOSED = "Closed {0}";
    public static final String COPIED = "Copied {0}";
    public static final String MOVED = "Moved {0}";
    public static final String REMOVED = "Removed {0}";
    private List<IResource> addedRoots = new ArrayList<IResource>();
    private List<IResource> changedRoots = new ArrayList<IResource>();
    private List<IResource> closedProjects = new ArrayList<IResource>();
    private List<IResource> copiedRoots = new ArrayList<IResource>();
    private List<Status> errors = new ArrayList<Status>();
    private List<IResource> movedRoots = new ArrayList<IResource>();
    private List<IResource> removedRoots = new ArrayList<IResource>();

    public static String getMessageFor(String messageTemplate, IResource resource) {
        return NLS.bind((String)messageTemplate, (Object)resource.getFullPath().toString());
    }

    private void accumulateStatus(IResource[] resources, List<ModelStatus> result, String message) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            result.add(new ModelStatus(2, "org.eclipse.core.tests.resources", "org.eclipse.core.tests.resources.modelProvider", ChangeDescription.getMessageFor(message, resource)));
            ++n2;
        }
    }

    public void addError(CoreException e) {
        this.errors.add(new Status(4, "org.eclipse.core.tests.resources", 0, "An error occurred", (Throwable)e));
    }

    public IStatus asStatus() {
        if (this.errors.isEmpty()) {
            ArrayList<ModelStatus> result = new ArrayList<ModelStatus>();
            this.accumulateStatus(this.addedRoots.toArray(new IResource[this.addedRoots.size()]), result, ADDED);
            this.accumulateStatus(this.removedRoots.toArray(new IResource[this.removedRoots.size()]), result, REMOVED);
            this.accumulateStatus(this.movedRoots.toArray(new IResource[this.movedRoots.size()]), result, MOVED);
            this.accumulateStatus(this.copiedRoots.toArray(new IResource[this.copiedRoots.size()]), result, COPIED);
            this.accumulateStatus(this.changedRoots.toArray(new IResource[this.changedRoots.size()]), result, CHANGED);
            this.accumulateStatus(this.closedProjects.toArray(new IResource[this.closedProjects.size()]), result, CLOSED);
            if (!result.isEmpty()) {
                if (result.size() == 1) {
                    return (IStatus)result.get(0);
                }
                return new MultiStatus("org.eclipse.core.tests.resources", 0, result.toArray(new IStatus[result.size()]), "Changes were validated", null);
            }
            return Status.OK_STATUS;
        }
        if (this.errors.size() == 1) {
            return (IStatus)this.errors.get(0);
        }
        return new MultiStatus("org.eclipse.core.tests.resources", 0, this.errors.toArray(new IStatus[this.errors.size()]), "Errors occurred", null);
    }

    private IResource createSourceResource(IResourceDelta delta) {
        IPath sourcePath = delta.getMovedFromPath();
        IResource resource = delta.getResource();
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        switch (resource.getType()) {
            case 4: {
                return wsRoot.getProject(sourcePath.segment(0));
            }
            case 2: {
                return wsRoot.getFolder(sourcePath);
            }
            case 1: {
                return wsRoot.getFile(sourcePath);
            }
        }
        return null;
    }

    private void ensureResourceCovered(IResource resource, List<IResource> list) {
        IPath path = resource.getFullPath();
        for (IResource root : list) {
            if (!root.getFullPath().isPrefixOf(path)) continue;
            return;
        }
        list.add(resource);
    }

    private void handleAdded(IResourceDelta delta) {
        if ((delta.getFlags() & 0x1000) != 0) {
            this.handleMove(delta);
        } else if ((delta.getFlags() & 0x800) != 0) {
            this.handleCopy(delta);
        } else {
            this.ensureResourceCovered(delta.getResource(), this.addedRoots);
        }
    }

    private void handleChange(IResourceDelta delta) {
        if ((delta.getFlags() & 0x40000) != 0) {
            this.handleAdded(delta);
        } else if (delta.getResource().getType() == 1) {
            this.ensureResourceCovered(delta.getResource(), this.changedRoots);
        }
    }

    private void handleCopy(IResourceDelta delta) {
        if ((delta.getFlags() & 0x800) != 0) {
            IResource source = this.createSourceResource(delta);
            this.ensureResourceCovered(source, this.copiedRoots);
        }
    }

    private void handleMove(IResourceDelta delta) {
        if ((delta.getFlags() & 0x2000) != 0) {
            this.ensureResourceCovered(delta.getResource(), this.movedRoots);
        } else if ((delta.getFlags() & 0x1000) != 0) {
            IResource source = this.createSourceResource(delta);
            this.ensureResourceCovered(source, this.movedRoots);
        }
    }

    private void handleRemoved(IResourceDelta delta) {
        if ((delta.getFlags() & 0x4000) != 0) {
            this.closedProjects.add(delta.getResource());
        } else if ((delta.getFlags() & 0x2000) != 0) {
            this.handleMove(delta);
        } else {
            this.ensureResourceCovered(delta.getResource(), this.removedRoots);
        }
    }

    public boolean recordChange(IResourceDelta delta) {
        switch (delta.getKind()) {
            case 1: {
                this.handleAdded(delta);
                return true;
            }
            case 2: {
                this.handleRemoved(delta);
                return false;
            }
            case 4: {
                this.handleChange(delta);
                return true;
            }
        }
        return true;
    }
}

