/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.resources;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.core.tests.resources.ResourceTest;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ProjectPreferencesTest
extends ResourceTest {
    private static final String DIR_NAME = ".settings";
    private static final String FILE_EXTENSION = "prefs";

    public static Test suite() {
        return new TestSuite(ProjectPreferencesTest.class);
    }

    public ProjectPreferencesTest(String name) {
        super(name);
    }

    public void testSimple() {
        IProject project = ProjectPreferencesTest.getProject("foo");
        String qualifier = "org.eclipse.core.tests.resources";
        String key = "key" + this.getUniqueString();
        String instanceValue = "instance" + this.getUniqueString();
        String projectValue = "project" + this.getUniqueString();
        ProjectScope projectContext = new ProjectScope(project);
        IScopeContext instanceContext = InstanceScope.INSTANCE;
        this.ensureExistsInWorkspace((IResource)project, true);
        ArrayList<IScopeContext[]> list = new ArrayList<IScopeContext[]>();
        list.add(null);
        list.add(new IScopeContext[0]);
        list.add(new IScopeContext[1]);
        IScopeContext[][] contextsWithoutScope = (IScopeContext[][])list.toArray((T[])new IScopeContext[list.size()][]);
        list = new ArrayList();
        list.add(new IScopeContext[]{projectContext});
        IScopeContext[] iScopeContextArray = new IScopeContext[2];
        iScopeContextArray[1] = projectContext;
        list.add(iScopeContextArray);
        IScopeContext[][] contextsWithScope = (IScopeContext[][])list.toArray((T[])new IScopeContext[list.size()][]);
        IPreferencesService service = Platform.getPreferencesService();
        IEclipsePreferences node = instanceContext.getNode(qualifier);
        node.put(key, instanceValue);
        String actual = node.get(key, null);
        ProjectPreferencesTest.assertNotNull((String)"1.0", (Object)actual);
        ProjectPreferencesTest.assertEquals((String)"1.1", (String)instanceValue, (String)actual);
        int i = 0;
        while (i < contextsWithoutScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithoutScope[i]);
            ProjectPreferencesTest.assertNotNull((String)("2.0." + i), (Object)actual);
            ProjectPreferencesTest.assertEquals((String)("2.1." + i), (String)instanceValue, (String)actual);
            ++i;
        }
        i = 0;
        while (i < contextsWithScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithScope[i]);
            ProjectPreferencesTest.assertNotNull((String)("2.2." + i), (Object)actual);
            ProjectPreferencesTest.assertEquals((String)("2.3." + i), (String)instanceValue, (String)actual);
            ++i;
        }
        node = projectContext.getNode(qualifier);
        node.put(key, projectValue);
        actual = node.get(key, null);
        ProjectPreferencesTest.assertNotNull((String)"3.0", (Object)actual);
        ProjectPreferencesTest.assertEquals((String)"3.1", (String)projectValue, (String)actual);
        i = 0;
        while (i < contextsWithoutScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithoutScope[i]);
            ProjectPreferencesTest.assertNotNull((String)("4.0." + i), (Object)actual);
            ProjectPreferencesTest.assertEquals((String)("4.1." + i), (String)instanceValue, (String)actual);
            ++i;
        }
        i = 0;
        while (i < contextsWithScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithScope[i]);
            ProjectPreferencesTest.assertNotNull((String)("4.2." + i), (Object)actual);
            ProjectPreferencesTest.assertEquals((String)("4.3." + i), (String)projectValue, (String)actual);
            ++i;
        }
        node = projectContext.getNode(qualifier);
        node.remove(key);
        actual = node.get(key, null);
        ProjectPreferencesTest.assertNull((String)"5.0", (Object)actual);
        i = 0;
        while (i < contextsWithoutScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithoutScope[i]);
            ProjectPreferencesTest.assertNotNull((String)("6.0." + i), (Object)actual);
            ProjectPreferencesTest.assertEquals((String)("6.1." + i), (String)instanceValue, (String)actual);
            ++i;
        }
        i = 0;
        while (i < contextsWithScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithScope[i]);
            ProjectPreferencesTest.assertNotNull((String)("6.2." + i), (Object)actual);
            ProjectPreferencesTest.assertEquals((String)("6.3." + i), (String)instanceValue, (String)actual);
            ++i;
        }
        node = instanceContext.getNode(qualifier);
        node.remove(key);
        actual = node.get(key, null);
        i = 0;
        while (i < contextsWithoutScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithoutScope[i]);
            ProjectPreferencesTest.assertNull((String)("7.0." + i), (Object)actual);
            ++i;
        }
        i = 0;
        while (i < contextsWithScope.length) {
            actual = service.getString(qualifier, key, null, contextsWithScope[i]);
            ProjectPreferencesTest.assertNull((String)("7.1." + i), (Object)actual);
            ++i;
        }
    }

    public void testListener() {
        String newValue;
        String newKey;
        String actual;
        IEclipsePreferences node;
        String value;
        String key;
        String qualifier;
        IProject project;
        block33: {
            Properties props;
            File file;
            block31: {
                project = ProjectPreferencesTest.getProject(this.getUniqueString());
                qualifier = "org.eclipse.core.tests.resources";
                key = "key" + this.getUniqueString();
                value = "value" + this.getUniqueString();
                ProjectScope projectContext = new ProjectScope(project);
                this.ensureExistsInWorkspace((IResource)project, true);
                node = projectContext.getNode(qualifier);
                node.put(key, value);
                actual = node.get(key, null);
                ProjectPreferencesTest.assertNotNull((String)"1.0", (Object)actual);
                ProjectPreferencesTest.assertEquals((String)"1.1", (String)value, (String)actual);
                try {
                    node.flush();
                }
                catch (BackingStoreException e) {
                    ProjectPreferencesTest.fail((String)"0.0", (Throwable)e);
                }
                file = ProjectPreferencesTest.getFileInFilesystem(project, qualifier);
                props = new Properties();
                InputStream input = null;
                try {
                    try {
                        input = new BufferedInputStream(new FileInputStream(file));
                        props.load(input);
                    }
                    catch (IOException e) {
                        ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block31;
                    }
                }
                catch (Throwable throwable) {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            newKey = "newKey" + this.getUniqueString();
            newValue = "newValue" + this.getUniqueString();
            props.put(newKey, newValue);
            OutputStream output = null;
            try {
                try {
                    output = new BufferedOutputStream(new FileOutputStream(file));
                    props.store(output, null);
                }
                catch (IOException e) {
                    ProjectPreferencesTest.fail((String)"2.0", (Throwable)e);
                    if (output != null) {
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block33;
                }
            }
            catch (Throwable throwable) {
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException iOException) {}
            }
        }
        IFile workspaceFile = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        this.touchInFilesystem((IResource)workspaceFile);
        try {
            workspaceFile.refreshLocal(0, this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"3.1", (Throwable)e);
        }
        actual = node.get(key, null);
        ProjectPreferencesTest.assertEquals((String)"4.1", (String)value, (String)actual);
        actual = node.get(newKey, null);
        ProjectPreferencesTest.assertEquals((String)"4.2", (String)newValue, (String)actual);
    }

    public void testProjectDelete() {
        IProject project = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        String qualifier = this.getUniqueString();
        String key = this.getUniqueString();
        String value = this.getUniqueString();
        ProjectScope context = new ProjectScope(project);
        IEclipsePreferences node = context.getNode(qualifier);
        Preferences parent = node.parent().parent();
        node.put(key, value);
        ProjectPreferencesTest.assertEquals((String)"1.0", (String)value, (String)node.get(key, null));
        try {
            project.delete(5, this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            ProjectPreferencesTest.assertTrue((String)"3.0", (!parent.nodeExists(project.getName()) ? 1 : 0) != 0);
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"3.1", (Throwable)e);
        }
        this.ensureExistsInWorkspace((IResource)project, true);
        ProjectPreferencesTest.assertNull((String)"4.0", (Object)context.getNode(qualifier).get(key, null));
    }

    public void testProjectMove() {
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace(new IResource[]{project1}, true);
        String qualifier = this.getUniqueString();
        String key = this.getUniqueString();
        String value = this.getUniqueString();
        IEclipsePreferences node = new ProjectScope(project1).getNode(qualifier);
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            project1.move((IPath)new Path(project2.getName()), false, null);
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"2.0", (Throwable)e);
        }
        node = Platform.getPreferencesService().getRootNode().node("project");
        ProjectPreferencesTest.assertNotNull((String)"2.1", (Object)node);
        try {
            ProjectPreferencesTest.assertTrue((String)"2.2", (!node.nodeExists(project1.getName()) ? 1 : 0) != 0);
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"2.3", (Throwable)e);
        }
        node = Platform.getPreferencesService().getRootNode().node("project");
        ProjectPreferencesTest.assertNotNull((String)"2.3", (Object)node);
        try {
            ProjectPreferencesTest.assertTrue((String)"2.4", (boolean)node.nodeExists(project2.getName()));
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"2.5", (Throwable)e);
        }
        node = node.node(project2.getName());
        ProjectPreferencesTest.assertNotNull((String)"3.1", (Object)node);
        try {
            ProjectPreferencesTest.assertTrue((String)"3.2", (boolean)node.nodeExists(qualifier));
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"3.3", (Throwable)e);
        }
        node = node.node(qualifier);
        ProjectPreferencesTest.assertNotNull((String)"4.1", (Object)node);
        ProjectPreferencesTest.assertEquals((String)"4.2", (String)value, (String)node.get(key, null));
    }

    public void test_60925() {
        IProject project = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        String qualifier = this.getUniqueString();
        IFile file = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        ProjectPreferencesTest.assertTrue((String)"0.0", (!file.exists() ? 1 : 0) != 0);
        ProjectPreferencesTest.assertTrue((String)"0.1", (!file.getLocation().toFile().exists() ? 1 : 0) != 0);
        ProjectScope context = new ProjectScope(project);
        String key = this.getUniqueString();
        String value = this.getUniqueString();
        IEclipsePreferences node = context.getNode(qualifier);
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
        }
        ProjectPreferencesTest.assertTrue((String)"2.0", (boolean)file.exists());
        ProjectPreferencesTest.assertTrue((String)"2.1", (boolean)file.isSynchronized(0));
    }

    public void test_55410() {
        Properties props;
        String value2;
        String value1;
        String key2;
        String key1;
        block18: {
            IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
            this.ensureExistsInWorkspace(new IResource[]{project1}, true);
            Preferences node = new ProjectScope(project1).getNode("org.eclipse.core.resources").node("subnode");
            key1 = ".";
            key2 = "x";
            value1 = this.getUniqueString();
            value2 = this.getUniqueString();
            node.put(key1, value1);
            node.put(key2, value2);
            ProjectPreferencesTest.assertEquals((String)"0.8", (String)value1, (String)node.get(key1, null));
            ProjectPreferencesTest.assertEquals((String)"0.9", (String)value2, (String)node.get(key2, null));
            IFile prefsFile = ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources");
            ProjectPreferencesTest.assertTrue((String)"1.0", (!prefsFile.exists() ? 1 : 0) != 0);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ProjectPreferencesTest.fail((String)"1.1", (Throwable)e);
            }
            ProjectPreferencesTest.assertTrue((String)"1.1", (boolean)prefsFile.exists());
            props = new Properties();
            InputStream contents = null;
            try {
                contents = prefsFile.getContents();
            }
            catch (CoreException e) {
                ProjectPreferencesTest.fail((String)"1.2", (Throwable)e);
            }
            try {
                try {
                    props.load(contents);
                }
                catch (IOException e) {
                    ProjectPreferencesTest.fail((String)"1.3", (Throwable)e);
                    if (contents != null) {
                        try {
                            contents.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (contents != null) {
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (contents != null) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
            }
        }
        ProjectPreferencesTest.assertEquals((String)"2.0", (String)value2, (String)props.getProperty("subnode/" + key2));
        ProjectPreferencesTest.assertEquals((String)"2.1", (String)value1, (String)props.getProperty("subnode/" + key1));
    }

    public void test_61277a() {
        IProject project = ProjectPreferencesTest.getProject(this.getUniqueString());
        IProject destProject = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        this.ensureDoesNotExistInWorkspace((IResource)destProject);
        ProjectScope context = new ProjectScope(project);
        String qualifier = this.getUniqueString();
        IEclipsePreferences node = context.getNode(qualifier);
        String key = this.getUniqueString();
        String value = this.getUniqueString();
        node.put(key, value);
        ProjectPreferencesTest.assertEquals((String)"1.0", (String)value, (String)node.get(key, null));
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            project.move(destProject.getFullPath(), true, this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"2.0", (Throwable)e);
        }
        context = new ProjectScope(destProject);
        node = context.getNode(qualifier);
        ProjectPreferencesTest.assertEquals((String)"3.0", (String)value, (String)node.get(key, null));
    }

    public void test_61277b() {
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace(new IResource[]{project1}, true);
        IEclipsePreferences node = new ProjectScope(project1).getNode("org.eclipse.core.resources");
        node.put("key", "value");
        ProjectPreferencesTest.assertTrue((String)"1.0", (!ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources").exists() ? 1 : 0) != 0);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.99", (Throwable)e);
        }
        ProjectPreferencesTest.assertTrue((String)"1.1", (boolean)ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources").exists());
        try {
            project1.move(project2.getFullPath(), false, null);
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"2.99", (Throwable)e);
        }
        ProjectPreferencesTest.assertTrue((String)"2.0", (boolean)ProjectPreferencesTest.getFileInWorkspace(project2, "org.eclipse.core.resources").exists());
        node = new ProjectScope(project2).getNode("org.eclipse.core.resources");
        ProjectPreferencesTest.assertEquals((String)"2.1", (String)"value", (String)node.get("key", null));
    }

    public void test_61277c() {
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace(new IResource[]{project1}, true);
        IEclipsePreferences node = new ProjectScope(project1).getNode("org.eclipse.core.resources");
        String key1 = "key";
        String emptyKey = "";
        String value1 = this.getUniqueString();
        String value2 = this.getUniqueString();
        node.put(key1, value1);
        node.put(emptyKey, value2);
        ProjectPreferencesTest.assertTrue((String)"1.0", (!ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources").exists() ? 1 : 0) != 0);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.1", (Throwable)e);
        }
        ProjectPreferencesTest.assertTrue((String)"1.2", (boolean)ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources").exists());
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        try {
            project1.move(project2.getFullPath(), false, null);
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"2.99", (Throwable)e);
        }
        ProjectPreferencesTest.assertTrue((String)"2.0", (boolean)ProjectPreferencesTest.getFileInWorkspace(project2, "org.eclipse.core.resources").exists());
        node = new ProjectScope(project2).getNode("org.eclipse.core.resources");
        ProjectPreferencesTest.assertEquals((String)"2.1", (String)value1, (String)node.get(key1, null));
        ProjectPreferencesTest.assertEquals((String)"2.2", (String)value2, (String)node.get(emptyKey, null));
    }

    public void test_61843() {
        IProject project;
        String qualifier;
        block23: {
            qualifier = this.getUniqueString();
            project = ProjectPreferencesTest.getProject(this.getUniqueString());
            this.ensureExistsInWorkspace((IResource)project, true);
            IFile settingsFile = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
            Properties properties = new Properties();
            properties.put("key", "value");
            OutputStream output = null;
            try {
                File file = settingsFile.getLocation().toFile();
                file.getParentFile().mkdirs();
                output = new BufferedOutputStream(new FileOutputStream(file));
                properties.store(output, null);
            }
            catch (FileNotFoundException e) {
                ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
                try {
                    if (output != null) {
                        output.close();
                    }
                    break block23;
                }
                catch (IOException iOException) {}
                break block23;
            }
            catch (IOException e) {
                try {
                    ProjectPreferencesTest.fail((String)"1.1", (Throwable)e);
                }
                catch (Throwable throwable) {
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (output != null) {
                        output.close();
                    }
                    break block23;
                }
                catch (IOException iOException) {}
                break block23;
            }
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
        }
        ILogListener logListener = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                Throwable exception = status.getException();
                if (exception == null || !(exception instanceof CoreException)) {
                    return;
                }
                if (380 == ((CoreException)exception).getStatus().getCode()) {
                    ProjectPreferencesTest.fail((String)"3.0");
                }
            }
        };
        IResourceChangeListener rclistener = new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                new ProjectScope(project).getNode(qualifier);
            }
        };
        Platform.addLogListener((ILogListener)logListener);
        ProjectPreferencesTest.getWorkspace().addResourceChangeListener(rclistener, 1);
        try {
            try {
                project.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                ProjectPreferencesTest.fail((String)"4.0", (Throwable)e);
                Platform.removeLogListener((ILogListener)logListener);
                ProjectPreferencesTest.getWorkspace().removeResourceChangeListener(rclistener);
            }
        }
        finally {
            Platform.removeLogListener((ILogListener)logListener);
            ProjectPreferencesTest.getWorkspace().removeResourceChangeListener(rclistener);
        }
    }

    public void test_65068() {
        IProject project = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        IEclipsePreferences node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        String key = "key";
        String value = this.getUniqueString();
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.1", (Throwable)e);
        }
        ProjectPreferencesTest.assertTrue((String)"1.2", (boolean)ProjectPreferencesTest.getFileInWorkspace(project, "org.eclipse.core.resources").exists());
        node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        ProjectPreferencesTest.assertEquals((String)"1.3", (String)value, (String)node.get(key, null));
        this.ensureDoesNotExistInWorkspace((IResource)project.getFolder(DIR_NAME));
        node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        ProjectPreferencesTest.assertNull((String)"2.0", (Object)node.get(key, null));
    }

    public void test_95052() {
        Properties properties;
        IFile prefFile;
        IEclipsePreferences node;
        IProject project;
        block19: {
            project = ProjectPreferencesTest.getProject(this.getUniqueString());
            this.ensureExistsInWorkspace((IResource)project, true);
            node = new ProjectScope(project).getNode("org.eclipse.core.resources");
            node.put("key1", "value1");
            node.put("key2", "value2");
            node.put("key3", "value3");
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ProjectPreferencesTest.fail((String)"1.1", (Throwable)e);
            }
            prefFile = ProjectPreferencesTest.getFileInWorkspace(project, "org.eclipse.core.resources");
            ProjectPreferencesTest.assertTrue((String)"1.2", (boolean)prefFile.exists());
            properties = new Properties();
            InputStream contents = null;
            try {
                contents = prefFile.getContents();
            }
            catch (CoreException e) {
                ProjectPreferencesTest.fail((String)"1.3", (Throwable)e);
            }
            try {
                try {
                    properties.load(contents);
                }
                catch (IOException e) {
                    ProjectPreferencesTest.fail((String)"1.4", (Throwable)e);
                    try {
                        contents.close();
                    }
                    catch (IOException iOException) {}
                    break block19;
                }
            }
            catch (Throwable throwable) {
                try {
                    contents.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                contents.close();
            }
            catch (IOException iOException) {}
        }
        ProjectPreferencesTest.assertEquals((String)"2.0", (Object)"value1", (Object)properties.get("key1"));
        ProjectPreferencesTest.assertEquals((String)"2.1", (Object)"value2", (Object)properties.get("key2"));
        ProjectPreferencesTest.assertEquals((String)"2.2", (Object)"value3", (Object)properties.get("key3"));
        properties.put("key0", "value0");
        properties.put("key2", "value2".toUpperCase());
        properties.remove("key3");
        ByteArrayOutputStream tempOutput = new ByteArrayOutputStream();
        try {
            properties.store(tempOutput, null);
        }
        catch (IOException e) {
            ProjectPreferencesTest.fail((String)"2.4", (Throwable)e);
        }
        ByteArrayInputStream tempInput = new ByteArrayInputStream(tempOutput.toByteArray());
        try {
            prefFile.setContents((InputStream)tempInput, false, false, this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"2.5", (Throwable)e);
        }
        node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        ProjectPreferencesTest.assertEquals((String)"3.0", (String)"value0", (String)node.get("key0", null));
        ProjectPreferencesTest.assertEquals((String)"3.1", (String)"value1", (String)node.get("key1", null));
        ProjectPreferencesTest.assertEquals((String)"3.2", (String)"value2".toUpperCase(), (String)node.get("key2", null));
        ProjectPreferencesTest.assertNull((String)"3.3", (Object)node.get("key3", null));
    }

    public void test_256900() {
        IProject project = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project2, true);
        this.ensureExistsInWorkspace((IResource)project2.getFolder(DIR_NAME), true);
        IEclipsePreferences node = new ProjectScope(project).getNode("org.eclipse.core.resources");
        String key = "key";
        String value = this.getUniqueString();
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
        }
        IFile prefFile = ProjectPreferencesTest.getFileInWorkspace(project, "org.eclipse.core.resources");
        ProjectPreferencesTest.assertTrue((String)"2.0", (boolean)prefFile.exists());
        IEclipsePreferences project2Node = new ProjectScope(project2).getNode("org.eclipse.core.resources");
        ProjectPreferencesTest.assertNull((String)"3.0", (Object)project2Node.get(key, null));
        try {
            prefFile.copy(ProjectPreferencesTest.getFileInWorkspace(project2, "org.eclipse.core.resources").getFullPath(), true, null);
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"4.0", (Throwable)e);
        }
        ProjectPreferencesTest.assertEquals((String)"5.0", (String)value, (String)project2Node.get(key, null));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void test_325000() {
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace(new IResource[]{project1}, true);
        Preferences node = new ProjectScope(project1).getNode("org.eclipse.core.resources").node("subnode");
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("z" + this.getUniqueString());
        keys.add("a" + this.getUniqueString());
        keys.add("1" + this.getUniqueString());
        keys.add("z" + this.getUniqueString());
        keys.add("_" + this.getUniqueString());
        keys.add(this.getUniqueString());
        for (String key : keys) {
            node.put(key, this.getUniqueString());
        }
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
        }
        IFile prefsFile = ProjectPreferencesTest.getFileInWorkspace(project1, "org.eclipse.core.resources");
        BufferedReader reader = null;
        try {
            try {
                reader = new BufferedReader(new InputStreamReader(prefsFile.getContents()));
                String currentLine = null;
                String prevLine = null;
                while ((currentLine = reader.readLine()) != null) {
                    boolean isUserProperty = false;
                    for (String key : keys) {
                        if (!currentLine.contains(key)) continue;
                        isUserProperty = true;
                        break;
                    }
                    if (!isUserProperty) continue;
                    if (prevLine == null) {
                        prevLine = currentLine;
                        continue;
                    }
                    if (prevLine.compareTo(currentLine) > 0) {
                        ProjectPreferencesTest.fail((String)"1.1");
                    }
                    prevLine = currentLine;
                }
                return;
            }
            catch (CoreException e) {
                ProjectPreferencesTest.fail((String)"1.2", (Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e2) {
                    ProjectPreferencesTest.fail((String)"1.4", (Throwable)e2);
                }
                return;
            }
            catch (IOException e) {
                ProjectPreferencesTest.fail((String)"1.3", (Throwable)e);
                if (reader == null) return;
                try {
                    reader.close();
                    return;
                }
                catch (IOException e3) {
                    ProjectPreferencesTest.fail((String)"1.4", (Throwable)e3);
                }
                return;
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    ProjectPreferencesTest.fail((String)"1.4", (Throwable)e);
                }
            }
        }
    }

    public void test_335591() {
        String projectName = this.getUniqueString();
        String nodeName = "node";
        IProject project = ProjectPreferencesTest.getProject(projectName);
        try {
            project.create(this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            File folder = new File(String.valueOf(project.getLocation().toOSString()) + "/.settings");
            folder.mkdir();
            BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(folder.getPath()) + "/" + nodeName + ".prefs"));
            bw.write("#Fri Jan 28 10:28:45 CET 2011\neclipse.preferences.version=1\nKEY=VALUE");
            bw.close();
        }
        catch (IOException e) {
            ProjectPreferencesTest.fail((String)"2.0", (Throwable)e);
        }
        Preferences projectNode = Platform.getPreferencesService().getRootNode().node("project").node(projectName);
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"3.0", (Throwable)e);
        }
        Preferences node = projectNode.node(nodeName);
        ProjectPreferencesTest.assertEquals((String)"VALUE", (String)node.get("KEY", null));
        node.put("NEW_KEY", "NEW_VALUE");
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"4.0", (Throwable)e);
        }
        try {
            File folder = new File(String.valueOf(project.getLocation().toOSString()) + "/.settings");
            BufferedReader br = new BufferedReader(new FileReader(String.valueOf(folder.getPath()) + "/" + nodeName + ".prefs"));
            ArrayList<String> lines = new ArrayList<String>();
            String line = br.readLine();
            while (line != null) {
                if (!line.startsWith("#") && !line.startsWith("eclipse.preferences.version")) {
                    lines.add(line);
                }
                line = br.readLine();
            }
            br.close();
            ProjectPreferencesTest.assertEquals((int)2, (int)lines.size());
            Collections.sort(lines);
            ProjectPreferencesTest.assertTrue((boolean)((String)lines.get(0)).equals("KEY=VALUE"));
            ProjectPreferencesTest.assertTrue((boolean)((String)lines.get(1)).equals("NEW_KEY=NEW_VALUE"));
        }
        catch (IOException e) {
            ProjectPreferencesTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            node.sync();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"6.0", (Throwable)e);
        }
        ProjectPreferencesTest.assertEquals((String)"VALUE", (String)node.get("KEY", null));
        ProjectPreferencesTest.assertEquals((String)"NEW_VALUE", (String)node.get("NEW_KEY", null));
    }

    public void test_384151() throws BackingStoreException, CoreException {
        String newProjectValue;
        String newInstanceValue;
        String systemValue = System.getProperty("line.separator");
        if (systemValue.equals("\n")) {
            newInstanceValue = "\r";
            newProjectValue = "\r\n";
        } else if (systemValue.equals("\r")) {
            newInstanceValue = "\n";
            newProjectValue = "\r\n";
        } else {
            newInstanceValue = "\r";
            newProjectValue = "\n";
        }
        IProject project = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        IEclipsePreferences rootNode = Platform.getPreferencesService().getRootNode();
        Preferences instanceNode = rootNode.node("instance").node("org.eclipse.core.runtime");
        Preferences projectNode = rootNode.node("project").node(project.getName()).node("org.eclipse.core.runtime");
        String oldInstanceValue = instanceNode.get("line.separator", null);
        String oldProjectValue = projectNode.get("line.separator", null);
        String qualifier = "qualifier";
        IFile file = project.getFile((IPath)new Path(".settings/" + qualifier + ".prefs"));
        Preferences node = rootNode.node("project").node(project.getName()).node(qualifier);
        String key = "key";
        try {
            node.put(key, this.getUniqueString());
            node.flush();
            ProjectPreferencesTest.assertEquals((String)"1.0", (String)systemValue, (String)this.getLineSeparatorFromFile(file));
            file.delete(true, this.getMonitor());
            instanceNode.put("line.separator", newInstanceValue);
            instanceNode.flush();
            node.put(key, this.getUniqueString());
            node.flush();
            ProjectPreferencesTest.assertEquals((String)"2.0", (String)newInstanceValue, (String)this.getLineSeparatorFromFile(file));
            file.delete(true, this.getMonitor());
            projectNode.put("line.separator", newProjectValue);
            projectNode.flush();
            node.put(key, this.getUniqueString());
            node.flush();
            String recentlyUsedLineSeparator = this.getLineSeparatorFromFile(file);
            ProjectPreferencesTest.assertEquals((String)"3.0", (String)newProjectValue, (String)recentlyUsedLineSeparator);
            if (oldInstanceValue == null) {
                instanceNode.remove("line.separator");
            } else {
                instanceNode.put("line.separator", oldInstanceValue);
            }
            if (oldProjectValue == null) {
                projectNode.remove("line.separator");
            } else {
                projectNode.put("line.separator", oldProjectValue);
            }
            instanceNode.flush();
            projectNode.flush();
            node.put(key, this.getUniqueString());
            node.flush();
            ProjectPreferencesTest.assertEquals((String)"4.0", (String)recentlyUsedLineSeparator, (String)this.getLineSeparatorFromFile(file));
        }
        finally {
            if (oldInstanceValue == null) {
                instanceNode.remove("line.separator");
            } else {
                instanceNode.put("line.separator", oldInstanceValue);
            }
            instanceNode.flush();
            project.delete(true, this.getMonitor());
        }
    }

    public void test_336211() throws BackingStoreException, CoreException, IOException {
        String projectName = this.getUniqueString();
        String nodeName = "node";
        IProject project = ProjectPreferencesTest.getProject(projectName);
        project.create(this.getMonitor());
        File folder = new File(String.valueOf(project.getLocation().toOSString()) + "/.settings");
        folder.mkdir();
        BufferedWriter bw = new BufferedWriter(new FileWriter(String.valueOf(folder.getPath()) + "/" + nodeName + ".prefs"));
        bw.write("#Fri Jan 28 10:28:45 CET 2011\neclipse.preferences.version=1\nKEY=VALUE");
        bw.close();
        Preferences projectNode = Platform.getPreferencesService().getRootNode().node("project").node(projectName);
        ProjectPreferencesTest.assertFalse((boolean)projectNode.nodeExists(nodeName));
        Preferences node = projectNode.node(nodeName);
        project.open(this.getMonitor());
        ProjectPreferencesTest.assertTrue((node == projectNode.node(nodeName) ? 1 : 0) != 0);
        ProjectPreferencesTest.assertEquals((String)"VALUE", (String)node.get("KEY", null));
    }

    public void testProjectOpenClose() {
        IProject project = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        String qualifier = this.getUniqueString();
        String key = this.getUniqueString();
        String value = this.getUniqueString();
        IEclipsePreferences node = new ProjectScope(project).getNode(qualifier);
        node.put(key, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            project.close(this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"1.1", (Throwable)e);
        }
        try {
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"2.0", (Throwable)e);
        }
        node = new ProjectScope(project).getNode(qualifier);
        ProjectPreferencesTest.assertEquals((String)"2.1", (String)value, (String)node.get(key, null));
    }

    public void testContentType() {
        IContentType prefsType = Platform.getContentTypeManager().getContentType("org.eclipse.core.resources.preferences");
        ProjectPreferencesTest.assertNotNull((String)"1.0", (Object)prefsType);
        IContentType associatedType = Platform.getContentTypeManager().findContentTypeFor("some.qualifier.prefs");
        ProjectPreferencesTest.assertEquals((String)"1.1", (Object)prefsType, (Object)associatedType);
    }

    public void testListenerOnChangeFile() {
        InputStream input;
        Properties props;
        String actual;
        Tracer tracer;
        IEclipsePreferences node;
        String value;
        String key;
        String qualifier;
        IProject project;
        block20: {
            project = ProjectPreferencesTest.getProject(this.getUniqueString());
            qualifier = "org.eclipse.core.tests.resources";
            key = "key" + this.getUniqueString();
            value = "value" + this.getUniqueString();
            ProjectScope projectContext = new ProjectScope(project);
            this.ensureExistsInWorkspace((IResource)project, true);
            node = projectContext.getNode(qualifier);
            node.put(key, value);
            tracer = new Tracer();
            node.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)tracer);
            actual = node.get(key, null);
            ProjectPreferencesTest.assertNotNull((String)"1.0", (Object)actual);
            ProjectPreferencesTest.assertEquals((String)"1.1", (String)value, (String)actual);
            try {
                node.flush();
            }
            catch (BackingStoreException e) {
                ProjectPreferencesTest.fail((String)"0.0", (Throwable)e);
            }
            File file = ProjectPreferencesTest.getFileInFilesystem(project, qualifier);
            props = new Properties();
            input = null;
            try {
                try {
                    input = new BufferedInputStream(new FileInputStream(file));
                    props.load(input);
                }
                catch (IOException e) {
                    ProjectPreferencesTest.fail((String)"1.0", (Throwable)e);
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException iOException) {}
            }
        }
        tracer.log.setLength(0);
        String newKey = "newKey" + this.getUniqueString();
        String newValue = "newValue" + this.getUniqueString();
        props.put(newKey, newValue);
        IFile workspaceFile = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try {
            props.store(output, null);
        }
        catch (IOException e) {
            ProjectPreferencesTest.fail((String)"2.0", (Throwable)e);
        }
        input = new ByteArrayInputStream(output.toByteArray());
        try {
            workspaceFile.setContents(input, 0, this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"2.1", (Throwable)e);
        }
        actual = node.get(key, null);
        ProjectPreferencesTest.assertEquals((String)"4.1", (String)value, (String)actual);
        actual = node.get(newKey, null);
        ProjectPreferencesTest.assertEquals((String)"4.2", (String)newValue, (String)actual);
        ProjectPreferencesTest.assertEquals((String)"4.3", (String)("[" + newKey + ":null->S" + newValue + "]"), (String)tracer.log.toString());
    }

    private static IProject getProject(String name) {
        return ProjectPreferencesTest.getWorkspace().getRoot().getProject(name);
    }

    private static IFile getFileInWorkspace(IProject project, String qualifier) {
        return project.getFile(new Path(DIR_NAME).append(qualifier).addFileExtension(FILE_EXTENSION));
    }

    private static File getFileInFilesystem(IProject project, String qualifier) {
        return project.getLocation().append(DIR_NAME).append(qualifier).addFileExtension(FILE_EXTENSION).toFile();
    }

    public void testLoadIsImport() {
        IProject project = ProjectPreferencesTest.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        ProjectScope context = new ProjectScope(project);
        String qualifier = "test.load.is.import";
        IEclipsePreferences node = context.getNode(qualifier);
        String key = "key";
        String oldValue = "old value";
        String newValue = "new value";
        IPreferencesService service = Platform.getPreferencesService();
        node.put(key, oldValue);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"1.99", (Throwable)e);
        }
        ProjectPreferencesTest.assertEquals((String)"1.00", (String)oldValue, (String)node.get(key, null));
        File fileInFS = ProjectPreferencesTest.getFileInFilesystem(project, qualifier);
        BufferedInputStream input = null;
        OutputStream output = null;
        byte[] buffer = null;
        try {
            input = new BufferedInputStream(new FileInputStream(fileInFS));
            output = new ByteArrayOutputStream(1024);
            this.transferData(input, output);
            buffer = output.toByteArray();
        }
        catch (IOException e) {
            ProjectPreferencesTest.fail((String)"2.99", (Throwable)e);
        }
        IFile fileInWS = ProjectPreferencesTest.getFileInWorkspace(project, qualifier);
        try {
            fileInWS.delete(0, this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"3.90", (Throwable)e);
        }
        ProjectPreferencesTest.assertTrue((String)"3.0", (!fileInWS.exists() ? 1 : 0) != 0);
        ProjectPreferencesTest.assertTrue((String)"3.1", (!fileInFS.exists() ? 1 : 0) != 0);
        IEclipsePreferences projectNode = (IEclipsePreferences)service.getRootNode().node("project").node(project.getName());
        try {
            ProjectPreferencesTest.assertTrue((String)"3.2", (boolean)this.isNodeCleared((Preferences)projectNode, new String[]{qualifier}));
        }
        catch (BackingStoreException e) {
            ProjectPreferencesTest.fail((String)"3.91", (Throwable)e);
        }
        try {
            output = new BufferedOutputStream(new FileOutputStream(fileInFS));
        }
        catch (FileNotFoundException e) {
            ProjectPreferencesTest.fail((String)"4.90", (Throwable)e);
        }
        input = new BufferedInputStream(new ByteArrayInputStream(buffer));
        this.transferData(input, output);
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            ProjectPreferencesTest.fail((String)"4.91", (Throwable)e);
        }
        this.waitForBuild();
        node = context.getNode(qualifier);
        ProjectPreferencesTest.assertEquals((String)"5.0", (String)newValue, (String)node.get(key, null));
    }

    private boolean isNodeCleared(Preferences node, String[] childrenNames) throws BackingStoreException {
        if (node.keys().length != 0) {
            return false;
        }
        Preferences childNode = null;
        String[] stringArray = childrenNames;
        int n = childrenNames.length;
        int n2 = 0;
        while (n2 < n) {
            String childrenName = stringArray[n2];
            childNode = node.node(childrenName);
            if (!this.isNodeCleared(childNode, childNode.childrenNames())) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public void testChildrenNamesAgainstInitialize() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode("");
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        IEclipsePreferences node = new ProjectScope(project1).getNode("");
        String[] childrenNames = node.childrenNames();
        ProjectPreferencesTest.assertEquals((int)1, (int)childrenNames.length);
        ProjectPreferencesTest.assertEquals((String)nodeA, (String)childrenNames[0]);
        node = node.node(nodeA);
        childrenNames = node.childrenNames();
        ProjectPreferencesTest.assertEquals((int)1, (int)childrenNames.length);
        ProjectPreferencesTest.assertEquals((String)nodeB, (String)childrenNames[0]);
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    public void testChildrenNamesAgainstLoad() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA);
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        IEclipsePreferences node = new ProjectScope(project1).getNode(nodeA);
        String[] childrenNames = node.childrenNames();
        ProjectPreferencesTest.assertEquals((int)1, (int)childrenNames.length);
        ProjectPreferencesTest.assertEquals((String)nodeB, (String)childrenNames[0]);
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    public void testClear() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        node.clear();
        ProjectPreferencesTest.assertEquals((int)0, (int)node.keys().length);
        ProjectPreferencesTest.assertNull((Object)node.get(key, null));
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    public void testGet() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)node.get(key, null));
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    public void testKeys() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        String[] keys = node.keys();
        ProjectPreferencesTest.assertEquals((int)1, (int)keys.length);
        ProjectPreferencesTest.assertEquals((String)key, (String)keys[0]);
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    public void testNodeExistsAgainstInitialize() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode("nodeC");
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        IEclipsePreferences node = new ProjectScope(project1).getNode("");
        ProjectPreferencesTest.assertTrue((boolean)node.nodeExists(nodeA));
        node = node.node(nodeA);
        ProjectPreferencesTest.assertTrue((boolean)node.nodeExists(nodeB));
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    public void testNodeExistsAgainstLoad() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node("nodeC");
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        IEclipsePreferences node = new ProjectScope(project1).getNode(nodeA);
        ProjectPreferencesTest.assertTrue((boolean)node.nodeExists(nodeB));
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    public void testPut() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        String anotherValue = "anotherValue";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        node.put(key, anotherValue);
        ProjectPreferencesTest.assertEquals((String)anotherValue, (String)node.get(key, null));
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    public void testRemove() throws BackingStoreException, CoreException {
        String nodeA = "nodeA";
        String nodeB = "nodeB";
        String key = "key";
        String value = "value";
        IProject project1 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.create(this.getMonitor());
        project1.open(this.getMonitor());
        Preferences prefs1 = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        prefs1.put(key, value);
        prefs1.flush();
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs1.get(key, null));
        IProject project2 = ProjectPreferencesTest.getProject(this.getUniqueString());
        project1.move(project2.getFullPath(), 0, this.getMonitor());
        Preferences prefs2 = new ProjectScope(project2).getNode(nodeA).node(nodeB);
        ProjectPreferencesTest.assertEquals((String)value, (String)prefs2.get(key, null));
        new ProjectScope(project1).getNode(nodeA).node(nodeB);
        project2.move(project1.getFullPath(), 0, this.getMonitor());
        Preferences node = new ProjectScope(project1).getNode(nodeA).node(nodeB);
        node.remove(key);
        ProjectPreferencesTest.assertNull((Object)node.get(key, null));
        project1.delete(true, this.getMonitor());
        project2.delete(true, this.getMonitor());
    }

    class Tracer
    implements IEclipsePreferences.IPreferenceChangeListener {
        public StringBuffer log = new StringBuffer();

        Tracer() {
        }

        private String typeCode(Object value) {
            if (value == null) {
                return "";
            }
            if (value instanceof Boolean) {
                return "B";
            }
            if (value instanceof Integer) {
                return "I";
            }
            if (value instanceof Long) {
                return "L";
            }
            if (value instanceof Float) {
                return "F";
            }
            if (value instanceof Double) {
                return "D";
            }
            if (value instanceof String) {
                return "S";
            }
            ProjectPreferencesTest.assertTrue((String)"0.0", (boolean)false);
            return null;
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            this.log.append("[");
            this.log.append(event.getKey());
            this.log.append(":");
            this.log.append(this.typeCode(event.getOldValue()));
            this.log.append(event.getOldValue() == null ? "null" : event.getOldValue());
            this.log.append("->");
            this.log.append(this.typeCode(event.getNewValue()));
            this.log.append(event.getNewValue() == null ? "null" : event.getNewValue());
            this.log.append("]");
        }
    }
}

