/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.utils;

import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.filesystem.FileSystemTest;

public class FileUtilTest
extends FileSystemTest {
    private IPath baseTestDir;

    public static Test suite() {
        return new TestSuite(FileUtilTest.class);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.baseTestDir = this.getRandomLocation();
        this.baseTestDir.toFile().mkdirs();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.ensureDoesNotExistInFileSystem(this.baseTestDir.toFile());
    }

    public void testRealPath() throws Exception {
        IPath realPath = this.baseTestDir.append("Test.TXT");
        realPath.toFile().createNewFile();
        IPath testPath = EFS.getLocalFileSystem().isCaseSensitive() ? realPath : Path.fromOSString((String)realPath.toOSString().toLowerCase());
        FileUtilTest.assertEquals((Object)realPath, (Object)FileUtil.realPath((IPath)testPath));
    }

    public void testRealPathOfNonexistingFile() throws Exception {
        IPath realPath = this.baseTestDir.append("ExistingDir");
        realPath.toFile().mkdirs();
        IPath testPath = EFS.getLocalFileSystem().isCaseSensitive() ? realPath : Path.fromOSString((String)realPath.toOSString().toLowerCase());
        String suffix = "NonexistingDir/NonexistingFile.txt";
        FileUtilTest.assertEquals((Object)realPath.append(suffix), (Object)FileUtil.realPath((IPath)testPath.append(suffix)));
    }

    public void testRealURI() throws Exception {
        IPath realPath = this.baseTestDir.append("Test.TXT");
        realPath.toFile().createNewFile();
        IPath testPath = EFS.getLocalFileSystem().isCaseSensitive() ? realPath : Path.fromOSString((String)realPath.toOSString().toLowerCase());
        URI realURI = URIUtil.toURI((IPath)realPath);
        URI testURI = URIUtil.toURI((IPath)testPath);
        FileUtilTest.assertEquals((Object)realURI, (Object)FileUtil.realURI((URI)testURI));
    }
}

