/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.internal.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.utils.ObjectMap;
import org.eclipse.core.tests.resources.ResourceTest;

public class ObjectMapTest
extends ResourceTest {
    private static final int MAXIMUM = 100;
    private Object[] values;

    public ObjectMapTest() {
    }

    public ObjectMapTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(ObjectMapTest.class);
    }

    public void testPut() {
        Integer key;
        ObjectMap map = new ObjectMap();
        int max = 100;
        Object[] values = new Object[max];
        int i = 0;
        while (i < max) {
            values[i] = new Long(System.currentTimeMillis());
            ++i;
        }
        i = 0;
        while (i < values.length) {
            key = i;
            map.put((Object)key, values[i]);
            ObjectMapTest.assertTrue((String)("2.0." + i), (boolean)map.containsKey((Object)key));
            ObjectMapTest.assertTrue((String)("2.1." + i), (boolean)map.containsValue(values[i]));
            ObjectMapTest.assertEquals((String)("2.2." + i), (int)(i + 1), (int)map.size());
            ++i;
        }
        ObjectMapTest.assertEquals((String)"3.0", (int)max, (int)map.size());
        i = 0;
        while (i < values.length) {
            key = i;
            ObjectMapTest.assertTrue((String)("3.1." + i), (boolean)map.containsKey((Object)key));
            ObjectMapTest.assertNotNull((String)("3.2." + i), (Object)map.get((Object)key));
            ++i;
        }
    }

    public void testPutEmptyMap() {
        ObjectMap map = new ObjectMap(new HashMap());
        map.put(new Object(), new Object());
    }

    public void testRemove() {
        ObjectMap<Integer, Object> map = this.populateMap(100);
        int i = 99;
        while (i >= 0) {
            Integer key = i;
            map.remove((Object)key);
            ObjectMapTest.assertTrue((String)("2.0." + i), (!map.containsKey((Object)key) ? 1 : 0) != 0);
            ObjectMapTest.assertEquals((String)("2.1," + i), (int)i, (int)map.size());
            int j = 0;
            while (j < i) {
                ObjectMapTest.assertTrue((String)("2.2." + j), (boolean)map.containsKey((Object)j));
                ++j;
            }
            --i;
        }
        ObjectMapTest.assertEquals((String)"3.0", (int)0, (int)map.size());
    }

    public void testContains() {
        ObjectMap<Integer, Object> map = this.populateMap(100);
        int i = 0;
        while (i < 100) {
            ObjectMapTest.assertTrue((String)("2.0." + i), (boolean)map.containsKey((Object)i));
            ObjectMapTest.assertTrue((String)("2.1." + i), (boolean)map.containsValue(this.values[i]));
            ++i;
        }
        ObjectMapTest.assertFalse((String)"3.0", (boolean)map.containsKey((Object)101));
        ObjectMapTest.assertFalse((String)"3.1", (boolean)map.containsKey((Object)-1));
        ObjectMapTest.assertFalse((String)"3.2", (boolean)map.containsValue(null));
        ObjectMapTest.assertFalse((String)"3.3", (boolean)map.containsValue((Object)this.getRandomString()));
    }

    public void testValues() {
        ObjectMap<Integer, Object> map = this.populateMap(100);
        Collection result = map.values();
        int i = 0;
        while (i < 100) {
            ObjectMapTest.assertTrue((String)("2.0." + i), (boolean)result.contains(this.values[i]));
            ++i;
        }
    }

    public void testKeySet() {
        ObjectMap<Integer, Object> map = this.populateMap(100);
        Set keys = map.keySet();
        ObjectMapTest.assertEquals((String)"1.0", (int)100, (int)keys.size());
    }

    public void testEntrySet() {
        ObjectMap<Integer, Object> map = this.populateMap(100);
        Set entries = map.entrySet();
        int i = 0;
        while (i < 100) {
            ObjectMapTest.assertTrue((String)("1.0." + i), (boolean)this.contains(entries, this.values[i]));
            ++i;
        }
    }

    private boolean contains(Set<Map.Entry<Integer, Object>> set, Object value) {
        for (Map.Entry<Integer, Object> entry : set) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    private ObjectMap<Integer, Object> populateMap(int max) {
        ObjectMap map = new ObjectMap();
        this.values = new Object[max];
        int i = 0;
        while (i < max) {
            this.values[i] = new Long(System.currentTimeMillis());
            map.put((Object)i, this.values[i]);
            ++i;
        }
        ObjectMapTest.assertEquals((String)"#populateMap", (int)max, (int)map.size());
        return map;
    }

    public void testBug_62231() {
        ObjectMap map = new ObjectMap();
        try {
            map.entrySet();
        }
        catch (NullPointerException nullPointerException) {
            ObjectMapTest.fail((String)"1.0");
        }
        map.clear();
        try {
            map.entrySet();
        }
        catch (NullPointerException nullPointerException) {
            ObjectMapTest.fail((String)"1.1");
        }
    }
}

