/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class IResourceChangeEventTest
extends ResourceTest {
    protected IProject project1;
    protected IProject project2;
    protected IFolder folder1;
    protected IFolder folder2;
    protected IFolder folder3;
    protected IFile file1;
    protected IFile file2;
    protected IFile file3;
    protected IMarker marker1;
    protected IMarker marker2;
    protected IMarker marker3;
    protected IResource[] allResources;

    public IResourceChangeEventTest() {
    }

    public IResourceChangeEventTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.project1 = IResourceChangeEventTest.getWorkspace().getRoot().getProject("Project1");
        this.project2 = IResourceChangeEventTest.getWorkspace().getRoot().getProject("Project2");
        this.folder1 = this.project1.getFolder("Folder1");
        this.folder2 = this.folder1.getFolder("Folder2");
        this.folder3 = this.folder1.getFolder("Folder3");
        this.file1 = this.folder1.getFile("File1");
        this.file2 = this.folder1.getFile("File2");
        this.file3 = this.folder2.getFile("File3");
        this.allResources = new IResource[]{this.project1, this.project2, this.folder1, this.folder2, this.folder3, this.file1, this.file2, this.file3};
        IWorkspaceRunnable body = monitor -> {
            this.ensureExistsInWorkspace(this.allResources, true);
            this.marker2 = this.file2.createMarker("org.eclipse.core.resources.bookmark");
            this.marker3 = this.file3.createMarker("org.eclipse.core.resources.bookmark");
        };
        try {
            IResourceChangeEventTest.getWorkspace().run(body, this.getMonitor());
        }
        catch (CoreException e) {
            IResourceChangeEventTest.fail((String)"1.0", (Throwable)e);
        }
    }

    public static Test suite() {
        return new TestSuite(IResourceChangeEventTest.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.ensureDoesNotExistInWorkspace((IResource)IResourceChangeEventTest.getWorkspace().getRoot());
    }

    public void testFindMarkerDeltas() {
        IResourceChangeListener listener = event -> {
            IMarkerDelta[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
            this.verifyDeltas(deltas);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", true);
            this.verifyDeltas(deltas);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", false);
            IResourceChangeEventTest.assertNotNull((String)"10.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"10.1", (deltas.length == 0 ? 1 : 0) != 0);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", true);
            this.verifyDeltas(deltas);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
            IResourceChangeEventTest.assertNotNull((String)"12.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"12.1", (deltas.length == 0 ? 1 : 0) != 0);
            deltas = event.findMarkerDeltas(null, true);
            this.verifyDeltas(deltas);
            deltas = event.findMarkerDeltas(null, false);
            this.verifyDeltas(deltas);
        };
        IResourceChangeEventTest.getWorkspace().addResourceChangeListener(listener);
        IWorkspaceRunnable body = monitor -> {
            this.marker1 = this.file1.createMarker("org.eclipse.core.resources.bookmark");
            this.marker2.delete();
            this.marker3.setAttribute("Foo", true);
        };
        try {
            try {
                IResourceChangeEventTest.getWorkspace().run(body, this.getMonitor());
            }
            catch (CoreException e) {
                IResourceChangeEventTest.fail((String)"Exception1", (Throwable)e);
                IResourceChangeEventTest.getWorkspace().removeResourceChangeListener(listener);
            }
        }
        finally {
            IResourceChangeEventTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    public void testFindMarkerDeltasInEmptyDelta() {
        IResourceChangeListener listener = event -> {
            IMarkerDelta[] deltas = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
            IResourceChangeEventTest.assertNotNull((String)"1.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"1.1", (deltas.length == 0 ? 1 : 0) != 0);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", true);
            IResourceChangeEventTest.assertNotNull((String)"2.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"2.1", (deltas.length == 0 ? 1 : 0) != 0);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", false);
            IResourceChangeEventTest.assertNotNull((String)"3.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"3.1", (deltas.length == 0 ? 1 : 0) != 0);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.marker", true);
            IResourceChangeEventTest.assertNotNull((String)"4.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"4.1", (deltas.length == 0 ? 1 : 0) != 0);
            deltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
            IResourceChangeEventTest.assertNotNull((String)"5.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"5.1", (deltas.length == 0 ? 1 : 0) != 0);
            deltas = event.findMarkerDeltas(null, true);
            IResourceChangeEventTest.assertNotNull((String)"6.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"6.1", (deltas.length == 0 ? 1 : 0) != 0);
            deltas = event.findMarkerDeltas(null, false);
            IResourceChangeEventTest.assertNotNull((String)"7.0", (Object)deltas);
            IResourceChangeEventTest.assertTrue((String)"7.1", (deltas.length == 0 ? 1 : 0) != 0);
        };
        IResourceChangeEventTest.getWorkspace().addResourceChangeListener(listener);
        try {
            try {
                this.file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            }
            catch (CoreException e) {
                IResourceChangeEventTest.fail((String)"Exception2", (Throwable)e);
                IResourceChangeEventTest.getWorkspace().removeResourceChangeListener(listener);
            }
        }
        finally {
            IResourceChangeEventTest.getWorkspace().removeResourceChangeListener(listener);
        }
    }

    protected void verifyDeltas(IMarkerDelta[] deltas) {
        IResourceChangeEventTest.assertNotNull((String)"1.0", (Object)deltas);
        IResourceChangeEventTest.assertTrue((String)"1.1", (deltas.length == 3 ? 1 : 0) != 0);
        boolean found1 = false;
        boolean found2 = false;
        boolean found3 = false;
        int i = 0;
        while (i < deltas.length) {
            IResourceChangeEventTest.assertTrue((String)("kind" + i), (boolean)deltas[i].getType().equals("org.eclipse.core.resources.bookmark"));
            long id = deltas[i].getId();
            if (id == this.marker1.getId()) {
                found1 = true;
                IResourceChangeEventTest.assertTrue((String)"2.0", (deltas[i].getKind() == 1 ? 1 : 0) != 0);
            } else if (id == this.marker2.getId()) {
                found2 = true;
                IResourceChangeEventTest.assertTrue((String)"3.0", (deltas[i].getKind() == 2 ? 1 : 0) != 0);
            } else if (id == this.marker3.getId()) {
                found3 = true;
                IResourceChangeEventTest.assertTrue((String)"4.0", (deltas[i].getKind() == 4 ? 1 : 0) != 0);
            } else {
                IResourceChangeEventTest.assertTrue((String)"4.99", (boolean)false);
            }
            ++i;
        }
        IResourceChangeEventTest.assertTrue((String)"5.0", (boolean)found1);
        IResourceChangeEventTest.assertTrue((String)"5.1", (boolean)found2);
        IResourceChangeEventTest.assertTrue((String)"5.2", (boolean)found3);
    }
}

