/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.resources.projectvariables.ProjectLocationVariableResolver;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.tests.resources.ResourceTest;

public class LinkedResourceSyncMoveAndCopyTest
extends ResourceTest {
    protected IProject existingProject;
    protected IProject otherExistingProject;

    public static Test suite() {
        return new TestSuite(LinkedResourceSyncMoveAndCopyTest.class);
    }

    public LinkedResourceSyncMoveAndCopyTest() {
    }

    public LinkedResourceSyncMoveAndCopyTest(String name) {
        super(name);
    }

    protected void doCleanup() throws Exception {
        this.ensureExistsInWorkspace(new IResource[]{this.existingProject, this.otherExistingProject}, true);
    }

    protected IPath resolve(IPath path) {
        return path;
    }

    protected URI resolve(URI uri) {
        return uri;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.existingProject = LinkedResourceSyncMoveAndCopyTest.getWorkspace().getRoot().getProject("ExistingProject");
        this.otherExistingProject = LinkedResourceSyncMoveAndCopyTest.getWorkspace().getRoot().getProject("OtherExistingProject");
        this.doCleanup();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void internalMovedAndCopyTest(IResource resource, int copyMoveFlag, boolean copyMoveSucceeds) {
    }

    public void testFileLinkedToNonExistent_Deep() {
        IFile fileLink = this.existingProject.getFile(this.getUniqueString());
        IPath fileLocation = this.getRandomLocation();
        try {
            fileLink.createLink(fileLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.0", (Throwable)e);
        }
        try {
            fileLink.setContents((InputStream)new ByteArrayInputStream(this.getRandomString().getBytes()), 0, this.getMonitor());
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.1");
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.assertEquals((String)"1.2", (int)269, (int)e.getStatus().getCode());
        }
        LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"2.0", (boolean)fileLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)fileLink, 0, false);
        this.createFileInFileSystem(fileLocation);
        try {
            fileLink.setContents((InputStream)new ByteArrayInputStream(this.getRandomString().getBytes()), 0, this.getMonitor());
            LinkedResourceSyncMoveAndCopyTest.fail((String)"2.1");
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.assertEquals((String)"2.2", (int)274, (int)e.getStatus().getCode());
        }
        try {
            LinkedResourceSyncMoveAndCopyTest.assertFalse((String)"3.0", (boolean)fileLink.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)fileLink, 0, false);
            try {
                fileLink.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceSyncMoveAndCopyTest.fail((String)"4.0", (Throwable)e);
            }
            LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"5.0", (boolean)fileLink.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)fileLink, 0, true);
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testFileLinkedToNonExistent_Shallow() {
        IFile fileLink = this.existingProject.getFile(this.getUniqueString());
        IPath fileLocation = this.getRandomLocation();
        try {
            fileLink.createLink(fileLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.0", (Throwable)e);
        }
        LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"2.0", (boolean)fileLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)fileLink, 32, true);
        this.createFileInFileSystem(fileLocation);
        try {
            LinkedResourceSyncMoveAndCopyTest.assertFalse((String)"3.0", (boolean)fileLink.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)fileLink, 32, true);
            try {
                fileLink.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceSyncMoveAndCopyTest.fail((String)"4.0", (Throwable)e);
            }
            LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"5.0", (boolean)fileLink.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)fileLink, 32, true);
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testFolderLinkedToNonExistent_Deep() {
        IFolder folderLink = this.existingProject.getFolder(this.getUniqueString());
        IPath folderLocation = this.getRandomLocation();
        try {
            folderLink.createLink(folderLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.0", (Throwable)e);
        }
        LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"3.0", (boolean)folderLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folderLink, 0, false);
        folderLocation.toFile().mkdir();
        try {
            LinkedResourceSyncMoveAndCopyTest.assertFalse((String)"3.0", (boolean)folderLink.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folderLink, 0, true);
            try {
                folderLink.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceSyncMoveAndCopyTest.fail((String)"4.0", (Throwable)e);
            }
            LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"5.0", (boolean)folderLink.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folderLink, 0, true);
        }
        finally {
            Workspace.clear((File)this.resolve(folderLocation).toFile());
        }
    }

    public void testFolderLinkedToNonExistent_Shallow() {
        IFolder folderLink = this.existingProject.getFolder(this.getUniqueString());
        IPath folderLocation = this.getRandomLocation();
        try {
            folderLink.createLink(folderLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.0", (Throwable)e);
        }
        LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"2.0", (boolean)folderLink.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folderLink, 32, true);
        folderLocation.toFile().mkdir();
        try {
            LinkedResourceSyncMoveAndCopyTest.assertFalse((String)"3.0", (boolean)folderLink.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folderLink, 32, true);
            try {
                folderLink.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceSyncMoveAndCopyTest.fail((String)"4.0", (Throwable)e);
            }
            LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"5.0", (boolean)folderLink.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folderLink, 32, true);
        }
        finally {
            Workspace.clear((File)this.resolve(folderLocation).toFile());
        }
    }

    public void _testMoveFolderWithLinksToNonExisitngLocations_withShallow() {
        IFolder folderWithLinks = this.existingProject.getFolder(this.getUniqueString());
        try {
            folderWithLinks.create(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.0", (Throwable)e);
        }
        IPath fileLocation = this.getRandomLocation();
        IFile linkedFile = folderWithLinks.getFile(this.getUniqueString());
        try {
            linkedFile.createLink(fileLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            folderWithLinks.move(this.otherExistingProject.getFolder(this.getUniqueString()).getFullPath(), 32, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            folderWithLinks.move(this.otherExistingProject.getFolder(this.getUniqueString()).getFullPath(), 0, this.getMonitor());
            LinkedResourceSyncMoveAndCopyTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        LinkedResourceSyncMoveAndCopyTest.assertFalse((String)"5.0", (boolean)folderWithLinks.exists());
        LinkedResourceSyncMoveAndCopyTest.assertFalse((String)"6.0", (boolean)linkedFile.exists());
    }

    public void _testCopyFolderWithLinksToNonExisitngLocations_withShallow() {
        IFolder folderWithLinks = this.existingProject.getFolder(this.getUniqueString());
        try {
            folderWithLinks.create(true, true, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.0", (Throwable)e);
        }
        IPath fileLocation = this.getRandomLocation();
        IFile linkedFile = folderWithLinks.getFile(this.getUniqueString());
        try {
            linkedFile.createLink(fileLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"2.0", (Throwable)e);
        }
        try {
            folderWithLinks.copy(this.otherExistingProject.getFolder(this.getUniqueString()).getFullPath(), 32, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            folderWithLinks.copy(this.otherExistingProject.getFolder(this.getUniqueString()).getFullPath(), 0, this.getMonitor());
            LinkedResourceSyncMoveAndCopyTest.fail((String)"3.0");
        }
        catch (CoreException coreException) {}
        LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"5.0", (boolean)folderWithLinks.exists());
        LinkedResourceSyncMoveAndCopyTest.assertTrue((String)"6.0", (boolean)linkedFile.exists());
    }

    public void testFolderWithFileLinkedToNonExistent_Deep() {
        IFolder folder = this.existingProject.getFolder(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)folder, true);
        IFile fileLinkInFolder = folder.getFile(this.getUniqueString());
        IPath fileLocation = this.getRandomLocation();
        try {
            fileLinkInFolder.createLink(fileLocation, 16, this.getMonitor());
        }
        catch (CoreException e1) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"4.99", (Throwable)e1);
        }
        LinkedResourceSyncMoveAndCopyTest.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 0, false);
        this.createFileInFileSystem(fileLocation);
        try {
            LinkedResourceSyncMoveAndCopyTest.assertFalse((boolean)folder.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folder, 0, false);
            try {
                folder.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceSyncMoveAndCopyTest.fail((String)"4.99", (Throwable)e);
            }
            LinkedResourceSyncMoveAndCopyTest.assertTrue((boolean)folder.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folder, 0, true);
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testFolderWithFileLinkedToNonExistent_Shallow() {
        IFolder folder = this.existingProject.getFolder(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)folder, true);
        IFile fileLinkInFolder = folder.getFile(this.getUniqueString());
        IPath fileLocation = this.getRandomLocation();
        try {
            fileLinkInFolder.createLink(fileLocation, 16, this.getMonitor());
        }
        catch (CoreException e1) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"4.99", (Throwable)e1);
        }
        LinkedResourceSyncMoveAndCopyTest.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 32, true);
        this.createFileInFileSystem(fileLocation);
        try {
            LinkedResourceSyncMoveAndCopyTest.assertFalse((boolean)folder.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folder, 32, true);
            try {
                folder.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceSyncMoveAndCopyTest.fail((String)"4.99", (Throwable)e);
            }
            LinkedResourceSyncMoveAndCopyTest.assertTrue((boolean)folder.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folder, 32, true);
        }
        finally {
            Workspace.clear((File)this.resolve(fileLocation).toFile());
        }
    }

    public void testFolderWithFolderLinkedToNonExistent_Deep() {
        IFolder folder = this.existingProject.getFolder(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)folder, true);
        IFolder folderLinkInFolder = folder.getFolder(this.getUniqueString());
        IPath folderLocation = this.getRandomLocation();
        try {
            folderLinkInFolder.createLink(folderLocation, 16, this.getMonitor());
        }
        catch (CoreException e1) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"4.99", (Throwable)e1);
        }
        LinkedResourceSyncMoveAndCopyTest.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 0, false);
        folderLocation.toFile().mkdir();
        try {
            LinkedResourceSyncMoveAndCopyTest.assertFalse((boolean)folder.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folder, 0, true);
            try {
                folder.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceSyncMoveAndCopyTest.fail((String)"4.99", (Throwable)e);
            }
            LinkedResourceSyncMoveAndCopyTest.assertTrue((boolean)folder.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folder, 0, true);
        }
        finally {
            Workspace.clear((File)this.resolve(folderLocation).toFile());
        }
    }

    public void testFolderWithFolderLinkedToNonExistent_Shallow() {
        IFolder folder = this.existingProject.getFolder(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)folder, true);
        IFolder folderLinkInFolder = folder.getFolder(this.getUniqueString());
        IPath folderLocation = this.getRandomLocation();
        try {
            folderLinkInFolder.createLink(folderLocation, 16, this.getMonitor());
        }
        catch (CoreException e1) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"4.99", (Throwable)e1);
        }
        LinkedResourceSyncMoveAndCopyTest.assertTrue((boolean)folder.isSynchronized(2));
        this.internalMovedAndCopyTest((IResource)folder, 32, true);
        folderLocation.toFile().mkdir();
        try {
            LinkedResourceSyncMoveAndCopyTest.assertFalse((boolean)folder.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folder, 32, true);
            try {
                folder.refreshLocal(2, this.getMonitor());
            }
            catch (CoreException e) {
                LinkedResourceSyncMoveAndCopyTest.fail((String)"4.99", (Throwable)e);
            }
            LinkedResourceSyncMoveAndCopyTest.assertTrue((boolean)folder.isSynchronized(2));
            this.internalMovedAndCopyTest((IResource)folder, 32, true);
        }
        finally {
            Workspace.clear((File)this.resolve(folderLocation).toFile());
        }
    }

    public void test361201() {
        String linkName = this.getUniqueString();
        IFile fileLink = this.existingProject.getFile(linkName);
        IFile file = this.existingProject.getFolder("dir").getFile("foo.txt");
        this.ensureExistsInWorkspace((IResource)file.getParent(), true);
        this.ensureExistsInWorkspace(file, "content");
        IPath fileLocation = file.getLocation();
        URI relativeLocation = null;
        try {
            relativeLocation = this.existingProject.getPathVariableManager().convertToRelative(URIUtil.toURI((IPath)fileLocation), true, ProjectLocationVariableResolver.NAME);
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"0.99", (Throwable)e);
        }
        try {
            fileLink.createLink(relativeLocation, 16, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.0", (Throwable)e);
        }
        IProject destination = LinkedResourceSyncMoveAndCopyTest.getWorkspace().getRoot().getProject("DestProject");
        IProjectDescription description = LinkedResourceSyncMoveAndCopyTest.getWorkspace().newProjectDescription(destination.getName());
        this.assertDoesNotExistInWorkspace("1.1", (IResource)destination);
        try {
            this.existingProject.move(description, 32, this.getMonitor());
        }
        catch (CoreException e) {
            LinkedResourceSyncMoveAndCopyTest.fail((String)"1.2", (Throwable)e);
        }
        IProject destProject = ResourcesPlugin.getWorkspace().getRoot().getProject("DestProject");
        this.assertExistsInWorkspace("2.0", (IResource)destProject);
        this.assertExistsInWorkspace("2.1", (IResource)destProject.getFile(linkName));
    }
}

