/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Arrays;
import java.util.Comparator;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.IMarkerSetElement;
import org.eclipse.core.internal.resources.MarkerInfo;
import org.eclipse.core.internal.resources.MarkerSet;
import org.eclipse.core.tests.resources.ResourceTest;

public class MarkerSetTest
extends ResourceTest {
    public MarkerSetTest() {
    }

    public MarkerSetTest(String name) {
        super(name);
    }

    public void assertEquals(String message, IMarkerSetElement[] array1, IMarkerSetElement[] array2) {
        MarkerSetTest.assertNotNull((String)message, (Object)array1);
        MarkerSetTest.assertNotNull((String)message, (Object)array2);
        MarkerSetTest.assertEquals((String)message, (int)array1.length, (int)array2.length);
        IMarkerSetElement[] m1 = new IMarkerSetElement[array1.length];
        System.arraycopy(array1, 0, m1, 0, array1.length);
        IMarkerSetElement[] m2 = new IMarkerSetElement[array2.length];
        System.arraycopy(array2, 0, m2, 0, array2.length);
        Comparator compare = (e1, e2) -> {
            long id2;
            long id1 = e1.getId();
            if (id1 == (id2 = e2.getId())) {
                return 0;
            }
            return id1 < id2 ? -1 : 1;
        };
        Arrays.sort(m1, compare);
        Arrays.sort(m2, compare);
        int i = 0;
        while (i < m1.length) {
            MarkerSetTest.assertEquals((String)message, (long)m1[i].getId(), (long)m2[i].getId());
            ++i;
        }
    }

    public static Test suite() {
        return new TestSuite(MarkerSetTest.class);
    }

    public void testAdd() {
        MarkerSet set = new MarkerSet();
        int max = 100;
        MarkerInfo info = null;
        MarkerInfo[] infos = new MarkerInfo[max];
        int i = 0;
        while (i < max) {
            info = new MarkerInfo();
            info.setId((long)i);
            info.setType("org.eclipse.core.resources.problemmarker");
            info.setAttribute("message", (Object)this.getRandomString(), true);
            infos[i] = info;
            ++i;
        }
        i = 0;
        while (i < infos.length) {
            info = infos[i];
            set.add((IMarkerSetElement)info);
            MarkerSetTest.assertTrue((String)("2.0." + i), (boolean)set.contains(info.getId()));
            MarkerSetTest.assertEquals((String)("2.1." + i), (int)(i + 1), (int)set.size());
            ++i;
        }
        MarkerSetTest.assertEquals((String)"3.0", (int)max, (int)set.size());
        i = 0;
        while (i < infos.length) {
            info = infos[i];
            MarkerSetTest.assertTrue((String)("3.1." + i), (boolean)set.contains(info.getId()));
            MarkerSetTest.assertNotNull((String)("3.2." + i), (Object)set.get(info.getId()));
            ++i;
        }
    }

    public void testElements() {
        MarkerSet set = new MarkerSet();
        int max = 100;
        MarkerInfo info = null;
        MarkerInfo[] infos = new MarkerInfo[max];
        int i = 0;
        while (i < max) {
            info = new MarkerInfo();
            info.setId((long)i);
            info.setType("org.eclipse.core.resources.problemmarker");
            info.setAttribute("message", (Object)this.getRandomString(), true);
            infos[i] = info;
            ++i;
        }
        set.addAll((IMarkerSetElement[])infos);
        MarkerSetTest.assertEquals((String)"1.0", (int)max, (int)set.size());
        this.assertEquals("2.0", set.elements(), (IMarkerSetElement[])infos);
    }

    public void testRemove() {
        MarkerSet set = new MarkerSet();
        int max = 100;
        MarkerInfo info = null;
        MarkerInfo[] infos = new MarkerInfo[max];
        int i = 0;
        while (i < max) {
            info = new MarkerInfo();
            info.setId((long)i);
            info.setType("org.eclipse.core.resources.problemmarker");
            info.setAttribute("message", (Object)this.getRandomString(), true);
            infos[i] = info;
            ++i;
        }
        set.addAll((IMarkerSetElement[])infos);
        MarkerSetTest.assertEquals((String)"1.0", (int)max, (int)set.size());
        i = max - 1;
        while (i >= 0) {
            info = infos[i];
            set.remove((IMarkerSetElement)info);
            MarkerSetTest.assertTrue((String)("2.0." + i), (!set.contains(info.getId()) ? 1 : 0) != 0);
            MarkerSetTest.assertEquals((String)("2.1," + i), (int)i, (int)set.size());
            int j = 0;
            while (j < i) {
                MarkerSetTest.assertTrue((String)("2.2." + j), (boolean)set.contains(infos[j].getId()));
                ++j;
            }
            --i;
        }
        MarkerSetTest.assertEquals((String)"3.0", (int)0, (int)set.size());
    }
}

