/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class MarkersChangeListener
implements IResourceChangeListener {
    protected Hashtable<IPath, Vector<IMarkerDelta>> changes;

    public MarkersChangeListener() {
        this.reset();
    }

    public boolean checkChanges(IResource resource, IMarker[] added, IMarker[] removed, IMarker[] changed) {
        int numChanges;
        Object path = resource == null ? Path.ROOT : resource.getFullPath();
        Vector<Object> v = this.changes.get(path);
        if (v == null) {
            v = new Vector();
        }
        if ((numChanges = (added == null ? 0 : added.length) + (removed == null ? 0 : removed.length) + (changed == null ? 0 : changed.length)) != v.size()) {
            return false;
        }
        int i = 0;
        while (i < v.size()) {
            IMarkerDelta delta = (IMarkerDelta)v.elementAt(i);
            switch (delta.getKind()) {
                case 1: {
                    if (this.contains(added, delta.getMarker())) break;
                    return false;
                }
                case 2: {
                    if (this.contains(removed, delta.getMarker())) break;
                    return false;
                }
                case 4: {
                    if (this.contains(changed, delta.getMarker())) break;
                    return false;
                }
                default: {
                    throw new Error();
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean contains(IMarker[] markers, IMarker marker) {
        if (markers != null) {
            IMarker[] iMarkerArray = markers;
            int n = markers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker marker2 = iMarkerArray[n2];
                if (marker2.equals((Object)marker)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public int numAffectedResources() {
        return this.changes.size();
    }

    public void reset() {
        this.changes = new Hashtable(11);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        this.resourceChanged(event.getDelta());
    }

    protected void resourceChanged(IResourceDelta delta) {
        IResourceDelta[] children;
        if (delta == null) {
            return;
        }
        if ((delta.getFlags() & 0x20000) != 0) {
            IMarkerDelta[] markerDeltas;
            IPath path = delta.getFullPath();
            Vector<Object> v = this.changes.get(path);
            if (v == null) {
                v = new Vector();
                this.changes.put(path, v);
            }
            IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
            int n = markerDeltas.length;
            int n2 = 0;
            while (n2 < n) {
                IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                v.addElement(markerDelta);
                ++n2;
            }
        }
        IResourceDelta[] iResourceDeltaArray = children = delta.getAffectedChildren();
        int n = children.length;
        int n3 = 0;
        while (n3 < n) {
            IResourceDelta element = iResourceDeltaArray[n3];
            this.resourceChanged(element);
            ++n3;
        }
    }
}

