/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.utils.FileUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.internal.resources.SimpleNature;
import org.eclipse.core.tests.resources.ResourceTest;

public class NatureTest
extends ResourceTest {
    public NatureTest() {
    }

    public NatureTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(NatureTest.class);
    }

    protected void setNatures(String message, IProject project, String[] natures, boolean shouldFail) {
        this.setNatures(message, project, natures, shouldFail, false);
    }

    protected void setNatures(String message, IProject project, String[] natures, boolean shouldFail, boolean silent) {
        block4: {
            try {
                IProjectDescription desc = project.getDescription();
                desc.setNatureIds(natures);
                int flags = 2;
                if (silent) {
                    flags |= 0x40;
                }
                project.setDescription(desc, flags, this.getMonitor());
                if (shouldFail) {
                    NatureTest.fail((String)message);
                }
            }
            catch (CoreException e) {
                if (shouldFail) break block4;
                NatureTest.fail((String)message, (Throwable)e);
            }
        }
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        NatureTest.getWorkspace().getRoot().refreshLocal(2, null);
        this.ensureDoesNotExistInWorkspace((IResource)NatureTest.getWorkspace().getRoot());
    }

    public void testInvalidAdditions() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.setNatures("1.0", project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false);
        this.setNatures("2.0", project, new String[]{"org.eclipse.core.tests.resources.simpleNature", "no.such.nature.Missing"}, true);
        try {
            NatureTest.assertTrue((String)"2.1", (boolean)project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
            NatureTest.assertTrue((String)"2.2", (!project.hasNature("no.such.nature.Missing") ? 1 : 0) != 0);
            NatureTest.assertTrue((String)"2.3", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
            NatureTest.assertTrue((String)"2.4", (!project.isNatureEnabled("no.such.nature.Missing") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            NatureTest.fail((String)"2.99", (Throwable)e);
        }
        this.setNatures("3.0", project, new String[]{"org.eclipse.core.tests.resources.simpleNature", "org.eclipse.core.tests.resources.snowNature"}, true);
        try {
            NatureTest.assertTrue((String)"3.1", (boolean)project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
            NatureTest.assertTrue((String)"3.2", (!project.hasNature("org.eclipse.core.tests.resources.snowNature") ? 1 : 0) != 0);
            NatureTest.assertTrue((String)"3.3", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
            NatureTest.assertTrue((String)"3.4", (!project.isNatureEnabled("org.eclipse.core.tests.resources.snowNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            NatureTest.fail((String)"3.99", (Throwable)e);
        }
        this.setNatures("4.0", project, new String[]{"org.eclipse.core.tests.resources.earthNature"}, false);
        this.setNatures("4.1", project, new String[]{"org.eclipse.core.tests.resources.earthNature", "org.eclipse.core.tests.resources.waterNature"}, true);
        try {
            NatureTest.assertTrue((String)"3.1", (boolean)project.hasNature("org.eclipse.core.tests.resources.earthNature"));
            NatureTest.assertTrue((String)"3.2", (!project.hasNature("org.eclipse.core.tests.resources.waterNature") ? 1 : 0) != 0);
            NatureTest.assertTrue((String)"3.3", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.earthNature"));
            NatureTest.assertTrue((String)"3.4", (!project.isNatureEnabled("org.eclipse.core.tests.resources.waterNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            NatureTest.fail((String)"3.99", (Throwable)e);
        }
    }

    public void testInvalidRemovals() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.setNatures("1.0", project, new String[]{"org.eclipse.core.tests.resources.waterNature", "org.eclipse.core.tests.resources.snowNature"}, false);
        this.setNatures("2.0", project, new String[]{"org.eclipse.core.tests.resources.snowNature"}, true);
        try {
            NatureTest.assertTrue((String)"2.1", (boolean)project.hasNature("org.eclipse.core.tests.resources.waterNature"));
            NatureTest.assertTrue((String)"2.2", (boolean)project.hasNature("org.eclipse.core.tests.resources.snowNature"));
            NatureTest.assertTrue((String)"2.3", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.waterNature"));
            NatureTest.assertTrue((String)"2.4", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.snowNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"2.99", (Throwable)e);
        }
    }

    public void testNatureLifecyle() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        this.setNatures("1.0", project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false);
        SimpleNature instance = SimpleNature.getInstance();
        NatureTest.assertTrue((String)"1.1", (boolean)instance.wasConfigured);
        NatureTest.assertTrue((String)"1.2", (!instance.wasDeconfigured ? 1 : 0) != 0);
        instance.reset();
        this.setNatures("1.3", project, new String[0], false);
        instance = SimpleNature.getInstance();
        NatureTest.assertTrue((String)"1.4", (!instance.wasConfigured ? 1 : 0) != 0);
        NatureTest.assertTrue((String)"1.5", (boolean)instance.wasDeconfigured);
        instance.reset();
        this.setNatures("2.0", project, new String[]{"org.eclipse.core.tests.resources.simpleNature"}, false, true);
        instance = SimpleNature.getInstance();
        NatureTest.assertTrue((String)"2.1", (!instance.wasConfigured ? 1 : 0) != 0);
        NatureTest.assertTrue((String)"2.2", (!instance.wasDeconfigured ? 1 : 0) != 0);
        try {
            NatureTest.assertTrue((String)"2.3", (boolean)project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"1.99", (Throwable)e);
        }
        instance.reset();
        this.setNatures("2.3", project, new String[0], false, true);
        instance = SimpleNature.getInstance();
        NatureTest.assertTrue((String)"2.4", (!instance.wasConfigured ? 1 : 0) != 0);
        NatureTest.assertTrue((String)"2.5", (!instance.wasDeconfigured ? 1 : 0) != 0);
        try {
            NatureTest.assertTrue((String)"2.6", (!project.hasNature("org.eclipse.core.tests.resources.simpleNature") ? 1 : 0) != 0);
        }
        catch (CoreException e) {
            NatureTest.fail((String)"2.99", (Throwable)e);
        }
    }

    public void testSimpleNature() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IProject project = ws.getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        String[][] valid = this.getValidNatureSets();
        int i = 0;
        while (i < valid.length) {
            this.setNatures("valid: " + i, project, valid[i], false);
            ++i;
        }
        Object[] currentSet = new String[]{"org.eclipse.core.tests.resources.simpleNature"};
        this.setNatures("1.0", project, (String[])currentSet, false);
        String[][] invalid = this.getInvalidNatureSets();
        int i2 = 0;
        while (i2 < invalid.length) {
            this.setNatures("invalid: " + i2, project, invalid[i2], true);
            try {
                NatureTest.assertTrue((String)"2.0", (boolean)project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
                NatureTest.assertTrue((String)"2.1", (!project.hasNature("org.eclipse.core.tests.resources.earthNature") ? 1 : 0) != 0);
                NatureTest.assertTrue((String)"2.2", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
                NatureTest.assertTrue((String)"2.3", (!project.isNatureEnabled("org.eclipse.core.tests.resources.earthNature") ? 1 : 0) != 0);
                this.assertEquals("2.4", project.getDescription().getNatureIds(), currentSet);
            }
            catch (CoreException e) {
                NatureTest.fail((String)"2.99", (Throwable)e);
            }
            ++i2;
        }
    }

    public void testBug127562Nature() {
        IJobManager manager;
        IProject project;
        IWorkspace ws;
        block13: {
            ws = ResourcesPlugin.getWorkspace();
            project = ws.getRoot().getProject("Project");
            this.ensureExistsInWorkspace((IResource)project, true);
            String[][] valid = this.getValidNatureSets();
            int i = 0;
            while (i < valid.length) {
                this.setNatures("valid: " + i, project, valid[i], false);
                ++i;
            }
            String[] currentSet = new String[]{"org.eclipse.core.tests.resources.bug127562Nature"};
            this.setNatures("1.0", project, currentSet, false, true);
            manager = Job.getJobManager();
            try {
                manager.beginRule(ws.getRuleFactory().modifyRule((IResource)project), null);
                project.getNature("org.eclipse.core.tests.resources.bug127562Nature").configure();
                NatureTest.fail((String)"2.0");
            }
            catch (CoreException coreException) {
                NatureTest.fail((String)"2.1");
                manager.endRule(ws.getRuleFactory().modifyRule((IResource)project));
                break block13;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    manager.endRule(ws.getRuleFactory().modifyRule((IResource)project));
                }
            }
            manager.endRule(ws.getRuleFactory().modifyRule((IResource)project));
        }
        try {
            try {
                manager.beginRule((ISchedulingRule)ws.getRoot(), null);
                project.getNature("org.eclipse.core.tests.resources.bug127562Nature").configure();
            }
            catch (CoreException coreException) {
                NatureTest.fail((String)"3.0");
                manager.endRule((ISchedulingRule)ws.getRoot());
            }
        }
        finally {
            manager.endRule((ISchedulingRule)ws.getRoot());
        }
    }

    public void testBug297871() {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        Project project = (Project)ws.getRoot().getProject("Project");
        this.ensureExistsInWorkspace((IResource)project, true);
        File desc = null;
        try {
            IFileStore descStore = ((org.eclipse.core.internal.resources.File)project.getFile(".project")).getStore();
            desc = descStore.toLocalFile(0, this.getMonitor());
        }
        catch (CoreException coreException) {
            NatureTest.fail((String)"1.0");
        }
        File descTmp = new File(String.valueOf(desc.getPath()) + ".tmp");
        try {
            this.copy(desc, descTmp);
        }
        catch (IOException e) {
            NatureTest.fail((String)"2.0", (Throwable)e);
        }
        this.setNatures("valid ", (IProject)project, new String[]{"org.eclipse.core.tests.resources.earthNature"}, false);
        try {
            NatureTest.assertNotNull((Object)project.getNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"3.0", (Throwable)e);
        }
        try {
            NatureTest.assertTrue((boolean)project.hasNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"4.0", (Throwable)e);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            NatureTest.fail((String)"5.0", (Throwable)e);
        }
        try {
            this.copy(descTmp, desc);
        }
        catch (IOException e) {
            NatureTest.fail((String)"6.0", (Throwable)e);
        }
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            NatureTest.fail((String)"7.0", (Throwable)e);
        }
        try {
            NatureTest.assertNull((Object)project.getNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"8.0", (Throwable)e);
        }
        try {
            NatureTest.assertFalse((boolean)project.hasNature("org.eclipse.core.tests.resources.earthNature"));
        }
        catch (CoreException e) {
            NatureTest.fail((String)"9.0", (Throwable)e);
        }
    }

    private void copy(File src, File dst) throws IOException {
        int read;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buffer = new byte[1024];
        while ((read = ((InputStream)in).read(buffer)) > 0) {
            ((OutputStream)out).write(buffer, 0, read);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public void testBug338055() throws Exception {
        Project project;
        block10: {
            final boolean[] finished = new boolean[1];
            project = (Project)ResourcesPlugin.getWorkspace().getRoot().getProject(this.getUniqueString());
            this.ensureExistsInWorkspace((IResource)project, true);
            new Job("CheckNatureJob"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        if (!finished[0]) {
                            if (project.exists() && project.isOpen()) {
                                project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature");
                            }
                            this.schedule();
                        }
                    }
                    catch (CoreException e) {
                        NatureTest.fail((String)"CheckNatureJob failed", (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                NatureTest.fail((String)"2.0", (Throwable)e);
            }
            IFileStore descStore = ((org.eclipse.core.internal.resources.File)project.getFile(".project")).getStore();
            StringBuffer description = new StringBuffer();
            description.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><projectDescription><name></name><comment></comment><projects></projects><buildSpec></buildSpec><natures>");
            description.append("<nature>org.eclipse.core.tests.resources.simpleNature</nature>");
            int i = 0;
            while (i < 100) {
                description.append("<nature>nature" + i + "</nature>");
                ++i;
            }
            description.append("</natures></projectDescription>\n");
            OutputStream output = null;
            try {
                try {
                    output = descStore.openOutputStream(0, this.getMonitor());
                    output.write(description.toString().getBytes());
                }
                catch (CoreException coreException) {
                    NatureTest.fail((String)"1.0");
                    FileUtil.safeClose((Closeable)output);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                FileUtil.safeClose(output);
                throw throwable;
            }
            FileUtil.safeClose((Closeable)output);
        }
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            NatureTest.fail((String)"3.0", (Throwable)e);
        }
        finished[0] = true;
        NatureTest.assertTrue((String)"4.0", (boolean)project.hasNature("org.eclipse.core.tests.resources.simpleNature"));
        NatureTest.assertTrue((String)"5.0", (boolean)project.isNatureEnabled("org.eclipse.core.tests.resources.simpleNature"));
    }
}

