/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.junit.Assert;

public class ResourceDeltaVerifier
extends Assert
implements IResourceChangeListener {
    private Hashtable<IPath, ExpectedChange> fExpectedChanges = new Hashtable();
    boolean fIsDeltaValid = true;
    private StringBuffer fMessage = new StringBuffer();
    private static final int RECEIVING_INPUTS = 0;
    private static final int DELTA_VERIFIED = 1;
    private static final int VERIFICATION_COMPLETE = 2;
    private int fState = 0;

    public void addExpectedChange(IResource[] resources, int status, int changeFlags) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            this.addExpectedChange(resource, null, status, changeFlags, null, null);
            ++n2;
        }
    }

    public void addExpectedDeletion(IResource resource) {
        this.addExpectedChange(resource, 2, 0);
        if (resource instanceof IContainer) {
            try {
                IResource[] children;
                IResource[] iResourceArray = children = ((IContainer)resource).members(11);
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource element = iResourceArray[n2];
                    this.addExpectedDeletion(element);
                    ++n2;
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                ResourceDeltaVerifier.fail((String)"Failed to get children in addExpectedDeletion");
            }
        }
    }

    public void addExpectedChange(IResource resource, int status, int changeFlags) {
        this.addExpectedChange(resource, null, status, changeFlags, null, null);
    }

    public void addExpectedChange(IResource resource, int status, int changeFlags, IPath movedFromPath, IPath movedToPath) {
        this.addExpectedChange(resource, null, status, changeFlags, movedFromPath, movedToPath);
    }

    public void addExpectedChange(IResource resource, IResource topLevelParent, int status, int changeFlags) {
        this.addExpectedChange(resource, topLevelParent, status, changeFlags, null, null);
    }

    public void addExpectedChange(IResource resource, IResource topLevelParent, int status, int changeFlags, IPath movedFromPath, IPath movedToPath) {
        this.resetIfNecessary();
        ExpectedChange expectedChange = new ExpectedChange(resource, status, changeFlags, movedFromPath, movedToPath);
        this.fExpectedChanges.put(resource.getFullPath(), expectedChange);
        IContainer parentResource = resource.getParent();
        IContainer limit = topLevelParent == null ? null : topLevelParent.getParent();
        while (parentResource != null && !parentResource.equals((Object)limit)) {
            IPath key = parentResource.getFullPath();
            if (this.fExpectedChanges.get(key) == null) {
                ExpectedChange parentExpectedChange = new ExpectedChange((IResource)parentResource, 4, 0, null, null);
                this.fExpectedChanges.put(key, parentExpectedChange);
            }
            parentResource = parentResource.getParent();
        }
    }

    private void checkChanges(IResourceDelta delta) {
        IResource resource = delta.getResource();
        ExpectedChange expectedChange = this.fExpectedChanges.remove(resource.getFullPath());
        int status = delta.getKind();
        int changeFlags = delta.getFlags();
        if (status == 0) {
            return;
        }
        if (expectedChange == null) {
            this.recordMissingExpectedChange(status, changeFlags);
        } else {
            int expectedStatus = expectedChange.getKind();
            int expectedChangeFlags = expectedChange.getChangeFlags();
            if (status != expectedStatus || changeFlags != expectedChangeFlags) {
                this.recordConflictingChange(expectedStatus, status, expectedChangeFlags, changeFlags);
            }
        }
    }

    private void checkChildren(IResourceDelta delta) {
        IResourceDelta childDelta2;
        IResource childResource;
        IResourceDelta childDelta1;
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(31, 10);
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1, 10);
        IResourceDelta[] changedChildren = delta.getAffectedChildren(4, 10);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2, 10);
        Hashtable<IResource, IResourceDelta> h = new Hashtable<IResource, IResourceDelta>(affectedChildren.length + 1);
        IResourceDelta[] iResourceDeltaArray = addedChildren;
        int n = addedChildren.length;
        int n2 = 0;
        while (n2 < n) {
            childDelta1 = iResourceDeltaArray[n2];
            childResource = childDelta1.getResource();
            childDelta2 = (IResourceDelta)h.get(childResource);
            if (childDelta2 != null) {
                this.recordDuplicateChild(childResource.getFullPath(), childDelta2.getKind(), childDelta1.getKind(), 1);
            } else {
                h.put(childResource, childDelta1);
            }
            if (childDelta1.getKind() != 1) {
                this.recordIllegalChild(childResource.getFullPath(), 1, childDelta1.getKind());
            }
            ++n2;
        }
        iResourceDeltaArray = changedChildren;
        n = changedChildren.length;
        n2 = 0;
        while (n2 < n) {
            childDelta1 = iResourceDeltaArray[n2];
            childResource = childDelta1.getResource();
            childDelta2 = (IResourceDelta)h.get(childResource);
            if (childDelta2 != null) {
                this.recordDuplicateChild(childResource.getFullPath(), childDelta2.getKind(), childDelta1.getKind(), 4);
            } else {
                h.put(childResource, childDelta1);
            }
            if (childDelta1.getKind() != 4) {
                this.recordIllegalChild(childResource.getFullPath(), 4, childDelta1.getKind());
            }
            ++n2;
        }
        iResourceDeltaArray = removedChildren;
        n = removedChildren.length;
        n2 = 0;
        while (n2 < n) {
            childDelta1 = iResourceDeltaArray[n2];
            childResource = childDelta1.getResource();
            childDelta2 = (IResourceDelta)h.get(childResource);
            if (childDelta2 != null) {
                this.recordDuplicateChild(childResource.getFullPath(), childDelta2.getKind(), childDelta1.getKind(), 2);
            } else {
                h.put(childResource, childDelta1);
            }
            if (childDelta1.getKind() != 2) {
                this.recordIllegalChild(childResource.getFullPath(), 2, childDelta1.getKind());
            }
            ++n2;
        }
        iResourceDeltaArray = affectedChildren;
        n = affectedChildren.length;
        n2 = 0;
        while (n2 < n) {
            int kind;
            childDelta1 = iResourceDeltaArray[n2];
            childResource = childDelta1.getResource();
            childDelta2 = (IResourceDelta)h.remove(childResource);
            if (childDelta2 == null && ((kind = childDelta1.getKind()) == 1 || kind == 2 || kind == 4)) {
                this.recordMissingChild(childResource.getFullPath(), childDelta1.getKind(), false);
            }
            ++n2;
        }
        for (Map.Entry entry : h.entrySet()) {
            IResource childResource2 = (IResource)entry.getKey();
            IResourceDelta childDelta = (IResourceDelta)entry.getValue();
            this.recordMissingChild(childResource2.getFullPath(), childDelta.getKind(), true);
        }
        iResourceDeltaArray = affectedChildren;
        int n3 = affectedChildren.length;
        int n4 = 0;
        while (n4 < n3) {
            IResourceDelta element = iResourceDeltaArray[n4];
            this.internalVerifyDelta(element);
            ++n4;
        }
        for (IResourceDelta childDelta : h.values()) {
            this.internalVerifyDelta(childDelta);
        }
    }

    private void checkPaths(IResourceDelta delta) {
        ExpectedChange expectedChange;
        IPath actualProjectRelativePath;
        IPath expectedProjectRelativePath;
        IPath actualFullPath;
        IResource resource = delta.getResource();
        IPath expectedFullPath = resource.getFullPath();
        if (!expectedFullPath.equals((Object)(actualFullPath = delta.getFullPath()))) {
            this.recordConflictingFullPaths(expectedFullPath, actualFullPath);
        }
        if (!((expectedProjectRelativePath = resource.getProjectRelativePath()) == (actualProjectRelativePath = delta.getProjectRelativePath()) || expectedProjectRelativePath != null && expectedProjectRelativePath.equals((Object)actualProjectRelativePath))) {
            this.recordConflictingProjectRelativePaths(expectedProjectRelativePath, actualProjectRelativePath);
        }
        if ((expectedChange = this.fExpectedChanges.get(resource.getFullPath())) != null) {
            IPath actualMovedToPath;
            IPath expectedMovedToPath;
            IPath actualMovedFromPath;
            IPath expectedMovedFromPath = expectedChange.getMovedFromPath();
            if (!(expectedMovedFromPath == (actualMovedFromPath = delta.getMovedFromPath()) || expectedMovedFromPath != null && expectedMovedFromPath.equals((Object)actualMovedFromPath))) {
                this.recordConflictingMovedFromPaths(expectedMovedFromPath, actualMovedFromPath);
            }
            if (!((expectedMovedToPath = expectedChange.getMovedToPath()) == (actualMovedToPath = delta.getMovedToPath()) || expectedMovedToPath != null && expectedMovedToPath.equals((Object)actualMovedToPath))) {
                this.recordConflictingMovedToPaths(expectedMovedToPath, actualMovedToPath);
            }
        }
    }

    String convertChangeFlags(int changeFlags) {
        String result;
        if (changeFlags == 0) {
            return "0";
        }
        StringBuffer buf = new StringBuffer();
        if ((changeFlags & 0x100) != 0) {
            changeFlags ^= 0x100;
            buf.append("CONTENT | ");
        }
        if ((changeFlags & 0x1000) != 0) {
            changeFlags ^= 0x1000;
            buf.append("MOVED_FROM | ");
        }
        if ((changeFlags & 0x2000) != 0) {
            changeFlags ^= 0x2000;
            buf.append("MOVED_TO | ");
        }
        if ((changeFlags & 0x4000) != 0) {
            changeFlags ^= 0x4000;
            buf.append("OPEN | ");
        }
        if ((changeFlags & 0x8000) != 0) {
            changeFlags ^= 0x8000;
            buf.append("TYPE | ");
        }
        if ((changeFlags & 0x20000) != 0) {
            changeFlags ^= 0x20000;
            buf.append("MARKERS | ");
        }
        if ((changeFlags & 0x40000) != 0) {
            changeFlags ^= 0x40000;
            buf.append("REPLACED | ");
        }
        if ((changeFlags & 0x100000) != 0) {
            changeFlags ^= 0x100000;
            buf.append("ENCODING | ");
        }
        if ((changeFlags & 0x400000) != 0) {
            changeFlags ^= 0x400000;
            buf.append("DERIVED_CHANGED | ");
        }
        if ((changeFlags & 0x80000) != 0) {
            changeFlags ^= 0x80000;
            buf.append("DESCRIPTION | ");
        }
        if ((changeFlags & 0x10000) != 0) {
            changeFlags ^= 0x10000;
            buf.append("SYNC | ");
        }
        if (changeFlags != 0) {
            buf.append(changeFlags);
            buf.append(" | ");
        }
        if ((result = buf.toString()).length() != 0) {
            result = result.substring(0, result.length() - 3);
        }
        return result;
    }

    String convertKind(int kind) {
        switch (kind) {
            case 1: {
                return "ADDED";
            }
            case 4: {
                return "CHANGED";
            }
            case 2: {
                return "REMOVED";
            }
            case 8: {
                return "ADDED_PHANTOM";
            }
            case 16: {
                return "REMOVED_PHANTOM";
            }
        }
        return "Unknown(" + kind + ")";
    }

    private void finishVerification() {
        HashSet<IPath> resourcePaths = new HashSet<IPath>(this.fExpectedChanges.keySet());
        for (IPath resourcePath : resourcePaths) {
            this.fMessage.append("Checking expectations for ");
            this.fMessage.append(resourcePath);
            this.fMessage.append("\n");
            ExpectedChange expectedChange = this.fExpectedChanges.remove(resourcePath);
            if (expectedChange == null) continue;
            this.recordMissingActualChange(expectedChange.getKind(), expectedChange.getChangeFlags());
        }
    }

    public String getMessage() {
        if (this.fState == 0) {
            if (this.hasExpectedChanges()) {
                ResourceDeltaVerifier.fail((String)"Verifier has not yet been given a resource delta");
            } else {
                this.fState = 1;
            }
        }
        if (this.fState == 1) {
            this.finishVerification();
            this.fState = 2;
        }
        return this.fMessage.toString();
    }

    public boolean hasBeenNotified() {
        return this.fState == 1;
    }

    public boolean hasExpectedChanges() {
        return !this.fExpectedChanges.isEmpty();
    }

    void internalVerifyDelta(IResourceDelta delta) {
        try {
            if (delta == null) {
                return;
            }
            this.fMessage.append("Verifying delta for ");
            this.fMessage.append(delta.getFullPath());
            this.fMessage.append("\n");
            if (delta.getResource() != null) {
                this.checkPaths(delta);
                this.checkChanges(delta);
            }
            this.checkChildren(delta);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fMessage.append("Exception during event notification:" + e.getMessage());
            this.fIsDeltaValid = false;
        }
    }

    public boolean isDeltaValid() {
        if (this.fState == 0) {
            if (this.hasExpectedChanges()) {
                ResourceDeltaVerifier.fail((String)"Verifier has not yet been given a resource delta");
            } else {
                this.fState = 1;
            }
        }
        if (this.fState == 1) {
            this.finishVerification();
            this.fState = 2;
        }
        return this.fIsDeltaValid;
    }

    public static void main(String[] args) {
        ResourceDeltaVerifier comparer = new ResourceDeltaVerifier();
        int status = 4;
        int changeFlags = 256;
        int expectedStatus = 4;
        int actualStatus = 2;
        int expectedChangeFlags = 16384;
        int actualChangeFlags = 0;
        int formerChildStatus = expectedStatus;
        int latterChildStatus = actualStatus;
        Path path = new Path("/a/b/c");
        Path path2 = new Path("/a/b/d");
        Path expectedFullPath = path;
        Path actualFullPath = path2;
        Path expectedMovedFromPath = path;
        Path actualMovedFromPath = path2;
        Path expectedMovedToPath = path;
        Path actualMovedToPath = path2;
        Path expectedProjectRelativePath = new Path("b/c");
        Path actualProjectRelativePath = new Path("b/d");
        comparer.fMessage.append("Checking delta for ");
        comparer.fMessage.append(path);
        comparer.fMessage.append("\n");
        comparer.recordConflictingChange(expectedStatus, actualStatus, expectedChangeFlags, actualChangeFlags);
        comparer.recordConflictingFullPaths((IPath)expectedFullPath, (IPath)actualFullPath);
        comparer.recordConflictingMovedFromPaths((IPath)expectedMovedFromPath, (IPath)actualMovedFromPath);
        comparer.recordConflictingMovedToPaths((IPath)expectedMovedToPath, (IPath)actualMovedToPath);
        comparer.recordConflictingProjectRelativePaths((IPath)expectedProjectRelativePath, (IPath)actualProjectRelativePath);
        comparer.recordDuplicateChild((IPath)path, formerChildStatus, latterChildStatus, expectedStatus);
        comparer.recordIllegalChild((IPath)path, expectedStatus, actualStatus);
        comparer.recordMissingActualChange(status, changeFlags);
        comparer.recordMissingChild((IPath)path, status, true);
        comparer.recordMissingChild((IPath)path, status, false);
        comparer.recordMissingExpectedChange(status, changeFlags);
        System.out.print(comparer.fMessage.toString());
    }

    private void recordConflictingChange(int expectedKind, int kind, int expectedChangeFlags, int changeFlags) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tConflicting change\n");
        if (expectedKind != kind) {
            this.fMessage.append("\t\tExpected kind: <");
            this.fMessage.append(this.convertKind(expectedKind));
            this.fMessage.append("> actual kind: <");
            this.fMessage.append(this.convertKind(kind));
            this.fMessage.append(">\n");
        }
        if (expectedChangeFlags != changeFlags) {
            this.fMessage.append("\t\tExpected change flags: <");
            this.fMessage.append(this.convertChangeFlags(expectedChangeFlags));
            this.fMessage.append("> actual change flags: <");
            this.fMessage.append(this.convertChangeFlags(changeFlags));
            this.fMessage.append(">\n");
        }
    }

    private void recordConflictingFullPaths(IPath expectedFullPath, IPath actualFullPath) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tConflicting full paths\n");
        this.fMessage.append("\t\tExpected full path: ");
        this.fMessage.append(expectedFullPath);
        this.fMessage.append("\n");
        this.fMessage.append("\t\tActual full path: ");
        this.fMessage.append(actualFullPath);
        this.fMessage.append("\n");
    }

    private void recordConflictingMovedFromPaths(IPath expectedMovedFromPath, IPath actualMovedFromPath) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tConflicting moved from paths\n");
        this.fMessage.append("\t\tExpected moved from path: ");
        this.fMessage.append(expectedMovedFromPath);
        this.fMessage.append("\n");
        this.fMessage.append("\t\tActual moved from path: ");
        this.fMessage.append(actualMovedFromPath);
        this.fMessage.append("\n");
    }

    private void recordConflictingMovedToPaths(IPath expectedMovedToPath, IPath actualMovedToPath) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tConflicting moved to paths\n");
        this.fMessage.append("\t\tExpected moved to path: ");
        this.fMessage.append(expectedMovedToPath);
        this.fMessage.append("\n");
        this.fMessage.append("\t\tActual moved to path: ");
        this.fMessage.append(actualMovedToPath);
        this.fMessage.append("\n");
    }

    private void recordConflictingProjectRelativePaths(IPath expectedProjectRelativePath, IPath actualProjectRelativePath) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tConflicting project relative paths\n");
        this.fMessage.append("\t\tExpected project relative path: ");
        this.fMessage.append(expectedProjectRelativePath);
        this.fMessage.append("\n");
        this.fMessage.append("\t\tActual project relative path: ");
        this.fMessage.append(actualProjectRelativePath);
        this.fMessage.append("\n");
    }

    private void recordDuplicateChild(IPath path, int formerChildKind, int latterChildKind, int expectedKind) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tDuplicate child: ");
        this.fMessage.append(path);
        this.fMessage.append("\n");
        this.fMessage.append("\t\tProduced by IResourceDelta.get");
        switch (expectedKind) {
            case 1: {
                this.fMessage.append("Added");
                break;
            }
            case 4: {
                this.fMessage.append("Changed");
                break;
            }
            case 2: {
                this.fMessage.append("Removed");
            }
        }
        this.fMessage.append("Children()\n");
        this.fMessage.append("\t\tFormer child's status: ");
        this.fMessage.append(this.convertKind(formerChildKind));
        this.fMessage.append("\n");
        this.fMessage.append("\t\tLatter child's status: ");
        this.fMessage.append(this.convertKind(latterChildKind));
        this.fMessage.append("\n");
    }

    private void recordIllegalChild(IPath path, int expectedKind, int actualKind) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tIllegal child: ");
        this.fMessage.append(path);
        this.fMessage.append("\n");
        this.fMessage.append("\t\tProduced by IResourceDelta.get");
        switch (expectedKind) {
            case 1: {
                this.fMessage.append("Added");
                break;
            }
            case 4: {
                this.fMessage.append("Changed");
                break;
            }
            case 2: {
                this.fMessage.append("Removed");
            }
        }
        this.fMessage.append("Children()\n");
        this.fMessage.append("\t\tIlleagal child's status: ");
        this.fMessage.append(this.convertKind(actualKind));
        this.fMessage.append("\n");
    }

    private void recordMissingActualChange(int kind, int changeFlags) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tMissing actual change\n");
        this.fMessage.append("\t\tExpected kind: <");
        this.fMessage.append(this.convertKind(kind));
        this.fMessage.append(">\n");
        this.fMessage.append("\t\tExpected change flags: <");
        this.fMessage.append(this.convertChangeFlags(changeFlags));
        this.fMessage.append(">\n");
    }

    private void recordMissingChild(IPath path, int kind, boolean isMissingFromAffectedChildren) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tMissing child: ");
        this.fMessage.append(path);
        this.fMessage.append("\n");
        this.fMessage.append("\t\tfrom IResourceDelta.getAffectedChildren(");
        if (!isMissingFromAffectedChildren) {
            switch (kind) {
                case 1: {
                    this.fMessage.append("ADDED");
                    break;
                }
                case 4: {
                    this.fMessage.append("CHANGED");
                    break;
                }
                case 2: {
                    this.fMessage.append("REMOVED");
                    break;
                }
                default: {
                    this.fMessage.append(kind);
                }
            }
        }
        this.fMessage.append(")\n");
    }

    private void recordMissingExpectedChange(int kind, int changeFlags) {
        this.fIsDeltaValid = false;
        this.fMessage.append("\tMissing expected change\n");
        this.fMessage.append("\t\tActual kind: <");
        this.fMessage.append(this.convertKind(kind));
        this.fMessage.append(">\n");
        this.fMessage.append("\t\tActual change flags: <");
        this.fMessage.append(this.convertChangeFlags(changeFlags));
        this.fMessage.append(">\n");
    }

    public void reset() {
        this.fExpectedChanges.clear();
        this.fIsDeltaValid = true;
        this.fMessage.setLength(0);
        this.fState = 0;
    }

    private void resetIfNecessary() {
        if (this.fState == 1) {
            this.reset();
        }
    }

    public void resourceChanged(IResourceChangeEvent e) {
        this.verifyDelta(e.getDelta());
    }

    public void verifyDelta(IResourceDelta delta) {
        this.internalVerifyDelta(delta);
        this.fState = 1;
    }

    private class ExpectedChange {
        IResource fResource;
        IPath movedFromPath;
        IPath movedToPath;
        int fKind;
        int fChangeFlags;

        public ExpectedChange(IResource resource, int kind, int changeFlags, IPath movedFromPath, IPath movedToPath) {
            this.fResource = resource;
            this.fKind = kind;
            this.fChangeFlags = changeFlags;
            this.movedFromPath = movedFromPath;
            this.movedToPath = movedToPath;
        }

        public int getChangeFlags() {
            return this.fChangeFlags;
        }

        public IPath getMovedFromPath() {
            if ((this.fChangeFlags & 0x1000) != 0) {
                return this.movedFromPath;
            }
            return null;
        }

        public IPath getMovedToPath() {
            if ((this.fChangeFlags & 0x2000) != 0) {
                return this.movedToPath;
            }
            return null;
        }

        public int getKind() {
            return this.fKind;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("ExpectedChange(");
            buf.append(this.fResource);
            buf.append(", ");
            buf.append(ResourceDeltaVerifier.this.convertKind(this.fKind));
            buf.append(", ");
            buf.append(ResourceDeltaVerifier.this.convertChangeFlags(this.fChangeFlags));
            buf.append(")");
            return buf.toString();
        }
    }
}

