/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.content.LazyInputStream;

public class LazyInputStreamTest
extends TestCase {
    private static final String DATA = "012345678901234567890123456789";
    private static final int[] VARIOUS_INTS;

    static {
        int[] nArray = new int[7];
        nArray[0] = 255;
        nArray[1] = 254;
        nArray[2] = 160;
        nArray[3] = 127;
        nArray[4] = 112;
        nArray[5] = 16;
        VARIOUS_INTS = nArray;
    }

    public LazyInputStreamTest(String name) {
        super(name);
    }

    public void testReadSingleByte() throws UnsupportedEncodingException, IOException {
        ByteArrayInputStream underlying = new ByteArrayInputStream(DATA.getBytes());
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        LazyInputStreamTest.assertEquals((String)"1.0", (int)48, (int)stream.read());
        LazyInputStreamTest.assertEquals((String)"1.1", (int)49, (int)stream.read());
        stream.skip(10L);
        LazyInputStreamTest.assertEquals((String)"1.2", (int)50, (int)stream.read());
        LazyInputStreamTest.assertEquals((String)"1.3", (int)13, (int)stream.getOffset());
        stream.close();
    }

    public void testReadBlock() throws UnsupportedEncodingException, IOException {
        ByteArrayInputStream underlying = new ByteArrayInputStream(DATA.getBytes());
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        stream.skip(4L);
        byte[] buffer = new byte[7];
        int read = stream.read(buffer);
        LazyInputStreamTest.assertEquals((String)"1.0", (int)buffer.length, (int)read);
        LazyInputStreamTest.assertEquals((String)"1.1", (String)DATA.substring(4, 4 + buffer.length), (String)new String(buffer));
        LazyInputStreamTest.assertEquals((String)"1.2", (int)11, (int)stream.getOffset());
        read = stream.read(buffer, 3, 4);
        LazyInputStreamTest.assertEquals((String)"2.0", (int)4, (int)read);
        LazyInputStreamTest.assertEquals((String)"2.1", (String)DATA.substring(11, 11 + read), (String)new String(buffer, 3, read));
        LazyInputStreamTest.assertEquals((String)"2.2", (int)15, (int)stream.getOffset());
        stream.mark(0);
        buffer = new byte[100];
        read = stream.read(buffer);
        LazyInputStreamTest.assertEquals((String)"3.0", (int)(DATA.length() - 15), (int)read);
        LazyInputStreamTest.assertEquals((String)"3.1", (String)DATA.substring(15, 15 + read), (String)new String(buffer, 0, read));
        LazyInputStreamTest.assertEquals((String)"3.2", (int)0, (int)stream.available());
        stream.reset();
        LazyInputStreamTest.assertEquals((String)"4.0", (int)15, (int)stream.getOffset());
        read = stream.read(buffer, 10, 14);
        LazyInputStreamTest.assertEquals((String)"4.1", (int)29, (int)stream.getOffset());
        LazyInputStreamTest.assertEquals((String)"4.2", (int)1, (int)stream.available());
        LazyInputStreamTest.assertEquals((String)"4.3", (int)14, (int)read);
        LazyInputStreamTest.assertEquals((String)"4.4", (String)DATA.substring(15, 15 + read), (String)new String(buffer, 10, read));
        read = stream.read(buffer);
        LazyInputStreamTest.assertEquals((String)"5.0", (int)30, (int)stream.getOffset());
        LazyInputStreamTest.assertEquals((String)"5.1", (int)0, (int)stream.available());
        LazyInputStreamTest.assertEquals((String)"5.2", (int)1, (int)read);
        LazyInputStreamTest.assertEquals((String)"5.3", (byte)((byte)DATA.charAt(29)), (byte)buffer[0]);
        read = stream.read(buffer);
        LazyInputStreamTest.assertEquals((String)"6.0", (int)30, (int)stream.getOffset());
        LazyInputStreamTest.assertEquals((String)"6.1", (int)0, (int)stream.available());
        LazyInputStreamTest.assertEquals((String)"6.2", (int)-1, (int)read);
        stream.close();
    }

    public void testMarkAndReset() throws UnsupportedEncodingException, IOException {
        ByteArrayInputStream underlying = new ByteArrayInputStream(DATA.getBytes());
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        LazyInputStreamTest.assertEquals((String)"0.1", (int)30, (int)stream.available());
        stream.skip(13L);
        LazyInputStreamTest.assertEquals((String)"0.2", (int)17, (int)stream.available());
        stream.mark(0);
        LazyInputStreamTest.assertEquals((String)"2.0", (int)13, (int)stream.getMark());
        LazyInputStreamTest.assertEquals((String)"2.1", (int)51, (int)stream.read());
        LazyInputStreamTest.assertEquals((String)"2.2", (int)52, (int)stream.read());
        LazyInputStreamTest.assertEquals((String)"2.3", (int)15, (int)stream.getOffset());
        LazyInputStreamTest.assertEquals((String)"2.4", (int)15, (int)stream.available());
        stream.reset();
        LazyInputStreamTest.assertEquals((String)"2.5", (int)17, (int)stream.available());
        LazyInputStreamTest.assertEquals((String)"2.6", (int)13, (int)stream.getOffset());
        stream.reset();
        LazyInputStreamTest.assertEquals((String)"2.7", (int)17, (int)stream.available());
        LazyInputStreamTest.assertEquals((String)"2.8", (int)13, (int)stream.getOffset());
        stream.rewind();
        LazyInputStreamTest.assertEquals((String)"3.0", (int)0, (int)stream.getOffset());
        stream.close();
    }

    public void testContentHasEOF() throws IOException {
        byte[] changedData = DATA.getBytes();
        changedData[0] = -1;
        ByteArrayInputStream underlying = new ByteArrayInputStream(changedData);
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        int c = stream.read();
        LazyInputStreamTest.assertTrue((String)"1.0", (-1 != c ? 1 : 0) != 0);
        LazyInputStreamTest.assertEquals((String)"2.0", (int)255, (int)c);
        stream.close();
    }

    public void testVariedContent() throws IOException {
        byte[] contents = new byte[VARIOUS_INTS.length];
        int i = 0;
        while (i < contents.length) {
            contents[i] = (byte)VARIOUS_INTS[i];
            ++i;
        }
        ByteArrayInputStream underlying = new ByteArrayInputStream(contents);
        OpenLazyInputStream stream = new OpenLazyInputStream(underlying, 7);
        int i2 = 0;
        while (i2 < VARIOUS_INTS.length) {
            LazyInputStreamTest.assertEquals((String)("1.0." + i2), (int)VARIOUS_INTS[i2], (int)stream.read());
            ++i2;
        }
        stream.close();
    }

    public static Test suite() {
        return new TestSuite(LazyInputStreamTest.class);
    }

    private static class OpenLazyInputStream
    extends LazyInputStream {
        public OpenLazyInputStream(InputStream in, int blockCapacity) {
            super(in, blockCapacity);
        }

        public int getBlockCount() {
            return super.getBlockCount();
        }

        public int getBufferSize() {
            return super.getBufferSize();
        }

        public int getMark() {
            return super.getMark();
        }

        public int getOffset() {
            return super.getOffset();
        }
    }
}

