/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.content;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;

public class MyContentDescriber
implements IContentDescriber {
    public static final Object[] MY_OPTION_VALUES;
    public static final String SIGNATURE = "MY_CONTENTS";
    public static final QualifiedName[] MY_OPTIONS;

    static {
        Object[] objectArray = new Object[3];
        objectArray[0] = "FOO";
        objectArray[2] = "BAR";
        MY_OPTION_VALUES = objectArray;
        MY_OPTIONS = new QualifiedName[]{new QualifiedName("org.eclipse.core.tests.resources", "my_option_1"), new QualifiedName("org.eclipse.core.tests.resources", "my_option_2"), new QualifiedName("org.eclipse.core.tests.resources", "my_option_3")};
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        byte[] signature = SIGNATURE.getBytes("US-ASCII");
        byte[] buffer = new byte[signature.length];
        if (contents.read(buffer) != buffer.length) {
            return 0;
        }
        int i = 0;
        while (i < signature.length) {
            if (signature[i] != buffer[i]) {
                return 0;
            }
            ++i;
        }
        if (description == null) {
            return 2;
        }
        i = 0;
        while (i < MY_OPTIONS.length) {
            this.setIfRequested(description, i);
            ++i;
        }
        return 2;
    }

    public QualifiedName[] getSupportedOptions() {
        return MY_OPTIONS;
    }

    private void setIfRequested(IContentDescription description, int option) {
        if (description.isRequested(MY_OPTIONS[option])) {
            description.setProperty(MY_OPTIONS[option], MY_OPTION_VALUES[option]);
        }
    }
}

