/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.OldCorePerformanceTest;

public class BenchElementTree
extends OldCorePerformanceTest {
    static String[] javaLangUnits = new String[]{"AbstractMethodError.java", "ArithmeticException.java", "ArrayIndexOutOfBoundsException.java", "ArrayStoreException.java", "Boolean.java", "Byte.java", "Character.java", "Class.java", "ClassCastException.java", "ClassCircularityError.java", "ClassFormatError.java", "ClassLoader.java", "ClassNotFoundException.java", "Cloneable.java", "CloneNotSupportedException.java", "Compiler.java", "Double.java", "Error.java", "Exception.java", "ExceptionInInitializerError.java", "Float.java", "FloatingDecimal.java", "IllegalAccessError.java", "IllegalAccessException.java", "IllegalArgumentException.java", "IllegalMonitorStateException.java", "IllegalStateException.java", "IllegalThreadStateException.java", "IncompatibleClassChangeError.java", "IndexOutOfBoundsException.java", "InstantiationError.java", "InstantiationException.java", "Integer.java", "InternalError.java", "InterruptedException.java", "LinkageError.java", "Long.java", "Math.java", "NegativeArraySizeException.java", "NoClassDefFoundError.java", "NoSuchFieldError.java", "NoSuchFieldException.java", "NoSuchMethodError.java", "NoSuchMethodException.java", "NullPointerException.java", "Number.java", "NumberFormatException.java", "Object.java", "OutOfMemoryError.java", "Process.java", "Runnable.java", "Runtime.java", "RuntimeException.java", "SecurityException.java", "SecurityManager.java", "Short.java", "StackOverflowError.java", "String.java", "StringBuffer.java", "StringIndexOutOfBoundsException.java", "System.java", "Thread.java", "ThreadDeath.java", "ThreadGroup.java", "Throwable.java", "UnknownError.java", "UnsatisfiedLinkError.java", "VerifyError.java", "VirtualMachineError.java", "Void.java"};
    static final IPath solution = Path.ROOT.append("solution");
    static final IPath project = solution.append("project");
    static final IPath folder = project.append("folder");
    static final IPath[] files = BenchElementTree.getFilePaths();

    public BenchElementTree() {
    }

    public BenchElementTree(String name) {
        super(name);
    }

    public void testCreateElement() {
        new PerformanceTestRunner(){

            protected void test() {
                BenchElementTree.this.createTestTree(false);
            }
        }.run((TestCase)this, 10, 400);
    }

    public void benchDeleteElement() {
        ElementTree[] trees = new ElementTree[400];
        int i = 0;
        while (i < 400) {
            trees[i] = this.createTestTree(false);
            ++i;
        }
        this.startBench();
        int rep = 400;
        while (--rep >= 0) {
            IPath[] iPathArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IPath file = iPathArray[n2];
                trees[rep].deleteElement(file);
                ++n2;
            }
        }
        this.stopBench("benchDeleteElement", 400 * files.length);
    }

    public void benchGetElementData() {
        ElementTree tree = this.createTestTree(false);
        this.startBench();
        int rep = 500;
        while (--rep >= 0) {
            IPath[] iPathArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IPath file = iPathArray[n2];
                tree.getElementData(file);
                ++n2;
            }
        }
        this.stopBench("benchGetElementData", 500 * files.length);
    }

    public void benchMergeDeltaChain() {
        ElementTree[] bases = new ElementTree[50];
        ElementTree[][] chains = new ElementTree[50][];
        int i = 0;
        while (i < 50) {
            bases[i] = this.createTestTree(true);
            chains[i] = this.buildDeltaChain(this.createTestTree(false));
            ++i;
        }
        this.startBench();
        i = 50;
        while (--i >= 0) {
            bases[i].mergeDeltaChain(folder, chains[i]);
        }
        this.stopBench("benchMergeDeltaChain", 50);
    }

    public void benchRoutineOperations() {
        int opCount = 0;
        this.startBench();
        int i = 0;
        while (i < 75) {
            opCount += this.doRoutineOperations();
            ++i;
        }
        this.stopBench("benchRoutineOperations", opCount);
    }

    public void benchSetElementData() {
        ElementTree tree = this.createTestTree(false);
        Object data = new Object();
        this.startBench();
        int rep = 500;
        while (--rep >= 0) {
            IPath[] iPathArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IPath file = iPathArray[n2];
                tree.setElementData(file, data);
                ++n2;
            }
        }
        this.stopBench("benchSetElementData", 500 * files.length);
    }

    private ElementTree[] buildDeltaChain(ElementTree tree) {
        IPath[] filePaths;
        Vector<ElementTree> trees = new Vector<ElementTree>();
        trees.addElement(tree);
        int repeat = 1;
        tree = tree.newEmptyDelta();
        IPath[] iPathArray = filePaths = BenchElementTree.getFilePaths();
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath filePath = iPathArray[n2];
            String data = filePath.toString();
            tree.createElement(filePath, (Object)data);
            tree.immutable();
            trees.addElement(tree);
            tree = tree.newEmptyDelta();
            ++n2;
        }
        int i = 0;
        while (i < repeat) {
            String data = "data" + i;
            IPath[] iPathArray2 = filePaths;
            int n3 = filePaths.length;
            int n4 = 0;
            while (n4 < n3) {
                IPath filePath = iPathArray2[n4];
                tree.setElementData(filePath, (Object)data);
                tree.immutable();
                trees.addElement(tree);
                tree = tree.newEmptyDelta();
                ++n4;
            }
            ++i;
        }
        iPathArray = filePaths;
        n = filePaths.length;
        int n5 = 0;
        while (n5 < n) {
            IPath filePath = iPathArray[n5];
            tree.deleteElement(filePath);
            tree.immutable();
            trees.addElement(tree);
            tree = tree.newEmptyDelta();
            ++n5;
        }
        Object[] results = new ElementTree[trees.size()];
        trees.copyInto(results);
        return results;
    }

    ElementTree createTestTree(boolean withDeltas) {
        ElementTree tree = new ElementTree();
        Object data = new Object();
        tree.createElement(solution, data);
        if (withDeltas) {
            tree.immutable();
            tree = tree.newEmptyDelta();
        }
        tree.createElement(project, data);
        if (withDeltas) {
            tree.immutable();
            tree = tree.newEmptyDelta();
        }
        tree.createElement(folder, data);
        String[] stringArray = javaLangUnits;
        int n = javaLangUnits.length;
        int n2 = 0;
        while (n2 < n) {
            String javaLangUnit = stringArray[n2];
            if (withDeltas) {
                tree.immutable();
                tree = tree.newEmptyDelta();
            }
            IPath file = folder.append(javaLangUnit);
            tree.createElement(file, data);
            ++n2;
        }
        return tree;
    }

    private int doRoutineOperations() {
        ElementTree tree = this.createTestTree(true);
        int repeat = 1;
        int i = 0;
        while (i < repeat) {
            String data = "data" + i;
            IPath[] iPathArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                IPath file = iPathArray[n2];
                tree = tree.newEmptyDelta();
                tree.setElementData(file, (Object)data);
                tree.immutable();
                ++n2;
            }
            ++i;
        }
        IPath[] iPathArray = files;
        int n = files.length;
        int n3 = 0;
        while (n3 < n) {
            IPath file = iPathArray[n3];
            tree = tree.newEmptyDelta();
            tree.deleteElement(file);
            tree.immutable();
            ++n3;
        }
        return (repeat + 2) * files.length;
    }

    static IPath[] getFilePaths() {
        IPath[] jcuIDs = new IPath[javaLangUnits.length];
        int i = 0;
        int len = javaLangUnits.length;
        while (i < len) {
            jcuIDs[i] = folder.append(javaLangUnits[i]);
            ++i;
        }
        return jcuIDs;
    }

    @Override
    protected void setUp() throws Exception {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(BenchElementTree.class.getName());
        suite.addTest((Test)new BenchElementTree("benchCreateElement"));
        suite.addTest((Test)new BenchElementTree("benchDeleteElement"));
        suite.addTest((Test)new BenchElementTree("benchDeltaLargeTreeFewChanges"));
        suite.addTest((Test)new BenchElementTree("benchDeltaLargeTreeManyChangesInOneLayer"));
        suite.addTest((Test)new BenchElementTree("benchDeltaSmallTreeManyChangesInSeperateLayers"));
        suite.addTest((Test)new BenchElementTree("benchGetElementData"));
        suite.addTest((Test)new BenchElementTree("benchReverseDeltaLargeTreeFewChanges"));
        suite.addTest((Test)new BenchElementTree("benchReverseDeltaLargeTreeManyChangesInOneLayer"));
        suite.addTest((Test)new BenchElementTree("benchReverseDeltaSmallTreeManyChangesInSeperateLayers"));
        suite.addTest((Test)new BenchElementTree("benchRoutineOperations"));
        suite.addTest((Test)new BenchElementTree("benchSetElementData"));
        return suite;
    }

    @Override
    protected void tearDown() throws Exception {
    }
}

