/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.perf;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.tests.harness.PerformanceTestRunner;
import org.eclipse.core.tests.resources.ResourceTest;

public class PropertyManagerPerformanceTest
extends ResourceTest {
    public static String getPropertyValue(int size) {
        StringBuffer value = new StringBuffer(size);
        int i = 0;
        while (i < size) {
            value.append((char)(Math.random() * 65535.0));
            ++i;
        }
        return value.toString();
    }

    public static Test suite() {
        return new TestSuite(PropertyManagerPerformanceTest.class);
    }

    public PropertyManagerPerformanceTest(String name) {
        super(name);
    }

    private List<IResource> createTree(IFolder base, int filesPerFolder) {
        IFolder folder;
        IFolder[] folders;
        folders = new IFolder[]{base.getFolder("folder1"), base.getFolder("folder2"), folders[0].getFolder("folder3"), folders[2].getFolder("folder4"), folders[3].getFolder("folder5")};
        ArrayList<IResource> resources = new ArrayList<IResource>(filesPerFolder * folders.length);
        IFolder[] iFolderArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            folder = iFolderArray[n2];
            resources.add((IResource)folder);
            ++n2;
        }
        this.ensureExistsInWorkspace((IResource[])folders, true);
        iFolderArray = folders;
        n = folders.length;
        n2 = 0;
        while (n2 < n) {
            folder = iFolderArray[n2];
            int j = 0;
            while (j < filesPerFolder) {
                IFile file = folder.getFile("file" + j);
                this.ensureExistsInWorkspace(file, this.getRandomContents());
                resources.add((IResource)file);
                ++j;
            }
            ++n2;
        }
        return resources;
    }

    private void testGetProperty(int filesPerFolder, final int properties, int measurements, int repetitions) {
        IProject proj1 = PropertyManagerPerformanceTest.getWorkspace().getRoot().getProject("proj1");
        IFolder folder1 = proj1.getFolder("folder1");
        final List<IResource> allResources = this.createTree(folder1, filesPerFolder);
        for (IResource resource : allResources) {
            int j = 0;
            while (j < properties) {
                try {
                    resource.setPersistentProperty(new QualifiedName("org.eclipse.core.tests.resources", "prop" + j), PropertyManagerPerformanceTest.getPropertyValue(200));
                }
                catch (CoreException ce) {
                    PropertyManagerPerformanceTest.fail((String)"0.2", (Throwable)ce);
                }
                ++j;
            }
        }
        new PerformanceTestRunner(){

            protected void test() {
                int j = 0;
                while (j < properties) {
                    for (IResource resource : allResources) {
                        try {
                            PropertyManagerPerformanceTest.assertNotNull((Object)resource.getPersistentProperty(new QualifiedName("org.eclipse.core.tests.resources", "prop" + j)));
                        }
                        catch (CoreException ce) {
                            PropertyManagerPerformanceTest.fail((String)"0.2", (Throwable)ce);
                        }
                    }
                    ++j;
                }
            }
        }.run((TestCase)this, measurements, repetitions);
        try {
            ((Workspace)PropertyManagerPerformanceTest.getWorkspace()).getPropertyManager().deleteProperties((IResource)folder1, 2);
        }
        catch (CoreException e) {
            PropertyManagerPerformanceTest.fail((String)"0.1", (Throwable)e);
        }
    }

    public void testGetProperty100x4() {
        this.testGetProperty(100, 4, 10, 2);
    }

    public void testGetProperty20x20() {
        this.testGetProperty(20, 20, 10, 2);
    }

    public void testGetProperty4x100() {
        this.testGetProperty(4, 100, 10, 1);
    }

    private void testSetProperty(int filesPerFolder, int properties, int measurements, int repetitions) {
        IProject proj1 = PropertyManagerPerformanceTest.getWorkspace().getRoot().getProject("proj1");
        final IFolder folder1 = proj1.getFolder("folder1");
        final List<IResource> allResources = this.createTree(folder1, filesPerFolder);
        new PerformanceTestRunner(){

            protected void tearDown() {
                try {
                    ((Workspace)PropertyManagerPerformanceTest.getWorkspace()).getPropertyManager().deleteProperties((IResource)folder1, 2);
                }
                catch (CoreException e) {
                    PropertyManagerPerformanceTest.fail((String)"0.1", (Throwable)e);
                }
            }

            protected void test() {
                for (IResource resource : allResources) {
                    try {
                        resource.setPersistentProperty(new QualifiedName("org.eclipse.core.tests.resources", "prop" + (int)Math.random() * 50), PropertyManagerPerformanceTest.getPropertyValue(200));
                    }
                    catch (CoreException ce) {
                        PropertyManagerPerformanceTest.fail((String)"0.2", (Throwable)ce);
                    }
                }
            }
        }.run((TestCase)this, measurements, repetitions);
    }

    public void testSetProperty100x4() {
        this.testSetProperty(100, 4, 10, 1);
    }

    public void testSetProperty20x20() {
        this.testSetProperty(20, 20, 10, 4);
    }

    public void testSetProperty4x100() {
        this.testSetProperty(4, 100, 10, 20);
    }
}

