/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.refresh;

import java.io.File;
import java.util.HashMap;
import junit.framework.AssertionFailedError;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.tests.resources.ResourceTest;
import org.eclipse.core.tests.resources.TestUtil;
import org.eclipse.core.tests.resources.refresh.TestRefreshProvider;

public class RefreshProviderTest
extends ResourceTest {
    public static TestSuite suite() {
        return new TestSuite(RefreshProviderTest.class);
    }

    public RefreshProviderTest() {
    }

    public RefreshProviderTest(String name) {
        super(name);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        TestRefreshProvider.reset();
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("refresh.enabled", true);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        TestRefreshProvider.reset();
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        preferences.setValue("refresh.enabled", false);
    }

    public void testLinkedFile() throws Exception {
        IPath location = this.getRandomLocation();
        String name = "testUnmonitorLinkedResource";
        try {
            try {
                IProject project = RefreshProviderTest.getWorkspace().getRoot().getProject(name);
                this.ensureExistsInWorkspace((IResource)project, true);
                this.joinAutoRefreshJobs();
                IFile link = project.getFile("Link");
                TestRefreshProvider provider = TestRefreshProvider.getInstance();
                RefreshProviderTest.assertEquals((String)"1.0", (int)1, (int)provider.getMonitoredResources().length);
                link.createLink(location, 16, this.getMonitor());
                this.joinAutoRefreshJobs();
                RefreshProviderTest.assertEquals((String)"1.1", (int)2, (int)provider.getMonitoredResources().length);
                link.delete(1, this.getMonitor());
                this.joinAutoRefreshJobs();
                RefreshProviderTest.assertEquals((String)"1.2", (int)1, (int)provider.getMonitoredResources().length);
                this.ensureDoesNotExistInWorkspace((IResource)project);
                this.joinAutoRefreshJobs();
                RefreshProviderTest.assertEquals((String)"1.3", (int)0, (int)provider.getMonitoredResources().length);
                AssertionFailedError[] failures = provider.getFailures();
                if (failures.length > 0) {
                    RefreshProviderTest.fail((String)(failures.length + " failures"), (Throwable)failures[0]);
                }
            }
            catch (CoreException e) {
                RefreshProviderTest.fail((String)"1.99", (Throwable)e);
                Workspace.clear((File)location.toFile());
                RefreshProviderTest.deleteProject(name);
            }
        }
        finally {
            Workspace.clear((File)location.toFile());
            RefreshProviderTest.deleteProject(name);
        }
    }

    public void testProjectCloseOpen() throws Exception {
        String name = "testProjectCloseOpen";
        IProject project = RefreshProviderTest.getWorkspace().getRoot().getProject(name);
        try {
            try {
                this.ensureExistsInWorkspace((IResource)project, true);
                this.joinAutoRefreshJobs();
                TestRefreshProvider provider = TestRefreshProvider.getInstance();
                RefreshProviderTest.assertEquals((String)"1.0", (int)1, (int)provider.getMonitoredResources().length);
                project.close(this.getMonitor());
                this.joinAutoRefreshJobs();
                RefreshProviderTest.assertEquals((String)"1.1", (int)0, (int)provider.getMonitoredResources().length);
                project.open(this.getMonitor());
                this.joinAutoRefreshJobs();
                RefreshProviderTest.assertEquals((String)"1.2", (int)1, (int)provider.getMonitoredResources().length);
                this.ensureDoesNotExistInWorkspace((IResource)project);
                this.joinAutoRefreshJobs();
                RefreshProviderTest.assertEquals((String)"1.3", (int)0, (int)provider.getMonitoredResources().length);
                AssertionFailedError[] failures = provider.getFailures();
                if (failures.length > 0) {
                    RefreshProviderTest.fail((String)(failures.length + " failures"), (Throwable)failures[0]);
                }
            }
            catch (CoreException e) {
                RefreshProviderTest.fail((String)"1.99", (Throwable)e);
                RefreshProviderTest.deleteProject(name);
            }
        }
        finally {
            RefreshProviderTest.deleteProject(name);
        }
    }

    public void testProjectCreateDelete() throws Exception {
        String name = "testProjectCreateDelete";
        int i = 0;
        HashMap<Integer, CoreException> fails = new HashMap<Integer, CoreException>();
        try {
            while (i < 1000) {
                if (i % 50 == 0) {
                    TestUtil.waitForJobs(this.getName(), 5L, 100L);
                }
                try {
                    RefreshProviderTest.assertTrue((boolean)this.createProject(name).isAccessible());
                    RefreshProviderTest.assertFalse((boolean)RefreshProviderTest.deleteProject(name).exists());
                }
                catch (CoreException e) {
                    fails.put(i, e);
                }
                ++i;
            }
        }
        finally {
            RefreshProviderTest.deleteProject(name);
        }
        if (!fails.isEmpty()) {
            RefreshProviderTest.fail((String)("Failed " + fails.size() + " times out of " + i), (Throwable)((Throwable)fails.values().iterator().next()));
        }
    }

    private IProject createProject(String name) throws Exception {
        IWorkspaceRoot root;
        IProject project;
        IProject pro = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (pro.exists()) {
            pro.delete(true, true, null);
        }
        if (!(project = (root = ResourcesPlugin.getWorkspace().getRoot()).getProject(name)).exists()) {
            project.create(null);
        } else {
            project.refreshLocal(2, null);
        }
        if (!project.isOpen()) {
            project.open(null);
        }
        return project;
    }

    private static IProject deleteProject(String name) throws Exception {
        IProject pro = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (pro.exists()) {
            pro.delete(true, true, null);
        }
        return pro;
    }

    private void joinAutoRefreshJobs() throws InterruptedException {
        Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, null);
    }
}

