/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_025457
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(Bug_025457.class);
    }

    public Bug_025457() {
    }

    public Bug_025457(String name) {
        super(name);
    }

    public void testFile() {
        IFile destFile;
        block14: {
            if (!Bug_025457.isWindows()) {
                return;
            }
            IProject source = Bug_025457.getWorkspace().getRoot().getProject("project");
            IFile sourceFile = source.getFile("file.txt");
            destFile = source.getFile("File.txt");
            this.ensureExistsInWorkspace((IResource)source, true);
            String content = this.getRandomString();
            this.ensureExistsInWorkspace(sourceFile, content);
            InputStream stream = null;
            try {
                try {
                    stream = sourceFile.getContents();
                }
                catch (CoreException e) {
                    Bug_025457.fail((String)"0.99", (Throwable)e);
                }
                try {
                    sourceFile.move(destFile.getFullPath(), 0, this.getMonitor());
                    Bug_025457.fail((String)"1.99");
                }
                catch (CoreException coreException) {}
            }
            finally {
                this.assertClose(stream);
            }
            Bug_025457.assertTrue((String)"2.0", (boolean)source.exists());
            Bug_025457.assertTrue((String)"2.1", (boolean)sourceFile.exists());
            try {
                try {
                    stream = sourceFile.getContents();
                    Bug_025457.assertTrue((String)"2.2", (boolean)this.compareContent(stream, new ByteArrayInputStream(content.getBytes())));
                }
                catch (CoreException e) {
                    Bug_025457.fail((String)"3.99", (Throwable)e);
                    this.assertClose(stream);
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.assertClose(stream);
                throw throwable;
            }
            this.assertClose(stream);
        }
        Bug_025457.assertTrue((String)"2.3", (!destFile.exists() ? 1 : 0) != 0);
    }

    public void testFolder() {
        if (!Bug_025457.isWindows() || !this.isReadOnlySupported()) {
            return;
        }
        IProject source = Bug_025457.getWorkspace().getRoot().getProject("SourceProject");
        IFolder sourceFolder = source.getFolder("folder");
        IFile sourceFile = sourceFolder.getFile("Important.txt");
        IFolder destFolder = source.getFolder("Folder");
        IFile destFile = destFolder.getFile("Important.txt");
        this.ensureExistsInWorkspace((IResource)source, true);
        this.ensureExistsInWorkspace((IResource)sourceFolder, true);
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        InputStream stream = null;
        try {
            try {
                stream = sourceFile.getContents();
            }
            catch (CoreException e) {
                Bug_025457.fail((String)"0.99", (Throwable)e);
            }
            try {
                sourceFolder.move(destFolder.getFullPath(), 0, this.getMonitor());
                Bug_025457.fail((String)"1.99");
            }
            catch (CoreException coreException) {}
            Bug_025457.assertTrue((String)"2.0", (boolean)source.exists());
            Bug_025457.assertTrue((String)"2.1", (boolean)sourceFolder.exists());
            Bug_025457.assertTrue((String)"2.2", (boolean)sourceFile.exists());
            Bug_025457.assertTrue((String)"2.3", (!destFolder.exists() ? 1 : 0) != 0);
            Bug_025457.assertTrue((String)"2.4", (!destFile.exists() ? 1 : 0) != 0);
        }
        finally {
            this.assertClose(stream);
        }
    }

    public void testProject() {
        if (!Bug_025457.isWindows()) {
            return;
        }
        IProject source = Bug_025457.getWorkspace().getRoot().getProject("project");
        IProject destination = Bug_025457.getWorkspace().getRoot().getProject("Project");
        IFile sourceFile = source.getFile("Important.txt");
        IFile destFile = destination.getFile("Important.txt");
        this.ensureExistsInWorkspace((IResource)source, true);
        this.ensureExistsInWorkspace((IResource)sourceFile, true);
        InputStream stream = null;
        try {
            try {
                stream = sourceFile.getContents();
            }
            catch (CoreException e) {
                Bug_025457.fail((String)"1.99", (Throwable)e);
            }
            try {
                source.move(destination.getFullPath(), 0, this.getMonitor());
                Bug_025457.fail((String)"1.99");
            }
            catch (CoreException coreException) {}
            Bug_025457.assertTrue((String)"2.0", (!source.exists() ? 1 : 0) != 0);
            Bug_025457.assertTrue((String)"2.1", (!sourceFile.exists() ? 1 : 0) != 0);
            Bug_025457.assertTrue((String)"2.2", (boolean)destination.exists());
            Bug_025457.assertTrue((String)"2.3", (boolean)destFile.exists());
        }
        finally {
            this.assertClose(stream);
        }
    }
}

