/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_044106
extends ResourceTest {
    public static Test suite() {
        return new TestSuite(Bug_044106.class);
    }

    public Bug_044106() {
    }

    public Bug_044106(String name) {
        super(name);
    }

    private void createSymLink(String target, String local) {
        try {
            Process p = Runtime.getRuntime().exec("/bin/ln -s " + target + " " + local);
            p.waitFor();
        }
        catch (IOException e) {
            Bug_044106.fail((String)"1.0", (Throwable)e);
        }
        catch (InterruptedException e) {
            Bug_044106.fail((String)"1.1", (Throwable)e);
        }
    }

    public void doTestDeleteLinkedFile(int deleteFlags) {
        IFileStore linkDestFile = this.getTempStore();
        this.createFileInFileSystem(linkDestFile);
        Bug_044106.assertTrue((String)"0.1", (boolean)linkDestFile.fetchInfo().exists());
        IProject project = Bug_044106.getWorkspace().getRoot().getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        String target = new File(linkDestFile.toURI()).getAbsolutePath();
        IFile linkedFile = project.getFile("linkedFile");
        String local = linkedFile.getLocation().toOSString();
        this.createSymLink(target, local);
        this.assertExistsInFileSystem("1.2", (IResource)linkedFile);
        try {
            project.refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_044106.fail((String)"2.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.1", (IResource)linkedFile);
        try {
            linkedFile.delete(deleteFlags, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_044106.fail((String)"3.0", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("4.0", (IResource)linkedFile);
        Bug_044106.assertTrue((String)"4.1", (boolean)linkDestFile.fetchInfo().exists());
    }

    public void doTestDeleteLinkedFolder(IFolder linkedFolder, boolean deleteParent, int deleteFlags) {
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        IFileStore linkDestLocation = this.getTempStore();
        IFileStore linkDestFile = linkDestLocation.getChild(this.getUniqueString());
        this.createFileInFileSystem(linkDestFile);
        Bug_044106.assertTrue((String)"0.1", (boolean)linkDestLocation.fetchInfo().exists());
        Bug_044106.assertTrue((String)"0.2", (boolean)linkDestFile.fetchInfo().exists());
        this.ensureExistsInWorkspace((IResource)linkedFolder.getParent(), true);
        String target = new File(linkDestLocation.toURI()).getAbsolutePath();
        IFile linkedFile = linkedFolder.getFile(linkDestFile.getName());
        String local = linkedFolder.getLocation().toOSString();
        this.createSymLink(target, local);
        this.assertExistsInFileSystem("1.2", (IResource)linkedFolder);
        this.assertExistsInFileSystem("1.3", (IResource)linkedFile);
        try {
            linkedFolder.getProject().refreshLocal(2, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_044106.fail((String)"2.0", (Throwable)e);
        }
        this.assertExistsInWorkspace("2.1", (IResource)linkedFolder);
        this.assertExistsInWorkspace("2.2", (IResource)linkedFile);
        try {
            if (deleteParent) {
                linkedFolder.getParent().delete(deleteFlags, this.getMonitor());
            } else {
                linkedFolder.delete(deleteFlags, this.getMonitor());
            }
        }
        catch (CoreException e) {
            Bug_044106.fail((String)"3.0", (Throwable)e);
        }
        this.assertDoesNotExistInWorkspace("4.0", (IResource)linkedFolder);
        this.assertDoesNotExistInWorkspace("4.1", (IResource)linkedFile);
        Bug_044106.assertTrue((String)"4.2", (boolean)linkDestLocation.fetchInfo().exists());
        Bug_044106.assertTrue((String)"4.3", (boolean)linkDestFile.fetchInfo().exists());
    }

    public void testDeleteLinkedFile() {
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        this.doTestDeleteLinkedFile(0);
    }

    public void testDeleteLinkedFolder() {
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        IProject project = Bug_044106.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder linkedFolder = project.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, false, 0);
    }

    public void testDeleteLinkedResourceInProject() {
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        IProject project = Bug_044106.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder linkedFolder = project.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, true, 0);
    }

    public void testDeleteLinkedFileKeepHistory() {
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        this.doTestDeleteLinkedFile(2);
    }

    public void testDeleteLinkedFolderParentKeepHistory() {
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        IProject project = Bug_044106.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder parent = project.getFolder("parent");
        IFolder linkedFolder = parent.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, true, 2);
    }

    public void testDeleteLinkedFolderKeepHistory() {
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        IProject project = Bug_044106.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder linkedFolder = project.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, false, 2);
    }

    public void testDeleteLinkedResourceInProjectKeepHistory() {
        if (!Platform.getOS().equals("linux")) {
            return;
        }
        IProject project = Bug_044106.getWorkspace().getRoot().getProject(this.getUniqueString());
        IFolder linkedFolder = project.getFolder("linkedFolder");
        this.doTestDeleteLinkedFolder(linkedFolder, true, 2);
    }
}

