/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.tests.resources.ResourceTest;

public class Bug_331445
extends ResourceTest {
    public Bug_331445() {
    }

    public Bug_331445(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(Bug_331445.class);
    }

    public void testBug() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(this.getUniqueString());
        this.ensureExistsInWorkspace((IResource)project, true);
        String variableName = "a" + this.getUniqueString();
        String variablePath = "mem:/MyProject";
        String folderName = "MyFolder";
        String rawLinkFolderLocation = String.valueOf(variableName) + "/" + folderName;
        String linkFolderLocation = String.valueOf(variablePath) + "/" + folderName;
        try {
            project.getPathVariableManager().setURIValue(variableName, new URI(variablePath));
        }
        catch (CoreException e) {
            Bug_331445.fail((String)"1.0", (Throwable)e);
        }
        catch (URISyntaxException e) {
            Bug_331445.fail((String)"1.1", (Throwable)e);
        }
        IFolder folder = project.getFolder(this.getUniqueString());
        try {
            folder.createLink((IPath)new Path(rawLinkFolderLocation), 16, this.getMonitor());
        }
        catch (CoreException e) {
            Bug_331445.fail((String)"2.0", (Throwable)e);
        }
        Bug_331445.assertNull((String)"3.0", (Object)folder.getLocation());
        Bug_331445.assertEquals((String)"4.0", (Object)new Path(rawLinkFolderLocation), (Object)folder.getRawLocation());
        try {
            Bug_331445.assertEquals((String)"5.0", (Object)new URI(linkFolderLocation), (Object)folder.getLocationURI());
        }
        catch (URISyntaxException e) {
            Bug_331445.fail((String)"5.1", (Throwable)e);
        }
        try {
            Bug_331445.assertEquals((String)"6.0", (Object)new URI(rawLinkFolderLocation), (Object)folder.getRawLocationURI());
        }
        catch (URISyntaxException e) {
            Bug_331445.fail((String)"6.1", (Throwable)e);
        }
    }
}

