/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.resources.regression;

import java.io.File;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileState;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.tests.resources.ResourceTest;

public class IWorkspaceTest
extends ResourceTest {
    public IWorkspaceTest() {
    }

    public IWorkspaceTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(IWorkspaceTest.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        IWorkspaceTest.getWorkspace().getRoot().delete(true, null);
    }

    public void testMultiMove_1GDKIHD() {
        IFileState[] states;
        IProject project = IWorkspaceTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"0.0", (Throwable)e);
        }
        IFile file1 = project.getFile("file.txt");
        IFolder folder = project.getFolder("folder");
        IResource[] allResources = new IResource[]{file1, folder};
        try {
            folder.create(true, true, this.getMonitor());
            file1.create(this.getRandomContents(), true, this.getMonitor());
            file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            IWorkspaceTest.getWorkspace().move((IResource[])new IFile[]{file1}, folder.getFullPath(), true, this.getMonitor());
            file1.create(this.getRandomContents(), true, this.getMonitor());
            states = file1.getHistory(this.getMonitor());
            IWorkspaceTest.assertEquals((String)"1.0", (int)3, (int)states.length);
            IWorkspaceTest.getWorkspace().delete(allResources, true, this.getMonitor());
            project.clearHistory(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"1.20", (Throwable)e);
        }
        try {
            folder.create(true, true, this.getMonitor());
            file1.create(this.getRandomContents(), true, this.getMonitor());
            file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            IWorkspaceTest.getWorkspace().move((IResource[])new IFile[]{file1}, folder.getFullPath(), false, this.getMonitor());
            file1.create(this.getRandomContents(), true, this.getMonitor());
            states = file1.getHistory(this.getMonitor());
            IWorkspaceTest.assertEquals((String)"2.0", (int)3, (int)states.length);
            IWorkspaceTest.getWorkspace().delete(allResources, true, this.getMonitor());
            project.clearHistory(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"2.20", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public void testMultiDelete_1GDGRIZ() {
        IFileState[] states;
        IFileState[] states2;
        IProject project = IWorkspaceTest.getWorkspace().getRoot().getProject("MyProject");
        try {
            project.create(this.getMonitor());
            project.open(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"0.0", (Throwable)e);
        }
        IFile file1 = project.getFile("file.txt");
        try {
            file1.create(this.getRandomContents(), true, this.getMonitor());
            file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            IWorkspaceTest.getWorkspace().delete((IResource[])new IFile[]{file1}, true, this.getMonitor());
            file1.create(this.getRandomContents(), true, this.getMonitor());
            states2 = file1.getHistory(this.getMonitor());
            IWorkspaceTest.assertEquals((String)"1.0", (int)3, (int)states2.length);
            IWorkspaceTest.getWorkspace().delete(new IResource[]{file1}, true, this.getMonitor());
            project.clearHistory(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"1.20", (Throwable)e);
        }
        try {
            file1.create(this.getRandomContents(), true, this.getMonitor());
            file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            file1.setContents(this.getRandomContents(), true, true, this.getMonitor());
            IWorkspaceTest.getWorkspace().delete((IResource[])new IFile[]{file1}, false, this.getMonitor());
            file1.create(this.getRandomContents(), true, this.getMonitor());
            states2 = file1.getHistory(this.getMonitor());
            IWorkspaceTest.assertEquals((String)"2.0", (int)3, (int)states2.length);
            IWorkspaceTest.getWorkspace().delete(new IResource[]{file1}, true, this.getMonitor());
            project.clearHistory(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"2.20", (Throwable)e);
        }
        IFolder folder = project.getFolder("folder");
        IFile file2 = folder.getFile("file2.txt");
        try {
            folder.create(true, true, this.getMonitor());
            file2.create(this.getRandomContents(), true, this.getMonitor());
            file2.setContents(this.getRandomContents(), true, true, this.getMonitor());
            file2.setContents(this.getRandomContents(), true, true, this.getMonitor());
            IWorkspaceTest.getWorkspace().delete(new IResource[]{folder}, true, this.getMonitor());
            folder.create(true, true, this.getMonitor());
            file2.create(this.getRandomContents(), true, this.getMonitor());
            states = file2.getHistory(this.getMonitor());
            IWorkspaceTest.assertEquals((String)"3.0", (int)3, (int)states.length);
            IWorkspaceTest.getWorkspace().delete(new IResource[]{folder, file1, file2}, true, this.getMonitor());
            project.clearHistory(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"3.20", (Throwable)e);
        }
        try {
            folder.create(true, true, this.getMonitor());
            file2.create(this.getRandomContents(), true, this.getMonitor());
            file2.setContents(this.getRandomContents(), true, true, this.getMonitor());
            file2.setContents(this.getRandomContents(), true, true, this.getMonitor());
            IWorkspaceTest.getWorkspace().delete(new IResource[]{folder}, false, this.getMonitor());
            folder.create(true, true, this.getMonitor());
            file2.create(this.getRandomContents(), true, this.getMonitor());
            states = file2.getHistory(this.getMonitor());
            IWorkspaceTest.assertEquals((String)"4.0", (int)3, (int)states.length);
            IWorkspaceTest.getWorkspace().delete(new IResource[]{folder, file1, file2}, true, this.getMonitor());
            project.clearHistory(this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"4.20", (Throwable)e);
        }
        try {
            project.delete(true, this.getMonitor());
        }
        catch (CoreException e) {
            IWorkspaceTest.fail((String)"20.0", (Throwable)e);
        }
    }

    public void test_8974() {
        IProject one = IWorkspaceTest.getWorkspace().getRoot().getProject("One");
        IPath oneLocation = this.getRandomLocation().append(one.getName());
        oneLocation.toFile().mkdirs();
        IProjectDescription oneDescription = IWorkspaceTest.getWorkspace().newProjectDescription(one.getName());
        oneDescription.setLocation(oneLocation);
        try {
            one.create(oneDescription, this.getMonitor());
        }
        catch (CoreException e) {
            Workspace.clear((File)oneLocation.removeLastSegments(1).toFile());
            IWorkspaceTest.fail((String)"0.0", (Throwable)e);
        }
        try {
            IProject two = IWorkspaceTest.getWorkspace().getRoot().getProject("Two");
            IPath twoLocation = oneLocation.removeLastSegments(1).append(oneLocation.lastSegment().toLowerCase());
            IStatus result = IWorkspaceTest.getWorkspace().validateProjectLocation(two, twoLocation);
            if (Workspace.caseSensitive) {
                IWorkspaceTest.assertTrue((String)"1.0", (boolean)result.isOK());
            } else {
                IWorkspaceTest.assertTrue((String)"1.1", (!result.isOK() ? 1 : 0) != 0);
            }
            this.ensureDoesNotExistInWorkspace((IResource)one);
        }
        finally {
            Workspace.clear((File)oneLocation.removeLastSegments(1).toFile());
        }
    }
}

